/* DUPLICATOR MYSQL SCRIPT CREATED ON : 2016-11-18 15:37:02 */

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8_unicode_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `package` mediumblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `wp_gde_profiles` (
  `profile_id` mediumint(9) unsigned NOT NULL AUTO_INCREMENT,
  `profile_name` varchar(64) NOT NULL,
  `profile_desc` varchar(255) DEFAULT NULL,
  `profile_data` longtext NOT NULL,
  UNIQUE KEY `profile_id` (`profile_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gde_secure` (
  `code` varchar(10) NOT NULL,
  `url` varchar(255) NOT NULL,
  `murl` varchar(100) NOT NULL,
  `stamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `autoexpire` enum('Y','N') NOT NULL DEFAULT 'N',
  UNIQUE KEY `code` (`code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM AUTO_INCREMENT=26542 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=MyISAM AUTO_INCREMENT=1653 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8_unicode_ci NOT NULL,
  `post_title` text COLLATE utf8_unicode_ci NOT NULL,
  `post_excerpt` text COLLATE utf8_unicode_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8_unicode_ci NOT NULL,
  `pinged` text COLLATE utf8_unicode_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8_unicode_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=1498 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `wp_statistics_exclusions` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `reason` varchar(255) DEFAULT NULL,
  `count` bigint(20) NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `date` (`date`),
  KEY `reason` (`reason`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_statistics_pages` (
  `uri` varchar(255) NOT NULL,
  `date` date NOT NULL,
  `count` int(11) NOT NULL,
  `id` int(11) NOT NULL,
  UNIQUE KEY `date_2` (`date`,`uri`),
  KEY `url` (`uri`),
  KEY `date` (`date`),
  KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_statistics_useronline` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `ip` varchar(20) NOT NULL,
  `timestamp` int(10) NOT NULL,
  `date` datetime NOT NULL,
  `referred` text NOT NULL,
  `agent` varchar(255) NOT NULL,
  `platform` varchar(255) DEFAULT NULL,
  `version` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM AUTO_INCREMENT=43640 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_statistics_visit` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `last_visit` datetime NOT NULL,
  `last_counter` date NOT NULL,
  `visit` int(10) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM AUTO_INCREMENT=936 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_statistics_visitor` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `last_counter` date NOT NULL,
  `referred` text NOT NULL,
  `agent` varchar(255) NOT NULL,
  `platform` varchar(255) DEFAULT NULL,
  `version` varchar(255) DEFAULT NULL,
  `UAString` varchar(255) DEFAULT NULL,
  `ip` varchar(20) NOT NULL,
  `location` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `agent` (`agent`),
  KEY `platform` (`platform`),
  KEY `version` (`version`),
  KEY `location` (`location`)
) ENGINE=MyISAM AUTO_INCREMENT=12732 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8_unicode_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  UNIQUE KEY `slug` (`slug`),
  KEY `name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=MyISAM AUTO_INCREMENT=31 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `user_pass` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "20161118_santamargherita", "582f1ff8618d76648161118153624", "20", "2016-11-18 15:37:01", "sm", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2016-11-18 15:36:24\";s:7:\"Version\";s:6:\"1.1.20\";s:9:\"VersionWP\";s:6:\"3.9.14\";s:9:\"VersionDB\";s:6:\"5.5.51\";s:10:\"VersionPHP\";s:6:\"5.2.17\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:24:\"20161118_santamargherita\";s:4:\"Hash\";s:29:\"582f1ff8618d76648161118153624\";s:8:\"NameHash\";s:54:\"20161118_santamargherita_582f1ff8618d76648161118153624\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:53:\"/home/sm/public_html/santamargherita/wp-snapshots/tmp\";s:8:\"StoreURL\";s:43:\"http://santamargherita.s-m.cl/wp-snapshots/\";s:8:\"ScanFile\";s:64:\"20161118_santamargherita_582f1ff8618d76648161118153624_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";s:2:\"sm\";s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:66:\"20161118_santamargherita_582f1ff8618d76648161118153624_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:36:\"/home/sm/public_html/santamargherita\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2016-11-18 15:36:24\";s:7:\"Version\";s:6:\"1.1.20\";s:9:\"VersionWP\";s:6:\"3.9.14\";s:9:\"VersionDB\";s:6:\"5.5.51\";s:10:\"VersionPHP\";s:6:\"5.2.17\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:24:\"20161118_santamargherita\";s:4:\"Hash\";s:29:\"582f1ff8618d76648161118153624\";s:8:\"NameHash\";s:54:\"20161118_santamargherita_582f1ff8618d76648161118153624\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:53:\"/home/sm/public_html/santamargherita/wp-snapshots/tmp\";s:8:\"StoreURL\";s:43:\"http://santamargherita.s-m.cl/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";r:22;s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:68:\"20161118_santamargherita_582f1ff8618d76648161118153624_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:52;}s:8:\"Database\";O:12:\"DUP_Database\":12:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:67:\"20161118_santamargherita_582f1ff8618d76648161118153624_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}}s:9:\"Installer\";r:74;s:8:\"Database\";r:87;}");

/* INSERT TABLE DATA: wp_gde_profiles */
INSERT INTO `wp_gde_profiles` VALUES("1", "default", "This is the default profile, used when no profile is specified.", "a:22:{s:6:\"viewer\";s:8:\"standard\";s:13:\"default_width\";s:4:\"100%\";s:14:\"default_height\";s:5:\"500px\";s:9:\"tb_mobile\";s:7:\"default\";s:8:\"tb_flags\";s:0:\"\";s:10:\"tb_fullscr\";s:7:\"default\";s:10:\"tb_fullwin\";s:3:\"new\";s:11:\"tb_fulluser\";s:2:\"no\";s:8:\"tb_print\";s:2:\"no\";s:10:\"vw_bgcolor\";s:7:\"#EBEBEB\";s:10:\"vw_pbcolor\";s:7:\"#DADADA\";s:6:\"vw_css\";s:0:\"\";s:8:\"vw_flags\";s:0:\"\";s:8:\"language\";s:5:\"en_US\";s:8:\"base_url\";s:49:\"http://santamargherita.s-m.cl/wp-content/uploads/\";s:9:\"link_show\";s:3:\"all\";s:9:\"link_mask\";s:2:\"no\";s:10:\"link_block\";s:2:\"no\";s:9:\"link_text\";s:23:\"Download (%TYPE, %SIZE)\";s:8:\"link_pos\";s:5:\"below\";s:10:\"link_force\";s:2:\"no\";s:5:\"cache\";s:2:\"on\";}");
INSERT INTO `wp_gde_profiles` VALUES("2", "max-doc-security", "Hide document location and text selection, prevent downloads", "a:22:{s:6:\"viewer\";s:8:\"enhanced\";s:13:\"default_width\";s:4:\"100%\";s:14:\"default_height\";s:5:\"500px\";s:9:\"tb_mobile\";s:7:\"default\";s:8:\"tb_flags\";s:0:\"\";s:10:\"tb_fullscr\";s:6:\"viewer\";s:10:\"tb_fullwin\";s:3:\"new\";s:11:\"tb_fulluser\";s:2:\"no\";s:8:\"tb_print\";s:2:\"no\";s:10:\"vw_bgcolor\";s:7:\"#EBEBEB\";s:10:\"vw_pbcolor\";s:7:\"#DADADA\";s:6:\"vw_css\";s:0:\"\";s:8:\"vw_flags\";s:0:\"\";s:8:\"language\";s:5:\"en_US\";s:8:\"base_url\";s:49:\"http://santamargherita.s-m.cl/wp-content/uploads/\";s:9:\"link_show\";s:4:\"none\";s:9:\"link_mask\";s:2:\"no\";s:10:\"link_block\";s:3:\"yes\";s:9:\"link_text\";s:0:\"\";s:8:\"link_pos\";s:5:\"below\";s:10:\"link_force\";s:2:\"no\";s:5:\"cache\";s:2:\"on\";}");
INSERT INTO `wp_gde_profiles` VALUES("3", "dark", "Dark-colored theme, example of custom CSS option", "a:22:{s:6:\"viewer\";s:8:\"enhanced\";s:13:\"default_width\";s:4:\"100%\";s:14:\"default_height\";s:5:\"500px\";s:9:\"tb_mobile\";s:7:\"default\";s:8:\"tb_flags\";s:0:\"\";s:10:\"tb_fullscr\";s:6:\"viewer\";s:10:\"tb_fullwin\";s:3:\"new\";s:11:\"tb_fulluser\";s:2:\"no\";s:8:\"tb_print\";s:2:\"no\";s:10:\"vw_bgcolor\";s:0:\"\";s:10:\"vw_pbcolor\";s:0:\"\";s:6:\"vw_css\";s:90:\"http://santamargherita.s-m.cl/wp-content/plugins/google-document-embedder/css/gde-dark.css\";s:8:\"vw_flags\";s:0:\"\";s:8:\"language\";s:5:\"en_US\";s:8:\"base_url\";s:49:\"http://santamargherita.s-m.cl/wp-content/uploads/\";s:9:\"link_show\";s:3:\"all\";s:9:\"link_mask\";s:2:\"no\";s:10:\"link_block\";s:2:\"no\";s:9:\"link_text\";s:23:\"Download (%TYPE, %SIZE)\";s:8:\"link_pos\";s:5:\"below\";s:10:\"link_force\";s:2:\"no\";s:5:\"cache\";s:2:\"on\";}");

/* INSERT TABLE DATA: wp_links */
INSERT INTO `wp_links` VALUES("1", "http://codex.wordpress.org/", "Documentation", "", "", "", "Y", "1", "0", "0000-00-00 00:00:00", "", "", "");
INSERT INTO `wp_links` VALUES("2", "http://wordpress.org/news/", "WordPress Blog", "", "", "", "Y", "1", "0", "0000-00-00 00:00:00", "", "", "http://wordpress.org/news/feed/");
INSERT INTO `wp_links` VALUES("3", "http://wordpress.org/extend/ideas/", "Suggest Ideas", "", "", "", "Y", "1", "0", "0000-00-00 00:00:00", "", "", "");
INSERT INTO `wp_links` VALUES("4", "http://wordpress.org/support/", "Support Forum", "", "", "", "Y", "1", "0", "0000-00-00 00:00:00", "", "", "");
INSERT INTO `wp_links` VALUES("5", "http://wordpress.org/extend/plugins/", "Plugins", "", "", "", "Y", "1", "0", "0000-00-00 00:00:00", "", "", "");
INSERT INTO `wp_links` VALUES("6", "http://wordpress.org/extend/themes/", "Themes", "", "", "", "Y", "1", "0", "0000-00-00 00:00:00", "", "", "");
INSERT INTO `wp_links` VALUES("7", "http://planet.wordpress.org/", "WordPress Planet", "", "", "", "Y", "1", "0", "0000-00-00 00:00:00", "", "", "");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("26536", "_site_transient_timeout_theme_roots", "1479485143", "yes");
INSERT INTO `wp_options` VALUES("26537", "_site_transient_theme_roots", "a:5:{s:5:\"arras\";s:7:\"/themes\";s:12:\"twentyeleven\";s:7:\"/themes\";s:14:\"twentyfourteen\";s:7:\"/themes\";s:14:\"twentythirteen\";s:7:\"/themes\";s:12:\"twentytwelve\";s:7:\"/themes\";}", "yes");
INSERT INTO `wp_options` VALUES("3", "siteurl", "http://santamargherita.s-m.cl", "yes");
INSERT INTO `wp_options` VALUES("4", "blogname", "Santamargherita", "yes");
INSERT INTO `wp_options` VALUES("5", "blogdescription", "", "yes");
INSERT INTO `wp_options` VALUES("6", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("7", "admin_email", "gabrielagb@gmail.com", "yes");
INSERT INTO `wp_options` VALUES("8", "start_of_week", "1", "yes");
INSERT INTO `wp_options` VALUES("9", "use_balanceTags", "", "yes");
INSERT INTO `wp_options` VALUES("10", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("13", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("14", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("18", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("19", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("20", "default_comment_status", "closed", "yes");
INSERT INTO `wp_options` VALUES("21", "default_ping_status", "closed", "yes");
INSERT INTO `wp_options` VALUES("22", "default_pingback_flag", "", "yes");
INSERT INTO `wp_options` VALUES("24", "posts_per_page", "16", "yes");
INSERT INTO `wp_options` VALUES("25", "date_format", "F j, Y", "yes");
INSERT INTO `wp_options` VALUES("26", "time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("27", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("31", "comment_moderation", "", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("33", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("34", "gzipcompression", "0", "yes");
INSERT INTO `wp_options` VALUES("35", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("36", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("37", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("38", "active_plugins", "a:7:{i:0;s:36:\"contact-form-plugin/contact_form.php\";i:1;s:25:\"duplicator/duplicator.php\";i:2;s:36:\"google-document-embedder/gviewer.php\";i:3;s:39:\"improved-include-page/iinclude_page.php\";i:4;s:30:\"lightbox-plus/lightboxplus.php\";i:5;s:29:\"widget-logic/widget_logic.php\";i:6;s:31:\"wp-statistics/wp-statistics.php\";}", "yes");
INSERT INTO `wp_options` VALUES("39", "home", "http://s-m.cl", "yes");
INSERT INTO `wp_options` VALUES("40", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("41", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("42", "advanced_edit", "0", "yes");
INSERT INTO `wp_options` VALUES("43", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("44", "gmt_offset", "-4", "yes");
INSERT INTO `wp_options` VALUES("45", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("46", "recently_edited", "a:5:{i:0;s:70:\"/home/sm/public_html/santamargherita/wp-content/themes/arras/style.css\";i:1;s:82:\"/home/sm/public_html/santamargherita/wp-content/themes/arras/library/slideshow.php\";i:2;s:74:\"/home/sm/public_html/santamargherita/wp-content/themes/arras/functions.php\";i:3;s:69:\"/home/sm/public_html/santamargherita/wp-content/themes/arras/page.php\";i:4;s:91:\"/home/sm/public_html/santamargherita/wp-content/themes/arras/pagetpl-onecolumn_sinestar.php\";}", "no");
INSERT INTO `wp_options` VALUES("47", "template", "arras", "yes");
INSERT INTO `wp_options` VALUES("48", "stylesheet", "arras", "yes");
INSERT INTO `wp_options` VALUES("49", "comment_whitelist", "1", "yes");
INSERT INTO `wp_options` VALUES("50", "blacklist_keys", "", "no");
INSERT INTO `wp_options` VALUES("51", "comment_registration", "", "yes");
INSERT INTO `wp_options` VALUES("53", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("54", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("55", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("56", "db_version", "27918", "yes");
INSERT INTO `wp_options` VALUES("57", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("58", "upload_path", "wp-content/uploads", "yes");
INSERT INTO `wp_options` VALUES("59", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("60", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("61", "show_on_front", "posts", "yes");
INSERT INTO `wp_options` VALUES("62", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("63", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("64", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("65", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("66", "thumbnail_size_w", "116", "yes");
INSERT INTO `wp_options` VALUES("67", "thumbnail_size_h", "116", "yes");
INSERT INTO `wp_options` VALUES("68", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("69", "medium_size_w", "576", "yes");
INSERT INTO `wp_options` VALUES("70", "medium_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("71", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("74", "large_size_w", "700", "yes");
INSERT INTO `wp_options` VALUES("75", "large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("76", "image_default_link_type", "", "yes");
INSERT INTO `wp_options` VALUES("77", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("78", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("79", "close_comments_for_old_posts", "", "yes");
INSERT INTO `wp_options` VALUES("80", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("81", "thread_comments", "", "yes");
INSERT INTO `wp_options` VALUES("82", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("83", "page_comments", "", "yes");
INSERT INTO `wp_options` VALUES("84", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("85", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("86", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("87", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("88", "widget_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("89", "widget_text", "a:2:{i:4;a:3:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:701:\"<div class=\"ventaja\">\r\n<ul>\r\n<li><a href=\"http://santamargherita.s-m.cl/garantia-calidad/\">Garantía y Calidad</a></li>\r\n<li><a href=\"http://santamargherita.s-m.cl/colores/\">Colores</a></li>\r\n<li><a href=\"http://santamargherita.s-m.cl/certificaciones/\">Certificaciones</a></li>\r\n<li><a href=\"http://santamargherita.s-m.cl/aplicaciones/\">Aplicaciones</a></li>\r\n<li><a href=\"http://santamargherita.s-m.cl/proyectos-destacados/\">Proyectos Destacados</a></li>\r\n<li><a href=\"http://santamargherita.s-m.cl/novedades/\">Novedades</a></li>\r\n<li><a href=\"http://santamargherita.s-m.cl/ventajas/\">Ventajas</a></li>\r\n<li><a href=\"http://santamargherita.s-m.cl/mantenimiento/\">Mantenimiento</a></li>\r\n</ul>\r\n</div>\";s:6:\"filter\";b:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("90", "widget_rss", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("91", "timezone_string", "", "yes");
INSERT INTO `wp_options` VALUES("93", "embed_size_w", "", "yes");
INSERT INTO `wp_options` VALUES("94", "embed_size_h", "600", "yes");
INSERT INTO `wp_options` VALUES("95", "page_for_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("96", "page_on_front", "0", "yes");
INSERT INTO `wp_options` VALUES("97", "default_post_format", "", "yes");
INSERT INTO `wp_options` VALUES("98", "initial_db_version", "19470", "yes");
INSERT INTO `wp_options` VALUES("99", "wp_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:62:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:9:\"add_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("100", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("101", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("102", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("103", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("104", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("105", "sidebars_widgets", "a:7:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:1:{i:0;s:6:\"text-4\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}s:9:\"sidebar-4\";a:0:{}s:9:\"sidebar-5\";a:0:{}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("207", "current_theme", "Arras", "yes");
INSERT INTO `wp_options` VALUES("153", "cron", "a:4:{i:1479488374;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1479531591;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1479565534;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("1545", "uninstall_plugins", "a:2:{s:30:\"lightbox-plus/lightboxplus.php\";s:12:\"UninstallLBP\";s:36:\"contact-form-plugin/contact_form.php\";s:23:\"cntctfrm_delete_options\";}", "no");
INSERT INTO `wp_options` VALUES("162", "dashboard_widget_options", "a:4:{s:25:\"dashboard_recent_comments\";a:1:{s:5:\"items\";i:5;}s:24:\"dashboard_incoming_links\";a:5:{s:4:\"home\";s:29:\"http://santamargherita.s-m.cl\";s:4:\"link\";s:105:\"http://blogsearch.google.com/blogsearch?scoring=d&partner=wordpress&q=link:http://santamargherita.s-m.cl/\";s:3:\"url\";s:122:\"http://blogsearch.google.com/blogsearch_feeds?scoring=d&ie=utf-8&num=10&output=rss&partner=wordpress&q=link:http://s-m.cl/\";s:5:\"items\";i:10;s:9:\"show_date\";b:0;}s:17:\"dashboard_primary\";a:7:{s:4:\"link\";s:26:\"http://wordpress.org/news/\";s:3:\"url\";s:31:\"http://wordpress.org/news/feed/\";s:5:\"title\";s:14:\"WordPress Blog\";s:5:\"items\";i:2;s:12:\"show_summary\";i:1;s:11:\"show_author\";i:0;s:9:\"show_date\";i:1;}s:19:\"dashboard_secondary\";a:7:{s:4:\"link\";s:28:\"http://planet.wordpress.org/\";s:3:\"url\";s:33:\"http://planet.wordpress.org/feed/\";s:5:\"title\";s:20:\"Other WordPress News\";s:5:\"items\";i:5;s:12:\"show_summary\";i:0;s:11:\"show_author\";i:0;s:9:\"show_date\";i:0;}}", "yes");
INSERT INTO `wp_options` VALUES("1388", "gde_options", "a:13:{s:10:\"ed_disable\";s:2:\"no\";s:16:\"ed_extend_upload\";s:3:\"yes\";s:11:\"ed_embed_sc\";s:3:\"yes\";s:12:\"file_maxsize\";s:2:\"12\";s:11:\"error_check\";s:3:\"yes\";s:13:\"error_display\";s:3:\"yes\";s:9:\"error_log\";s:2:\"no\";s:10:\"beta_check\";s:3:\"yes\";s:9:\"ga_enable\";s:2:\"no\";s:11:\"ga_category\";s:19:\"Google Doc Embedder\";s:8:\"ga_label\";s:3:\"url\";s:7:\"api_key\";s:13:\"1Rmsa2MMOla5b\";s:8:\"upgraded\";s:3:\"yes\";}", "yes");
INSERT INTO `wp_options` VALUES("206", "theme_mods_twentyeleven", "a:1:{s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1334303074;s:4:\"data\";a:6:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}s:9:\"sidebar-4\";a:0:{}s:9:\"sidebar-5\";a:0:{}}}}", "yes");
INSERT INTO `wp_options` VALUES("208", "theme_mods_arras", "a:2:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:9:\"main-menu\";i:6;s:8:\"top-menu\";i:0;}}", "yes");
INSERT INTO `wp_options` VALUES("209", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("210", "arras_custom_bg_options", "s:206:\"a:9:{s:6:\"enable\";b:0;s:2:\"id\";i:0;s:10:\"attachment\";s:6:\"scroll\";s:5:\"pos-x\";s:6:\"center\";s:5:\"pos-y\";s:3:\"top\";s:6:\"repeat\";s:9:\"no-repeat\";s:5:\"color\";s:7:\"#F0F0F0\";s:10:\"foreground\";b:0;s:4:\"wrap\";b:0;}\";", "yes");
INSERT INTO `wp_options` VALUES("211", "arras_tapestry_default", "a:2:{s:5:\"nodes\";i:4;s:7:\"excerpt\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("212", "arras_options", "O:12:\"ArrasOptions\":56:{s:8:\"defaults\";a:47:{s:7:\"version\";s:5:\"1.5.2\";s:6:\"donate\";b:0;s:15:\"footer_sidebars\";i:1;s:12:\"footer_title\";s:9:\"Copyright\";s:14:\"footer_message\";s:47:\"<p>Copyright Tecnocom. All Rights Reserved.</p>\";s:11:\"topnav_home\";s:4:\"Home\";s:14:\"topnav_display\";s:10:\"categories\";s:14:\"topnav_linkcat\";i:0;s:15:\"hide_duplicates\";b:0;s:16:\"enable_slideshow\";b:1;s:13:\"slideshow_cat\";i:0;s:15:\"slideshow_count\";i:4;s:16:\"enable_featured1\";b:1;s:15:\"featured1_title\";s:16:\"Featured Stories\";s:13:\"featured1_cat\";i:0;s:17:\"featured1_display\";s:7:\"default\";s:15:\"featured1_count\";i:3;s:16:\"enable_featured2\";b:1;s:15:\"featured2_title\";s:14:\"Editors\' Picks\";s:13:\"featured2_cat\";i:0;s:17:\"featured2_display\";s:5:\"quick\";s:15:\"featured2_count\";i:3;s:11:\"enable_news\";b:1;s:10:\"news_title\";s:16:\"Latest Headlines\";s:8:\"news_cat\";i:0;s:12:\"news_display\";s:4:\"line\";s:11:\"index_count\";s:2:\"10\";s:15:\"archive_display\";s:5:\"quick\";s:14:\"display_author\";b:1;s:11:\"post_author\";b:1;s:9:\"post_date\";b:1;s:9:\"post_cats\";b:1;s:9:\"post_tags\";b:1;s:13:\"single_thumbs\";b:0;s:20:\"single_custom_fields\";s:31:\"Score:score,Pros:pros,Cons:cons\";s:13:\"excerpt_limit\";i:30;s:6:\"layout\";s:10:\"2c-r-fixed\";s:5:\"style\";s:7:\"default\";s:11:\"auto_thumbs\";b:1;s:18:\"slideshow_posttype\";s:4:\"post\";s:18:\"featured1_posttype\";s:4:\"post\";s:18:\"featured2_posttype\";s:4:\"post\";s:13:\"news_posttype\";s:4:\"post\";s:13:\"slideshow_tax\";s:8:\"category\";s:13:\"featured1_tax\";s:8:\"category\";s:13:\"featured2_tax\";s:8:\"category\";s:8:\"news_tax\";s:8:\"category\";}s:7:\"version\";s:5:\"1.5.2\";s:6:\"donate\";b:1;s:8:\"feed_url\";N;s:17:\"comments_feed_url\";N;s:16:\"twitter_username\";s:0:\"\";s:16:\"facebook_profile\";s:0:\"\";s:12:\"footer_title\";s:9:\"Copyright\";s:14:\"footer_message\";s:47:\"<p>Copyright Tecnocom. All Rights Reserved.</p>\";s:11:\"topnav_home\";s:4:\"Home\";s:14:\"topnav_display\";s:10:\"categories\";s:14:\"topnav_linkcat\";i:0;s:15:\"hide_duplicates\";b:0;s:16:\"enable_slideshow\";b:1;s:13:\"slideshow_cat\";a:1:{i:0;s:1:\"5\";}s:15:\"slideshow_count\";i:11;s:16:\"enable_featured1\";b:1;s:15:\"featured1_title\";s:1:\" \";s:13:\"featured1_cat\";a:1:{i:0;s:1:\"3\";}s:17:\"featured1_display\";s:7:\"default\";s:15:\"featured1_count\";i:8;s:16:\"enable_featured2\";b:0;s:15:\"featured2_title\";s:14:\"Editors\' Picks\";s:13:\"featured2_cat\";N;s:17:\"featured2_display\";s:5:\"quick\";s:15:\"featured2_count\";i:3;s:11:\"enable_news\";b:0;s:10:\"news_title\";s:16:\"Latest Headlines\";s:8:\"news_cat\";N;s:12:\"news_display\";s:4:\"line\";s:11:\"index_count\";i:10;s:15:\"archive_display\";s:7:\"default\";s:14:\"display_author\";b:0;s:20:\"single_custom_fields\";s:31:\"Score:score,Pros:pros,Cons:cons\";s:24:\"single_custom_taxonomies\";s:0:\"\";s:13:\"excerpt_limit\";i:12;s:11:\"post_author\";b:0;s:9:\"post_date\";b:0;s:9:\"post_cats\";b:0;s:9:\"post_tags\";b:0;s:14:\"postbar_footer\";N;s:13:\"single_thumbs\";b:0;s:11:\"auto_thumbs\";b:1;s:13:\"custom_thumbs\";a:5:{s:12:\"single-thumb\";a:2:{s:1:\"w\";i:700;s:1:\"h\";i:300;}s:13:\"sidebar-thumb\";a:2:{s:1:\"w\";i:36;s:1:\"h\";i:36;}s:24:\"featured-slideshow-thumb\";a:2:{s:1:\"w\";i:810;s:1:\"h\";i:328;}s:16:\"node-based-thumb\";a:2:{s:1:\"w\";i:196;s:1:\"h\";i:88;}s:19:\"quick-preview-thumb\";a:2:{s:1:\"w\";i:115;s:1:\"h\";i:115;}}s:6:\"layout\";s:8:\"3c-fixed\";s:5:\"style\";s:7:\"default\";s:4:\"logo\";i:559;s:15:\"footer_sidebars\";i:1;s:18:\"slideshow_posttype\";s:4:\"post\";s:18:\"featured1_posttype\";s:4:\"post\";s:18:\"featured2_posttype\";s:4:\"post\";s:13:\"news_posttype\";s:4:\"post\";s:13:\"slideshow_tax\";s:8:\"category\";s:13:\"featured1_tax\";s:8:\"category\";s:13:\"featured2_tax\";s:8:\"category\";s:8:\"news_tax\";s:8:\"category\";}", "yes");
INSERT INTO `wp_options` VALUES("221", "_transient_random_seed", "af4d191bc3979a469e3f5cf35f3c03fd", "yes");
INSERT INTO `wp_options` VALUES("213", "recently_activated", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("214", "lightboxplus_options", "a:39:{s:18:\"lightboxplus_style\";s:7:\"elegant\";s:16:\"use_custom_style\";N;s:11:\"disable_css\";N;s:12:\"use_php_four\";N;s:18:\"lightboxplus_multi\";N;s:10:\"use_inline\";N;s:10:\"inline_num\";s:1:\"1\";s:10:\"transition\";s:7:\"elastic\";s:5:\"speed\";s:3:\"350\";s:5:\"width\";s:5:\"false\";s:6:\"height\";s:5:\"false\";s:11:\"inner_width\";s:5:\"false\";s:12:\"inner_height\";s:5:\"false\";s:13:\"initial_width\";s:3:\"300\";s:14:\"initial_height\";s:3:\"100\";s:9:\"max_width\";s:3:\"800\";s:10:\"max_height\";s:3:\"500\";s:6:\"resize\";s:1:\"1\";s:7:\"opacity\";s:3:\"0.6\";s:10:\"preloading\";s:1:\"1\";s:11:\"label_image\";s:6:\"Imagen\";s:8:\"label_of\";s:2:\"de\";s:8:\"previous\";s:8:\"Antetior\";s:4:\"next\";s:9:\"Siguiente\";s:5:\"close\";s:6:\"Cerrar\";s:13:\"overlay_close\";s:1:\"1\";s:9:\"slideshow\";N;s:14:\"slideshow_auto\";N;s:15:\"slideshow_speed\";s:4:\"2500\";s:15:\"slideshow_start\";s:5:\"start\";s:14:\"slideshow_stop\";s:4:\"stop\";s:17:\"use_caption_title\";N;s:20:\"gallery_lightboxplus\";N;s:18:\"multiple_galleries\";N;s:16:\"use_class_method\";N;s:10:\"class_name\";s:9:\"cboxModal\";s:16:\"no_auto_lightbox\";N;s:10:\"text_links\";N;s:16:\"no_display_title\";N;}", "yes");
INSERT INTO `wp_options` VALUES("215", "lightboxplus_init", "1", "yes");
INSERT INTO `wp_options` VALUES("216", "cntctfrm_options", "a:50:{s:19:\"cntctfrm_user_email\";s:2:\"sm\";s:21:\"cntctfrm_custom_email\";s:17:\"cnavarrete@s-m.cl\";s:21:\"cntctfrm_select_email\";s:6:\"custom\";s:19:\"cntctfrm_from_email\";s:4:\"user\";s:26:\"cntctfrm_custom_from_email\";s:0:\"\";s:26:\"cntctfrm_additions_options\";s:1:\"1\";s:19:\"cntctfrm_attachment\";i:0;s:32:\"cntctfrm_attachment_explanations\";i:1;s:18:\"cntctfrm_send_copy\";i:0;s:19:\"cntctfrm_from_field\";s:8:\"Tecnocom\";s:28:\"cntctfrm_display_phone_field\";i:0;s:30:\"cntctfrm_display_address_field\";i:0;s:28:\"cntctfrm_required_name_field\";i:1;s:31:\"cntctfrm_required_address_field\";i:0;s:29:\"cntctfrm_required_email_field\";i:1;s:29:\"cntctfrm_required_phone_field\";i:0;s:31:\"cntctfrm_required_subject_field\";i:1;s:31:\"cntctfrm_required_message_field\";i:1;s:25:\"cntctfrm_display_add_info\";i:1;s:26:\"cntctfrm_display_sent_from\";i:1;s:26:\"cntctfrm_display_date_time\";i:1;s:20:\"cntctfrm_mail_method\";s:7:\"wp-mail\";s:28:\"cntctfrm_display_coming_from\";i:1;s:27:\"cntctfrm_display_user_agent\";i:1;s:17:\"cntctfrm_language\";a:0:{}s:21:\"cntctfrm_change_label\";i:1;s:19:\"cntctfrm_name_label\";a:1:{s:2:\"en\";s:7:\"Nombre:\";}s:22:\"cntctfrm_address_label\";a:1:{s:2:\"en\";s:8:\"Address:\";}s:20:\"cntctfrm_email_label\";a:1:{s:2:\"en\";s:7:\"E-Mail:\";}s:20:\"cntctfrm_phone_label\";a:1:{s:2:\"en\";N;}s:22:\"cntctfrm_subject_label\";a:1:{s:2:\"en\";s:7:\"Asunto:\";}s:22:\"cntctfrm_message_label\";a:1:{s:2:\"en\";s:8:\"Mensaje:\";}s:25:\"cntctfrm_attachment_label\";a:1:{s:2:\"en\";s:0:\"\";}s:24:\"cntctfrm_send_copy_label\";a:1:{s:2:\"en\";s:14:\"Send me a copy\";}s:21:\"cntctfrm_submit_label\";a:1:{s:2:\"en\";s:6:\"Submit\";}s:19:\"cntctfrm_name_error\";a:1:{s:2:\"en\";s:22:\"Your name is required.\";}s:22:\"cntctfrm_address_error\";a:1:{s:2:\"en\";s:20:\"Address is required.\";}s:20:\"cntctfrm_email_error\";a:1:{s:2:\"en\";s:36:\"A proper e-mail address is required.\";}s:20:\"cntctfrm_phone_error\";a:1:{s:2:\"en\";s:25:\"Phone number is required.\";}s:22:\"cntctfrm_subject_error\";a:1:{s:2:\"en\";s:20:\"Subject is required.\";}s:22:\"cntctfrm_message_error\";a:1:{s:2:\"en\";s:25:\"Message text is required.\";}s:25:\"cntctfrm_attachment_error\";a:1:{s:2:\"en\";s:25:\"File format is not valid.\";}s:32:\"cntctfrm_attachment_upload_error\";a:1:{s:2:\"en\";s:18:\"File upload error.\";}s:30:\"cntctfrm_attachment_move_error\";a:1:{s:2:\"en\";s:31:\"The file could not be uploaded.\";}s:30:\"cntctfrm_attachment_size_error\";a:1:{s:2:\"en\";s:23:\"This file is too large.\";}s:22:\"cntctfrm_captcha_error\";a:1:{s:2:\"en\";s:28:\"Please fill out the CAPTCHA.\";}s:19:\"cntctfrm_form_error\";a:1:{s:2:\"en\";s:44:\"Please make corrections below and try again.\";}s:26:\"cntctfrm_action_after_send\";i:1;s:19:\"cntctfrm_thank_text\";a:1:{s:2:\"en\";N;}s:21:\"cntctfrm_redirect_url\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("17538", "rewrite_rules", "a:68:{s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:20:\"(.?.+?)(/[0-9]+)?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:20:\"([^/]+)(/[0-9]+)?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";}", "yes");
INSERT INTO `wp_options` VALUES("233", "widget_logic", "a:1:{s:6:\"text-4\";s:18:\"is_single(\\\'ccc\\\')\";}", "yes");
INSERT INTO `wp_options` VALUES("234", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("26534", "_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a", "1479494126", "yes");
INSERT INTO `wp_options` VALUES("26535", "_site_transient_poptags_40cd750bba9870f18aada2478b24840a", "a:100:{s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";s:4:\"6110\";}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"Post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";s:4:\"3747\";}s:6:\"plugin\";a:3:{s:4:\"name\";s:6:\"plugin\";s:4:\"slug\";s:6:\"plugin\";s:5:\"count\";s:4:\"3738\";}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";s:4:\"3244\";}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";s:4:\"2869\";}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";s:4:\"2546\";}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";s:4:\"2229\";}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";s:4:\"2155\";}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";s:4:\"2104\";}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";s:4:\"2089\";}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";s:4:\"2044\";}s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";s:4:\"2025\";}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";s:4:\"1965\";}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";s:4:\"1937\";}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"Facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";s:4:\"1756\";}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";s:4:\"1653\";}s:9:\"wordpress\";a:3:{s:4:\"name\";s:9:\"wordpress\";s:4:\"slug\";s:9:\"wordpress\";s:5:\"count\";s:4:\"1625\";}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";s:4:\"1469\";}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";s:4:\"1380\";}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";s:4:\"1299\";}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";s:4:\"1296\";}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";s:4:\"1152\";}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";s:4:\"1136\";}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";s:4:\"1065\";}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";s:4:\"1027\";}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";s:4:\"1017\";}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";s:3:\"969\";}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";s:3:\"964\";}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";s:3:\"963\";}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"AJAX\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";s:3:\"932\";}s:10:\"responsive\";a:3:{s:4:\"name\";s:10:\"responsive\";s:4:\"slug\";s:10:\"responsive\";s:5:\"count\";s:3:\"929\";}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";s:3:\"916\";}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";s:3:\"861\";}s:10:\"e-commerce\";a:3:{s:4:\"name\";s:10:\"e-commerce\";s:4:\"slug\";s:10:\"e-commerce\";s:5:\"count\";s:3:\"851\";}s:8:\"security\";a:3:{s:4:\"name\";s:8:\"security\";s:4:\"slug\";s:8:\"security\";s:5:\"count\";s:3:\"841\";}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";s:3:\"821\";}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";s:3:\"788\";}s:5:\"share\";a:3:{s:4:\"name\";s:5:\"Share\";s:4:\"slug\";s:5:\"share\";s:5:\"count\";s:3:\"783\";}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";s:3:\"783\";}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";s:3:\"770\";}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";s:3:\"759\";}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";s:3:\"751\";}s:9:\"analytics\";a:3:{s:4:\"name\";s:9:\"analytics\";s:4:\"slug\";s:9:\"analytics\";s:5:\"count\";s:3:\"749\";}s:6:\"slider\";a:3:{s:4:\"name\";s:6:\"slider\";s:4:\"slug\";s:6:\"slider\";s:5:\"count\";s:3:\"743\";}s:3:\"css\";a:3:{s:4:\"name\";s:3:\"CSS\";s:4:\"slug\";s:3:\"css\";s:5:\"count\";s:3:\"736\";}s:8:\"category\";a:3:{s:4:\"name\";s:8:\"category\";s:4:\"slug\";s:8:\"category\";s:5:\"count\";s:3:\"731\";}s:4:\"form\";a:3:{s:4:\"name\";s:4:\"form\";s:4:\"slug\";s:4:\"form\";s:5:\"count\";s:3:\"725\";}s:5:\"embed\";a:3:{s:4:\"name\";s:5:\"embed\";s:4:\"slug\";s:5:\"embed\";s:5:\"count\";s:3:\"718\";}s:6:\"search\";a:3:{s:4:\"name\";s:6:\"search\";s:4:\"slug\";s:6:\"search\";s:5:\"count\";s:3:\"718\";}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";s:3:\"710\";}s:6:\"custom\";a:3:{s:4:\"name\";s:6:\"custom\";s:4:\"slug\";s:6:\"custom\";s:5:\"count\";s:3:\"701\";}s:9:\"slideshow\";a:3:{s:4:\"name\";s:9:\"slideshow\";s:4:\"slug\";s:9:\"slideshow\";s:5:\"count\";s:3:\"656\";}s:4:\"menu\";a:3:{s:4:\"name\";s:4:\"menu\";s:4:\"slug\";s:4:\"menu\";s:5:\"count\";s:3:\"652\";}s:6:\"button\";a:3:{s:4:\"name\";s:6:\"button\";s:4:\"slug\";s:6:\"button\";s:5:\"count\";s:3:\"640\";}s:5:\"stats\";a:3:{s:4:\"name\";s:5:\"stats\";s:4:\"slug\";s:5:\"stats\";s:5:\"count\";s:3:\"635\";}s:5:\"theme\";a:3:{s:4:\"name\";s:5:\"theme\";s:4:\"slug\";s:5:\"theme\";s:5:\"count\";s:3:\"629\";}s:7:\"comment\";a:3:{s:4:\"name\";s:7:\"comment\";s:4:\"slug\";s:7:\"comment\";s:5:\"count\";s:3:\"616\";}s:9:\"dashboard\";a:3:{s:4:\"name\";s:9:\"dashboard\";s:4:\"slug\";s:9:\"dashboard\";s:5:\"count\";s:3:\"615\";}s:4:\"tags\";a:3:{s:4:\"name\";s:4:\"tags\";s:4:\"slug\";s:4:\"tags\";s:5:\"count\";s:3:\"614\";}s:6:\"mobile\";a:3:{s:4:\"name\";s:6:\"mobile\";s:4:\"slug\";s:6:\"mobile\";s:5:\"count\";s:3:\"612\";}s:10:\"categories\";a:3:{s:4:\"name\";s:10:\"categories\";s:4:\"slug\";s:10:\"categories\";s:5:\"count\";s:3:\"601\";}s:6:\"editor\";a:3:{s:4:\"name\";s:6:\"editor\";s:4:\"slug\";s:6:\"editor\";s:5:\"count\";s:3:\"585\";}s:10:\"statistics\";a:3:{s:4:\"name\";s:10:\"statistics\";s:4:\"slug\";s:10:\"statistics\";s:5:\"count\";s:3:\"585\";}s:3:\"ads\";a:3:{s:4:\"name\";s:3:\"ads\";s:4:\"slug\";s:3:\"ads\";s:5:\"count\";s:3:\"584\";}s:4:\"user\";a:3:{s:4:\"name\";s:4:\"user\";s:4:\"slug\";s:4:\"user\";s:5:\"count\";s:3:\"580\";}s:12:\"social-media\";a:3:{s:4:\"name\";s:12:\"social media\";s:4:\"slug\";s:12:\"social-media\";s:5:\"count\";s:3:\"563\";}s:5:\"users\";a:3:{s:4:\"name\";s:5:\"users\";s:4:\"slug\";s:5:\"users\";s:5:\"count\";s:3:\"553\";}s:4:\"list\";a:3:{s:4:\"name\";s:4:\"list\";s:4:\"slug\";s:4:\"list\";s:5:\"count\";s:3:\"549\";}s:12:\"contact-form\";a:3:{s:4:\"name\";s:12:\"contact form\";s:4:\"slug\";s:12:\"contact-form\";s:5:\"count\";s:3:\"546\";}s:6:\"simple\";a:3:{s:4:\"name\";s:6:\"simple\";s:4:\"slug\";s:6:\"simple\";s:5:\"count\";s:3:\"540\";}s:9:\"affiliate\";a:3:{s:4:\"name\";s:9:\"affiliate\";s:4:\"slug\";s:9:\"affiliate\";s:5:\"count\";s:3:\"540\";}s:7:\"plugins\";a:3:{s:4:\"name\";s:7:\"plugins\";s:4:\"slug\";s:7:\"plugins\";s:5:\"count\";s:3:\"538\";}s:9:\"multisite\";a:3:{s:4:\"name\";s:9:\"multisite\";s:4:\"slug\";s:9:\"multisite\";s:5:\"count\";s:3:\"534\";}s:4:\"shop\";a:3:{s:4:\"name\";s:4:\"shop\";s:4:\"slug\";s:4:\"shop\";s:5:\"count\";s:3:\"522\";}s:7:\"picture\";a:3:{s:4:\"name\";s:7:\"picture\";s:4:\"slug\";s:7:\"picture\";s:5:\"count\";s:3:\"519\";}s:9:\"marketing\";a:3:{s:4:\"name\";s:9:\"marketing\";s:4:\"slug\";s:9:\"marketing\";s:5:\"count\";s:3:\"509\";}s:3:\"api\";a:3:{s:4:\"name\";s:3:\"api\";s:4:\"slug\";s:3:\"api\";s:5:\"count\";s:3:\"507\";}s:7:\"contact\";a:3:{s:4:\"name\";s:7:\"contact\";s:4:\"slug\";s:7:\"contact\";s:5:\"count\";s:3:\"496\";}s:3:\"url\";a:3:{s:4:\"name\";s:3:\"url\";s:4:\"slug\";s:3:\"url\";s:5:\"count\";s:3:\"484\";}s:10:\"navigation\";a:3:{s:4:\"name\";s:10:\"navigation\";s:4:\"slug\";s:10:\"navigation\";s:5:\"count\";s:3:\"471\";}s:10:\"newsletter\";a:3:{s:4:\"name\";s:10:\"newsletter\";s:4:\"slug\";s:10:\"newsletter\";s:5:\"count\";s:3:\"469\";}s:8:\"pictures\";a:3:{s:4:\"name\";s:8:\"pictures\";s:4:\"slug\";s:8:\"pictures\";s:5:\"count\";s:3:\"467\";}s:4:\"html\";a:3:{s:4:\"name\";s:4:\"html\";s:4:\"slug\";s:4:\"html\";s:5:\"count\";s:3:\"462\";}s:6:\"events\";a:3:{s:4:\"name\";s:6:\"events\";s:4:\"slug\";s:6:\"events\";s:5:\"count\";s:3:\"459\";}s:8:\"tracking\";a:3:{s:4:\"name\";s:8:\"tracking\";s:4:\"slug\";s:8:\"tracking\";s:5:\"count\";s:3:\"448\";}s:10:\"shortcodes\";a:3:{s:4:\"name\";s:10:\"shortcodes\";s:4:\"slug\";s:10:\"shortcodes\";s:5:\"count\";s:3:\"447\";}s:8:\"calendar\";a:3:{s:4:\"name\";s:8:\"calendar\";s:4:\"slug\";s:8:\"calendar\";s:5:\"count\";s:3:\"443\";}s:4:\"meta\";a:3:{s:4:\"name\";s:4:\"meta\";s:4:\"slug\";s:4:\"meta\";s:5:\"count\";s:3:\"438\";}s:8:\"lightbox\";a:3:{s:4:\"name\";s:8:\"lightbox\";s:4:\"slug\";s:8:\"lightbox\";s:5:\"count\";s:3:\"436\";}s:3:\"tag\";a:3:{s:4:\"name\";s:3:\"tag\";s:4:\"slug\";s:3:\"tag\";s:5:\"count\";s:3:\"430\";}s:6:\"paypal\";a:3:{s:4:\"name\";s:6:\"paypal\";s:4:\"slug\";s:6:\"paypal\";s:5:\"count\";s:3:\"427\";}s:11:\"advertising\";a:3:{s:4:\"name\";s:11:\"advertising\";s:4:\"slug\";s:11:\"advertising\";s:5:\"count\";s:3:\"426\";}s:6:\"upload\";a:3:{s:4:\"name\";s:6:\"upload\";s:4:\"slug\";s:6:\"upload\";s:5:\"count\";s:3:\"425\";}s:12:\"notification\";a:3:{s:4:\"name\";s:12:\"notification\";s:4:\"slug\";s:12:\"notification\";s:5:\"count\";s:3:\"424\";}s:4:\"news\";a:3:{s:4:\"name\";s:4:\"News\";s:4:\"slug\";s:4:\"news\";s:5:\"count\";s:3:\"422\";}s:7:\"sharing\";a:3:{s:4:\"name\";s:7:\"sharing\";s:4:\"slug\";s:7:\"sharing\";s:5:\"count\";s:3:\"422\";}s:5:\"flash\";a:3:{s:4:\"name\";s:5:\"flash\";s:4:\"slug\";s:5:\"flash\";s:5:\"count\";s:3:\"421\";}s:9:\"thumbnail\";a:3:{s:4:\"name\";s:9:\"thumbnail\";s:4:\"slug\";s:9:\"thumbnail\";s:5:\"count\";s:3:\"417\";}s:16:\"custom-post-type\";a:3:{s:4:\"name\";s:16:\"custom post type\";s:4:\"slug\";s:16:\"custom-post-type\";s:5:\"count\";s:3:\"414\";}s:8:\"linkedin\";a:3:{s:4:\"name\";s:8:\"linkedin\";s:4:\"slug\";s:8:\"linkedin\";s:5:\"count\";s:3:\"413\";}}", "yes");
INSERT INTO `wp_options` VALUES("1546", "db_upgraded", "", "yes");
INSERT INTO `wp_options` VALUES("4354", "link_manager_enabled", "1", "yes");
INSERT INTO `wp_options` VALUES("6311", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:20:\"gabrielagb@gmail.com\";s:7:\"version\";s:6:\"3.9.14\";s:9:\"timestamp\";i:1473266509;}", "yes");
INSERT INTO `wp_options` VALUES("4020", "gde_db_version", "1.2", "yes");
INSERT INTO `wp_options` VALUES("22826", "can_compress_scripts", "0", "yes");
INSERT INTO `wp_options` VALUES("26532", "_transient_timeout_plugin_slugs", "1479569751", "no");
INSERT INTO `wp_options` VALUES("26533", "_transient_plugin_slugs", "a:7:{i:0;s:36:\"contact-form-plugin/contact_form.php\";i:1;s:25:\"duplicator/duplicator.php\";i:2;s:36:\"google-document-embedder/gviewer.php\";i:3;s:39:\"improved-include-page/iinclude_page.php\";i:4;s:30:\"lightbox-plus/lightboxplus.php\";i:5;s:29:\"widget-logic/widget_logic.php\";i:6;s:31:\"wp-statistics/wp-statistics.php\";}", "no");
INSERT INTO `wp_options` VALUES("26531", "_site_transient_browser_bbe17f0a746d1d92d88f5944fc82bf7f", "a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"54.0.2840.99\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("26527", "_site_transient_update_themes", "O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1479483345;s:7:\"checked\";a:5:{s:5:\"arras\";s:9:\"1.5.2-RC2\";s:12:\"twentyeleven\";s:3:\"1.3\";s:14:\"twentyfourteen\";s:3:\"1.0\";s:14:\"twentythirteen\";s:3:\"1.0\";s:12:\"twentytwelve\";s:3:\"1.2\";}s:8:\"response\";a:4:{s:12:\"twentyeleven\";a:4:{s:5:\"theme\";s:12:\"twentyeleven\";s:11:\"new_version\";s:3:\"2.5\";s:3:\"url\";s:42:\"https://wordpress.org/themes/twentyeleven/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/theme/twentyeleven.2.5.zip\";}s:14:\"twentyfourteen\";a:4:{s:5:\"theme\";s:14:\"twentyfourteen\";s:11:\"new_version\";s:3:\"1.8\";s:3:\"url\";s:44:\"https://wordpress.org/themes/twentyfourteen/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/theme/twentyfourteen.1.8.zip\";}s:14:\"twentythirteen\";a:4:{s:5:\"theme\";s:14:\"twentythirteen\";s:11:\"new_version\";s:3:\"2.0\";s:3:\"url\";s:44:\"https://wordpress.org/themes/twentythirteen/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/theme/twentythirteen.2.0.zip\";}s:12:\"twentytwelve\";a:4:{s:5:\"theme\";s:12:\"twentytwelve\";s:11:\"new_version\";s:3:\"2.1\";s:3:\"url\";s:42:\"https://wordpress.org/themes/twentytwelve/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/theme/twentytwelve.2.1.zip\";}}s:12:\"translations\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("26538", "_site_transient_update_plugins", "O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1479483349;s:7:\"checked\";a:7:{s:36:\"contact-form-plugin/contact_form.php\";s:4:\"3.51\";s:25:\"duplicator/duplicator.php\";s:6:\"1.1.20\";s:36:\"google-document-embedder/gviewer.php\";s:5:\"2.5.7\";s:39:\"improved-include-page/iinclude_page.php\";s:5:\"0.4.8\";s:30:\"lightbox-plus/lightboxplus.php\";s:3:\"2.6\";s:29:\"widget-logic/widget_logic.php\";s:4:\"0.56\";s:31:\"wp-statistics/wp-statistics.php\";s:3:\"6.0\";}s:8:\"response\";a:4:{s:36:\"contact-form-plugin/contact_form.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"22832\";s:4:\"slug\";s:19:\"contact-form-plugin\";s:6:\"plugin\";s:36:\"contact-form-plugin/contact_form.php\";s:11:\"new_version\";s:5:\"4.0.3\";s:3:\"url\";s:50:\"https://wordpress.org/plugins/contact-form-plugin/\";s:7:\"package\";s:68:\"https://downloads.wordpress.org/plugin/contact-form-plugin.4.0.3.zip\";}s:36:\"google-document-embedder/gviewer.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"10222\";s:4:\"slug\";s:24:\"google-document-embedder\";s:6:\"plugin\";s:36:\"google-document-embedder/gviewer.php\";s:11:\"new_version\";s:5:\"2.6.2\";s:3:\"url\";s:55:\"https://wordpress.org/plugins/google-document-embedder/\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/plugin/google-document-embedder.zip\";}s:29:\"widget-logic/widget_logic.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:4:\"2545\";s:4:\"slug\";s:12:\"widget-logic\";s:6:\"plugin\";s:29:\"widget-logic/widget_logic.php\";s:11:\"new_version\";s:4:\"0.57\";s:3:\"url\";s:43:\"https://wordpress.org/plugins/widget-logic/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/widget-logic.0.57.zip\";}s:31:\"wp-statistics/wp-statistics.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"21429\";s:4:\"slug\";s:13:\"wp-statistics\";s:6:\"plugin\";s:31:\"wp-statistics/wp-statistics.php\";s:11:\"new_version\";s:6:\"11.0.1\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/wp-statistics/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/wp-statistics.11.0.1.zip\";}}s:12:\"translations\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("26539", "duplicator_settings", "a:10:{s:7:\"version\";s:6:\"1.1.20\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:16:\"uninstall_tables\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";b:0;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:20:\"storage_htaccess_off\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("26540", "duplicator_version_plugin", "1.1.20", "yes");
INSERT INTO `wp_options` VALUES("26541", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2016-11-18 15:36:24\";s:7:\"Version\";s:6:\"1.1.20\";s:9:\"VersionWP\";s:6:\"3.9.14\";s:9:\"VersionDB\";s:6:\"5.5.51\";s:10:\"VersionPHP\";s:6:\"5.2.17\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:24:\"20161118_santamargherita\";s:4:\"Hash\";s:29:\"582f1ff8618d76648161118153624\";s:8:\"NameHash\";s:54:\"20161118_santamargherita_582f1ff8618d76648161118153624\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:53:\"/home/sm/public_html/santamargherita/wp-snapshots/tmp\";s:8:\"StoreURL\";s:43:\"http://santamargherita.s-m.cl/wp-snapshots/\";s:8:\"ScanFile\";s:64:\"20161118_santamargherita_582f1ff8618d76648161118153624_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:36:\"/home/sm/public_html/santamargherita\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2016-11-18 15:36:24\";s:7:\"Version\";s:6:\"1.1.20\";s:9:\"VersionWP\";s:6:\"3.9.14\";s:9:\"VersionDB\";s:6:\"5.5.51\";s:10:\"VersionPHP\";s:6:\"5.2.17\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:24:\"20161118_santamargherita\";s:4:\"Hash\";s:29:\"582f1ff8618d76648161118153624\";s:8:\"NameHash\";s:54:\"20161118_santamargherita_582f1ff8618d76648161118153624\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:53:\"/home/sm/public_html/santamargherita/wp-snapshots/tmp\";s:8:\"StoreURL\";s:43:\"http://santamargherita.s-m.cl/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";r:22;s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:52;}s:8:\"Database\";O:12:\"DUP_Database\":12:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:10:\"\0*\0Package\";r:52;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}}s:9:\"Installer\";r:74;s:8:\"Database\";r:87;}", "yes");
INSERT INTO `wp_options` VALUES("26530", "_site_transient_timeout_browser_bbe17f0a746d1d92d88f5944fc82bf7f", "1480088110", "yes");
INSERT INTO `wp_options` VALUES("25584", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:8:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:7:\"upgrade\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.6.1.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.6.1.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-4.6.1-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.6.1-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.6.1\";s:7:\"version\";s:5:\"4.6.1\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.4\";s:15:\"partial_version\";s:0:\"\";}i:1;O:8:\"stdClass\":10:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.6.1.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.6.1.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-4.6.1-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.6.1-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.6.1\";s:7:\"version\";s:5:\"4.6.1\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.4\";s:15:\"partial_version\";s:0:\"\";}i:2;O:8:\"stdClass\":10:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.5.4.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.5.4.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-4.5.4-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.5.4-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.5.4\";s:7:\"version\";s:5:\"4.5.4\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.4\";s:15:\"partial_version\";s:0:\"\";}i:3;O:8:\"stdClass\":10:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.4.5.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.4.5.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-4.4.5-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.4.5-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.4.5\";s:7:\"version\";s:5:\"4.4.5\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.4\";s:15:\"partial_version\";s:0:\"\";}i:4;O:8:\"stdClass\":10:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.3.6.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.3.6.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-4.3.6-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.3.6-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.3.6\";s:7:\"version\";s:5:\"4.3.6\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.4\";s:15:\"partial_version\";s:0:\"\";}i:5;O:8:\"stdClass\":10:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:60:\"https://downloads.wordpress.org/release/wordpress-4.2.10.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:60:\"https://downloads.wordpress.org/release/wordpress-4.2.10.zip\";s:10:\"no_content\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.2.10-no-content.zip\";s:11:\"new_bundled\";s:72:\"https://downloads.wordpress.org/release/wordpress-4.2.10-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:6:\"4.2.10\";s:7:\"version\";s:6:\"4.2.10\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.4\";s:15:\"partial_version\";s:0:\"\";}i:6;O:8:\"stdClass\":10:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:60:\"https://downloads.wordpress.org/release/wordpress-4.1.13.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:60:\"https://downloads.wordpress.org/release/wordpress-4.1.13.zip\";s:10:\"no_content\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.1.13-no-content.zip\";s:11:\"new_bundled\";s:72:\"https://downloads.wordpress.org/release/wordpress-4.1.13-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:6:\"4.1.13\";s:7:\"version\";s:6:\"4.1.13\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.4\";s:15:\"partial_version\";s:0:\"\";}i:7;O:8:\"stdClass\":10:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:60:\"https://downloads.wordpress.org/release/wordpress-4.0.13.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:60:\"https://downloads.wordpress.org/release/wordpress-4.0.13.zip\";s:10:\"no_content\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.0.13-no-content.zip\";s:11:\"new_bundled\";s:72:\"https://downloads.wordpress.org/release/wordpress-4.0.13-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:6:\"4.0.13\";s:7:\"version\";s:6:\"4.0.13\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.4\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1479483345;s:15:\"version_checked\";s:6:\"3.9.14\";s:12:\"translations\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("6039", "category_children", "a:1:{i:8;a:2:{i:0;i:9;i:1;i:10;}}", "yes");
INSERT INTO `wp_options` VALUES("22824", "_site_transient_timeout_browser_1b39d7d1d62ac4d2b3dc7459ef7d1588", "1458749117", "yes");
INSERT INTO `wp_options` VALUES("22825", "_site_transient_browser_1b39d7d1d62ac4d2b3dc7459ef7d1588", "a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"49.0.2623.87\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("6083", "wp_statistics_plugin_version", "6.0", "yes");
INSERT INTO `wp_options` VALUES("6084", "wp_statistics_db_version", "6.0", "yes");
INSERT INTO `wp_options` VALUES("6085", "wps_useronline", "1", "yes");
INSERT INTO `wp_options` VALUES("6086", "wps_visits", "1", "yes");
INSERT INTO `wp_options` VALUES("6087", "wps_visitors", "1", "yes");
INSERT INTO `wp_options` VALUES("6088", "wps_check_online", "30", "yes");
INSERT INTO `wp_options` VALUES("6089", "wps_coefficient", "1", "yes");
INSERT INTO `wp_options` VALUES("6090", "wps_chart_type", "line", "yes");
INSERT INTO `wp_options` VALUES("6091", "wps_time_report", "daily", "yes");
INSERT INTO `wp_options` VALUES("6092", "wps_send_report", "mail", "yes");
INSERT INTO `wp_options` VALUES("6093", "wps_content_report", "", "yes");
INSERT INTO `wp_options` VALUES("6094", "wps_update_geoip", "", "yes");
INSERT INTO `wp_options` VALUES("6095", "wps_robotlist", "A6-Indexer\nAbachoBOT\naccoona\nAcoiRobot\nAddThis.com\nADmantX\nAhrefsBot\nalexa\nAltaVista\nappie\narchive.org_bot\nAsk Jeeves\nASPSeek\nBaiduspider\nBenjojo\nbingbot\nBOT for JCE\nButterfly\nccbot\nclamantivirus\ncrawler\nCrocCrawler\nDumbot\neStyle\nezooms\nfacebookexternalhit\nFAST\nFeedfetcher-Google\nFirfly\nfroogle\nGeonaBot\nGigabot\ngirafabot\nGooglebot\nia_archiver\nIDBot\nInfoSeek\ninktomi\nLeikibot\nlinkdexbot\nLoadTimeBot\nlooksmart\nLycos\nMail.RU_Bot\nMe.dium\nmeanpathbot\nMediapartners-Google\nMJ12bot\nmsnbot\nmoreover\nMRBOT\nNationalDirectory\nNerdyBot\nniki-bot\nnutch\nOpenbot\nPagesInventory\nproximic\nrabaz\nRambler\nRankivabot\nScooter\nScrubby\nsees.co\nSeznamBot\nSlurp\nSocialSearch\nSogou web spider\nSpade\nspbot\nSurveyBot\nTechnoratiSnoop\nTECNOSEEK\nTeoma\ntrendictionbot\nTweetmemeBot\nTwiceler\nTwitterbot\nTwitturls\nURL_Spider_SQL\nWebAlta Crawler\nWebBug\nWebFindBot\nWeSEE:Search\nWotbox\nwww.galaxy.com\nyandex\nYahoo\nYammybot\nZyBorg\nZemlyaCrawl", "yes");
INSERT INTO `wp_options` VALUES("6096", "wps_exclude_administrator", "1", "yes");
INSERT INTO `wp_options` VALUES("6097", "wps_last_geoip_dl", "1398873905", "yes");

/* INSERT TABLE DATA: wp_postmeta */
INSERT INTO `wp_postmeta` VALUES("1516", "1434", "_edit_lock", "1398871492:1");
INSERT INTO `wp_postmeta` VALUES("609", "772", "_wp_attached_file", "2012/03/Apulia-b.jpg");
INSERT INTO `wp_postmeta` VALUES("610", "772", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'96\'\";s:4:\"file\";s:20:\"2012/03/Apulia-b.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:20:\"Apulia-b-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:20:\"Apulia-b-500x300.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:18:\"Apulia-b-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:20:\"Apulia-b-500x328.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:19:\"Apulia-b-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:20:\"Apulia-b-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("611", "773", "_wp_attached_file", "2012/03/Atena-b.jpg");
INSERT INTO `wp_postmeta` VALUES("612", "773", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'96\'\";s:4:\"file\";s:19:\"2012/03/Atena-b.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:19:\"Atena-b-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:19:\"Atena-b-500x300.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:17:\"Atena-b-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:19:\"Atena-b-500x328.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:18:\"Atena-b-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:19:\"Atena-b-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:9:\"SM 9800XL\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1229359332\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("539", "727", "_wp_attached_file", "2012/05/santamargherita1.png");
INSERT INTO `wp_postmeta` VALUES("540", "727", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"342\";s:6:\"height\";s:3:\"106\";s:14:\"hwstring_small\";s:23:\"height=\'39\' width=\'128\'\";s:4:\"file\";s:28:\"2012/05/santamargherita1.png\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:28:\"santamargherita1-116x106.png\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"106\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:26:\"santamargherita1-36x36.png\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:27:\"santamargherita1-196x88.png\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:28:\"santamargherita1-115x106.png\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"106\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("614", "775", "_wp_attached_file", "2012/03/Auby-b.jpg");
INSERT INTO `wp_postmeta` VALUES("615", "775", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'96\'\";s:4:\"file\";s:18:\"2012/03/Auby-b.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:18:\"Auby-b-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:18:\"Auby-b-500x300.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:16:\"Auby-b-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:18:\"Auby-b-500x328.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:17:\"Auby-b-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:18:\"Auby-b-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("616", "776", "_wp_attached_file", "2012/03/Belvedere-b.jpg");
INSERT INTO `wp_postmeta` VALUES("617", "776", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'96\'\";s:4:\"file\";s:23:\"2012/03/Belvedere-b.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:23:\"Belvedere-b-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:23:\"Belvedere-b-500x300.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:21:\"Belvedere-b-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:23:\"Belvedere-b-500x328.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:22:\"Belvedere-b-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:23:\"Belvedere-b-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1123", "1143", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1121", "383", "_wp_old_slug", "eficiencia-energetica");
INSERT INTO `wp_postmeta` VALUES("1124", "1143", "_edit_lock", "1340031640:1");
INSERT INTO `wp_postmeta` VALUES("1126", "1145", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("1127", "1145", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("1128", "1145", "_menu_item_object_id", "1145");
INSERT INTO `wp_postmeta` VALUES("1129", "1145", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("1130", "1145", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("1131", "1145", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1132", "1145", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("1133", "1145", "_menu_item_url", "http://santamargherita.s-m.cl/category/obras/");
INSERT INTO `wp_postmeta` VALUES("1146", "1153", "_edit_lock", "1339735501:1");
INSERT INTO `wp_postmeta` VALUES("1156", "1161", "_wp_attached_file", "2012/06/aeropuertos.jpg");
INSERT INTO `wp_postmeta` VALUES("1151", "1158", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1152", "1158", "_edit_lock", "1339735479:1");
INSERT INTO `wp_postmeta` VALUES("626", "784", "_wp_attached_file", "2012/03/ventajas3.jpg");
INSERT INTO `wp_postmeta` VALUES("627", "784", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";s:14:\"hwstring_small\";s:23:\"height=\'51\' width=\'128\'\";s:4:\"file\";s:21:\"2012/03/ventajas3.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:21:\"ventajas3-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:21:\"ventajas3-576x233.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"233\";}s:5:\"large\";a:3:{s:4:\"file\";s:21:\"ventajas3-700x283.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"283\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:21:\"ventajas3-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:19:\"ventajas3-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:20:\"ventajas3-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:21:\"ventajas3-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("638", "792", "_wp_attached_file", "2012/03/garantia2.jpg");
INSERT INTO `wp_postmeta` VALUES("639", "792", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";s:14:\"hwstring_small\";s:23:\"height=\'51\' width=\'128\'\";s:4:\"file\";s:21:\"2012/03/garantia2.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:21:\"garantia2-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:21:\"garantia2-576x233.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"233\";}s:5:\"large\";a:3:{s:4:\"file\";s:21:\"garantia2-700x283.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"283\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:21:\"garantia2-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:19:\"garantia2-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:20:\"garantia2-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:21:\"garantia2-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("632", "788", "_wp_attached_file", "2012/03/novedades3.jpg");
INSERT INTO `wp_postmeta` VALUES("633", "788", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";s:14:\"hwstring_small\";s:23:\"height=\'51\' width=\'128\'\";s:4:\"file\";s:22:\"2012/03/novedades3.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:22:\"novedades3-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:22:\"novedades3-576x233.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"233\";}s:5:\"large\";a:3:{s:4:\"file\";s:22:\"novedades3-700x283.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"283\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:22:\"novedades3-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:20:\"novedades3-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:21:\"novedades3-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:22:\"novedades3-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("641", "794", "_wp_attached_file", "2012/03/colores2.jpg");
INSERT INTO `wp_postmeta` VALUES("642", "794", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";s:14:\"hwstring_small\";s:23:\"height=\'51\' width=\'128\'\";s:4:\"file\";s:20:\"2012/03/colores2.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:20:\"colores2-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:20:\"colores2-576x233.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"233\";}s:5:\"large\";a:3:{s:4:\"file\";s:20:\"colores2-700x283.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"283\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:20:\"colores2-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:18:\"colores2-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:19:\"colores2-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:20:\"colores2-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("644", "796", "_wp_attached_file", "2012/03/aplicaciones2.jpg");
INSERT INTO `wp_postmeta` VALUES("645", "796", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";s:14:\"hwstring_small\";s:23:\"height=\'51\' width=\'128\'\";s:4:\"file\";s:25:\"2012/03/aplicaciones2.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:25:\"aplicaciones2-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:25:\"aplicaciones2-576x233.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"233\";}s:5:\"large\";a:3:{s:4:\"file\";s:25:\"aplicaciones2-700x283.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"283\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:25:\"aplicaciones2-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:23:\"aplicaciones2-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:24:\"aplicaciones2-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:25:\"aplicaciones2-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("648", "799", "_wp_attached_file", "2012/03/mantenimiento2.jpg");
INSERT INTO `wp_postmeta` VALUES("649", "799", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";s:14:\"hwstring_small\";s:23:\"height=\'51\' width=\'128\'\";s:4:\"file\";s:26:\"2012/03/mantenimiento2.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:26:\"mantenimiento2-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:26:\"mantenimiento2-576x233.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"233\";}s:5:\"large\";a:3:{s:4:\"file\";s:26:\"mantenimiento2-700x283.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"283\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:26:\"mantenimiento2-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:24:\"mantenimiento2-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:25:\"mantenimiento2-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:26:\"mantenimiento2-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("651", "801", "_wp_attached_file", "2012/03/certificaciones2.jpg");
INSERT INTO `wp_postmeta` VALUES("652", "801", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";s:14:\"hwstring_small\";s:23:\"height=\'51\' width=\'128\'\";s:4:\"file\";s:28:\"2012/03/certificaciones2.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:28:\"certificaciones2-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:28:\"certificaciones2-576x233.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"233\";}s:5:\"large\";a:3:{s:4:\"file\";s:28:\"certificaciones2-700x283.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"283\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:28:\"certificaciones2-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:26:\"certificaciones2-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:27:\"certificaciones2-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:28:\"certificaciones2-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("655", "804", "_wp_attached_file", "2012/03/Breda-b.jpg");
INSERT INTO `wp_postmeta` VALUES("656", "804", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"508\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'94\'\";s:4:\"file\";s:19:\"2012/03/Breda-b.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:19:\"Breda-b-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:19:\"Breda-b-500x300.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:17:\"Breda-b-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:19:\"Breda-b-500x328.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:18:\"Breda-b-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:19:\"Breda-b-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("657", "805", "_wp_attached_file", "2012/03/Caledonia-b.jpg");
INSERT INTO `wp_postmeta` VALUES("658", "805", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"505\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'95\'\";s:4:\"file\";s:23:\"2012/03/Caledonia-b.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:23:\"Caledonia-b-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:23:\"Caledonia-b-500x300.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:21:\"Caledonia-b-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:23:\"Caledonia-b-500x328.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:22:\"Caledonia-b-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:23:\"Caledonia-b-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:9:\"SM 9800XL\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1229447088\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("659", "806", "_wp_attached_file", "2012/03/Camargue-b.jpg");
INSERT INTO `wp_postmeta` VALUES("660", "806", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"508\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'94\'\";s:4:\"file\";s:22:\"2012/03/Camargue-b.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:22:\"Camargue-b-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:22:\"Camargue-b-500x300.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:20:\"Camargue-b-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:22:\"Camargue-b-500x328.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:21:\"Camargue-b-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:22:\"Camargue-b-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("661", "807", "_wp_attached_file", "2012/03/Carnia-b.jpg");
INSERT INTO `wp_postmeta` VALUES("662", "807", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'96\'\";s:4:\"file\";s:20:\"2012/03/Carnia-b.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:20:\"Carnia-b-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:20:\"Carnia-b-500x300.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:18:\"Carnia-b-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:20:\"Carnia-b-500x328.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:19:\"Carnia-b-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:20:\"Carnia-b-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("663", "808", "_wp_attached_file", "2012/03/Catalina-b.jpg");
INSERT INTO `wp_postmeta` VALUES("664", "808", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'96\'\";s:4:\"file\";s:22:\"2012/03/Catalina-b.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:22:\"Catalina-b-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:22:\"Catalina-b-500x300.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:20:\"Catalina-b-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:22:\"Catalina-b-500x328.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:21:\"Catalina-b-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:22:\"Catalina-b-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("665", "809", "_wp_attached_file", "2012/03/Friuli-b.jpg");
INSERT INTO `wp_postmeta` VALUES("666", "809", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'96\'\";s:4:\"file\";s:20:\"2012/03/Friuli-b.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:20:\"Friuli-b-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:20:\"Friuli-b-500x300.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:18:\"Friuli-b-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:20:\"Friuli-b-500x328.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:19:\"Friuli-b-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:20:\"Friuli-b-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:9:\"SM 9800XL\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1229427428\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("669", "812", "_wp_attached_file", "2012/03/Hermitage-b.jpg");
INSERT INTO `wp_postmeta` VALUES("670", "812", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'96\'\";s:4:\"file\";s:23:\"2012/03/Hermitage-b.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:23:\"Hermitage-b-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:23:\"Hermitage-b-500x300.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:21:\"Hermitage-b-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:23:\"Hermitage-b-500x328.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:22:\"Hermitage-b-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:23:\"Hermitage-b-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("671", "813", "_wp_attached_file", "2012/03/Istria-b.jpg");
INSERT INTO `wp_postmeta` VALUES("672", "813", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"508\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'94\'\";s:4:\"file\";s:20:\"2012/03/Istria-b.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:20:\"Istria-b-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:20:\"Istria-b-500x300.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:18:\"Istria-b-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:20:\"Istria-b-500x328.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:19:\"Istria-b-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:20:\"Istria-b-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("673", "814", "_wp_attached_file", "2012/03/Itaca-b.jpg");
INSERT INTO `wp_postmeta` VALUES("674", "814", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'96\'\";s:4:\"file\";s:19:\"2012/03/Itaca-b.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:19:\"Itaca-b-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:19:\"Itaca-b-500x300.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:17:\"Itaca-b-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:19:\"Itaca-b-500x328.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:18:\"Itaca-b-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:19:\"Itaca-b-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:9:\"SM 9800XL\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1229356497\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("675", "815", "_wp_attached_file", "2012/03/Miami-b.jpg");
INSERT INTO `wp_postmeta` VALUES("676", "815", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"508\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'94\'\";s:4:\"file\";s:19:\"2012/03/Miami-b.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:19:\"Miami-b-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:19:\"Miami-b-500x300.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:17:\"Miami-b-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:19:\"Miami-b-500x328.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:18:\"Miami-b-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:19:\"Miami-b-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("677", "816", "_wp_attached_file", "2012/03/Miramare-b.jpg");
INSERT INTO `wp_postmeta` VALUES("678", "816", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'96\'\";s:4:\"file\";s:22:\"2012/03/Miramare-b.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:22:\"Miramare-b-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:22:\"Miramare-b-500x300.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:20:\"Miramare-b-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:22:\"Miramare-b-500x328.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:21:\"Miramare-b-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:22:\"Miramare-b-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("679", "817", "_wp_attached_file", "2012/03/Modena-b.jpg");
INSERT INTO `wp_postmeta` VALUES("680", "817", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'96\'\";s:4:\"file\";s:20:\"2012/03/Modena-b.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:20:\"Modena-b-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:20:\"Modena-b-500x300.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:18:\"Modena-b-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:20:\"Modena-b-500x328.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:19:\"Modena-b-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:20:\"Modena-b-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:9:\"SM 9800XL\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1229357631\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("681", "818", "_wp_attached_file", "2012/03/Naxos-b.jpg");
INSERT INTO `wp_postmeta` VALUES("682", "818", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"508\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'94\'\";s:4:\"file\";s:19:\"2012/03/Naxos-b.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:19:\"Naxos-b-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:19:\"Naxos-b-500x300.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:17:\"Naxos-b-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:19:\"Naxos-b-500x328.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:18:\"Naxos-b-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:19:\"Naxos-b-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("683", "819", "_wp_attached_file", "2012/03/Nero-b.jpg");
INSERT INTO `wp_postmeta` VALUES("684", "819", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'96\'\";s:4:\"file\";s:18:\"2012/03/Nero-b.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:18:\"Nero-b-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:18:\"Nero-b-500x300.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:16:\"Nero-b-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:18:\"Nero-b-500x328.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:17:\"Nero-b-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:18:\"Nero-b-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("685", "820", "_wp_attached_file", "2012/03/Otello-b.jpg");
INSERT INTO `wp_postmeta` VALUES("686", "820", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'96\'\";s:4:\"file\";s:20:\"2012/03/Otello-b.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:20:\"Otello-b-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:20:\"Otello-b-500x300.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:18:\"Otello-b-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:20:\"Otello-b-500x328.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:19:\"Otello-b-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:20:\"Otello-b-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("687", "821", "_wp_attached_file", "2012/03/Pompei-b.jpg");
INSERT INTO `wp_postmeta` VALUES("688", "821", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"508\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'94\'\";s:4:\"file\";s:20:\"2012/03/Pompei-b.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:20:\"Pompei-b-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:20:\"Pompei-b-500x300.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:18:\"Pompei-b-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:20:\"Pompei-b-500x328.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:19:\"Pompei-b-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:20:\"Pompei-b-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("689", "822", "_wp_attached_file", "2012/03/Prussia-b.jpg");
INSERT INTO `wp_postmeta` VALUES("690", "822", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'96\'\";s:4:\"file\";s:21:\"2012/03/Prussia-b.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:21:\"Prussia-b-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:21:\"Prussia-b-500x300.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:19:\"Prussia-b-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:21:\"Prussia-b-500x328.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:20:\"Prussia-b-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:21:\"Prussia-b-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:9:\"SM 9800XL\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1229358573\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("691", "823", "_wp_attached_file", "2012/03/Rinmini-b.jpg");
INSERT INTO `wp_postmeta` VALUES("692", "823", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'96\'\";s:4:\"file\";s:21:\"2012/03/Rinmini-b.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:21:\"Rinmini-b-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:21:\"Rinmini-b-500x300.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:19:\"Rinmini-b-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:21:\"Rinmini-b-500x328.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:20:\"Rinmini-b-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:21:\"Rinmini-b-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:9:\"SM 9800XL\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1229358323\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("858", "959", "_wp_attached_file", "2012/03/colores.jpg");
INSERT INTO `wp_postmeta` VALUES("855", "957", "_wp_attached_file", "2012/03/mantenimiento.jpg");
INSERT INTO `wp_postmeta` VALUES("856", "957", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";s:14:\"hwstring_small\";s:23:\"height=\'51\' width=\'128\'\";s:4:\"file\";s:25:\"2012/03/mantenimiento.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:25:\"mantenimiento-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:25:\"mantenimiento-576x233.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"233\";}s:5:\"large\";a:3:{s:4:\"file\";s:25:\"mantenimiento-700x283.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"283\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:25:\"mantenimiento-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:23:\"mantenimiento-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:24:\"mantenimiento-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:25:\"mantenimiento-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("706", "840", "_wp_attached_file", "2012/03/Beige-Stardust-b.jpg");
INSERT INTO `wp_postmeta` VALUES("707", "840", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'96\'\";s:4:\"file\";s:28:\"2012/03/Beige-Stardust-b.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:28:\"Beige-Stardust-b-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:28:\"Beige-Stardust-b-500x300.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:26:\"Beige-Stardust-b-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:28:\"Beige-Stardust-b-500x328.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:27:\"Beige-Stardust-b-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:28:\"Beige-Stardust-b-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:9:\"SM 9800XL\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1229080596\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("708", "841", "_wp_attached_file", "2012/03/Bianco-Stardust-b.jpg");
INSERT INTO `wp_postmeta` VALUES("709", "841", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'96\'\";s:4:\"file\";s:29:\"2012/03/Bianco-Stardust-b.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:29:\"Bianco-Stardust-b-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:29:\"Bianco-Stardust-b-500x300.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:27:\"Bianco-Stardust-b-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:29:\"Bianco-Stardust-b-500x328.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:28:\"Bianco-Stardust-b-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:29:\"Bianco-Stardust-b-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:9:\"SM 9800XL\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1229079229\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("710", "842", "_wp_attached_file", "2012/03/Blu-Stardust-b.jpg");
INSERT INTO `wp_postmeta` VALUES("711", "842", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'96\'\";s:4:\"file\";s:26:\"2012/03/Blu-Stardust-b.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:26:\"Blu-Stardust-b-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:26:\"Blu-Stardust-b-500x300.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:24:\"Blu-Stardust-b-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:26:\"Blu-Stardust-b-500x328.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:25:\"Blu-Stardust-b-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:26:\"Blu-Stardust-b-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:9:\"SM 9800XL\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1229089651\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("712", "843", "_wp_attached_file", "2012/03/Giallo-Stardust-b.jpg");
INSERT INTO `wp_postmeta` VALUES("713", "843", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'96\'\";s:4:\"file\";s:29:\"2012/03/Giallo-Stardust-b.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:29:\"Giallo-Stardust-b-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:29:\"Giallo-Stardust-b-500x300.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:27:\"Giallo-Stardust-b-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:29:\"Giallo-Stardust-b-500x328.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:28:\"Giallo-Stardust-b-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:29:\"Giallo-Stardust-b-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("714", "844", "_wp_attached_file", "2012/03/Nero-Stardust-b.jpg");
INSERT INTO `wp_postmeta` VALUES("715", "844", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'96\'\";s:4:\"file\";s:27:\"2012/03/Nero-Stardust-b.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:27:\"Nero-Stardust-b-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:27:\"Nero-Stardust-b-500x300.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:25:\"Nero-Stardust-b-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:27:\"Nero-Stardust-b-500x328.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:26:\"Nero-Stardust-b-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:27:\"Nero-Stardust-b-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:9:\"SM 9800XL\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1229078670\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("716", "845", "_wp_attached_file", "2012/03/Pastel-Green-Stardust-b.jpg");
INSERT INTO `wp_postmeta` VALUES("717", "845", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'96\'\";s:4:\"file\";s:35:\"2012/03/Pastel-Green-Stardust-b.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:35:\"Pastel-Green-Stardust-b-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:35:\"Pastel-Green-Stardust-b-500x300.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:33:\"Pastel-Green-Stardust-b-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:35:\"Pastel-Green-Stardust-b-500x328.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:34:\"Pastel-Green-Stardust-b-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:35:\"Pastel-Green-Stardust-b-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:9:\"SM 9800XL\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1229091259\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("718", "846", "_wp_attached_file", "2012/03/Rosa-Stardust-b.jpg");
INSERT INTO `wp_postmeta` VALUES("719", "846", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'96\'\";s:4:\"file\";s:27:\"2012/03/Rosa-Stardust-b.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:27:\"Rosa-Stardust-b-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:27:\"Rosa-Stardust-b-500x300.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:25:\"Rosa-Stardust-b-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:27:\"Rosa-Stardust-b-500x328.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:26:\"Rosa-Stardust-b-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:27:\"Rosa-Stardust-b-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:9:\"SM 9800XL\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1229079832\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("720", "847", "_wp_attached_file", "2012/03/Rosso-Stardust-b.jpg");
INSERT INTO `wp_postmeta` VALUES("721", "847", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'96\'\";s:4:\"file\";s:28:\"2012/03/Rosso-Stardust-b.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:28:\"Rosso-Stardust-b-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:28:\"Rosso-Stardust-b-500x300.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:26:\"Rosso-Stardust-b-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:28:\"Rosso-Stardust-b-500x328.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:27:\"Rosso-Stardust-b-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:28:\"Rosso-Stardust-b-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:9:\"SM 9800XL\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1229081457\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("722", "848", "_wp_attached_file", "2012/03/Sky-Stardust-b.jpg");
INSERT INTO `wp_postmeta` VALUES("723", "848", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'96\'\";s:4:\"file\";s:26:\"2012/03/Sky-Stardust-b.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:26:\"Sky-Stardust-b-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:26:\"Sky-Stardust-b-500x300.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:24:\"Sky-Stardust-b-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:26:\"Sky-Stardust-b-500x328.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:25:\"Sky-Stardust-b-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:26:\"Sky-Stardust-b-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:9:\"SM 9800XL\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1229090628\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("733", "858", "_wp_attached_file", "2012/04/somos.jpg");
INSERT INTO `wp_postmeta` VALUES("734", "858", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";s:14:\"hwstring_small\";s:23:\"height=\'51\' width=\'128\'\";s:4:\"file\";s:17:\"2012/04/somos.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:17:\"somos-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:17:\"somos-576x233.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"233\";}s:5:\"large\";a:3:{s:4:\"file\";s:17:\"somos-700x283.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"283\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:17:\"somos-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:15:\"somos-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:16:\"somos-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:17:\"somos-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("735", "860", "_wp_attached_file", "2012/04/contacto.jpg");
INSERT INTO `wp_postmeta` VALUES("736", "860", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";s:14:\"hwstring_small\";s:23:\"height=\'51\' width=\'128\'\";s:4:\"file\";s:20:\"2012/04/contacto.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:20:\"contacto-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:20:\"contacto-576x233.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"233\";}s:5:\"large\";a:3:{s:4:\"file\";s:20:\"contacto-700x283.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"283\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:20:\"contacto-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:18:\"contacto-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:19:\"contacto-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:20:\"contacto-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("754", "874", "_wp_attached_file", "2012/05/cocina1.jpg");
INSERT INTO `wp_postmeta` VALUES("755", "874", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";s:14:\"hwstring_small\";s:23:\"height=\'51\' width=\'128\'\";s:4:\"file\";s:19:\"2012/05/cocina1.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:19:\"cocina1-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:19:\"cocina1-576x233.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"233\";}s:5:\"large\";a:3:{s:4:\"file\";s:19:\"cocina1-700x283.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"283\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:19:\"cocina1-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:17:\"cocina1-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:18:\"cocina1-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:19:\"cocina1-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1610", "1479", "_wp_attached_file", "2014/04/aei1.jpg");
INSERT INTO `wp_postmeta` VALUES("1491", "1422", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1492", "1422", "_edit_lock", "1398873150:1");
INSERT INTO `wp_postmeta` VALUES("1144", "1151", "_edit_lock", "1339735523:1");
INSERT INTO `wp_postmeta` VALUES("1145", "1153", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1140", "1148", "_edit_lock", "1339735551:1");
INSERT INTO `wp_postmeta` VALUES("1142", "1151", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1138", "1148", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1136", "1146", "_edit_lock", "1339735456:1");
INSERT INTO `wp_postmeta` VALUES("1135", "1146", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("803", "908", "_wp_attached_file", "2012/03/limones.jpg");
INSERT INTO `wp_postmeta` VALUES("804", "908", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";s:14:\"hwstring_small\";s:23:\"height=\'51\' width=\'128\'\";s:4:\"file\";s:19:\"2012/03/limones.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:19:\"limones-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:19:\"limones-576x233.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"233\";}s:5:\"large\";a:3:{s:4:\"file\";s:19:\"limones-700x283.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"283\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:19:\"limones-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:17:\"limones-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:18:\"limones-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:19:\"limones-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1621", "1482", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:196;s:6:\"height\";i:88;s:4:\"file\";s:19:\"2014/04/decoarq.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"decoarq-116x88.jpg\";s:5:\"width\";i:116;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"sidebar-thumb\";a:4:{s:4:\"file\";s:17:\"decoarq-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"node-based-thumb\";a:4:{s:4:\"file\";s:18:\"decoarq-196x88.jpg\";s:5:\"width\";i:196;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"quick-preview-thumb\";a:4:{s:4:\"file\";s:18:\"decoarq-115x88.jpg\";s:5:\"width\";i:115;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("979", "1032", "_wp_attached_file", "2012/06/partners.jpg");
INSERT INTO `wp_postmeta` VALUES("980", "1032", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";s:14:\"hwstring_small\";s:23:\"height=\'51\' width=\'128\'\";s:4:\"file\";s:20:\"2012/06/partners.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:20:\"partners-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:20:\"partners-576x233.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"233\";}s:5:\"large\";a:3:{s:4:\"file\";s:20:\"partners-700x283.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"283\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:20:\"partners-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:18:\"partners-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:19:\"partners-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:20:\"partners-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("859", "959", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";s:14:\"hwstring_small\";s:23:\"height=\'51\' width=\'128\'\";s:4:\"file\";s:19:\"2012/03/colores.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:19:\"colores-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:19:\"colores-576x233.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"233\";}s:5:\"large\";a:3:{s:4:\"file\";s:19:\"colores-700x283.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"283\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:19:\"colores-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:17:\"colores-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:18:\"colores-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:19:\"colores-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("861", "961", "_wp_attached_file", "2012/04/obras.jpg");
INSERT INTO `wp_postmeta` VALUES("862", "961", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";s:14:\"hwstring_small\";s:23:\"height=\'51\' width=\'128\'\";s:4:\"file\";s:17:\"2012/04/obras.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:17:\"obras-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:17:\"obras-576x233.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"233\";}s:5:\"large\";a:3:{s:4:\"file\";s:17:\"obras-700x283.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"283\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:17:\"obras-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:15:\"obras-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:16:\"obras-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:17:\"obras-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("893", "973", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("894", "973", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("895", "973", "_menu_item_object_id", "967");
INSERT INTO `wp_postmeta` VALUES("896", "973", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("897", "973", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("898", "973", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("899", "973", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("900", "973", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("164", "432", "titulo", "Quienes Somos");
INSERT INTO `wp_postmeta` VALUES("165", "432", "titulo", "Quienes Somos");
INSERT INTO `wp_postmeta` VALUES("166", "432", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("167", "432", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("168", "540", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("169", "540", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("170", "540", "_menu_item_object_id", "432");
INSERT INTO `wp_postmeta` VALUES("171", "540", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("172", "540", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("173", "540", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("174", "540", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("175", "540", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("176", "541", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("177", "541", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("178", "541", "_menu_item_object_id", "541");
INSERT INTO `wp_postmeta` VALUES("179", "541", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("180", "541", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("181", "541", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("182", "541", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("183", "541", "_menu_item_url", "http://santamargherita.s-m.cl/");
INSERT INTO `wp_postmeta` VALUES("817", "916", "_wp_attached_file", "2012/03/bano.jpg");
INSERT INTO `wp_postmeta` VALUES("771", "407", "_thumbnail_id", "957");
INSERT INTO `wp_postmeta` VALUES("775", "379", "_thumbnail_id", "1312");
INSERT INTO `wp_postmeta` VALUES("799", "904", "_wp_attached_file", "2012/03/santamargherita-logo-01.png");
INSERT INTO `wp_postmeta` VALUES("800", "904", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:2:\"80\";s:6:\"height\";s:2:\"15\";s:14:\"hwstring_small\";s:22:\"height=\'15\' width=\'80\'\";s:4:\"file\";s:35:\"2012/03/santamargherita-logo-01.png\";s:5:\"sizes\";a:1:{s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:33:\"santamargherita-logo-01-36x15.png\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"15\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("984", "1039", "_wp_attached_file", "2012/06/p-kubli.jpg");
INSERT INTO `wp_postmeta` VALUES("864", "456", "_edit_lock", "1458144308:1");
INSERT INTO `wp_postmeta` VALUES("865", "964", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("866", "964", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("867", "964", "_menu_item_object_id", "456");
INSERT INTO `wp_postmeta` VALUES("868", "964", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("869", "964", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("870", "964", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("871", "964", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("872", "964", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("1513", "1431", "_thumbnail_id", "1432");
INSERT INTO `wp_postmeta` VALUES("878", "967", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("879", "967", "_edit_lock", "1340034992:1");
INSERT INTO `wp_postmeta` VALUES("880", "967", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("881", "969", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("882", "969", "_edit_lock", "1398867784:1");
INSERT INTO `wp_postmeta` VALUES("883", "969", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("808", "372", "_thumbnail_id", "1310");
INSERT INTO `wp_postmeta` VALUES("815", "404", "_thumbnail_id", "914");
INSERT INTO `wp_postmeta` VALUES("810", "383", "_thumbnail_id", "908");
INSERT INTO `wp_postmeta` VALUES("813", "914", "_wp_attached_file", "2012/03/neroa.jpg");
INSERT INTO `wp_postmeta` VALUES("814", "914", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";s:14:\"hwstring_small\";s:23:\"height=\'51\' width=\'128\'\";s:4:\"file\";s:17:\"2012/03/neroa.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:17:\"neroa-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:17:\"neroa-576x233.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"233\";}s:5:\"large\";a:3:{s:4:\"file\";s:17:\"neroa-700x283.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"283\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:17:\"neroa-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:15:\"neroa-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:16:\"neroa-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:17:\"neroa-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("562", "386", "_wp_old_slug", "certificaciones");
INSERT INTO `wp_postmeta` VALUES("818", "916", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";s:14:\"hwstring_small\";s:23:\"height=\'51\' width=\'128\'\";s:4:\"file\";s:16:\"2012/03/bano.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:16:\"bano-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:16:\"bano-576x233.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"233\";}s:5:\"large\";a:3:{s:4:\"file\";s:16:\"bano-700x283.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"283\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:16:\"bano-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:14:\"bano-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:15:\"bano-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:16:\"bano-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("819", "398", "_thumbnail_id", "916");
INSERT INTO `wp_postmeta` VALUES("831", "934", "_wp_attached_file", "2012/03/certificacion-nsf.jpg");
INSERT INTO `wp_postmeta` VALUES("832", "934", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"103\";s:6:\"height\";s:2:\"96\";s:14:\"hwstring_small\";s:23:\"height=\'96\' width=\'103\'\";s:4:\"file\";s:29:\"2012/03/certificacion-nsf.jpg\";s:5:\"sizes\";a:2:{s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:27:\"certificacion-nsf-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:28:\"certificacion-nsf-103x88.jpg\";s:5:\"width\";s:3:\"103\";s:6:\"height\";s:2:\"88\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("833", "935", "_wp_attached_file", "2012/03/certificacion-greenguard.jpg");
INSERT INTO `wp_postmeta` VALUES("834", "935", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"176\";s:6:\"height\";s:2:\"96\";s:14:\"hwstring_small\";s:23:\"height=\'69\' width=\'128\'\";s:4:\"file\";s:36:\"2012/03/certificacion-greenguard.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:35:\"certificacion-greenguard-116x96.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:2:\"96\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:34:\"certificacion-greenguard-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:35:\"certificacion-greenguard-176x88.jpg\";s:5:\"width\";s:3:\"176\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:35:\"certificacion-greenguard-115x96.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:2:\"96\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:24:\"GGEnvironmentalInstitute\";}}");
INSERT INTO `wp_postmeta` VALUES("835", "936", "_wp_attached_file", "2012/03/certificacion-gbc.gif");
INSERT INTO `wp_postmeta` VALUES("836", "936", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:2:\"96\";s:6:\"height\";s:2:\"96\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'96\'\";s:4:\"file\";s:29:\"2012/03/certificacion-gbc.gif\";s:5:\"sizes\";a:2:{s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:27:\"certificacion-gbc-36x36.gif\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:27:\"certificacion-gbc-96x88.gif\";s:5:\"width\";s:2:\"96\";s:6:\"height\";s:2:\"88\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("852", "955", "_wp_attached_file", "2012/03/garantia.jpg");
INSERT INTO `wp_postmeta` VALUES("853", "955", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";s:14:\"hwstring_small\";s:23:\"height=\'51\' width=\'128\'\";s:4:\"file\";s:20:\"2012/03/garantia.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:20:\"garantia-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:20:\"garantia-576x233.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"233\";}s:5:\"large\";a:3:{s:4:\"file\";s:20:\"garantia-700x283.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"283\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:20:\"garantia-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:18:\"garantia-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:19:\"garantia-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:20:\"garantia-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("587", "407", "_wp_old_slug", "mantencion-post-venta");
INSERT INTO `wp_postmeta` VALUES("601", "767", "_wp_attached_file", "2012/03/Amalfi-b.jpg");
INSERT INTO `wp_postmeta` VALUES("602", "767", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'96\'\";s:4:\"file\";s:20:\"2012/03/Amalfi-b.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:20:\"Amalfi-b-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:20:\"Amalfi-b-500x300.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:18:\"Amalfi-b-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:20:\"Amalfi-b-500x328.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:19:\"Amalfi-b-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:20:\"Amalfi-b-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:9:\"SM 9800XL\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1229428511\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("603", "768", "_wp_attached_file", "2012/03/Antracite-b.jpg");
INSERT INTO `wp_postmeta` VALUES("604", "768", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'96\'\";s:4:\"file\";s:23:\"2012/03/Antracite-b.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:23:\"Antracite-b-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:23:\"Antracite-b-500x300.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:21:\"Antracite-b-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:23:\"Antracite-b-500x328.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:22:\"Antracite-b-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:23:\"Antracite-b-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:9:\"SM 9800XL\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1229355786\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("606", "770", "_wp_attached_file", "2012/03/Aosta-b.jpg");
INSERT INTO `wp_postmeta` VALUES("607", "770", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'96\'\";s:4:\"file\";s:19:\"2012/03/Aosta-b.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:19:\"Aosta-b-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:19:\"Aosta-b-500x300.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:17:\"Aosta-b-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:19:\"Aosta-b-500x328.jpg\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:18:\"Aosta-b-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:19:\"Aosta-b-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:9:\"SM 9800XL\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1229445386\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1414", "1310", "_wp_attached_file", "2012/03/garantia.jpg");
INSERT INTO `wp_postmeta` VALUES("1500", "1426", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:196;s:6:\"height\";i:88;s:4:\"file\";s:15:\"2014/04/sym.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:14:\"sym-116x88.jpg\";s:5:\"width\";i:116;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"sidebar-thumb\";a:4:{s:4:\"file\";s:13:\"sym-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"node-based-thumb\";a:4:{s:4:\"file\";s:14:\"sym-196x88.jpg\";s:5:\"width\";i:196;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"quick-preview-thumb\";a:4:{s:4:\"file\";s:14:\"sym-115x88.jpg\";s:5:\"width\";i:115;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("228", "372", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("230", "379", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("232", "383", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("234", "386", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("236", "398", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("239", "401", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("240", "404", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("242", "407", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("248", "452", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("249", "452", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("250", "456", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("251", "456", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("599", "765", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:1:\"5\";s:6:\"height\";s:3:\"345\";s:14:\"hwstring_small\";s:21:\"height=\'96\' width=\'1\'\";s:4:\"file\";s:21:\"2012/05/bgceleste.png\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:19:\"bgceleste-5x116.png\";s:5:\"width\";s:1:\"5\";s:6:\"height\";s:3:\"116\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:19:\"bgceleste-5x300.png\";s:5:\"width\";s:1:\"5\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:18:\"bgceleste-5x36.png\";s:5:\"width\";s:1:\"5\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:19:\"bgceleste-5x328.png\";s:5:\"width\";s:1:\"5\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:18:\"bgceleste-5x88.png\";s:5:\"width\";s:1:\"5\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:19:\"bgceleste-5x115.png\";s:5:\"width\";s:1:\"5\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("270", "557", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("271", "557", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("272", "557", "_menu_item_object_id", "452");
INSERT INTO `wp_postmeta` VALUES("273", "557", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("274", "557", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("275", "557", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("276", "557", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("277", "557", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("1418", "1312", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";s:14:\"hwstring_small\";s:23:\"height=\'51\' width=\'128\'\";s:4:\"file\";s:19:\"2012/03/colores.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:19:\"colores-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:19:\"colores-576x233.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"233\";}s:5:\"large\";a:3:{s:4:\"file\";s:19:\"colores-700x283.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"283\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:19:\"colores-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:17:\"colores-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:18:\"colores-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:19:\"colores-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("598", "765", "_wp_attached_file", "2012/05/bgceleste.png");
INSERT INTO `wp_postmeta` VALUES("288", "372", "_edit_lock", "1340634166:1");
INSERT INTO `wp_postmeta` VALUES("292", "383", "_edit_lock", "1339693726:1");
INSERT INTO `wp_postmeta` VALUES("296", "386", "_edit_lock", "1340032293:1");
INSERT INTO `wp_postmeta` VALUES("301", "398", "_edit_lock", "1340032337:1");
INSERT INTO `wp_postmeta` VALUES("303", "401", "_edit_lock", "1339615758:1");
INSERT INTO `wp_postmeta` VALUES("307", "407", "_edit_lock", "1339736272:1");
INSERT INTO `wp_postmeta` VALUES("312", "379", "_edit_lock", "1375909341:1");
INSERT INTO `wp_postmeta` VALUES("364", "404", "_edit_lock", "1339001117:1");
INSERT INTO `wp_postmeta` VALUES("370", "432", "_edit_lock", "1339429800:1");
INSERT INTO `wp_postmeta` VALUES("372", "452", "_edit_lock", "1458144470:1");
INSERT INTO `wp_postmeta` VALUES("590", "757", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:4:\"2048\";s:6:\"height\";s:4:\"1362\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:20:\"2012/03/DSC_0105.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:20:\"DSC_0105-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:20:\"DSC_0105-576x383.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"383\";}s:5:\"large\";a:3:{s:4:\"file\";s:20:\"DSC_0105-700x465.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"465\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:20:\"DSC_0105-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:18:\"DSC_0105-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:20:\"DSC_0105-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:19:\"DSC_0105-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:20:\"DSC_0105-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("589", "757", "_wp_attached_file", "2012/03/DSC_0105.jpg");
INSERT INTO `wp_postmeta` VALUES("902", "976", "_wp_attached_file", "2012/06/coloresvanguardistas.jpg");
INSERT INTO `wp_postmeta` VALUES("903", "976", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";s:14:\"hwstring_small\";s:23:\"height=\'51\' width=\'128\'\";s:4:\"file\";s:32:\"2012/06/coloresvanguardistas.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:32:\"coloresvanguardistas-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:32:\"coloresvanguardistas-576x233.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"233\";}s:5:\"large\";a:3:{s:4:\"file\";s:32:\"coloresvanguardistas-700x283.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"283\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:32:\"coloresvanguardistas-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:30:\"coloresvanguardistas-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:31:\"coloresvanguardistas-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:32:\"coloresvanguardistas-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("904", "977", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("905", "977", "_edit_lock", "1339606382:1");
INSERT INTO `wp_postmeta` VALUES("911", "981", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("912", "981", "_edit_lock", "1339449865:1");
INSERT INTO `wp_postmeta` VALUES("913", "982", "_wp_attached_file", "2012/06/resistenteabacterias.jpg");
INSERT INTO `wp_postmeta` VALUES("914", "982", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";s:14:\"hwstring_small\";s:23:\"height=\'51\' width=\'128\'\";s:4:\"file\";s:32:\"2012/06/resistenteabacterias.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:32:\"resistenteabacterias-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:32:\"resistenteabacterias-576x233.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"233\";}s:5:\"large\";a:3:{s:4:\"file\";s:32:\"resistenteabacterias-700x283.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"283\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:32:\"resistenteabacterias-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:30:\"resistenteabacterias-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:31:\"resistenteabacterias-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:32:\"resistenteabacterias-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("916", "984", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("917", "984", "_edit_lock", "1339597075:1");
INSERT INTO `wp_postmeta` VALUES("918", "985", "_wp_attached_file", "2012/06/resistenteabacterias2.jpg");
INSERT INTO `wp_postmeta` VALUES("919", "985", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";s:14:\"hwstring_small\";s:23:\"height=\'51\' width=\'128\'\";s:4:\"file\";s:33:\"2012/06/resistenteabacterias2.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:33:\"resistenteabacterias2-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:33:\"resistenteabacterias2-576x233.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"233\";}s:5:\"large\";a:3:{s:4:\"file\";s:33:\"resistenteabacterias2-700x283.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"283\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:33:\"resistenteabacterias2-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:31:\"resistenteabacterias2-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:32:\"resistenteabacterias2-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:33:\"resistenteabacterias2-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1618", "1481", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1619", "1481", "_edit_lock", "1398875879:1");
INSERT INTO `wp_postmeta` VALUES("1620", "1482", "_wp_attached_file", "2014/04/decoarq.jpg");
INSERT INTO `wp_postmeta` VALUES("1614", "1480", "_wp_attached_file", "2014/04/mobel1.jpg");
INSERT INTO `wp_postmeta` VALUES("1499", "1426", "_wp_attached_file", "2014/04/sym.jpg");
INSERT INTO `wp_postmeta` VALUES("929", "992", "_wp_attached_file", "2012/06/resistenteamanchas.jpg");
INSERT INTO `wp_postmeta` VALUES("930", "992", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";s:14:\"hwstring_small\";s:23:\"height=\'51\' width=\'128\'\";s:4:\"file\";s:30:\"2012/06/resistenteamanchas.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:30:\"resistenteamanchas-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:30:\"resistenteamanchas-576x233.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"233\";}s:5:\"large\";a:3:{s:4:\"file\";s:30:\"resistenteamanchas-700x283.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"283\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:30:\"resistenteamanchas-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:28:\"resistenteamanchas-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:29:\"resistenteamanchas-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:30:\"resistenteamanchas-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("931", "991", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("932", "991", "_edit_lock", "1339449726:1");
INSERT INTO `wp_postmeta` VALUES("977", "1025", "_wp_attached_file", "2012/06/vanguardia.jpg");
INSERT INTO `wp_postmeta` VALUES("978", "1025", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";s:14:\"hwstring_small\";s:23:\"height=\'51\' width=\'128\'\";s:4:\"file\";s:22:\"2012/06/vanguardia.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:22:\"vanguardia-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:22:\"vanguardia-576x233.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"233\";}s:5:\"large\";a:3:{s:4:\"file\";s:22:\"vanguardia-700x283.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"283\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:22:\"vanguardia-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:20:\"vanguardia-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:21:\"vanguardia-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:22:\"vanguardia-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("936", "994", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("940", "999", "_wp_attached_file", "2012/06/resistenteaacidos1.jpg");
INSERT INTO `wp_postmeta` VALUES("938", "994", "_edit_lock", "1339450002:1");
INSERT INTO `wp_postmeta` VALUES("941", "999", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";s:14:\"hwstring_small\";s:23:\"height=\'51\' width=\'128\'\";s:4:\"file\";s:30:\"2012/06/resistenteaacidos1.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:30:\"resistenteaacidos1-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:30:\"resistenteaacidos1-576x233.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"233\";}s:5:\"large\";a:3:{s:4:\"file\";s:30:\"resistenteaacidos1-700x283.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"283\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:30:\"resistenteaacidos1-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:28:\"resistenteaacidos1-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:29:\"resistenteaacidos1-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:30:\"resistenteaacidos1-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("943", "1002", "_wp_attached_file", "2012/06/resistenteacalor.jpg");
INSERT INTO `wp_postmeta` VALUES("944", "1002", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";s:14:\"hwstring_small\";s:23:\"height=\'51\' width=\'128\'\";s:4:\"file\";s:28:\"2012/06/resistenteacalor.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:28:\"resistenteacalor-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:28:\"resistenteacalor-576x233.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"233\";}s:5:\"large\";a:3:{s:4:\"file\";s:28:\"resistenteacalor-700x283.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"283\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:28:\"resistenteacalor-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:26:\"resistenteacalor-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:27:\"resistenteacalor-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:28:\"resistenteacalor-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("945", "1001", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("948", "1005", "_wp_attached_file", "2012/06/resistenteaimpacto.jpg");
INSERT INTO `wp_postmeta` VALUES("947", "1001", "_edit_lock", "1339449262:1");
INSERT INTO `wp_postmeta` VALUES("949", "1005", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";s:14:\"hwstring_small\";s:23:\"height=\'51\' width=\'128\'\";s:4:\"file\";s:30:\"2012/06/resistenteaimpacto.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:30:\"resistenteaimpacto-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:30:\"resistenteaimpacto-576x233.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"233\";}s:5:\"large\";a:3:{s:4:\"file\";s:30:\"resistenteaimpacto-700x283.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"283\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:30:\"resistenteaimpacto-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:28:\"resistenteaimpacto-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:29:\"resistenteaimpacto-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:30:\"resistenteaimpacto-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("950", "1004", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("951", "1004", "_edit_lock", "1339449368:1");
INSERT INTO `wp_postmeta` VALUES("953", "1008", "_wp_attached_file", "2012/06/superficiestexturizadas2.jpg");
INSERT INTO `wp_postmeta` VALUES("954", "1008", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";s:14:\"hwstring_small\";s:23:\"height=\'51\' width=\'128\'\";s:4:\"file\";s:36:\"2012/06/superficiestexturizadas2.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:36:\"superficiestexturizadas2-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:36:\"superficiestexturizadas2-576x233.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"233\";}s:5:\"large\";a:3:{s:4:\"file\";s:36:\"superficiestexturizadas2-700x283.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"283\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:36:\"superficiestexturizadas2-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:34:\"superficiestexturizadas2-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:35:\"superficiestexturizadas2-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:36:\"superficiestexturizadas2-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("955", "1007", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("958", "1011", "_wp_attached_file", "2012/06/superficiestexturizadas.jpg");
INSERT INTO `wp_postmeta` VALUES("957", "1007", "_edit_lock", "1339449508:1");
INSERT INTO `wp_postmeta` VALUES("959", "1011", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";s:14:\"hwstring_small\";s:23:\"height=\'51\' width=\'128\'\";s:4:\"file\";s:35:\"2012/06/superficiestexturizadas.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:35:\"superficiestexturizadas-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:35:\"superficiestexturizadas-576x233.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"233\";}s:5:\"large\";a:3:{s:4:\"file\";s:35:\"superficiestexturizadas-700x283.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"283\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:35:\"superficiestexturizadas-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:33:\"superficiestexturizadas-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:34:\"superficiestexturizadas-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:35:\"superficiestexturizadas-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("960", "1010", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("961", "1010", "_edit_lock", "1339449559:1");
INSERT INTO `wp_postmeta` VALUES("963", "1014", "_wp_attached_file", "2012/06/versatilidaddiseno.jpg");
INSERT INTO `wp_postmeta` VALUES("964", "1014", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";s:14:\"hwstring_small\";s:23:\"height=\'51\' width=\'128\'\";s:4:\"file\";s:30:\"2012/06/versatilidaddiseno.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:30:\"versatilidaddiseno-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:30:\"versatilidaddiseno-576x233.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"233\";}s:5:\"large\";a:3:{s:4:\"file\";s:30:\"versatilidaddiseno-700x283.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"283\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:30:\"versatilidaddiseno-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:28:\"versatilidaddiseno-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:29:\"versatilidaddiseno-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:30:\"versatilidaddiseno-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("965", "1013", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("966", "1013", "_edit_lock", "1339610422:1");
INSERT INTO `wp_postmeta` VALUES("985", "1039", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"392\";s:6:\"height\";s:2:\"76\";s:14:\"hwstring_small\";s:23:\"height=\'24\' width=\'128\'\";s:4:\"file\";s:19:\"2012/06/p-kubli.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:18:\"p-kubli-116x76.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:2:\"76\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:17:\"p-kubli-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:18:\"p-kubli-196x76.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"76\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:18:\"p-kubli-115x76.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:2:\"76\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("986", "1040", "_wp_attached_file", "2012/06/p-aei.jpg");
INSERT INTO `wp_postmeta` VALUES("987", "1040", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"386\";s:6:\"height\";s:2:\"78\";s:14:\"hwstring_small\";s:23:\"height=\'25\' width=\'128\'\";s:4:\"file\";s:17:\"2012/06/p-aei.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:16:\"p-aei-116x78.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:2:\"78\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:15:\"p-aei-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:16:\"p-aei-196x78.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"78\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:16:\"p-aei-115x78.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:2:\"78\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("988", "1042", "_wp_attached_file", "2012/06/p-bm.jpg");
INSERT INTO `wp_postmeta` VALUES("989", "1042", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"393\";s:6:\"height\";s:3:\"112\";s:14:\"hwstring_small\";s:23:\"height=\'36\' width=\'128\'\";s:4:\"file\";s:16:\"2012/06/p-bm.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:16:\"p-bm-116x112.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"112\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:14:\"p-bm-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:15:\"p-bm-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:16:\"p-bm-115x112.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"112\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("990", "1044", "_wp_attached_file", "2012/06/p-mobel.jpg");
INSERT INTO `wp_postmeta` VALUES("991", "1044", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"382\";s:6:\"height\";s:3:\"112\";s:14:\"hwstring_small\";s:23:\"height=\'37\' width=\'128\'\";s:4:\"file\";s:19:\"2012/06/p-mobel.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:19:\"p-mobel-116x112.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"112\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:17:\"p-mobel-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:18:\"p-mobel-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:19:\"p-mobel-115x112.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"112\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("992", "1046", "_wp_attached_file", "2012/06/p-sym.jpg");
INSERT INTO `wp_postmeta` VALUES("993", "1046", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"392\";s:6:\"height\";s:3:\"104\";s:14:\"hwstring_small\";s:23:\"height=\'33\' width=\'128\'\";s:4:\"file\";s:17:\"2012/06/p-sym.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:17:\"p-sym-116x104.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"104\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:15:\"p-sym-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:16:\"p-sym-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:17:\"p-sym-115x104.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"104\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("994", "1047", "_wp_attached_file", "2012/06/p-unna.jpg");
INSERT INTO `wp_postmeta` VALUES("995", "1047", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"381\";s:6:\"height\";s:3:\"103\";s:14:\"hwstring_small\";s:23:\"height=\'34\' width=\'128\'\";s:4:\"file\";s:18:\"2012/06/p-unna.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:18:\"p-unna-116x103.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"103\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:16:\"p-unna-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:17:\"p-unna-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:18:\"p-unna-115x103.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"103\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("996", "1050", "_wp_attached_file", "2012/06/p-kubli1.jpg");
INSERT INTO `wp_postmeta` VALUES("997", "1050", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"394\";s:6:\"height\";s:2:\"78\";s:14:\"hwstring_small\";s:23:\"height=\'25\' width=\'128\'\";s:4:\"file\";s:20:\"2012/06/p-kubli1.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:19:\"p-kubli1-116x78.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:2:\"78\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:18:\"p-kubli1-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:19:\"p-kubli1-196x78.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"78\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:19:\"p-kubli1-115x78.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:2:\"78\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("998", "1053", "_wp_attached_file", "2012/06/p-casakit.jpg");
INSERT INTO `wp_postmeta` VALUES("999", "1053", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"292\";s:6:\"height\";s:3:\"108\";s:14:\"hwstring_small\";s:23:\"height=\'47\' width=\'128\'\";s:4:\"file\";s:21:\"2012/06/p-casakit.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:21:\"p-casakit-116x108.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"108\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:19:\"p-casakit-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:20:\"p-casakit-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:21:\"p-casakit-115x108.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"108\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1000", "1054", "_wp_attached_file", "2012/06/p-madestone.jpg");
INSERT INTO `wp_postmeta` VALUES("1001", "1054", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"256\";s:6:\"height\";s:3:\"110\";s:14:\"hwstring_small\";s:23:\"height=\'55\' width=\'128\'\";s:4:\"file\";s:23:\"2012/06/p-madestone.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:23:\"p-madestone-116x110.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"110\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:21:\"p-madestone-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:22:\"p-madestone-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:23:\"p-madestone-115x110.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"110\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1002", "1055", "_wp_attached_file", "2012/06/p-espaciodinamico.jpg");
INSERT INTO `wp_postmeta` VALUES("1003", "1055", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"233\";s:6:\"height\";s:3:\"111\";s:14:\"hwstring_small\";s:23:\"height=\'60\' width=\'128\'\";s:4:\"file\";s:29:\"2012/06/p-espaciodinamico.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:29:\"p-espaciodinamico-116x111.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"111\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:27:\"p-espaciodinamico-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:28:\"p-espaciodinamico-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:29:\"p-espaciodinamico-115x111.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"111\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1004", "1056", "_wp_attached_file", "2012/06/p-mobilinares.jpg");
INSERT INTO `wp_postmeta` VALUES("1005", "1056", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"291\";s:6:\"height\";s:2:\"78\";s:14:\"hwstring_small\";s:23:\"height=\'34\' width=\'128\'\";s:4:\"file\";s:25:\"2012/06/p-mobilinares.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:24:\"p-mobilinares-116x78.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:2:\"78\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:23:\"p-mobilinares-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:24:\"p-mobilinares-196x78.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"78\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:24:\"p-mobilinares-115x78.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:2:\"78\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1006", "1057", "_wp_attached_file", "2012/06/p-staub.jpg");
INSERT INTO `wp_postmeta` VALUES("1007", "1057", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"255\";s:6:\"height\";s:2:\"77\";s:14:\"hwstring_small\";s:23:\"height=\'38\' width=\'128\'\";s:4:\"file\";s:19:\"2012/06/p-staub.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:18:\"p-staub-116x77.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:2:\"77\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:17:\"p-staub-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:18:\"p-staub-196x77.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"77\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:18:\"p-staub-115x77.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:2:\"77\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1008", "1058", "_wp_attached_file", "2012/06/p-disypro.jpg");
INSERT INTO `wp_postmeta` VALUES("1009", "1058", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"231\";s:6:\"height\";s:2:\"79\";s:14:\"hwstring_small\";s:23:\"height=\'43\' width=\'128\'\";s:4:\"file\";s:21:\"2012/06/p-disypro.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:20:\"p-disypro-116x79.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:2:\"79\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:19:\"p-disypro-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:20:\"p-disypro-196x79.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"79\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:20:\"p-disypro-115x79.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:2:\"79\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1011", "1063", "_wp_attached_file", "2012/06/partners2.jpeg");
INSERT INTO `wp_postmeta` VALUES("1012", "1063", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";s:14:\"hwstring_small\";s:23:\"height=\'51\' width=\'128\'\";s:4:\"file\";s:22:\"2012/06/partners2.jpeg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:21:\"partners2-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:21:\"partners2-576x233.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"233\";}s:5:\"large\";a:3:{s:4:\"file\";s:21:\"partners2-700x283.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"283\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:21:\"partners2-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:19:\"partners2-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:20:\"partners2-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:21:\"partners2-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1021", "1071", "_wp_attachment_metadata", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("1020", "1071", "_wp_attached_file", "2012/04/Ficha-tecnica-cuarzo.pdf");
INSERT INTO `wp_postmeta` VALUES("1022", "1073", "_wp_attached_file", "2012/04/Ficha-tecnica-Marmol.pdf");
INSERT INTO `wp_postmeta` VALUES("1023", "1073", "_wp_attachment_metadata", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("1024", "1079", "_wp_attached_file", "2012/03/glitters.jpg");
INSERT INTO `wp_postmeta` VALUES("1025", "1079", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"593\";s:6:\"height\";s:3:\"134\";s:14:\"hwstring_small\";s:23:\"height=\'28\' width=\'128\'\";s:4:\"file\";s:20:\"2012/03/glitters.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:20:\"glitters-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:20:\"glitters-576x130.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"130\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:18:\"glitters-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:19:\"glitters-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:20:\"glitters-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1042", "1090", "_wp_attached_file", "2012/06/Beige.jpg");
INSERT INTO `wp_postmeta` VALUES("1043", "1090", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"574\";s:6:\"height\";s:3:\"575\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'95\'\";s:4:\"file\";s:17:\"2012/06/Beige.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:17:\"Beige-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:17:\"Beige-574x300.jpg\";s:5:\"width\";s:3:\"574\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:15:\"Beige-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:17:\"Beige-574x328.jpg\";s:5:\"width\";s:3:\"574\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:16:\"Beige-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:17:\"Beige-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1044", "1091", "_wp_attached_file", "2012/06/Black.jpg");
INSERT INTO `wp_postmeta` VALUES("1045", "1091", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"574\";s:6:\"height\";s:3:\"575\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'95\'\";s:4:\"file\";s:17:\"2012/06/Black.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:17:\"Black-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:17:\"Black-574x300.jpg\";s:5:\"width\";s:3:\"574\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:15:\"Black-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:17:\"Black-574x328.jpg\";s:5:\"width\";s:3:\"574\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:16:\"Black-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:17:\"Black-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1030", "1083", "_wp_attached_file", "2012/03/Beige_t.jpg");
INSERT INTO `wp_postmeta` VALUES("1031", "1083", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"100\";s:6:\"height\";s:3:\"100\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'96\'\";s:4:\"file\";s:19:\"2012/03/Beige_t.jpg\";s:5:\"sizes\";a:2:{s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:17:\"Beige_t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:18:\"Beige_t-100x88.jpg\";s:5:\"width\";s:3:\"100\";s:6:\"height\";s:2:\"88\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1032", "1084", "_wp_attached_file", "2012/03/Black_t.jpg");
INSERT INTO `wp_postmeta` VALUES("1033", "1084", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"100\";s:6:\"height\";s:3:\"100\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'96\'\";s:4:\"file\";s:19:\"2012/03/Black_t.jpg\";s:5:\"sizes\";a:2:{s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:17:\"Black_t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:18:\"Black_t-100x88.jpg\";s:5:\"width\";s:3:\"100\";s:6:\"height\";s:2:\"88\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1034", "1085", "_wp_attached_file", "2012/03/Brown_t.jpg");
INSERT INTO `wp_postmeta` VALUES("1035", "1085", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"100\";s:6:\"height\";s:3:\"100\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'96\'\";s:4:\"file\";s:19:\"2012/03/Brown_t.jpg\";s:5:\"sizes\";a:2:{s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:17:\"Brown_t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:18:\"Brown_t-100x88.jpg\";s:5:\"width\";s:3:\"100\";s:6:\"height\";s:2:\"88\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1036", "1086", "_wp_attached_file", "2012/03/Grey_t.jpg");
INSERT INTO `wp_postmeta` VALUES("1037", "1086", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"100\";s:6:\"height\";s:3:\"100\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'96\'\";s:4:\"file\";s:18:\"2012/03/Grey_t.jpg\";s:5:\"sizes\";a:2:{s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:16:\"Grey_t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:17:\"Grey_t-100x88.jpg\";s:5:\"width\";s:3:\"100\";s:6:\"height\";s:2:\"88\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1038", "1087", "_wp_attached_file", "2012/03/White_t.jpg");
INSERT INTO `wp_postmeta` VALUES("1039", "1087", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"100\";s:6:\"height\";s:3:\"100\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'96\'\";s:4:\"file\";s:19:\"2012/03/White_t.jpg\";s:5:\"sizes\";a:2:{s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:17:\"White_t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:18:\"White_t-100x88.jpg\";s:5:\"width\";s:3:\"100\";s:6:\"height\";s:2:\"88\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1046", "1092", "_wp_attached_file", "2012/06/Brown.jpg");
INSERT INTO `wp_postmeta` VALUES("1047", "1092", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"574\";s:6:\"height\";s:3:\"576\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'95\'\";s:4:\"file\";s:17:\"2012/06/Brown.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:17:\"Brown-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:17:\"Brown-574x300.jpg\";s:5:\"width\";s:3:\"574\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:15:\"Brown-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:17:\"Brown-574x328.jpg\";s:5:\"width\";s:3:\"574\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:16:\"Brown-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:17:\"Brown-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1048", "1093", "_wp_attached_file", "2012/06/Grey.jpg");
INSERT INTO `wp_postmeta` VALUES("1049", "1093", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"574\";s:6:\"height\";s:3:\"576\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'95\'\";s:4:\"file\";s:16:\"2012/06/Grey.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:16:\"Grey-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:16:\"Grey-574x300.jpg\";s:5:\"width\";s:3:\"574\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:14:\"Grey-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:16:\"Grey-574x328.jpg\";s:5:\"width\";s:3:\"574\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:15:\"Grey-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:16:\"Grey-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1050", "1094", "_wp_attached_file", "2012/06/White.jpg");
INSERT INTO `wp_postmeta` VALUES("1051", "1094", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"574\";s:6:\"height\";s:3:\"574\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'96\'\";s:4:\"file\";s:17:\"2012/06/White.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:17:\"White-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:17:\"White-574x300.jpg\";s:5:\"width\";s:3:\"574\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:15:\"White-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:17:\"White-574x328.jpg\";s:5:\"width\";s:3:\"574\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:16:\"White-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:17:\"White-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1065", "1098", "_wp_attachment_image_alt", "");
INSERT INTO `wp_postmeta` VALUES("1064", "1101", "_wp_attachment_image_alt", "");
INSERT INTO `wp_postmeta` VALUES("1056", "1098", "_wp_attached_file", "2012/03/Gold_t.jpg");
INSERT INTO `wp_postmeta` VALUES("1057", "1098", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"100\";s:6:\"height\";s:3:\"100\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'96\'\";s:4:\"file\";s:18:\"2012/03/Gold_t.jpg\";s:5:\"sizes\";a:2:{s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:16:\"Gold_t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:17:\"Gold_t-100x88.jpg\";s:5:\"width\";s:3:\"100\";s:6:\"height\";s:2:\"88\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1058", "1099", "_wp_attached_file", "2012/03/Iron_t.jpg");
INSERT INTO `wp_postmeta` VALUES("1059", "1099", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"100\";s:6:\"height\";s:3:\"100\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'96\'\";s:4:\"file\";s:18:\"2012/03/Iron_t.jpg\";s:5:\"sizes\";a:2:{s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:16:\"Iron_t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:17:\"Iron_t-100x88.jpg\";s:5:\"width\";s:3:\"100\";s:6:\"height\";s:2:\"88\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1060", "1100", "_wp_attached_file", "2012/03/Pewter_t.jpg");
INSERT INTO `wp_postmeta` VALUES("1061", "1100", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"100\";s:6:\"height\";s:3:\"100\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'96\'\";s:4:\"file\";s:20:\"2012/03/Pewter_t.jpg\";s:5:\"sizes\";a:2:{s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:18:\"Pewter_t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:19:\"Pewter_t-100x88.jpg\";s:5:\"width\";s:3:\"100\";s:6:\"height\";s:2:\"88\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1062", "1101", "_wp_attached_file", "2012/03/Silver_t.jpg");
INSERT INTO `wp_postmeta` VALUES("1063", "1101", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"100\";s:6:\"height\";s:3:\"100\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'96\'\";s:4:\"file\";s:20:\"2012/03/Silver_t.jpg\";s:5:\"sizes\";a:2:{s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:18:\"Silver_t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:19:\"Silver_t-100x88.jpg\";s:5:\"width\";s:3:\"100\";s:6:\"height\";s:2:\"88\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1066", "1102", "_wp_attached_file", "2012/03/Bronze_t.jpg");
INSERT INTO `wp_postmeta` VALUES("1067", "1102", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"100\";s:6:\"height\";s:3:\"100\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'96\'\";s:4:\"file\";s:20:\"2012/03/Bronze_t.jpg\";s:5:\"sizes\";a:2:{s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:18:\"Bronze_t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:19:\"Bronze_t-100x88.jpg\";s:5:\"width\";s:3:\"100\";s:6:\"height\";s:2:\"88\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1068", "1100", "_wp_attachment_image_alt", "");
INSERT INTO `wp_postmeta` VALUES("1071", "1105", "_wp_attached_file", "2012/06/Bronze.jpg");
INSERT INTO `wp_postmeta` VALUES("1072", "1105", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"638\";s:6:\"height\";s:3:\"638\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'96\'\";s:4:\"file\";s:18:\"2012/06/Bronze.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:18:\"Bronze-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:18:\"Bronze-576x576.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"576\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:18:\"Bronze-638x300.jpg\";s:5:\"width\";s:3:\"638\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:16:\"Bronze-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:18:\"Bronze-638x328.jpg\";s:5:\"width\";s:3:\"638\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:17:\"Bronze-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:18:\"Bronze-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1073", "1106", "_wp_attached_file", "2012/06/Gold.jpg");
INSERT INTO `wp_postmeta` VALUES("1074", "1106", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"637\";s:6:\"height\";s:3:\"637\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'95\'\";s:4:\"file\";s:16:\"2012/06/Gold.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:16:\"Gold-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:16:\"Gold-576x576.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"576\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:16:\"Gold-637x300.jpg\";s:5:\"width\";s:3:\"637\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:14:\"Gold-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:16:\"Gold-637x328.jpg\";s:5:\"width\";s:3:\"637\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:15:\"Gold-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:16:\"Gold-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1075", "1107", "_wp_attached_file", "2012/06/Iron.jpg");
INSERT INTO `wp_postmeta` VALUES("1076", "1107", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"636\";s:6:\"height\";s:3:\"637\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'95\'\";s:4:\"file\";s:16:\"2012/06/Iron.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:16:\"Iron-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:16:\"Iron-576x576.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"576\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:16:\"Iron-636x300.jpg\";s:5:\"width\";s:3:\"636\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:14:\"Iron-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:16:\"Iron-636x328.jpg\";s:5:\"width\";s:3:\"636\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:15:\"Iron-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:16:\"Iron-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1077", "1108", "_wp_attached_file", "2012/06/Pewter.jpg");
INSERT INTO `wp_postmeta` VALUES("1078", "1108", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"633\";s:6:\"height\";s:3:\"635\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'95\'\";s:4:\"file\";s:18:\"2012/06/Pewter.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:18:\"Pewter-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:18:\"Pewter-576x577.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"577\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:18:\"Pewter-633x300.jpg\";s:5:\"width\";s:3:\"633\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:16:\"Pewter-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:18:\"Pewter-633x328.jpg\";s:5:\"width\";s:3:\"633\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:17:\"Pewter-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:18:\"Pewter-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1079", "1109", "_wp_attached_file", "2012/06/Silver.jpg");
INSERT INTO `wp_postmeta` VALUES("1080", "1109", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"633\";s:6:\"height\";s:3:\"635\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'95\'\";s:4:\"file\";s:18:\"2012/06/Silver.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:18:\"Silver-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:18:\"Silver-576x577.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"577\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:18:\"Silver-633x300.jpg\";s:5:\"width\";s:3:\"633\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:16:\"Silver-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:18:\"Silver-633x328.jpg\";s:5:\"width\";s:3:\"633\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:17:\"Silver-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:18:\"Silver-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1084", "1114", "_wp_attached_file", "2012/06/vanguardia01.jpg");
INSERT INTO `wp_postmeta` VALUES("1085", "1114", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"599\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:24:\"2012/06/vanguardia01.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:24:\"vanguardia01-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:24:\"vanguardia01-576x383.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"383\";}s:5:\"large\";a:3:{s:4:\"file\";s:24:\"vanguardia01-700x465.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"465\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:24:\"vanguardia01-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:22:\"vanguardia01-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:24:\"vanguardia01-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:23:\"vanguardia01-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:24:\"vanguardia01-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1086", "1115", "_wp_attached_file", "2012/06/vanguardia02.jpg");
INSERT INTO `wp_postmeta` VALUES("1087", "1115", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"599\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:24:\"2012/06/vanguardia02.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:24:\"vanguardia02-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:24:\"vanguardia02-576x383.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"383\";}s:5:\"large\";a:3:{s:4:\"file\";s:24:\"vanguardia02-700x465.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"465\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:24:\"vanguardia02-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:22:\"vanguardia02-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:24:\"vanguardia02-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:23:\"vanguardia02-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:24:\"vanguardia02-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1088", "1116", "_wp_attached_file", "2012/06/vanguardia03.jpg");
INSERT INTO `wp_postmeta` VALUES("1089", "1116", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"599\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:24:\"2012/06/vanguardia03.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:24:\"vanguardia03-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:24:\"vanguardia03-576x383.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"383\";}s:5:\"large\";a:3:{s:4:\"file\";s:24:\"vanguardia03-700x465.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"465\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:24:\"vanguardia03-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:22:\"vanguardia03-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:24:\"vanguardia03-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:23:\"vanguardia03-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:24:\"vanguardia03-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1090", "1117", "_wp_attached_file", "2012/06/vanguardia04.jpg");
INSERT INTO `wp_postmeta` VALUES("1091", "1117", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"599\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:24:\"2012/06/vanguardia04.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:24:\"vanguardia04-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:24:\"vanguardia04-576x383.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"383\";}s:5:\"large\";a:3:{s:4:\"file\";s:24:\"vanguardia04-700x465.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"465\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:24:\"vanguardia04-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:22:\"vanguardia04-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:24:\"vanguardia04-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:23:\"vanguardia04-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:24:\"vanguardia04-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1092", "1118", "_wp_attached_file", "2012/06/vanguardia05.jpg");
INSERT INTO `wp_postmeta` VALUES("1093", "1118", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"599\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:24:\"2012/06/vanguardia05.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:24:\"vanguardia05-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:24:\"vanguardia05-576x383.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"383\";}s:5:\"large\";a:3:{s:4:\"file\";s:24:\"vanguardia05-700x465.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"465\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:24:\"vanguardia05-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:22:\"vanguardia05-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:24:\"vanguardia05-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:23:\"vanguardia05-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:24:\"vanguardia05-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1094", "1119", "_wp_attached_file", "2012/06/vanguardia06.jpg");
INSERT INTO `wp_postmeta` VALUES("1095", "1119", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"609\";s:14:\"hwstring_small\";s:23:\"height=\'86\' width=\'128\'\";s:4:\"file\";s:24:\"2012/06/vanguardia06.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:24:\"vanguardia06-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:24:\"vanguardia06-576x389.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"389\";}s:5:\"large\";a:3:{s:4:\"file\";s:24:\"vanguardia06-700x473.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"473\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:24:\"vanguardia06-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:22:\"vanguardia06-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:24:\"vanguardia06-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:23:\"vanguardia06-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:24:\"vanguardia06-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1096", "1120", "_wp_attached_file", "2012/06/vanguardia07.jpg");
INSERT INTO `wp_postmeta` VALUES("1097", "1120", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"675\";s:14:\"hwstring_small\";s:23:\"height=\'96\' width=\'128\'\";s:4:\"file\";s:24:\"2012/06/vanguardia07.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:24:\"vanguardia07-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:24:\"vanguardia07-576x432.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"432\";}s:5:\"large\";a:3:{s:4:\"file\";s:24:\"vanguardia07-700x525.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"525\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:24:\"vanguardia07-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:22:\"vanguardia07-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:24:\"vanguardia07-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:23:\"vanguardia07-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:24:\"vanguardia07-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1098", "1121", "_wp_attached_file", "2012/06/vanguardia08.jpg");
INSERT INTO `wp_postmeta` VALUES("1099", "1121", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"675\";s:14:\"hwstring_small\";s:23:\"height=\'96\' width=\'128\'\";s:4:\"file\";s:24:\"2012/06/vanguardia08.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:24:\"vanguardia08-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:24:\"vanguardia08-576x432.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"432\";}s:5:\"large\";a:3:{s:4:\"file\";s:24:\"vanguardia08-700x525.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"525\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:24:\"vanguardia08-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:22:\"vanguardia08-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:24:\"vanguardia08-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:23:\"vanguardia08-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:24:\"vanguardia08-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1100", "1122", "_wp_attached_file", "2012/06/vanguardia09.jpg");
INSERT INTO `wp_postmeta` VALUES("1101", "1122", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"675\";s:14:\"hwstring_small\";s:23:\"height=\'96\' width=\'128\'\";s:4:\"file\";s:24:\"2012/06/vanguardia09.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:24:\"vanguardia09-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:24:\"vanguardia09-576x432.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"432\";}s:5:\"large\";a:3:{s:4:\"file\";s:24:\"vanguardia09-700x525.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"525\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:24:\"vanguardia09-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:22:\"vanguardia09-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:24:\"vanguardia09-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:23:\"vanguardia09-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:24:\"vanguardia09-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1102", "1123", "_wp_attached_file", "2012/06/vanguardia10.jpg");
INSERT INTO `wp_postmeta` VALUES("1103", "1123", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"675\";s:14:\"hwstring_small\";s:23:\"height=\'96\' width=\'128\'\";s:4:\"file\";s:24:\"2012/06/vanguardia10.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:24:\"vanguardia10-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:24:\"vanguardia10-576x432.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"432\";}s:5:\"large\";a:3:{s:4:\"file\";s:24:\"vanguardia10-700x525.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"525\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:24:\"vanguardia10-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:22:\"vanguardia10-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:24:\"vanguardia10-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:23:\"vanguardia10-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:24:\"vanguardia10-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1104", "1124", "_wp_attached_file", "2012/06/vanguardia11.jpg");
INSERT INTO `wp_postmeta` VALUES("1105", "1124", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"675\";s:14:\"hwstring_small\";s:23:\"height=\'96\' width=\'128\'\";s:4:\"file\";s:24:\"2012/06/vanguardia11.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:24:\"vanguardia11-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:24:\"vanguardia11-576x432.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"432\";}s:5:\"large\";a:3:{s:4:\"file\";s:24:\"vanguardia11-700x525.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"525\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:24:\"vanguardia11-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:22:\"vanguardia11-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:24:\"vanguardia11-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:23:\"vanguardia11-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:24:\"vanguardia11-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1106", "1131", "_wp_attached_file", "2012/03/banner_espoz_02.jpg");
INSERT INTO `wp_postmeta` VALUES("1107", "1131", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"696\";s:6:\"height\";s:3:\"266\";s:14:\"hwstring_small\";s:23:\"height=\'48\' width=\'128\'\";s:4:\"file\";s:27:\"2012/03/banner_espoz_02.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:27:\"banner_espoz_02-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:27:\"banner_espoz_02-576x220.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"220\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:25:\"banner_espoz_02-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:26:\"banner_espoz_02-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:27:\"banner_espoz_02-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1108", "1132", "_wp_attached_file", "2012/03/espoz_equip_04.jpg");
INSERT INTO `wp_postmeta` VALUES("1109", "1132", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"322\";s:6:\"height\";s:3:\"215\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:26:\"2012/03/espoz_equip_04.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:26:\"espoz_equip_04-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:24:\"espoz_equip_04-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:25:\"espoz_equip_04-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:26:\"espoz_equip_04-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1110", "1133", "_wp_attached_file", "2012/03/rafael-sanzio-departamentos.jpg");
INSERT INTO `wp_postmeta` VALUES("1111", "1133", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"740\";s:6:\"height\";s:3:\"493\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:39:\"2012/03/rafael-sanzio-departamentos.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:39:\"rafael-sanzio-departamentos-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:39:\"rafael-sanzio-departamentos-576x383.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"383\";}s:5:\"large\";a:3:{s:4:\"file\";s:39:\"rafael-sanzio-departamentos-700x466.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"466\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:39:\"rafael-sanzio-departamentos-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:37:\"rafael-sanzio-departamentos-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:39:\"rafael-sanzio-departamentos-740x328.jpg\";s:5:\"width\";s:3:\"740\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:38:\"rafael-sanzio-departamentos-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:39:\"rafael-sanzio-departamentos-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1157", "1161", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";s:14:\"hwstring_small\";s:23:\"height=\'51\' width=\'128\'\";s:4:\"file\";s:23:\"2012/06/aeropuertos.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:23:\"aeropuertos-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:23:\"aeropuertos-576x233.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"233\";}s:5:\"large\";a:3:{s:4:\"file\";s:23:\"aeropuertos-700x283.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"283\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:23:\"aeropuertos-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:21:\"aeropuertos-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:22:\"aeropuertos-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:23:\"aeropuertos-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1158", "1143", "_thumbnail_id", "1161");
INSERT INTO `wp_postmeta` VALUES("1160", "1163", "_wp_attached_file", "2012/06/Adelaide-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1161", "1163", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"675\";s:14:\"hwstring_small\";s:23:\"height=\'96\' width=\'128\'\";s:4:\"file\";s:22:\"2012/06/Adelaide-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:22:\"Adelaide-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:22:\"Adelaide-t-576x432.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"432\";}s:5:\"large\";a:3:{s:4:\"file\";s:22:\"Adelaide-t-700x525.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"525\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:22:\"Adelaide-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:20:\"Adelaide-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:22:\"Adelaide-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:21:\"Adelaide-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:22:\"Adelaide-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1162", "1164", "_wp_attached_file", "2012/06/Haneda-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1163", "1164", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"599\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:20:\"2012/06/Haneda-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:20:\"Haneda-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:20:\"Haneda-t-576x383.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"383\";}s:5:\"large\";a:3:{s:4:\"file\";s:20:\"Haneda-t-700x465.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"465\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:20:\"Haneda-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:18:\"Haneda-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:20:\"Haneda-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:19:\"Haneda-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:20:\"Haneda-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1164", "1165", "_wp_attached_file", "2012/06/Huang-Pu-3-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1165", "1165", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"704\";s:14:\"hwstring_small\";s:23:\"height=\'96\' width=\'122\'\";s:4:\"file\";s:24:\"2012/06/Huang-Pu-3-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:24:\"Huang-Pu-3-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:24:\"Huang-Pu-3-t-576x450.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"450\";}s:5:\"large\";a:3:{s:4:\"file\";s:24:\"Huang-Pu-3-t-700x547.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"547\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:24:\"Huang-Pu-3-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:22:\"Huang-Pu-3-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:24:\"Huang-Pu-3-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:23:\"Huang-Pu-3-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:24:\"Huang-Pu-3-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1166", "1166", "_wp_attached_file", "2012/06/Kuwait-2-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1167", "1166", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"600\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:22:\"2012/06/Kuwait-2-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:22:\"Kuwait-2-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:22:\"Kuwait-2-t-576x384.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"384\";}s:5:\"large\";a:3:{s:4:\"file\";s:22:\"Kuwait-2-t-700x466.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"466\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:22:\"Kuwait-2-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:20:\"Kuwait-2-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:22:\"Kuwait-2-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:21:\"Kuwait-2-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:22:\"Kuwait-2-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1168", "1167", "_wp_attached_file", "2012/06/Kuwait-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1169", "1167", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"600\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:20:\"2012/06/Kuwait-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:20:\"Kuwait-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:20:\"Kuwait-t-576x384.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"384\";}s:5:\"large\";a:3:{s:4:\"file\";s:20:\"Kuwait-t-700x466.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"466\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:20:\"Kuwait-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:18:\"Kuwait-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:20:\"Kuwait-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:19:\"Kuwait-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:20:\"Kuwait-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1170", "1168", "_wp_attached_file", "2012/06/Tokyo-Expo-2-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1171", "1168", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"701\";s:6:\"height\";s:3:\"900\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'74\'\";s:4:\"file\";s:26:\"2012/06/Tokyo-Expo-2-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:26:\"Tokyo-Expo-2-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:26:\"Tokyo-Expo-2-t-576x739.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"739\";}s:5:\"large\";a:3:{s:4:\"file\";s:26:\"Tokyo-Expo-2-t-700x898.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"898\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:26:\"Tokyo-Expo-2-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:24:\"Tokyo-Expo-2-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:26:\"Tokyo-Expo-2-t-701x328.jpg\";s:5:\"width\";s:3:\"701\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:25:\"Tokyo-Expo-2-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:26:\"Tokyo-Expo-2-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1173", "1171", "_wp_attached_file", "2012/06/banos.jpg");
INSERT INTO `wp_postmeta` VALUES("1174", "1171", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";s:14:\"hwstring_small\";s:23:\"height=\'51\' width=\'128\'\";s:4:\"file\";s:17:\"2012/06/banos.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:17:\"banos-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:17:\"banos-576x233.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"233\";}s:5:\"large\";a:3:{s:4:\"file\";s:17:\"banos-700x283.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"283\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:17:\"banos-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:15:\"banos-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:16:\"banos-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:17:\"banos-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1175", "1172", "_wp_attached_file", "2012/06/Apulia-Madr_1-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1176", "1172", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"735\";s:14:\"hwstring_small\";s:23:\"height=\'96\' width=\'117\'\";s:4:\"file\";s:27:\"2012/06/Apulia-Madr_1-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:27:\"Apulia-Madr_1-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:27:\"Apulia-Madr_1-t-576x470.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"470\";}s:5:\"large\";a:3:{s:4:\"file\";s:27:\"Apulia-Madr_1-t-700x571.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"571\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:27:\"Apulia-Madr_1-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:25:\"Apulia-Madr_1-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:27:\"Apulia-Madr_1-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:26:\"Apulia-Madr_1-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:27:\"Apulia-Madr_1-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1177", "1173", "_wp_attached_file", "2012/06/Bahama-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1178", "1173", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"675\";s:14:\"hwstring_small\";s:23:\"height=\'96\' width=\'128\'\";s:4:\"file\";s:20:\"2012/06/Bahama-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:20:\"Bahama-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:20:\"Bahama-t-576x432.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"432\";}s:5:\"large\";a:3:{s:4:\"file\";s:20:\"Bahama-t-700x525.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"525\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:20:\"Bahama-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:18:\"Bahama-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:20:\"Bahama-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:19:\"Bahama-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:20:\"Bahama-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1179", "1174", "_wp_attached_file", "2012/06/Blu-Stardust-3-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1180", "1174", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"675\";s:6:\"height\";s:3:\"900\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'72\'\";s:4:\"file\";s:28:\"2012/06/Blu-Stardust-3-t.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:28:\"Blu-Stardust-3-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:28:\"Blu-Stardust-3-t-576x768.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"768\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:28:\"Blu-Stardust-3-t-675x300.jpg\";s:5:\"width\";s:3:\"675\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:26:\"Blu-Stardust-3-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:28:\"Blu-Stardust-3-t-675x328.jpg\";s:5:\"width\";s:3:\"675\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:27:\"Blu-Stardust-3-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:28:\"Blu-Stardust-3-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1181", "1175", "_wp_attached_file", "2012/06/DSC_0080-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1182", "1175", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"599\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:22:\"2012/06/DSC_0080-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:22:\"DSC_0080-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:22:\"DSC_0080-t-576x383.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"383\";}s:5:\"large\";a:3:{s:4:\"file\";s:22:\"DSC_0080-t-700x465.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"465\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:22:\"DSC_0080-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:20:\"DSC_0080-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:22:\"DSC_0080-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:21:\"DSC_0080-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:22:\"DSC_0080-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1183", "1176", "_wp_attached_file", "2012/06/DSC_0105-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1184", "1176", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"599\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:22:\"2012/06/DSC_0105-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:22:\"DSC_0105-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:22:\"DSC_0105-t-576x383.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"383\";}s:5:\"large\";a:3:{s:4:\"file\";s:22:\"DSC_0105-t-700x465.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"465\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:22:\"DSC_0105-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:20:\"DSC_0105-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:22:\"DSC_0105-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:21:\"DSC_0105-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:22:\"DSC_0105-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1185", "1177", "_wp_attached_file", "2012/06/Engle-House-1-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1186", "1177", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:4:\"2048\";s:6:\"height\";s:4:\"1536\";s:14:\"hwstring_small\";s:23:\"height=\'96\' width=\'128\'\";s:4:\"file\";s:27:\"2012/06/Engle-House-1-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:27:\"Engle-House-1-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:27:\"Engle-House-1-t-576x432.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"432\";}s:5:\"large\";a:3:{s:4:\"file\";s:27:\"Engle-House-1-t-700x525.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"525\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:27:\"Engle-House-1-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:25:\"Engle-House-1-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:27:\"Engle-House-1-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:26:\"Engle-House-1-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:27:\"Engle-House-1-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1187", "1178", "_wp_attached_file", "2012/06/Img2590-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1188", "1178", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"602\";s:6:\"height\";s:3:\"900\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'64\'\";s:4:\"file\";s:21:\"2012/06/Img2590-t.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:21:\"Img2590-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:21:\"Img2590-t-576x861.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"861\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:21:\"Img2590-t-602x300.jpg\";s:5:\"width\";s:3:\"602\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:19:\"Img2590-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:21:\"Img2590-t-602x328.jpg\";s:5:\"width\";s:3:\"602\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:20:\"Img2590-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:21:\"Img2590-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1189", "1179", "_wp_attached_file", "2012/06/Img2618-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1190", "1179", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"602\";s:6:\"height\";s:3:\"900\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'64\'\";s:4:\"file\";s:21:\"2012/06/Img2618-t.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:21:\"Img2618-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:21:\"Img2618-t-576x861.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"861\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:21:\"Img2618-t-602x300.jpg\";s:5:\"width\";s:3:\"602\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:19:\"Img2618-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:21:\"Img2618-t-602x328.jpg\";s:5:\"width\";s:3:\"602\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:20:\"Img2618-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:21:\"Img2618-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1191", "1180", "_wp_attached_file", "2012/06/Rio-6-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1192", "1180", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"675\";s:6:\"height\";s:3:\"900\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'72\'\";s:4:\"file\";s:19:\"2012/06/Rio-6-t.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:19:\"Rio-6-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:19:\"Rio-6-t-576x768.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"768\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:19:\"Rio-6-t-675x300.jpg\";s:5:\"width\";s:3:\"675\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:17:\"Rio-6-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:19:\"Rio-6-t-675x328.jpg\";s:5:\"width\";s:3:\"675\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:18:\"Rio-6-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:19:\"Rio-6-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1197", "1186", "_wp_attached_file", "2012/06/malls.jpg");
INSERT INTO `wp_postmeta` VALUES("1198", "1186", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";s:14:\"hwstring_small\";s:23:\"height=\'51\' width=\'128\'\";s:4:\"file\";s:17:\"2012/06/malls.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:17:\"malls-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:17:\"malls-576x233.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"233\";}s:5:\"large\";a:3:{s:4:\"file\";s:17:\"malls-700x283.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"283\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:17:\"malls-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:15:\"malls-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:16:\"malls-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:17:\"malls-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1199", "1158", "_thumbnail_id", "1186");
INSERT INTO `wp_postmeta` VALUES("1200", "1187", "_wp_attached_file", "2012/06/Centria-04-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1201", "1187", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"599\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:24:\"2012/06/Centria-04-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:24:\"Centria-04-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:24:\"Centria-04-t-576x383.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"383\";}s:5:\"large\";a:3:{s:4:\"file\";s:24:\"Centria-04-t-700x465.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"465\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:24:\"Centria-04-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:22:\"Centria-04-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:24:\"Centria-04-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:23:\"Centria-04-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:24:\"Centria-04-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1202", "1188", "_wp_attached_file", "2012/06/DSC_0055-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1203", "1188", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"599\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:22:\"2012/06/DSC_0055-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:22:\"DSC_0055-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:22:\"DSC_0055-t-576x383.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"383\";}s:5:\"large\";a:3:{s:4:\"file\";s:22:\"DSC_0055-t-700x465.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"465\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:22:\"DSC_0055-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:20:\"DSC_0055-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:22:\"DSC_0055-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:21:\"DSC_0055-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:22:\"DSC_0055-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1204", "1189", "_wp_attached_file", "2012/06/DSC_0056-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1205", "1189", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"599\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:22:\"2012/06/DSC_0056-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:22:\"DSC_0056-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:22:\"DSC_0056-t-576x383.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"383\";}s:5:\"large\";a:3:{s:4:\"file\";s:22:\"DSC_0056-t-700x465.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"465\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:22:\"DSC_0056-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:20:\"DSC_0056-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:22:\"DSC_0056-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:21:\"DSC_0056-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:22:\"DSC_0056-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1206", "1190", "_wp_attached_file", "2012/06/DSC_0057-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1207", "1190", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"599\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:22:\"2012/06/DSC_0057-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:22:\"DSC_0057-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:22:\"DSC_0057-t-576x383.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"383\";}s:5:\"large\";a:3:{s:4:\"file\";s:22:\"DSC_0057-t-700x465.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"465\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:22:\"DSC_0057-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:20:\"DSC_0057-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:22:\"DSC_0057-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:21:\"DSC_0057-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:22:\"DSC_0057-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1208", "1191", "_wp_attached_file", "2012/06/DSC_0149-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1209", "1191", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"596\";s:6:\"height\";s:3:\"900\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'63\'\";s:4:\"file\";s:22:\"2012/06/DSC_0149-t.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:22:\"DSC_0149-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:22:\"DSC_0149-t-576x869.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"869\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:22:\"DSC_0149-t-596x300.jpg\";s:5:\"width\";s:3:\"596\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:20:\"DSC_0149-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:22:\"DSC_0149-t-596x328.jpg\";s:5:\"width\";s:3:\"596\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:21:\"DSC_0149-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:22:\"DSC_0149-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1210", "1192", "_wp_attached_file", "2012/06/DSC_0259-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1211", "1192", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"600\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:22:\"2012/06/DSC_0259-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:22:\"DSC_0259-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:22:\"DSC_0259-t-576x384.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"384\";}s:5:\"large\";a:3:{s:4:\"file\";s:22:\"DSC_0259-t-700x466.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"466\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:22:\"DSC_0259-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:20:\"DSC_0259-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:22:\"DSC_0259-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:21:\"DSC_0259-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:22:\"DSC_0259-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1212", "1193", "_wp_attached_file", "2012/06/IMG_0515-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1213", "1193", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"593\";s:14:\"hwstring_small\";s:23:\"height=\'84\' width=\'128\'\";s:4:\"file\";s:22:\"2012/06/IMG_0515-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:22:\"IMG_0515-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:22:\"IMG_0515-t-576x379.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"379\";}s:5:\"large\";a:3:{s:4:\"file\";s:22:\"IMG_0515-t-700x461.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"461\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:22:\"IMG_0515-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:20:\"IMG_0515-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:22:\"IMG_0515-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:21:\"IMG_0515-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:22:\"IMG_0515-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1214", "1194", "_wp_attached_file", "2012/06/IMG_0547-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1215", "1194", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"900\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'64\'\";s:4:\"file\";s:22:\"2012/06/IMG_0547-t.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:22:\"IMG_0547-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:22:\"IMG_0547-t-576x864.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"864\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:22:\"IMG_0547-t-600x300.jpg\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:20:\"IMG_0547-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:22:\"IMG_0547-t-600x328.jpg\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:21:\"IMG_0547-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:22:\"IMG_0547-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1216", "1195", "_wp_attached_file", "2012/06/IMG_0693-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1217", "1195", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"600\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:22:\"2012/06/IMG_0693-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:22:\"IMG_0693-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:22:\"IMG_0693-t-576x384.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"384\";}s:5:\"large\";a:3:{s:4:\"file\";s:22:\"IMG_0693-t-700x466.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"466\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:22:\"IMG_0693-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:20:\"IMG_0693-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:22:\"IMG_0693-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:21:\"IMG_0693-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:22:\"IMG_0693-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1218", "1196", "_wp_attached_file", "2012/06/Zar-20-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1219", "1196", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"675\";s:14:\"hwstring_small\";s:23:\"height=\'96\' width=\'128\'\";s:4:\"file\";s:20:\"2012/06/Zar-20-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:20:\"Zar-20-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:20:\"Zar-20-t-576x432.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"432\";}s:5:\"large\";a:3:{s:4:\"file\";s:20:\"Zar-20-t-700x525.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"525\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:20:\"Zar-20-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:18:\"Zar-20-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:20:\"Zar-20-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:19:\"Zar-20-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:20:\"Zar-20-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1220", "1197", "_wp_attached_file", "2012/06/Zar-21-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1221", "1197", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"675\";s:6:\"height\";s:3:\"900\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'72\'\";s:4:\"file\";s:20:\"2012/06/Zar-21-t.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:20:\"Zar-21-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:20:\"Zar-21-t-576x768.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"768\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:20:\"Zar-21-t-675x300.jpg\";s:5:\"width\";s:3:\"675\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:18:\"Zar-21-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:20:\"Zar-21-t-675x328.jpg\";s:5:\"width\";s:3:\"675\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:19:\"Zar-21-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:20:\"Zar-21-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1222", "1198", "_wp_attached_file", "2012/06/Zar-22-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1223", "1198", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"675\";s:6:\"height\";s:3:\"900\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'72\'\";s:4:\"file\";s:20:\"2012/06/Zar-22-t.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:20:\"Zar-22-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:20:\"Zar-22-t-576x768.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"768\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:20:\"Zar-22-t-675x300.jpg\";s:5:\"width\";s:3:\"675\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:18:\"Zar-22-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:20:\"Zar-22-t-675x328.jpg\";s:5:\"width\";s:3:\"675\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:19:\"Zar-22-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:20:\"Zar-22-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1227", "1203", "_wp_attached_file", "2012/06/hoteles.jpg");
INSERT INTO `wp_postmeta` VALUES("1228", "1203", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";s:14:\"hwstring_small\";s:23:\"height=\'51\' width=\'128\'\";s:4:\"file\";s:19:\"2012/06/hoteles.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:19:\"hoteles-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:19:\"hoteles-576x233.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"233\";}s:5:\"large\";a:3:{s:4:\"file\";s:19:\"hoteles-700x283.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"283\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:19:\"hoteles-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:17:\"hoteles-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:18:\"hoteles-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:19:\"hoteles-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1229", "1153", "_thumbnail_id", "1203");
INSERT INTO `wp_postmeta` VALUES("1231", "1205", "_wp_attached_file", "2012/06/Essey-1-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1232", "1205", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"603\";s:6:\"height\";s:3:\"900\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'64\'\";s:4:\"file\";s:21:\"2012/06/Essey-1-t.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:21:\"Essey-1-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:21:\"Essey-1-t-576x859.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"859\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:21:\"Essey-1-t-603x300.jpg\";s:5:\"width\";s:3:\"603\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:19:\"Essey-1-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:21:\"Essey-1-t-603x328.jpg\";s:5:\"width\";s:3:\"603\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:20:\"Essey-1-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:21:\"Essey-1-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1233", "1206", "_wp_attached_file", "2012/06/Essey-30-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1234", "1206", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"599\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:22:\"2012/06/Essey-30-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:22:\"Essey-30-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:22:\"Essey-30-t-576x383.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"383\";}s:5:\"large\";a:3:{s:4:\"file\";s:22:\"Essey-30-t-700x465.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"465\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:22:\"Essey-30-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:20:\"Essey-30-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:22:\"Essey-30-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:21:\"Essey-30-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:22:\"Essey-30-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1235", "1207", "_wp_attached_file", "2012/06/Fiorito-3-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1236", "1207", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"675\";s:14:\"hwstring_small\";s:23:\"height=\'96\' width=\'128\'\";s:4:\"file\";s:23:\"2012/06/Fiorito-3-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:23:\"Fiorito-3-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:23:\"Fiorito-3-t-576x432.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"432\";}s:5:\"large\";a:3:{s:4:\"file\";s:23:\"Fiorito-3-t-700x525.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"525\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:23:\"Fiorito-3-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:21:\"Fiorito-3-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:23:\"Fiorito-3-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:22:\"Fiorito-3-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:23:\"Fiorito-3-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1237", "1208", "_wp_attached_file", "2012/06/Fiorito-4-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1238", "1208", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"675\";s:14:\"hwstring_small\";s:23:\"height=\'96\' width=\'128\'\";s:4:\"file\";s:23:\"2012/06/Fiorito-4-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:23:\"Fiorito-4-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:23:\"Fiorito-4-t-576x432.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"432\";}s:5:\"large\";a:3:{s:4:\"file\";s:23:\"Fiorito-4-t-700x525.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"525\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:23:\"Fiorito-4-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:21:\"Fiorito-4-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:23:\"Fiorito-4-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:22:\"Fiorito-4-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:23:\"Fiorito-4-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1239", "1209", "_wp_attached_file", "2012/06/Fiorito-30-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1240", "1209", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"675\";s:6:\"height\";s:3:\"900\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'72\'\";s:4:\"file\";s:24:\"2012/06/Fiorito-30-t.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:24:\"Fiorito-30-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:24:\"Fiorito-30-t-576x768.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"768\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:24:\"Fiorito-30-t-675x300.jpg\";s:5:\"width\";s:3:\"675\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:22:\"Fiorito-30-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:24:\"Fiorito-30-t-675x328.jpg\";s:5:\"width\";s:3:\"675\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:23:\"Fiorito-30-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:24:\"Fiorito-30-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1241", "1210", "_wp_attached_file", "2012/06/Hilton-1-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1242", "1210", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"675\";s:14:\"hwstring_small\";s:23:\"height=\'96\' width=\'128\'\";s:4:\"file\";s:22:\"2012/06/Hilton-1-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:22:\"Hilton-1-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:22:\"Hilton-1-t-576x432.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"432\";}s:5:\"large\";a:3:{s:4:\"file\";s:22:\"Hilton-1-t-700x525.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"525\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:22:\"Hilton-1-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:20:\"Hilton-1-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:22:\"Hilton-1-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:21:\"Hilton-1-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:22:\"Hilton-1-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1243", "1211", "_wp_attached_file", "2012/06/Hilton-13-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1244", "1211", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"675\";s:14:\"hwstring_small\";s:23:\"height=\'96\' width=\'128\'\";s:4:\"file\";s:23:\"2012/06/Hilton-13-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:23:\"Hilton-13-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:23:\"Hilton-13-t-576x432.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"432\";}s:5:\"large\";a:3:{s:4:\"file\";s:23:\"Hilton-13-t-700x525.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"525\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:23:\"Hilton-13-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:21:\"Hilton-13-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:23:\"Hilton-13-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:22:\"Hilton-13-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:23:\"Hilton-13-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1245", "1212", "_wp_attached_file", "2012/06/Hilton-National-2-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1246", "1212", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"675\";s:14:\"hwstring_small\";s:23:\"height=\'96\' width=\'128\'\";s:4:\"file\";s:31:\"2012/06/Hilton-National-2-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:31:\"Hilton-National-2-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:31:\"Hilton-National-2-t-576x432.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"432\";}s:5:\"large\";a:3:{s:4:\"file\";s:31:\"Hilton-National-2-t-700x525.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"525\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:31:\"Hilton-National-2-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:29:\"Hilton-National-2-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:31:\"Hilton-National-2-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:30:\"Hilton-National-2-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:31:\"Hilton-National-2-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1247", "1213", "_wp_attached_file", "2012/06/Hotel-Lazise-1-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1248", "1213", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"817\";s:14:\"hwstring_small\";s:23:\"height=\'96\' width=\'105\'\";s:4:\"file\";s:28:\"2012/06/Hotel-Lazise-1-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:28:\"Hotel-Lazise-1-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:28:\"Hotel-Lazise-1-t-576x522.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"522\";}s:5:\"large\";a:3:{s:4:\"file\";s:28:\"Hotel-Lazise-1-t-700x635.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"635\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:28:\"Hotel-Lazise-1-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:26:\"Hotel-Lazise-1-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:28:\"Hotel-Lazise-1-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:27:\"Hotel-Lazise-1-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:28:\"Hotel-Lazise-1-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1249", "1214", "_wp_attached_file", "2012/06/Hotel-Lazise-2-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1250", "1214", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"908\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'95\'\";s:4:\"file\";s:28:\"2012/06/Hotel-Lazise-2-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:28:\"Hotel-Lazise-2-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:28:\"Hotel-Lazise-2-t-576x581.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"581\";}s:5:\"large\";a:3:{s:4:\"file\";s:28:\"Hotel-Lazise-2-t-700x706.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"706\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:28:\"Hotel-Lazise-2-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:26:\"Hotel-Lazise-2-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:28:\"Hotel-Lazise-2-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:27:\"Hotel-Lazise-2-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:28:\"Hotel-Lazise-2-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1251", "1215", "_wp_attached_file", "2012/06/Mirage-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1252", "1215", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"687\";s:14:\"hwstring_small\";s:23:\"height=\'96\' width=\'125\'\";s:4:\"file\";s:20:\"2012/06/Mirage-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:20:\"Mirage-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:20:\"Mirage-t-576x439.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"439\";}s:5:\"large\";a:3:{s:4:\"file\";s:20:\"Mirage-t-700x534.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"534\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:20:\"Mirage-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:18:\"Mirage-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:20:\"Mirage-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:19:\"Mirage-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:20:\"Mirage-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1253", "1216", "_wp_attached_file", "2012/06/Mirage2-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1254", "1216", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"978\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'88\'\";s:4:\"file\";s:21:\"2012/06/Mirage2-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:21:\"Mirage2-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:21:\"Mirage2-t-576x625.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"625\";}s:5:\"large\";a:3:{s:4:\"file\";s:21:\"Mirage2-t-700x760.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"760\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:21:\"Mirage2-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:19:\"Mirage2-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:21:\"Mirage2-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:20:\"Mirage2-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:21:\"Mirage2-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1255", "1217", "_wp_attached_file", "2012/06/Nikolina-Gora-1-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1256", "1217", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:4:\"1962\";s:6:\"height\";s:4:\"1298\";s:14:\"hwstring_small\";s:23:\"height=\'84\' width=\'128\'\";s:4:\"file\";s:29:\"2012/06/Nikolina-Gora-1-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:29:\"Nikolina-Gora-1-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:29:\"Nikolina-Gora-1-t-576x381.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"381\";}s:5:\"large\";a:3:{s:4:\"file\";s:29:\"Nikolina-Gora-1-t-700x463.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"463\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:29:\"Nikolina-Gora-1-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:27:\"Nikolina-Gora-1-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:29:\"Nikolina-Gora-1-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:28:\"Nikolina-Gora-1-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:29:\"Nikolina-Gora-1-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1257", "1218", "_wp_attached_file", "2012/06/Nikolina-Gora-11-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1258", "1218", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"604\";s:6:\"height\";s:3:\"900\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'64\'\";s:4:\"file\";s:30:\"2012/06/Nikolina-Gora-11-t.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:30:\"Nikolina-Gora-11-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:30:\"Nikolina-Gora-11-t-576x858.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"858\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:30:\"Nikolina-Gora-11-t-604x300.jpg\";s:5:\"width\";s:3:\"604\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:28:\"Nikolina-Gora-11-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:30:\"Nikolina-Gora-11-t-604x328.jpg\";s:5:\"width\";s:3:\"604\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:29:\"Nikolina-Gora-11-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:30:\"Nikolina-Gora-11-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1259", "1219", "_wp_attached_file", "2012/06/Nikolina-Gora-14-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1260", "1219", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"712\";s:14:\"hwstring_small\";s:23:\"height=\'96\' width=\'121\'\";s:4:\"file\";s:30:\"2012/06/Nikolina-Gora-14-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:30:\"Nikolina-Gora-14-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:30:\"Nikolina-Gora-14-t-576x455.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"455\";}s:5:\"large\";a:3:{s:4:\"file\";s:30:\"Nikolina-Gora-14-t-700x553.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"553\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:30:\"Nikolina-Gora-14-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:28:\"Nikolina-Gora-14-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:30:\"Nikolina-Gora-14-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:29:\"Nikolina-Gora-14-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:30:\"Nikolina-Gora-14-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1261", "1220", "_wp_attached_file", "2012/06/Park-Tower-Casino-1-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1262", "1220", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"675\";s:14:\"hwstring_small\";s:23:\"height=\'96\' width=\'128\'\";s:4:\"file\";s:33:\"2012/06/Park-Tower-Casino-1-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:33:\"Park-Tower-Casino-1-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:33:\"Park-Tower-Casino-1-t-576x432.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"432\";}s:5:\"large\";a:3:{s:4:\"file\";s:33:\"Park-Tower-Casino-1-t-700x525.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"525\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:33:\"Park-Tower-Casino-1-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:31:\"Park-Tower-Casino-1-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:33:\"Park-Tower-Casino-1-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:32:\"Park-Tower-Casino-1-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:33:\"Park-Tower-Casino-1-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1263", "1221", "_wp_attached_file", "2012/06/Sheraton-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1264", "1221", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"900\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'64\'\";s:4:\"file\";s:22:\"2012/06/Sheraton-t.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:22:\"Sheraton-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:22:\"Sheraton-t-576x864.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"864\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:22:\"Sheraton-t-600x300.jpg\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:20:\"Sheraton-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:22:\"Sheraton-t-600x328.jpg\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:21:\"Sheraton-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:22:\"Sheraton-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1266", "1224", "_wp_attached_file", "2012/06/ferias.jpg");
INSERT INTO `wp_postmeta` VALUES("1267", "1224", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";s:14:\"hwstring_small\";s:23:\"height=\'51\' width=\'128\'\";s:4:\"file\";s:18:\"2012/06/ferias.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:18:\"ferias-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:18:\"ferias-576x233.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"233\";}s:5:\"large\";a:3:{s:4:\"file\";s:18:\"ferias-700x283.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"283\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:18:\"ferias-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:16:\"ferias-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:17:\"ferias-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:18:\"ferias-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1268", "1151", "_thumbnail_id", "1224");
INSERT INTO `wp_postmeta` VALUES("1269", "1225", "_wp_attached_file", "2012/06/DSC0412-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1270", "1225", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"599\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:21:\"2012/06/DSC0412-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:21:\"DSC0412-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:21:\"DSC0412-t-576x383.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"383\";}s:5:\"large\";a:3:{s:4:\"file\";s:21:\"DSC0412-t-700x465.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"465\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:21:\"DSC0412-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:19:\"DSC0412-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:21:\"DSC0412-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:20:\"DSC0412-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:21:\"DSC0412-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1271", "1226", "_wp_attached_file", "2012/06/DSC0436-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1272", "1226", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"599\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:21:\"2012/06/DSC0436-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:21:\"DSC0436-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:21:\"DSC0436-t-576x383.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"383\";}s:5:\"large\";a:3:{s:4:\"file\";s:21:\"DSC0436-t-700x465.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"465\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:21:\"DSC0436-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:19:\"DSC0436-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:21:\"DSC0436-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:20:\"DSC0436-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:21:\"DSC0436-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1273", "1227", "_wp_attached_file", "2012/06/DSC0451-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1274", "1227", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"599\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:21:\"2012/06/DSC0451-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:21:\"DSC0451-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:21:\"DSC0451-t-576x383.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"383\";}s:5:\"large\";a:3:{s:4:\"file\";s:21:\"DSC0451-t-700x465.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"465\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:21:\"DSC0451-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:19:\"DSC0451-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:21:\"DSC0451-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:20:\"DSC0451-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:21:\"DSC0451-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1275", "1228", "_wp_attached_file", "2012/06/DSC0454-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1276", "1228", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"599\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:21:\"2012/06/DSC0454-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:21:\"DSC0454-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:21:\"DSC0454-t-576x383.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"383\";}s:5:\"large\";a:3:{s:4:\"file\";s:21:\"DSC0454-t-700x465.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"465\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:21:\"DSC0454-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:19:\"DSC0454-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:21:\"DSC0454-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:20:\"DSC0454-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:21:\"DSC0454-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1277", "1229", "_wp_attached_file", "2012/06/DSC0500-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1278", "1229", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"599\";s:6:\"height\";s:3:\"900\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'63\'\";s:4:\"file\";s:21:\"2012/06/DSC0500-t.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:21:\"DSC0500-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:21:\"DSC0500-t-576x865.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"865\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:21:\"DSC0500-t-599x300.jpg\";s:5:\"width\";s:3:\"599\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:19:\"DSC0500-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:21:\"DSC0500-t-599x328.jpg\";s:5:\"width\";s:3:\"599\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:20:\"DSC0500-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:21:\"DSC0500-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1279", "1230", "_wp_attached_file", "2012/06/DSC0511-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1280", "1230", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"599\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:21:\"2012/06/DSC0511-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:21:\"DSC0511-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:21:\"DSC0511-t-576x383.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"383\";}s:5:\"large\";a:3:{s:4:\"file\";s:21:\"DSC0511-t-700x465.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"465\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:21:\"DSC0511-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:19:\"DSC0511-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:21:\"DSC0511-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:20:\"DSC0511-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:21:\"DSC0511-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1281", "1231", "_wp_attached_file", "2012/06/FML4524-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1282", "1231", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"599\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:21:\"2012/06/FML4524-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:21:\"FML4524-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:21:\"FML4524-t-576x383.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"383\";}s:5:\"large\";a:3:{s:4:\"file\";s:21:\"FML4524-t-700x465.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"465\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:21:\"FML4524-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:19:\"FML4524-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:21:\"FML4524-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:20:\"FML4524-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:21:\"FML4524-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1283", "1232", "_wp_attached_file", "2012/06/FML4557-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1284", "1232", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"599\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:21:\"2012/06/FML4557-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:21:\"FML4557-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:21:\"FML4557-t-576x383.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"383\";}s:5:\"large\";a:3:{s:4:\"file\";s:21:\"FML4557-t-700x465.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"465\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:21:\"FML4557-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:19:\"FML4557-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:21:\"FML4557-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:20:\"FML4557-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:21:\"FML4557-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1285", "1233", "_wp_attached_file", "2012/06/FML4601-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1286", "1233", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"599\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:21:\"2012/06/FML4601-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:21:\"FML4601-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:21:\"FML4601-t-576x383.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"383\";}s:5:\"large\";a:3:{s:4:\"file\";s:21:\"FML4601-t-700x465.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"465\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:21:\"FML4601-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:19:\"FML4601-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:21:\"FML4601-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:20:\"FML4601-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:21:\"FML4601-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1287", "1234", "_wp_attached_file", "2012/06/FML5199-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1288", "1234", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"599\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:21:\"2012/06/FML5199-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:21:\"FML5199-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:21:\"FML5199-t-576x383.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"383\";}s:5:\"large\";a:3:{s:4:\"file\";s:21:\"FML5199-t-700x465.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"465\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:21:\"FML5199-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:19:\"FML5199-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:21:\"FML5199-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:20:\"FML5199-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:21:\"FML5199-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1289", "1235", "_wp_attached_file", "2012/06/FML5201-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1290", "1235", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"599\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:21:\"2012/06/FML5201-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:21:\"FML5201-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:21:\"FML5201-t-576x383.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"383\";}s:5:\"large\";a:3:{s:4:\"file\";s:21:\"FML5201-t-700x465.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"465\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:21:\"FML5201-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:19:\"FML5201-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:21:\"FML5201-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:20:\"FML5201-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:21:\"FML5201-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1291", "1236", "_wp_attached_file", "2012/06/FML5236-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1292", "1236", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"599\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:21:\"2012/06/FML5236-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:21:\"FML5236-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:21:\"FML5236-t-576x383.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"383\";}s:5:\"large\";a:3:{s:4:\"file\";s:21:\"FML5236-t-700x465.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"465\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:21:\"FML5236-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:19:\"FML5236-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:21:\"FML5236-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:20:\"FML5236-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:21:\"FML5236-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1293", "1237", "_wp_attached_file", "2012/06/FML5263-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1294", "1237", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"759\";s:14:\"hwstring_small\";s:23:\"height=\'96\' width=\'113\'\";s:4:\"file\";s:21:\"2012/06/FML5263-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:21:\"FML5263-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:21:\"FML5263-t-576x485.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"485\";}s:5:\"large\";a:3:{s:4:\"file\";s:21:\"FML5263-t-700x590.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"590\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:21:\"FML5263-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:19:\"FML5263-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:21:\"FML5263-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:20:\"FML5263-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:21:\"FML5263-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1295", "1238", "_wp_attached_file", "2012/06/FML5471-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1296", "1238", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"442\";s:14:\"hwstring_small\";s:23:\"height=\'62\' width=\'128\'\";s:4:\"file\";s:21:\"2012/06/FML5471-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:21:\"FML5471-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:21:\"FML5471-t-576x282.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"282\";}s:5:\"large\";a:3:{s:4:\"file\";s:21:\"FML5471-t-700x343.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"343\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:21:\"FML5471-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:19:\"FML5471-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:21:\"FML5471-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:20:\"FML5471-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:21:\"FML5471-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1297", "1239", "_wp_attached_file", "2012/06/CIMG2030-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1298", "1239", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"675\";s:14:\"hwstring_small\";s:23:\"height=\'96\' width=\'128\'\";s:4:\"file\";s:22:\"2012/06/CIMG2030-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:22:\"CIMG2030-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:22:\"CIMG2030-t-576x432.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"432\";}s:5:\"large\";a:3:{s:4:\"file\";s:22:\"CIMG2030-t-700x525.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"525\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:22:\"CIMG2030-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:20:\"CIMG2030-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:22:\"CIMG2030-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:21:\"CIMG2030-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:22:\"CIMG2030-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1299", "1240", "_wp_attached_file", "2012/06/IMG_0005-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1300", "1240", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"600\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:22:\"2012/06/IMG_0005-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:22:\"IMG_0005-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:22:\"IMG_0005-t-576x384.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"384\";}s:5:\"large\";a:3:{s:4:\"file\";s:22:\"IMG_0005-t-700x466.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"466\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:22:\"IMG_0005-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:20:\"IMG_0005-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:22:\"IMG_0005-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:21:\"IMG_0005-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:22:\"IMG_0005-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1301", "1241", "_wp_attached_file", "2012/06/IMG_0018-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1302", "1241", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"600\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:22:\"2012/06/IMG_0018-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:22:\"IMG_0018-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:22:\"IMG_0018-t-576x384.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"384\";}s:5:\"large\";a:3:{s:4:\"file\";s:22:\"IMG_0018-t-700x466.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"466\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:22:\"IMG_0018-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:20:\"IMG_0018-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:22:\"IMG_0018-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:21:\"IMG_0018-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:22:\"IMG_0018-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1303", "1242", "_wp_attached_file", "2012/06/IMG_0028-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1304", "1242", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"600\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:22:\"2012/06/IMG_0028-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:22:\"IMG_0028-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:22:\"IMG_0028-t-576x384.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"384\";}s:5:\"large\";a:3:{s:4:\"file\";s:22:\"IMG_0028-t-700x466.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"466\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:22:\"IMG_0028-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:20:\"IMG_0028-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:22:\"IMG_0028-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:21:\"IMG_0028-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:22:\"IMG_0028-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1305", "1243", "_wp_attached_file", "2012/06/marmomacc-07-002-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1306", "1243", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"675\";s:14:\"hwstring_small\";s:23:\"height=\'96\' width=\'128\'\";s:4:\"file\";s:30:\"2012/06/marmomacc-07-002-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:30:\"marmomacc-07-002-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:30:\"marmomacc-07-002-t-576x432.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"432\";}s:5:\"large\";a:3:{s:4:\"file\";s:30:\"marmomacc-07-002-t-700x525.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"525\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:30:\"marmomacc-07-002-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:28:\"marmomacc-07-002-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:30:\"marmomacc-07-002-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:29:\"marmomacc-07-002-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:30:\"marmomacc-07-002-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1307", "1244", "_wp_attached_file", "2012/06/marmomacc-07-023-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1308", "1244", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"675\";s:14:\"hwstring_small\";s:23:\"height=\'96\' width=\'128\'\";s:4:\"file\";s:30:\"2012/06/marmomacc-07-023-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:30:\"marmomacc-07-023-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:30:\"marmomacc-07-023-t-576x432.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"432\";}s:5:\"large\";a:3:{s:4:\"file\";s:30:\"marmomacc-07-023-t-700x525.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"525\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:30:\"marmomacc-07-023-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:28:\"marmomacc-07-023-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:30:\"marmomacc-07-023-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:29:\"marmomacc-07-023-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:30:\"marmomacc-07-023-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1309", "1245", "_wp_attached_file", "2012/06/P1010001-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1310", "1245", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"675\";s:14:\"hwstring_small\";s:23:\"height=\'96\' width=\'128\'\";s:4:\"file\";s:22:\"2012/06/P1010001-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:22:\"P1010001-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:22:\"P1010001-t-576x432.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"432\";}s:5:\"large\";a:3:{s:4:\"file\";s:22:\"P1010001-t-700x525.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"525\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:22:\"P1010001-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:20:\"P1010001-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:22:\"P1010001-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:21:\"P1010001-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:22:\"P1010001-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1311", "1246", "_wp_attached_file", "2012/06/P1010260-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1312", "1246", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"675\";s:14:\"hwstring_small\";s:23:\"height=\'96\' width=\'128\'\";s:4:\"file\";s:22:\"2012/06/P1010260-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:22:\"P1010260-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:22:\"P1010260-t-576x432.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"432\";}s:5:\"large\";a:3:{s:4:\"file\";s:22:\"P1010260-t-700x525.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"525\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:22:\"P1010260-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:20:\"P1010260-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:22:\"P1010260-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:21:\"P1010260-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:22:\"P1010260-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1313", "1247", "_wp_attached_file", "2012/06/SANY0010-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1314", "1247", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"673\";s:14:\"hwstring_small\";s:23:\"height=\'96\' width=\'128\'\";s:4:\"file\";s:22:\"2012/06/SANY0010-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:22:\"SANY0010-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:22:\"SANY0010-t-576x430.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"430\";}s:5:\"large\";a:3:{s:4:\"file\";s:22:\"SANY0010-t-700x523.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"523\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:22:\"SANY0010-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:20:\"SANY0010-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:22:\"SANY0010-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:21:\"SANY0010-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:22:\"SANY0010-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1317", "1251", "_wp_attached_file", "2012/06/cocinas.jpg");
INSERT INTO `wp_postmeta` VALUES("1318", "1251", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";s:14:\"hwstring_small\";s:23:\"height=\'51\' width=\'128\'\";s:4:\"file\";s:19:\"2012/06/cocinas.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:19:\"cocinas-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:19:\"cocinas-576x233.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"233\";}s:5:\"large\";a:3:{s:4:\"file\";s:19:\"cocinas-700x283.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"283\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:19:\"cocinas-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:17:\"cocinas-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:18:\"cocinas-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:19:\"cocinas-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1319", "1148", "_thumbnail_id", "1251");
INSERT INTO `wp_postmeta` VALUES("1320", "1252", "_wp_attached_file", "2012/06/019-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1321", "1252", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"599\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:17:\"2012/06/019-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:17:\"019-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:17:\"019-t-576x383.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"383\";}s:5:\"large\";a:3:{s:4:\"file\";s:17:\"019-t-700x465.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"465\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:17:\"019-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:15:\"019-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:17:\"019-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:16:\"019-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:17:\"019-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1322", "1253", "_wp_attached_file", "2012/06/Avellino-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1323", "1253", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"710\";s:14:\"hwstring_small\";s:23:\"height=\'96\' width=\'121\'\";s:4:\"file\";s:22:\"2012/06/Avellino-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:22:\"Avellino-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:22:\"Avellino-t-576x454.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"454\";}s:5:\"large\";a:3:{s:4:\"file\";s:22:\"Avellino-t-700x552.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"552\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:22:\"Avellino-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:20:\"Avellino-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:22:\"Avellino-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:21:\"Avellino-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:22:\"Avellino-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1324", "1254", "_wp_attached_file", "2012/06/Cucina-3-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1325", "1254", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"435\";s:14:\"hwstring_small\";s:23:\"height=\'61\' width=\'128\'\";s:4:\"file\";s:22:\"2012/06/Cucina-3-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:22:\"Cucina-3-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:22:\"Cucina-3-t-576x278.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"278\";}s:5:\"large\";a:3:{s:4:\"file\";s:22:\"Cucina-3-t-700x338.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"338\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:22:\"Cucina-3-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:20:\"Cucina-3-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:22:\"Cucina-3-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:21:\"Cucina-3-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:22:\"Cucina-3-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1326", "1255", "_wp_attached_file", "2012/06/Cucina-Bianco-Stardust-1-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1327", "1255", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"501\";s:14:\"hwstring_small\";s:23:\"height=\'71\' width=\'128\'\";s:4:\"file\";s:38:\"2012/06/Cucina-Bianco-Stardust-1-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:38:\"Cucina-Bianco-Stardust-1-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:38:\"Cucina-Bianco-Stardust-1-t-576x320.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"320\";}s:5:\"large\";a:3:{s:4:\"file\";s:38:\"Cucina-Bianco-Stardust-1-t-700x389.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"389\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:38:\"Cucina-Bianco-Stardust-1-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:36:\"Cucina-Bianco-Stardust-1-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:38:\"Cucina-Bianco-Stardust-1-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:37:\"Cucina-Bianco-Stardust-1-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:38:\"Cucina-Bianco-Stardust-1-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1328", "1256", "_wp_attached_file", "2012/06/Cucina-Bianco-Stardust-2-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1329", "1256", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"571\";s:14:\"hwstring_small\";s:23:\"height=\'81\' width=\'128\'\";s:4:\"file\";s:38:\"2012/06/Cucina-Bianco-Stardust-2-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:38:\"Cucina-Bianco-Stardust-2-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:38:\"Cucina-Bianco-Stardust-2-t-576x365.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"365\";}s:5:\"large\";a:3:{s:4:\"file\";s:38:\"Cucina-Bianco-Stardust-2-t-700x444.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"444\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:38:\"Cucina-Bianco-Stardust-2-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:36:\"Cucina-Bianco-Stardust-2-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:38:\"Cucina-Bianco-Stardust-2-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:37:\"Cucina-Bianco-Stardust-2-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:38:\"Cucina-Bianco-Stardust-2-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1330", "1257", "_wp_attached_file", "2012/06/Cucina-Madrid-2-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1331", "1257", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"675\";s:14:\"hwstring_small\";s:23:\"height=\'96\' width=\'128\'\";s:4:\"file\";s:29:\"2012/06/Cucina-Madrid-2-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:29:\"Cucina-Madrid-2-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:29:\"Cucina-Madrid-2-t-576x432.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"432\";}s:5:\"large\";a:3:{s:4:\"file\";s:29:\"Cucina-Madrid-2-t-700x525.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"525\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:29:\"Cucina-Madrid-2-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:27:\"Cucina-Madrid-2-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:29:\"Cucina-Madrid-2-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:28:\"Cucina-Madrid-2-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:29:\"Cucina-Madrid-2-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1332", "1258", "_wp_attached_file", "2012/06/Cucina-Nero-Stardust-2-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1333", "1258", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"675\";s:14:\"hwstring_small\";s:23:\"height=\'96\' width=\'128\'\";s:4:\"file\";s:36:\"2012/06/Cucina-Nero-Stardust-2-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:36:\"Cucina-Nero-Stardust-2-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:36:\"Cucina-Nero-Stardust-2-t-576x432.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"432\";}s:5:\"large\";a:3:{s:4:\"file\";s:36:\"Cucina-Nero-Stardust-2-t-700x525.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"525\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:36:\"Cucina-Nero-Stardust-2-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:34:\"Cucina-Nero-Stardust-2-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:36:\"Cucina-Nero-Stardust-2-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:35:\"Cucina-Nero-Stardust-2-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:36:\"Cucina-Nero-Stardust-2-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1334", "1259", "_wp_attached_file", "2012/06/Cucina-Nero-Stardust-3-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1335", "1259", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"675\";s:6:\"height\";s:3:\"900\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'72\'\";s:4:\"file\";s:36:\"2012/06/Cucina-Nero-Stardust-3-t.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:36:\"Cucina-Nero-Stardust-3-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:36:\"Cucina-Nero-Stardust-3-t-576x768.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"768\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:36:\"Cucina-Nero-Stardust-3-t-675x300.jpg\";s:5:\"width\";s:3:\"675\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:34:\"Cucina-Nero-Stardust-3-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:36:\"Cucina-Nero-Stardust-3-t-675x328.jpg\";s:5:\"width\";s:3:\"675\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:35:\"Cucina-Nero-Stardust-3-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:36:\"Cucina-Nero-Stardust-3-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1336", "1260", "_wp_attached_file", "2012/06/Cucina-Nettuno-1-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1337", "1260", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"675\";s:14:\"hwstring_small\";s:23:\"height=\'96\' width=\'128\'\";s:4:\"file\";s:30:\"2012/06/Cucina-Nettuno-1-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:30:\"Cucina-Nettuno-1-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:30:\"Cucina-Nettuno-1-t-576x432.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"432\";}s:5:\"large\";a:3:{s:4:\"file\";s:30:\"Cucina-Nettuno-1-t-700x525.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"525\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:30:\"Cucina-Nettuno-1-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:28:\"Cucina-Nettuno-1-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:30:\"Cucina-Nettuno-1-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:29:\"Cucina-Nettuno-1-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:30:\"Cucina-Nettuno-1-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1338", "1261", "_wp_attached_file", "2012/06/DSC_0020-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1339", "1261", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"599\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:22:\"2012/06/DSC_0020-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:22:\"DSC_0020-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:22:\"DSC_0020-t-576x383.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"383\";}s:5:\"large\";a:3:{s:4:\"file\";s:22:\"DSC_0020-t-700x465.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"465\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:22:\"DSC_0020-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:20:\"DSC_0020-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:22:\"DSC_0020-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:21:\"DSC_0020-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:22:\"DSC_0020-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1340", "1262", "_wp_attached_file", "2012/06/DSC_0036-copy-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1341", "1262", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"739\";s:14:\"hwstring_small\";s:23:\"height=\'96\' width=\'116\'\";s:4:\"file\";s:27:\"2012/06/DSC_0036-copy-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:27:\"DSC_0036-copy-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:27:\"DSC_0036-copy-t-576x472.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"472\";}s:5:\"large\";a:3:{s:4:\"file\";s:27:\"DSC_0036-copy-t-700x574.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"574\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:27:\"DSC_0036-copy-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:25:\"DSC_0036-copy-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:27:\"DSC_0036-copy-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:26:\"DSC_0036-copy-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:27:\"DSC_0036-copy-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1342", "1263", "_wp_attached_file", "2012/06/DSC_0049-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1343", "1263", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"599\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:22:\"2012/06/DSC_0049-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:22:\"DSC_0049-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:22:\"DSC_0049-t-576x383.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"383\";}s:5:\"large\";a:3:{s:4:\"file\";s:22:\"DSC_0049-t-700x465.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"465\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:22:\"DSC_0049-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:20:\"DSC_0049-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:22:\"DSC_0049-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:21:\"DSC_0049-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:22:\"DSC_0049-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1344", "1264", "_wp_attached_file", "2012/06/DSC_0065-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1345", "1264", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"588\";s:6:\"height\";s:3:\"900\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'62\'\";s:4:\"file\";s:22:\"2012/06/DSC_0065-t.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:22:\"DSC_0065-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:22:\"DSC_0065-t-576x881.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"881\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:22:\"DSC_0065-t-588x300.jpg\";s:5:\"width\";s:3:\"588\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:20:\"DSC_0065-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:22:\"DSC_0065-t-588x328.jpg\";s:5:\"width\";s:3:\"588\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:21:\"DSC_0065-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:22:\"DSC_0065-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1346", "1265", "_wp_attached_file", "2012/06/EurLiv-KitchenC-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1347", "1265", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"717\";s:14:\"hwstring_small\";s:23:\"height=\'96\' width=\'120\'\";s:4:\"file\";s:29:\"2012/06/EurLiv-KitchenC-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:29:\"EurLiv-KitchenC-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:29:\"EurLiv-KitchenC-t-576x458.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"458\";}s:5:\"large\";a:3:{s:4:\"file\";s:29:\"EurLiv-KitchenC-t-700x557.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"557\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:29:\"EurLiv-KitchenC-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:27:\"EurLiv-KitchenC-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:29:\"EurLiv-KitchenC-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:28:\"EurLiv-KitchenC-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:29:\"EurLiv-KitchenC-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1348", "1266", "_wp_attached_file", "2012/06/Img0744-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1349", "1266", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"602\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:21:\"2012/06/Img0744-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:21:\"Img0744-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:21:\"Img0744-t-576x385.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"385\";}s:5:\"large\";a:3:{s:4:\"file\";s:21:\"Img0744-t-700x468.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"468\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:21:\"Img0744-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:19:\"Img0744-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:21:\"Img0744-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:20:\"Img0744-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:21:\"Img0744-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1350", "1267", "_wp_attached_file", "2012/06/Img0769-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1351", "1267", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"602\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:21:\"2012/06/Img0769-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:21:\"Img0769-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:21:\"Img0769-t-576x385.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"385\";}s:5:\"large\";a:3:{s:4:\"file\";s:21:\"Img0769-t-700x468.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"468\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:21:\"Img0769-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:19:\"Img0769-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:21:\"Img0769-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:20:\"Img0769-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:21:\"Img0769-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1352", "1268", "_wp_attached_file", "2012/06/Img0770-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1353", "1268", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"602\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:21:\"2012/06/Img0770-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:21:\"Img0770-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:21:\"Img0770-t-576x385.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"385\";}s:5:\"large\";a:3:{s:4:\"file\";s:21:\"Img0770-t-700x468.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"468\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:21:\"Img0770-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:19:\"Img0770-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:21:\"Img0770-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:20:\"Img0770-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:21:\"Img0770-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1354", "1269", "_wp_attached_file", "2012/06/Img0802-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1355", "1269", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"602\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:21:\"2012/06/Img0802-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:21:\"Img0802-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:21:\"Img0802-t-576x385.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"385\";}s:5:\"large\";a:3:{s:4:\"file\";s:21:\"Img0802-t-700x468.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"468\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:21:\"Img0802-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:19:\"Img0802-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:21:\"Img0802-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:20:\"Img0802-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:21:\"Img0802-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1356", "1270", "_wp_attached_file", "2012/06/Img0818-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1357", "1270", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"602\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:21:\"2012/06/Img0818-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:21:\"Img0818-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:21:\"Img0818-t-576x385.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"385\";}s:5:\"large\";a:3:{s:4:\"file\";s:21:\"Img0818-t-700x468.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"468\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:21:\"Img0818-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:19:\"Img0818-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:21:\"Img0818-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:20:\"Img0818-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:21:\"Img0818-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1358", "1271", "_wp_attached_file", "2012/06/Img0872-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1359", "1271", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"602\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:21:\"2012/06/Img0872-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:21:\"Img0872-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:21:\"Img0872-t-576x385.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"385\";}s:5:\"large\";a:3:{s:4:\"file\";s:21:\"Img0872-t-700x468.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"468\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:21:\"Img0872-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:19:\"Img0872-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:21:\"Img0872-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:20:\"Img0872-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:21:\"Img0872-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1360", "1272", "_wp_attached_file", "2012/06/Img2644-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1361", "1272", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"602\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:21:\"2012/06/Img2644-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:21:\"Img2644-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:21:\"Img2644-t-576x385.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"385\";}s:5:\"large\";a:3:{s:4:\"file\";s:21:\"Img2644-t-700x468.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"468\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:21:\"Img2644-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:19:\"Img2644-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:21:\"Img2644-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:20:\"Img2644-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:21:\"Img2644-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1362", "1273", "_wp_attached_file", "2012/06/Img2649-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1363", "1273", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"602\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:21:\"2012/06/Img2649-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:21:\"Img2649-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:21:\"Img2649-t-576x385.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"385\";}s:5:\"large\";a:3:{s:4:\"file\";s:21:\"Img2649-t-700x468.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"468\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:21:\"Img2649-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:19:\"Img2649-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:21:\"Img2649-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:20:\"Img2649-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:21:\"Img2649-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1364", "1274", "_wp_attached_file", "2012/06/Img2653-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1365", "1274", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"602\";s:6:\"height\";s:3:\"900\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'64\'\";s:4:\"file\";s:21:\"2012/06/Img2653-t.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:21:\"Img2653-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:21:\"Img2653-t-576x861.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"861\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:21:\"Img2653-t-602x300.jpg\";s:5:\"width\";s:3:\"602\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:19:\"Img2653-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:21:\"Img2653-t-602x328.jpg\";s:5:\"width\";s:3:\"602\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:20:\"Img2653-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:21:\"Img2653-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1366", "1275", "_wp_attached_file", "2012/06/Img2680-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1367", "1275", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"602\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:21:\"2012/06/Img2680-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:21:\"Img2680-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:21:\"Img2680-t-576x385.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"385\";}s:5:\"large\";a:3:{s:4:\"file\";s:21:\"Img2680-t-700x468.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"468\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:21:\"Img2680-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:19:\"Img2680-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:21:\"Img2680-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:20:\"Img2680-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:21:\"Img2680-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1368", "1276", "_wp_attached_file", "2012/06/Img2695-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1369", "1276", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"602\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:21:\"2012/06/Img2695-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:21:\"Img2695-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:21:\"Img2695-t-576x385.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"385\";}s:5:\"large\";a:3:{s:4:\"file\";s:21:\"Img2695-t-700x468.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"468\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:21:\"Img2695-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:19:\"Img2695-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:21:\"Img2695-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:20:\"Img2695-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:21:\"Img2695-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1370", "1277", "_wp_attached_file", "2012/06/Img2716-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1371", "1277", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"602\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:21:\"2012/06/Img2716-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:21:\"Img2716-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:21:\"Img2716-t-576x385.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"385\";}s:5:\"large\";a:3:{s:4:\"file\";s:21:\"Img2716-t-700x468.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"468\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:21:\"Img2716-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:19:\"Img2716-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:21:\"Img2716-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:20:\"Img2716-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:21:\"Img2716-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1372", "1278", "_wp_attached_file", "2012/06/IMG_7287-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1373", "1278", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"600\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:22:\"2012/06/IMG_7287-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:22:\"IMG_7287-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:22:\"IMG_7287-t-576x384.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"384\";}s:5:\"large\";a:3:{s:4:\"file\";s:22:\"IMG_7287-t-700x466.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"466\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:22:\"IMG_7287-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:20:\"IMG_7287-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:22:\"IMG_7287-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:21:\"IMG_7287-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:22:\"IMG_7287-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1374", "1279", "_wp_attached_file", "2012/06/IMG_7334-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1375", "1279", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"646\";s:14:\"hwstring_small\";s:23:\"height=\'91\' width=\'128\'\";s:4:\"file\";s:22:\"2012/06/IMG_7334-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:22:\"IMG_7334-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:22:\"IMG_7334-t-576x413.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"413\";}s:5:\"large\";a:3:{s:4:\"file\";s:22:\"IMG_7334-t-700x502.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"502\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:22:\"IMG_7334-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:20:\"IMG_7334-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:22:\"IMG_7334-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:21:\"IMG_7334-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:22:\"IMG_7334-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1376", "1280", "_wp_attached_file", "2012/06/IMG_7405-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1377", "1280", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"600\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:22:\"2012/06/IMG_7405-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:22:\"IMG_7405-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:22:\"IMG_7405-t-576x384.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"384\";}s:5:\"large\";a:3:{s:4:\"file\";s:22:\"IMG_7405-t-700x466.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"466\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:22:\"IMG_7405-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:20:\"IMG_7405-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:22:\"IMG_7405-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:21:\"IMG_7405-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:22:\"IMG_7405-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1378", "1281", "_wp_attached_file", "2012/06/IMG_7445-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1379", "1281", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"600\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:22:\"2012/06/IMG_7445-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:22:\"IMG_7445-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:22:\"IMG_7445-t-576x384.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"384\";}s:5:\"large\";a:3:{s:4:\"file\";s:22:\"IMG_7445-t-700x466.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"466\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:22:\"IMG_7445-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:20:\"IMG_7445-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:22:\"IMG_7445-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:21:\"IMG_7445-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:22:\"IMG_7445-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1380", "1282", "_wp_attached_file", "2012/06/panoramica-2-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1381", "1282", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"599\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:26:\"2012/06/panoramica-2-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:26:\"panoramica-2-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:26:\"panoramica-2-t-576x383.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"383\";}s:5:\"large\";a:3:{s:4:\"file\";s:26:\"panoramica-2-t-700x465.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"465\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:26:\"panoramica-2-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:24:\"panoramica-2-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:26:\"panoramica-2-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:25:\"panoramica-2-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:26:\"panoramica-2-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1382", "1283", "_wp_attached_file", "2012/06/panoramica-3-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1383", "1283", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"598\";s:6:\"height\";s:3:\"900\";s:14:\"hwstring_small\";s:22:\"height=\'96\' width=\'63\'\";s:4:\"file\";s:26:\"2012/06/panoramica-3-t.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:26:\"panoramica-3-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:26:\"panoramica-3-t-576x866.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"866\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:26:\"panoramica-3-t-598x300.jpg\";s:5:\"width\";s:3:\"598\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:24:\"panoramica-3-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:26:\"panoramica-3-t-598x328.jpg\";s:5:\"width\";s:3:\"598\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:25:\"panoramica-3-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:26:\"panoramica-3-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1384", "1284", "_wp_attached_file", "2012/06/panoramica-5-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1385", "1284", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"599\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:26:\"2012/06/panoramica-5-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:26:\"panoramica-5-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:26:\"panoramica-5-t-576x383.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"383\";}s:5:\"large\";a:3:{s:4:\"file\";s:26:\"panoramica-5-t-700x465.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"465\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:26:\"panoramica-5-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:24:\"panoramica-5-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:26:\"panoramica-5-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:25:\"panoramica-5-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:26:\"panoramica-5-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1386", "1285", "_wp_attached_file", "2012/06/panoramica-angolare-4-t.jpg");
INSERT INTO `wp_postmeta` VALUES("1387", "1285", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"599\";s:14:\"hwstring_small\";s:23:\"height=\'85\' width=\'128\'\";s:4:\"file\";s:35:\"2012/06/panoramica-angolare-4-t.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:35:\"panoramica-angolare-4-t-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:35:\"panoramica-angolare-4-t-576x383.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"383\";}s:5:\"large\";a:3:{s:4:\"file\";s:35:\"panoramica-angolare-4-t-700x465.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"465\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:35:\"panoramica-angolare-4-t-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:33:\"panoramica-angolare-4-t-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:35:\"panoramica-angolare-4-t-810x328.jpg\";s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:34:\"panoramica-angolare-4-t-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:35:\"panoramica-angolare-4-t-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1408", "1305", "_wp_attached_file", "2012/06/untitled.png");
INSERT INTO `wp_postmeta` VALUES("1389", "1148", "_wp_old_slug", "centros-comerciales");
INSERT INTO `wp_postmeta` VALUES("1393", "1158", "_wp_old_slug", "centros-comerciales-2");
INSERT INTO `wp_postmeta` VALUES("1409", "1305", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"570\";s:6:\"height\";s:3:\"426\";s:14:\"hwstring_small\";s:23:\"height=\'96\' width=\'128\'\";s:4:\"file\";s:20:\"2012/06/untitled.png\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:20:\"untitled-116x116.png\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:20:\"untitled-570x300.png\";s:5:\"width\";s:3:\"570\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:18:\"untitled-36x36.png\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:20:\"untitled-570x328.png\";s:5:\"width\";s:3:\"570\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:19:\"untitled-196x88.png\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:20:\"untitled-115x115.png\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1410", "1306", "_wp_attached_file", "2012/06/cersaie-santamargherita.jpg");
INSERT INTO `wp_postmeta` VALUES("1411", "1306", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"560\";s:6:\"height\";s:3:\"436\";s:14:\"hwstring_small\";s:23:\"height=\'96\' width=\'123\'\";s:4:\"file\";s:35:\"2012/06/cersaie-santamargherita.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:35:\"cersaie-santamargherita-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:35:\"cersaie-santamargherita-560x300.jpg\";s:5:\"width\";s:3:\"560\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:33:\"cersaie-santamargherita-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:24:\"featured-slideshow-thumb\";a:3:{s:4:\"file\";s:35:\"cersaie-santamargherita-560x328.jpg\";s:5:\"width\";s:3:\"560\";s:6:\"height\";s:3:\"328\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:34:\"cersaie-santamargherita-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:35:\"cersaie-santamargherita-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1415", "1310", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";s:14:\"hwstring_small\";s:23:\"height=\'51\' width=\'128\'\";s:4:\"file\";s:20:\"2012/03/garantia.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:20:\"garantia-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:20:\"garantia-576x233.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"233\";}s:5:\"large\";a:3:{s:4:\"file\";s:20:\"garantia-700x283.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"283\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:20:\"garantia-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:18:\"garantia-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:19:\"garantia-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:20:\"garantia-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1417", "1312", "_wp_attached_file", "2012/03/colores.jpg");
INSERT INTO `wp_postmeta` VALUES("1622", "1481", "_thumbnail_id", "1482");
INSERT INTO `wp_postmeta` VALUES("1624", "1485", "_wp_attached_file", "2014/04/nucleoart.jpg");
INSERT INTO `wp_postmeta` VALUES("1625", "1485", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:196;s:6:\"height\";i:88;s:4:\"file\";s:21:\"2014/04/nucleoart.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"nucleoart-116x88.jpg\";s:5:\"width\";i:116;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"sidebar-thumb\";a:4:{s:4:\"file\";s:19:\"nucleoart-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"node-based-thumb\";a:4:{s:4:\"file\";s:20:\"nucleoart-196x88.jpg\";s:5:\"width\";i:196;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"quick-preview-thumb\";a:4:{s:4:\"file\";s:20:\"nucleoart-115x88.jpg\";s:5:\"width\";i:115;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1576", "1463", "_wp_attached_file", "2014/04/unna1.jpg");
INSERT INTO `wp_postmeta` VALUES("1515", "1434", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1509", "1431", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1510", "1431", "_edit_lock", "1398870128:1");
INSERT INTO `wp_postmeta` VALUES("1511", "1432", "_wp_attached_file", "2014/04/florense.jpg");
INSERT INTO `wp_postmeta` VALUES("1512", "1432", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:196;s:6:\"height\";i:88;s:4:\"file\";s:20:\"2014/04/florense.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"florense-116x88.jpg\";s:5:\"width\";i:116;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"sidebar-thumb\";a:4:{s:4:\"file\";s:18:\"florense-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"node-based-thumb\";a:4:{s:4:\"file\";s:19:\"florense-196x88.jpg\";s:5:\"width\";i:196;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"quick-preview-thumb\";a:4:{s:4:\"file\";s:19:\"florense-115x88.jpg\";s:5:\"width\";i:115;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1475", "1083", "_edit_lock", "1375909364:1");
INSERT INTO `wp_postmeta` VALUES("1476", "1090", "_edit_lock", "1375909372:1");
INSERT INTO `wp_postmeta` VALUES("1478", "1416", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1479", "1416", "_edit_lock", "1398868343:1");
INSERT INTO `wp_postmeta` VALUES("1480", "1417", "_wp_attached_file", "2014/04/bmdiseno.jpg");
INSERT INTO `wp_postmeta` VALUES("1481", "1417", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:196;s:6:\"height\";i:88;s:4:\"file\";s:20:\"2014/04/bmdiseno.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"bmdiseno-116x88.jpg\";s:5:\"width\";i:116;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"sidebar-thumb\";a:4:{s:4:\"file\";s:18:\"bmdiseno-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"node-based-thumb\";a:4:{s:4:\"file\";s:19:\"bmdiseno-196x88.jpg\";s:5:\"width\";i:196;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"quick-preview-thumb\";a:4:{s:4:\"file\";s:19:\"bmdiseno-115x88.jpg\";s:5:\"width\";i:115;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1482", "1416", "_thumbnail_id", "1417");
INSERT INTO `wp_postmeta` VALUES("1485", "1419", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1486", "1419", "_edit_lock", "1398873098:1");
INSERT INTO `wp_postmeta` VALUES("1487", "1420", "_wp_attached_file", "2014/04/aei.jpg");
INSERT INTO `wp_postmeta` VALUES("1488", "1420", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:196;s:6:\"height\";i:88;s:4:\"file\";s:15:\"2014/04/aei.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:14:\"aei-116x88.jpg\";s:5:\"width\";i:116;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"sidebar-thumb\";a:4:{s:4:\"file\";s:13:\"aei-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"node-based-thumb\";a:4:{s:4:\"file\";s:14:\"aei-196x88.jpg\";s:5:\"width\";i:196;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"quick-preview-thumb\";a:4:{s:4:\"file\";s:14:\"aei-115x88.jpg\";s:5:\"width\";i:115;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1636", "1490", "_menu_item_type", "taxonomy");
INSERT INTO `wp_postmeta` VALUES("1637", "1490", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("1638", "1490", "_menu_item_object_id", "8");
INSERT INTO `wp_postmeta` VALUES("1639", "1490", "_menu_item_object", "category");
INSERT INTO `wp_postmeta` VALUES("1640", "1490", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("1641", "1490", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1642", "1490", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("1643", "1490", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("1470", "1406", "_wp_attached_file", "2012/06/partners1.jpg");
INSERT INTO `wp_postmeta` VALUES("1471", "1406", "_wp_attachment_metadata", "a:6:{s:5:\"width\";s:3:\"810\";s:6:\"height\";s:3:\"328\";s:14:\"hwstring_small\";s:23:\"height=\'51\' width=\'128\'\";s:4:\"file\";s:21:\"2012/06/partners1.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:4:\"file\";s:21:\"partners1-116x116.jpg\";s:5:\"width\";s:3:\"116\";s:6:\"height\";s:3:\"116\";}s:6:\"medium\";a:3:{s:4:\"file\";s:21:\"partners1-576x233.jpg\";s:5:\"width\";s:3:\"576\";s:6:\"height\";s:3:\"233\";}s:5:\"large\";a:3:{s:4:\"file\";s:21:\"partners1-700x283.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"283\";}s:12:\"single-thumb\";a:3:{s:4:\"file\";s:21:\"partners1-700x300.jpg\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"300\";}s:13:\"sidebar-thumb\";a:3:{s:4:\"file\";s:19:\"partners1-36x36.jpg\";s:5:\"width\";s:2:\"36\";s:6:\"height\";s:2:\"36\";}s:16:\"node-based-thumb\";a:3:{s:4:\"file\";s:20:\"partners1-196x88.jpg\";s:5:\"width\";s:3:\"196\";s:6:\"height\";s:2:\"88\";}s:19:\"quick-preview-thumb\";a:3:{s:4:\"file\";s:21:\"partners1-115x115.jpg\";s:5:\"width\";s:3:\"115\";s:6:\"height\";s:3:\"115\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1626", "1484", "_thumbnail_id", "1485");
INSERT INTO `wp_postmeta` VALUES("1627", "1484", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1628", "1484", "_edit_lock", "1398873547:1");
INSERT INTO `wp_postmeta` VALUES("1630", "1488", "_wp_attached_file", "2014/04/dproject.jpg");
INSERT INTO `wp_postmeta` VALUES("1631", "1488", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:196;s:6:\"height\";i:88;s:4:\"file\";s:20:\"2014/04/dproject.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"dproject-116x88.jpg\";s:5:\"width\";i:116;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"sidebar-thumb\";a:4:{s:4:\"file\";s:18:\"dproject-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"node-based-thumb\";a:4:{s:4:\"file\";s:19:\"dproject-196x88.jpg\";s:5:\"width\";i:196;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"quick-preview-thumb\";a:4:{s:4:\"file\";s:19:\"dproject-115x88.jpg\";s:5:\"width\";i:115;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1559", "1455", "_wp_attached_file", "2014/04/topkitchen1.jpg");
INSERT INTO `wp_postmeta` VALUES("1523", "1438", "_wp_attached_file", "2014/04/rojoynegro.jpg");
INSERT INTO `wp_postmeta` VALUES("1521", "1437", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1522", "1437", "_edit_lock", "1398870303:1");
INSERT INTO `wp_postmeta` VALUES("1524", "1438", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:196;s:6:\"height\";i:88;s:4:\"file\";s:22:\"2014/04/rojoynegro.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"rojoynegro-116x88.jpg\";s:5:\"width\";i:116;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"sidebar-thumb\";a:4:{s:4:\"file\";s:20:\"rojoynegro-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"node-based-thumb\";a:4:{s:4:\"file\";s:21:\"rojoynegro-196x88.jpg\";s:5:\"width\";i:196;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"quick-preview-thumb\";a:4:{s:4:\"file\";s:21:\"rojoynegro-115x88.jpg\";s:5:\"width\";i:115;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1525", "1437", "_thumbnail_id", "1438");
INSERT INTO `wp_postmeta` VALUES("1527", "1440", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1528", "1440", "_edit_lock", "1398870384:1");
INSERT INTO `wp_postmeta` VALUES("1529", "1441", "_wp_attached_file", "2014/04/kitchenhome.jpg");
INSERT INTO `wp_postmeta` VALUES("1530", "1441", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:196;s:6:\"height\";i:88;s:4:\"file\";s:23:\"2014/04/kitchenhome.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"kitchenhome-116x88.jpg\";s:5:\"width\";i:116;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"sidebar-thumb\";a:4:{s:4:\"file\";s:21:\"kitchenhome-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"node-based-thumb\";a:4:{s:4:\"file\";s:22:\"kitchenhome-196x88.jpg\";s:5:\"width\";i:196;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"quick-preview-thumb\";a:4:{s:4:\"file\";s:22:\"kitchenhome-115x88.jpg\";s:5:\"width\";i:115;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1531", "1440", "_thumbnail_id", "1441");
INSERT INTO `wp_postmeta` VALUES("1632", "1487", "_thumbnail_id", "1488");
INSERT INTO `wp_postmeta` VALUES("1633", "1487", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1634", "1487", "_edit_lock", "1398873643:1");
INSERT INTO `wp_postmeta` VALUES("1555", "1454", "_wp_attached_file", "2014/04/houseco1.jpg");
INSERT INTO `wp_postmeta` VALUES("1536", "1443", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1539", "1447", "_wp_attached_file", "2014/04/kitchencenter.jpg");
INSERT INTO `wp_postmeta` VALUES("1538", "1443", "_edit_lock", "1398871379:1");
INSERT INTO `wp_postmeta` VALUES("1540", "1447", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:196;s:6:\"height\";i:88;s:4:\"file\";s:25:\"2014/04/kitchencenter.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"kitchencenter-116x88.jpg\";s:5:\"width\";i:116;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"sidebar-thumb\";a:4:{s:4:\"file\";s:23:\"kitchencenter-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"node-based-thumb\";a:4:{s:4:\"file\";s:24:\"kitchencenter-196x88.jpg\";s:5:\"width\";i:196;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"quick-preview-thumb\";a:4:{s:4:\"file\";s:24:\"kitchencenter-115x88.jpg\";s:5:\"width\";i:115;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1541", "1446", "_thumbnail_id", "1447");
INSERT INTO `wp_postmeta` VALUES("1542", "1446", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1545", "1449", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1544", "1446", "_edit_lock", "1398870562:1");
INSERT INTO `wp_postmeta` VALUES("1546", "1449", "_edit_lock", "1398871287:1");
INSERT INTO `wp_postmeta` VALUES("1551", "1453", "_wp_attached_file", "2014/04/oppein2.jpg");
INSERT INTO `wp_postmeta` VALUES("1552", "1453", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:196;s:6:\"height\";i:88;s:4:\"file\";s:19:\"2014/04/oppein2.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"oppein2-116x88.jpg\";s:5:\"width\";i:116;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"sidebar-thumb\";a:4:{s:4:\"file\";s:17:\"oppein2-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"node-based-thumb\";a:4:{s:4:\"file\";s:18:\"oppein2-196x88.jpg\";s:5:\"width\";i:196;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"quick-preview-thumb\";a:4:{s:4:\"file\";s:18:\"oppein2-115x88.jpg\";s:5:\"width\";i:115;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1553", "1449", "_thumbnail_id", "1453");
INSERT INTO `wp_postmeta` VALUES("1556", "1454", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:196;s:6:\"height\";i:88;s:4:\"file\";s:20:\"2014/04/houseco1.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"houseco1-116x88.jpg\";s:5:\"width\";i:116;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"sidebar-thumb\";a:4:{s:4:\"file\";s:18:\"houseco1-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"node-based-thumb\";a:4:{s:4:\"file\";s:19:\"houseco1-196x88.jpg\";s:5:\"width\";i:196;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"quick-preview-thumb\";a:4:{s:4:\"file\";s:19:\"houseco1-115x88.jpg\";s:5:\"width\";i:115;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1557", "1443", "_thumbnail_id", "1454");
INSERT INTO `wp_postmeta` VALUES("1560", "1455", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:196;s:6:\"height\";i:88;s:4:\"file\";s:23:\"2014/04/topkitchen1.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"topkitchen1-116x88.jpg\";s:5:\"width\";i:116;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"sidebar-thumb\";a:4:{s:4:\"file\";s:21:\"topkitchen1-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"node-based-thumb\";a:4:{s:4:\"file\";s:22:\"topkitchen1-196x88.jpg\";s:5:\"width\";i:196;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"quick-preview-thumb\";a:4:{s:4:\"file\";s:22:\"topkitchen1-115x88.jpg\";s:5:\"width\";i:115;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1561", "1434", "_thumbnail_id", "1455");
INSERT INTO `wp_postmeta` VALUES("1563", "1456", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1564", "1456", "_edit_lock", "1398871533:1");
INSERT INTO `wp_postmeta` VALUES("1565", "1457", "_wp_attached_file", "2014/04/casakit.jpg");
INSERT INTO `wp_postmeta` VALUES("1566", "1457", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:196;s:6:\"height\";i:88;s:4:\"file\";s:19:\"2014/04/casakit.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"casakit-116x88.jpg\";s:5:\"width\";i:116;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"sidebar-thumb\";a:4:{s:4:\"file\";s:17:\"casakit-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"node-based-thumb\";a:4:{s:4:\"file\";s:18:\"casakit-196x88.jpg\";s:5:\"width\";i:196;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"quick-preview-thumb\";a:4:{s:4:\"file\";s:18:\"casakit-115x88.jpg\";s:5:\"width\";i:115;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1567", "1456", "_thumbnail_id", "1457");
INSERT INTO `wp_postmeta` VALUES("1569", "1459", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1570", "1459", "_edit_lock", "1398872289:1");
INSERT INTO `wp_postmeta` VALUES("1571", "1460", "_wp_attached_file", "2014/04/madestone.jpg");
INSERT INTO `wp_postmeta` VALUES("1572", "1460", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:196;s:6:\"height\";i:88;s:4:\"file\";s:21:\"2014/04/madestone.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"madestone-116x88.jpg\";s:5:\"width\";i:116;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"sidebar-thumb\";a:4:{s:4:\"file\";s:19:\"madestone-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"node-based-thumb\";a:4:{s:4:\"file\";s:20:\"madestone-196x88.jpg\";s:5:\"width\";i:196;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"quick-preview-thumb\";a:4:{s:4:\"file\";s:20:\"madestone-115x88.jpg\";s:5:\"width\";i:115;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1573", "1459", "_thumbnail_id", "1460");
INSERT INTO `wp_postmeta` VALUES("1577", "1463", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:196;s:6:\"height\";i:88;s:4:\"file\";s:17:\"2014/04/unna1.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"unna1-116x88.jpg\";s:5:\"width\";i:116;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"sidebar-thumb\";a:4:{s:4:\"file\";s:15:\"unna1-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"node-based-thumb\";a:4:{s:4:\"file\";s:16:\"unna1-196x88.jpg\";s:5:\"width\";i:196;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"quick-preview-thumb\";a:4:{s:4:\"file\";s:16:\"unna1-115x88.jpg\";s:5:\"width\";i:115;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1580", "1464", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1581", "1464", "_edit_lock", "1398872551:1");
INSERT INTO `wp_postmeta` VALUES("1582", "1465", "_wp_attached_file", "2014/04/espaciodinamico.jpg");
INSERT INTO `wp_postmeta` VALUES("1583", "1465", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:196;s:6:\"height\";i:88;s:4:\"file\";s:27:\"2014/04/espaciodinamico.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"espaciodinamico-116x88.jpg\";s:5:\"width\";i:116;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"sidebar-thumb\";a:4:{s:4:\"file\";s:25:\"espaciodinamico-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"node-based-thumb\";a:4:{s:4:\"file\";s:26:\"espaciodinamico-196x88.jpg\";s:5:\"width\";i:196;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"quick-preview-thumb\";a:4:{s:4:\"file\";s:26:\"espaciodinamico-115x88.jpg\";s:5:\"width\";i:115;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1584", "1464", "_thumbnail_id", "1465");
INSERT INTO `wp_postmeta` VALUES("1586", "1467", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1587", "1467", "_edit_lock", "1398872693:1");
INSERT INTO `wp_postmeta` VALUES("1588", "1468", "_wp_attached_file", "2014/04/mobilinares.jpg");
INSERT INTO `wp_postmeta` VALUES("1589", "1468", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:196;s:6:\"height\";i:88;s:4:\"file\";s:23:\"2014/04/mobilinares.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"mobilinares-116x88.jpg\";s:5:\"width\";i:116;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"sidebar-thumb\";a:4:{s:4:\"file\";s:21:\"mobilinares-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"node-based-thumb\";a:4:{s:4:\"file\";s:22:\"mobilinares-196x88.jpg\";s:5:\"width\";i:196;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"quick-preview-thumb\";a:4:{s:4:\"file\";s:22:\"mobilinares-115x88.jpg\";s:5:\"width\";i:115;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1590", "1467", "_thumbnail_id", "1468");
INSERT INTO `wp_postmeta` VALUES("1594", "1471", "_wp_attached_file", "2014/04/staubmuebles.jpg");
INSERT INTO `wp_postmeta` VALUES("1595", "1471", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:196;s:6:\"height\";i:88;s:4:\"file\";s:24:\"2014/04/staubmuebles.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"staubmuebles-116x88.jpg\";s:5:\"width\";i:116;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"sidebar-thumb\";a:4:{s:4:\"file\";s:22:\"staubmuebles-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"node-based-thumb\";a:4:{s:4:\"file\";s:23:\"staubmuebles-196x88.jpg\";s:5:\"width\";i:196;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"quick-preview-thumb\";a:4:{s:4:\"file\";s:23:\"staubmuebles-115x88.jpg\";s:5:\"width\";i:115;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1598", "1473", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1599", "1473", "_edit_lock", "1398872977:1");
INSERT INTO `wp_postmeta` VALUES("1600", "1474", "_wp_attached_file", "2014/04/disypro.jpg");
INSERT INTO `wp_postmeta` VALUES("1601", "1474", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:196;s:6:\"height\";i:88;s:4:\"file\";s:19:\"2014/04/disypro.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"disypro-116x88.jpg\";s:5:\"width\";i:116;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"sidebar-thumb\";a:4:{s:4:\"file\";s:17:\"disypro-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"node-based-thumb\";a:4:{s:4:\"file\";s:18:\"disypro-196x88.jpg\";s:5:\"width\";i:196;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"quick-preview-thumb\";a:4:{s:4:\"file\";s:18:\"disypro-115x88.jpg\";s:5:\"width\";i:115;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1602", "1473", "_thumbnail_id", "1474");
INSERT INTO `wp_postmeta` VALUES("1604", "1476", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1605", "1476", "_edit_lock", "1398873035:1");
INSERT INTO `wp_postmeta` VALUES("1606", "1477", "_wp_attached_file", "2014/04/todoforma.jpg");
INSERT INTO `wp_postmeta` VALUES("1607", "1477", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:196;s:6:\"height\";i:88;s:4:\"file\";s:21:\"2014/04/todoforma.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"todoforma-116x88.jpg\";s:5:\"width\";i:116;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"sidebar-thumb\";a:4:{s:4:\"file\";s:19:\"todoforma-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"node-based-thumb\";a:4:{s:4:\"file\";s:20:\"todoforma-196x88.jpg\";s:5:\"width\";i:196;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"quick-preview-thumb\";a:4:{s:4:\"file\";s:20:\"todoforma-115x88.jpg\";s:5:\"width\";i:115;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1608", "1476", "_thumbnail_id", "1477");
INSERT INTO `wp_postmeta` VALUES("1611", "1479", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:196;s:6:\"height\";i:88;s:4:\"file\";s:16:\"2014/04/aei1.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"aei1-116x88.jpg\";s:5:\"width\";i:116;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"sidebar-thumb\";a:4:{s:4:\"file\";s:14:\"aei1-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"node-based-thumb\";a:4:{s:4:\"file\";s:15:\"aei1-196x88.jpg\";s:5:\"width\";i:196;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"quick-preview-thumb\";a:4:{s:4:\"file\";s:15:\"aei1-115x88.jpg\";s:5:\"width\";i:115;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1612", "1419", "_thumbnail_id", "1479");
INSERT INTO `wp_postmeta` VALUES("1615", "1480", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:196;s:6:\"height\";i:88;s:4:\"file\";s:18:\"2014/04/mobel1.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"mobel1-116x88.jpg\";s:5:\"width\";i:116;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"sidebar-thumb\";a:4:{s:4:\"file\";s:16:\"mobel1-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"node-based-thumb\";a:4:{s:4:\"file\";s:17:\"mobel1-196x88.jpg\";s:5:\"width\";i:196;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"quick-preview-thumb\";a:4:{s:4:\"file\";s:17:\"mobel1-115x88.jpg\";s:5:\"width\";i:115;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1616", "1422", "_thumbnail_id", "1480");

/* INSERT TABLE DATA: wp_posts */
INSERT INTO `wp_posts` VALUES("560", "1", "2012-06-06 13:52:12", "2012-06-06 17:52:12", "<img class=\"alignnone size-full wp-image-910\" title=\"Garantía &amp; Calidad\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/oficina.jpg\" alt=\"\" width=\"810\" height=\"328\" />\n<h3>GARANTÍA &amp; CALIDAD</h3>\nSANTAMARGHERITA encierra sus valores en una única expresión <em>“The original italian surface”</em>.\n\n<em>The Original</em> - La investigación constante, tanto tecnológica como estilística permite, desde hace más de cuarenta años, presentar al mercado un producto original en una gama de colores y acabados exclusivos.\n\n<em>Italian</em> – Garantía de calidad y fiabilidad, asistencia constante y competencia son sólo algunas de las características principales que hacen que los productos “Made in Italy” sean los primeros en el mundo por lo que respecta a diseño y arquitectura. SANTAMARGHERITA mantiene estos valores y los traduce en productos únicos e inimitables.\n\n<em>Surface</em> - Superﬁcies con base de mármol y de cuarzo, en esto se basa actualmente el know how de una empresa que no se detiene y mira hacia el futuro para desarrollarse cada vez más con la finalidad de brindar al cliente las más variadas posibilidades para revestir y decorar espacios habitacionales y grandes obras.", "Garantía &amp; calidad", "Santamargherita encierra sus valores en una única expresión “The original italian surface”.", "inherit", "open", "open", "", "372-autosave", "", "", "2012-06-06 13:52:12", "2012-06-06 17:52:12", "", "372", "http://s-m.cl/372-autosave/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("728", "1", "2012-04-26 09:51:48", "2012-04-26 13:51:48", "<a href=\"http://s-m.cl/wp-content/uploads/2012/03/calidad.jpg\"><img class=\"alignnone size-full wp-image-635\" title=\"calidad\" src=\"http://s-m.cl/wp-content/uploads/2012/03/calidad.jpg\" alt=\"Garantía &amp; calidad\" width=\"576\" height=\"200\" /></a>\r\n\r\n<strong>Garantía</strong>\r\n\r\nTecnocom ha desarrollado un compuesto de PVC bajo las mas estrictas normas de calidad. Es por esto que el los perfiles de color blanco cuentan con una garantía de 7 años. Para los perfiles de color, Tecnocom trabaja con la firma Alemana SKAI, la cual da una garantía de 5 años sobre el folio. Infórmese sobre las condiciones y alcances de la garantía.\r\n\r\n<strong>Calidad</strong>\r\n\r\nUn proceso de calidad contínuo es sinónimo de una marca líder. Desde la fabricación del compuesto hasta la extrusión y foliado del perfil. Tecnocom cuenta con un departamento de calidad para asegurar la entrega de un producto de clase mundial.\r\n\r\nDos laboratorios, uno de compuestos de PVC otro de Perfiles de PVC, colaboran continuamente en verificar los estándares de trabajo.", "Garantía &amp; calidad", "Un proceso de calidad contínuo es sinónimo de una marca líder.", "inherit", "open", "open", "", "372-revision-9", "", "", "2012-04-26 09:51:48", "2012-04-26 13:51:48", "", "372", "http://santamargherita.s-m.cl/372-revision-9/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("727", "1", "2012-05-24 13:18:58", "2012-05-24 17:18:58", "", "santamargherita", "", "inherit", "open", "open", "", "santamargherita-2", "", "", "2012-05-24 13:18:58", "2012-05-24 17:18:58", "", "0", "http://santamargherita.s-m.cl/wp-content/uploads/2012/05/santamargherita1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("729", "1", "2012-05-24 15:14:39", "2012-05-24 19:14:39", "<a href=\"http://s-m.cl/wp-content/uploads/2012/03/calidad.jpg\"><img class=\"alignnone size-full wp-image-635\" title=\"calidad\" src=\"http://s-m.cl/wp-content/uploads/2012/03/calidad.jpg\" alt=\"Garantía &amp; calidad\" width=\"576\" height=\"200\" /></a>\r\n\r\nSANTAMARGHERITA encierra sus valores en una única expresión “THE ORIGINAL ITALIAN SURFACE”.\r\n\r\nTHE ORIGINAL - La investigación constante, tanto tecnológica como estilística permite, desde hace más de cuarenta años, presentar al mercado un producto original en una gama de colores y acabados exclusivos.\r\n\r\nITALIAN – Garantía de calidad y fiabilidad, asistencia constante y competencia son sólo algunas de las características principales que hacen que los productos “Made in Italy” sean los primeros en el mundo por lo que respecta a diseño y arquitectura. SANTAMARGHERITA mantiene estos valores y los traduce en productos únicos e inimitables.\r\n\r\nSURFACE - Superﬁcies con base de mármol y de cuarzo, en esto se basa actualmente el know how de una empresa que no se detiene y mira hacia el futuro para desarrollarse cada vez más con la finalidad de brindar al cliente las más variadas posibilidades para revestir y decorar espacios habitacionales y grandes obras.", "Garantía &amp; calidad", "Un proceso de calidad contínuo es sinónimo de una marca líder.", "inherit", "open", "open", "", "372-revision-10", "", "", "2012-05-24 15:14:39", "2012-05-24 19:14:39", "", "372", "http://santamargherita.s-m.cl/372-revision-10/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("730", "1", "2012-05-24 15:15:19", "2012-05-24 19:15:19", "<a href=\"http://s-m.cl/wp-content/uploads/2012/03/calidad.jpg\"><img class=\"alignnone size-full wp-image-635\" title=\"calidad\" src=\"http://s-m.cl/wp-content/uploads/2012/03/calidad.jpg\" alt=\"Garantía &amp; calidad\" width=\"576\" height=\"200\" /></a>\r\n\r\nSANTAMARGHERITA encierra sus valores en una única expresión\r\n“THE ORIGINAL ITALIAN SURFACE”.\r\n\r\nTHE ORIGINAL - La investigación constante, tanto tecnológica como estilística permite, desde hace más de cuarenta años, presentar al mercado un producto original en una gama de colores y acabados exclusivos.\r\n\r\nITALIAN – Garantía de calidad y fiabilidad, asistencia constante y competencia son sólo algunas de las características principales que hacen que los productos “Made in Italy” sean los primeros en el mundo por lo que respecta a diseño y arquitectura. SANTAMARGHERITA mantiene estos valores y los traduce en productos únicos e inimitables.\r\n\r\nSURFACE - Superﬁcies con base de mármol y de cuarzo, en esto se basa actualmente el know how de una empresa que no se detiene y mira hacia el futuro para desarrollarse cada vez más con la finalidad de brindar al cliente las más variadas posibilidades para revestir y decorar espacios habitacionales y grandes obras.", "Garantía &amp; calidad", "Un proceso de calidad contínuo es sinónimo de una marca líder.", "inherit", "open", "open", "", "372-revision-11", "", "", "2012-05-24 15:15:19", "2012-05-24 19:15:19", "", "372", "http://santamargherita.s-m.cl/372-revision-11/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("884", "1", "2012-05-28 15:24:22", "2012-05-28 19:24:22", "<img class=\"alignnone size-full wp-image-799\" title=\"Mantenimiento\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/mantenimiento2.jpg\" alt=\"\" width=\"810\" height=\"328\" />\r\n<h3>MANTENIMIENTO</h3>\r\nLa composición especial, 93% de minerales naturales y 7% de resina de poliéster y pigmentos colorados, da al producto las variaciones de color, medida, forma o distribución de la gravilla de cuarzo y un color de fondo que hacen que sea exclusivo y único, manteniendo inalteradas las características técnicas. Las superficies no necesitan ser tratadas con ceras y, con la finalidad de mantener el estado de limpieza adecuado, se recomienda utilizar productos detergentes con base de alcohol y pH neutro, como por ejemplo productos para la limpieza de superficies de mármol (advertencia: no deben contener ceras).\r\n\r\nNo utilizar productos detergentes demasiado agresivos (pH muy alto o muy bajo). Se recomienda encarecidamente usar soportes para ollas o similares para evitar el contacto directo entre las superficies SANTAMARGHERITA y las fuentes de calor (ollas, paellas o platos quitandose del fuego). Para las encimeras con inserciones de nácar es necesario utilizar un producto detergente neutro de uso doméstico.\r\n\r\nSUSTANCIAS QUÍMICAS Y DISOLVENTES – Debe evitarse en lo posible el contacto entre las superficies y las sustancias químicas y disolventes, como por ejemplo amoniaco puro o productos detergentes a base de amoniaco, disolventes para uñas, blanqueantes, pinceles con tinta indeleble, jabones aceitosos, disolventes en general (especialmente los disolventes para las pinturas que contienen tricloroetileno y cloruro de metileno), etc.\r\n\r\nEn caso de contacto entre las sustancias antes indicadas y las superficies SANTAMARGHERITA aclarar abundantemente de inmediato.", "Mantenimiento", "Condiciones de mantenimiento.", "inherit", "open", "open", "", "407-revision-10", "", "", "2012-05-28 15:24:22", "2012-05-28 19:24:22", "", "407", "http://santamargherita.s-m.cl/407-revision-10/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("733", "1", "2012-05-24 15:16:02", "2012-05-24 19:16:02", "<a href=\"http://s-m.cl/wp-content/uploads/2012/03/calidad.jpg\"><img class=\"alignnone size-full wp-image-635\" title=\"calidad\" src=\"http://s-m.cl/wp-content/uploads/2012/03/calidad.jpg\" alt=\"Garantía &amp; calidad\" width=\"576\" height=\"200\" /></a>\r\n\r\nSANTAMARGHERITA encierra sus valores en una única expresión\r\n“THE ORIGINAL ITALIAN SURFACE”.\r\n\r\nTHE ORIGINAL - La investigación constante, tanto tecnológica como estilística permite, desde hace más de cuarenta años, presentar al mercado un producto original en una gama de colores y acabados exclusivos.\r\n\r\nITALIAN – Garantía de calidad y fiabilidad, asistencia constante y competencia son sólo algunas de las características principales que hacen que los productos “Made in Italy” sean los primeros en el mundo por lo que respecta a diseño y arquitectura. SANTAMARGHERITA mantiene estos valores y los traduce en productos únicos e inimitables.\r\n\r\nSURFACE - Superﬁcies con base de mármol y de cuarzo, en esto se basa actualmente el know how de una empresa que no se detiene y mira hacia el futuro para desarrollarse cada vez más con la finalidad de brindar al cliente las más variadas posibilidades para revestir y decorar espacios habitacionales y grandes obras.", "Garantía &amp; calidad", "Santamargherita encierra sus valores en una única expresión “The original italian surface”.", "inherit", "open", "open", "", "372-revision-12", "", "", "2012-05-24 15:16:02", "2012-05-24 19:16:02", "", "372", "http://santamargherita.s-m.cl/372-revision-12/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("794", "1", "2012-05-28 15:16:32", "2012-05-28 19:16:32", "", "Colores", "", "inherit", "open", "open", "", "colores2", "", "", "2012-05-28 15:16:32", "2012-05-28 19:16:32", "", "379", "http://santamargherita.s-m.cl/wp-content/uploads/2012/03/colores2.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("803", "1", "2012-05-28 15:19:31", "2012-05-28 19:19:31", "<img class=\"alignnone size-full wp-image-796\" title=\"Aplicaciones Baño\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/aplicaciones2.jpg\" alt=\"\" width=\"810\" height=\"328\" />\r\n<h3>APLICACIONES</h3>\r\n<strong><em>Aglomerado de Cuarzo para encimeras de Cocina y Baño</em></strong>\r\n\r\nCada casa refleja la personalidad de quienes viven en ella. Caracteres, gustos y estilos que pueden llegar a ser infinitos, opuestos entre ellos; desde el neoclásico hasta el barroco, desde la ostentación hasta el minimalismo, con el uso de una paleta de colores desde las tonalidades más claras hasta las más fuertes.<strong><em></em></strong>\r\n\r\nSANTAMARGHERITA, a través de una investigación constante, crea superficies con altas prestaciones técnicas y que son estéticamente capaces de hacer que los ambientes domésticos sean únicos satisfaciendo perfectamente las diferentes exigencias.\r\n\r\nEl material ideal para pavimentos y revestimientos, cabinas de ducha y encimeras de cocina y baño se caracteriza, por un lado, por la alta resistencia a la flexión, abrasión y ácidos, y por el otro, por la variedad de colores y texturas más neutras o con mayor profundidad y efectos de movimiento.\r\n\r\nActualmente en el diseño de interiores está marcado el uso de tamaño cada vez más grandes y personalizados, por tanto las colecciones de aglomerado con base de cuarzo SANTAMARGHERITA se proponen en baldosas de dimensiones estándares o variables. Para cada proyecto, para cada exigencia, para cada gusto, SANTAMARGHERITA dispone de la superficie ideal.\r\n\r\n&nbsp;\r\n\r\n<a name=\"aeropuerto\"></a><a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/aeropuerto.jpg\"><img class=\"alignnone size-full wp-image-742\" title=\"Aeropuerto\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/aeropuerto.jpg\" alt=\"\" width=\"576\" height=\"200\" /></a>\r\n\r\n<strong><em>Aglomerado de Cuarzo para superficies de grandes obras</em></strong>\r\n\r\nAeropuertos, estaciones de trenes, centros comerciales, grandes superficies en todo el mundo ostentan actualmente pavimentos y revestimientos con la marca SANTAMARGHERITA. Las potencialidades del aglomerado de cuarzo permiten que SANTAMARGHERITA responda a las exigencias en lo que se refiere a complejidad y personalidad de cada proyecto, a partir del suministro de grandes volúmenes hasta un servicio de investigación y desarrollo de nuevos colores personalizados que dan originalidad y unicidad al producto.\r\n\r\n&nbsp;", "Aplicaciones", "Cada casa refleja la personalidad de quienes viven en ella.", "inherit", "open", "open", "", "386-revision-10", "", "", "2012-05-28 15:19:31", "2012-05-28 19:19:31", "", "386", "http://santamargherita.s-m.cl/386-revision-10/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("739", "1", "2012-06-11 17:30:37", "2012-06-11 21:30:37", "<img class=\"alignnone size-full wp-image-796\" title=\"Aplicaciones Baño\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/aplicaciones2.jpg\" alt=\"\" width=\"810\" height=\"328\" />\n<h3>APLICACIONES</h3>\n<strong><em>Aglomerado de Cuarzo para encimeras de Cocina y Baño</em></strong>\n\nCada casa refleja la personalidad de quienes viven en ella. Caracteres, gustos y estilos que pueden llegar a ser infinitos, opuestos entre ellos; desde el neoclásico hasta el barroco, desde la ostentación hasta el minimalismo, con el uso de una paleta de colores desde las tonalidades más claras hasta las más fuertes.<strong><em></em></strong>\n\nSANTAMARGHERITA, a través de una investigación constante, crea superficies con altas prestaciones técnicas y que son estéticamente capaces de hacer que los ambientes domésticos sean únicos satisfaciendo perfectamente las diferentes exigencias.\n\nEl material ideal para pavimentos y revestimientos, cabinas de ducha y encimeras de cocina y baño se caracteriza, por un lado, por la alta resistencia a la flexión, abrasión y ácidos, y por el otro, por la variedad de colores y texturas más neutras o con mayor profundidad y efectos de movimiento.\n\nActualmente en el diseño de interiores está marcado el uso de tamaño cada vez más grandes y personalizados, por tanto las colecciones de aglomerado con base de cuarzo SANTAMARGHERITA se proponen en baldosas de dimensiones estándares o variables. Para cada proyecto, para cada exigencia, para cada gusto, SANTAMARGHERITA dispone de la superficie ideal.\n\n<strong><em>Aglomerado de Cuarzo para superficies de grandes obras</em></strong>\n\nAeropuertos, estaciones de trenes, centros comerciales, grandes superficies en todo el mundo ostentan actualmente pavimentos y revestimientos con la marca SANTAMARGHERITA. Las potencialidades del aglomerado de cuarzo permiten que SANTAMARGHERITA responda a las exigencias en lo que se refiere a complejidad y personalidad de cada proyecto, a partir del suministro de grandes volúmenes hasta un servicio de investigación y desarrollo de nuevos colores personalizados que dan originalidad y unicidad al producto.\n\n<a title=\"Obras\" href=\"http://santamargherita.s-m.cl/obras/\">Ver Obras →</a>", "Aplicaciones", "Cada casa refleja la personalidad de quienes viven en ella.", "inherit", "open", "open", "", "386-autosave", "", "", "2012-06-11 17:30:37", "2012-06-11 21:30:37", "", "386", "http://santamargherita.s-m.cl/386-autosave/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1021", "1", "2012-05-28 15:30:44", "2012-05-28 19:30:44", "<img class=\"alignnone size-full wp-image-796\" title=\"Aplicaciones Baño\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/aplicaciones2.jpg\" alt=\"\" width=\"810\" height=\"328\" />\r\n<h3>APLICACIONES</h3>\r\n<strong><em>Aglomerado de Cuarzo para encimeras de Cocina y Baño</em></strong>\r\n\r\nCada casa refleja la personalidad de quienes viven en ella. Caracteres, gustos y estilos que pueden llegar a ser infinitos, opuestos entre ellos; desde el neoclásico hasta el barroco, desde la ostentación hasta el minimalismo, con el uso de una paleta de colores desde las tonalidades más claras hasta las más fuertes.<strong><em></em></strong>\r\n\r\nSANTAMARGHERITA, a través de una investigación constante, crea superficies con altas prestaciones técnicas y que son estéticamente capaces de hacer que los ambientes domésticos sean únicos satisfaciendo perfectamente las diferentes exigencias.\r\n\r\nEl material ideal para pavimentos y revestimientos, cabinas de ducha y encimeras de cocina y baño se caracteriza, por un lado, por la alta resistencia a la flexión, abrasión y ácidos, y por el otro, por la variedad de colores y texturas más neutras o con mayor profundidad y efectos de movimiento.\r\n\r\nActualmente en el diseño de interiores está marcado el uso de tamaño cada vez más grandes y personalizados, por tanto las colecciones de aglomerado con base de cuarzo SANTAMARGHERITA se proponen en baldosas de dimensiones estándares o variables. Para cada proyecto, para cada exigencia, para cada gusto, SANTAMARGHERITA dispone de la superficie ideal.\r\n\r\n<strong><em>Aglomerado de Cuarzo para superficies de grandes obras</em></strong>\r\n\r\nAeropuertos, estaciones de trenes, centros comerciales, grandes superficies en todo el mundo ostentan actualmente pavimentos y revestimientos con la marca SANTAMARGHERITA. Las potencialidades del aglomerado de cuarzo permiten que SANTAMARGHERITA responda a las exigencias en lo que se refiere a complejidad y personalidad de cada proyecto, a partir del suministro de grandes volúmenes hasta un servicio de investigación y desarrollo de nuevos colores personalizados que dan originalidad y unicidad al producto.\r\n\r\n&nbsp;", "Aplicaciones", "Cada casa refleja la personalidad de quienes viven en ella.", "inherit", "closed", "closed", "", "386-revision-11", "", "", "2012-05-28 15:30:44", "2012-05-28 19:30:44", "", "386", "http://santamargherita.s-m.cl/386-revision-11/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("740", "1", "2012-04-19 15:34:12", "2012-04-19 19:34:12", "<img class=\"alignnone size-full wp-image-565\" title=\"certificaciones_OK\" src=\"http://s-m.cl/wp-content/uploads/2012/03/certificaciones_OK.jpg\" alt=\"\" width=\"576\" height=\"200\" />\r\n\r\nEl sistema de gestión de calidad para la fabricación de compuestos y masterbatch de PVC de la planta de Pablo de Podestá, se encuentra certificado por IRAM, con las normas ISO 9001:2008 y está acreditado ante INN (Chile), OAA (Argentina) e IQNet (Red Internacional).\r\n\r\n&nbsp;", "Certificaciones", "El sistema de gestión de calidad se encuentra certificado por IRAM.", "inherit", "open", "open", "", "386-revision-4", "", "", "2012-04-19 15:34:12", "2012-04-19 19:34:12", "", "386", "http://santamargherita.s-m.cl/386-revision-4/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("805", "1", "2012-05-28 15:39:29", "2012-05-28 19:39:29", "", "Caledonia", "Caledonia", "inherit", "open", "open", "", "caledonia-b", "", "", "2012-05-28 15:39:29", "2012-05-28 19:39:29", "", "379", "http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Caledonia-b.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("741", "1", "2012-05-24 15:33:44", "2012-05-24 19:33:44", "<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/colores.jpg\"><img class=\"alignnone size-full wp-image-734\" title=\"Colores\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/colores.jpg\" alt=\"\" width=\"576\" height=\"200\" /></a>\r\n\r\nEl aglomerado SANTAMARGHERITA , a base de arenas de cuarzo y resina, es un producto de elevadas características estéticas con una alta resistencia a la flexión, a la abrasión y a los ácidos. Innovador y con altas prestaciones técnicas es un material que se presenta de manera muy homogénea y uniforme, además de ser particularmente versátil en lo que se refiere a la coloración.<em></em>\r\n\r\nLa amplia gama de colores y granulometrías y una tecnología de vanguardia se presentan bajo forma de superficies con varias posibilidades de uso, los colores neutros y las tonalidades más fuertes permiten combinaciones personales e inéditas.\r\n\r\n<span style=\"color: #339966;\">Fotos de los colores están en el CD hay que separarlos por línea:</span>\r\n\r\n<span style=\"color: #339966;\">-Trafficstone</span>\r\n\r\n<span style=\"color: #339966;\">-Stardust</span>\r\n\r\n<span style=\"color: #339966;\">-Reff</span>\r\n\r\n&nbsp;", "Colores", "El color es otorgado a nuestros perfiles través de un proceso denominado “foliado”.", "inherit", "open", "open", "", "379-revision-v1", "", "", "2012-05-24 15:33:44", "2012-05-24 19:33:44", "", "379", "http://santamargherita.s-m.cl/379-revision-9/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("432", "1", "2012-04-02 18:08:52", "2012-04-03 01:08:52", "<img class=\"alignnone size-full wp-image-858\" title=\"Santamargherita\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/04/somos.jpg\" alt=\"\" width=\"810\" height=\"328\" />\r\n<h3>QUIÉNES SOMOS</h3>\r\n<img class=\"alignnone size-full wp-image-904\" title=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/santamargherita-logo-01.png\" alt=\"\" width=\"80\" height=\"15\" /> es una empresa Italiana líder en el mercado de los aglomerados, con más de 40 años de trayectoria y presente en más de 70 Países, siempre atenta a las nuevas tendencias de la arquitectura y del diseño interior, la empresa ubicada en Volargne di Dolcè (Verona) con más de 100.000 metros construidos, satisface las exigencias de diseño y calidad, ofreciendo a sus clientes líneas sobrias y esenciales, con tonalidades neutras y elegantes y líneas más innovadoras y exclusivas con colores cautivadores y acabados únicos.\r\n\r\n<img class=\"alignnone size-full wp-image-904\" title=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/santamargherita-logo-01.png\" alt=\"\" width=\"80\" height=\"15\" /> llega a Chile con su línea trafficstone para dar solución a los más variados proyectos tanto residenciales como públicos; su composición de 93% de cuarzo y un 7% de resina poliéster, le otorga cualidades únicas en el mercado, transformándolo en la mejor solución para cubiertas de baños y cocinas, además de revestimientos de muros y pisos.", "Quiénes somos", "", "publish", "closed", "closed", "", "quienes-somos", "", "", "2012-06-11 11:49:59", "2012-06-11 15:49:59", "", "0", "http://www.navaja.org/multicancha/?page_id=432", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("769", "1", "2012-05-24 15:45:11", "2012-05-24 19:45:11", "<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/colores.jpg\"><img class=\"alignnone size-full wp-image-734\" title=\"Colores\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/colores.jpg\" alt=\"\" width=\"576\" height=\"200\" /></a>\r\n\r\nEl aglomerado SANTAMARGHERITA , a base de arenas de cuarzo y resina, es un producto de elevadas características estéticas con una alta resistencia a la flexión, a la abrasión y a los ácidos. Innovador y con altas prestaciones técnicas es un material que se presenta de manera muy homogénea y uniforme, además de ser particularmente versátil en lo que se refiere a la coloración.<em></em>\r\n\r\nLa amplia gama de colores y granulometrías y una tecnología de vanguardia se presentan bajo forma de superficies con varias posibilidades de uso, los colores neutros y las tonalidades más fuertes permiten combinaciones personales e inéditas.\r\n\r\n<span style=\"color: #339966;\">Fotos de los colores están en el CD hay que separarlos por línea:</span>\r\n\r\n<span style=\"color: #339966;\">-Trafficstone</span>\r\n\r\n<span style=\"color: #339966;\">-Stardust</span>\r\n\r\n<span style=\"color: #339966;\">-Reff</span>\r\n\r\n&nbsp;", "Colores", "Amplia gama de colores y granulometrías.", "inherit", "open", "open", "", "379-revision-v1", "", "", "2012-05-24 15:45:11", "2012-05-24 19:45:11", "", "379", "http://santamargherita.s-m.cl/379-revision-10/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("770", "1", "2012-05-28 12:24:26", "2012-05-28 16:24:26", "", "Aosta", "Aosta", "inherit", "open", "open", "", "aosta-b", "", "", "2012-05-28 12:24:26", "2012-05-28 16:24:26", "", "379", "http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Aosta-b.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("771", "1", "2012-05-28 12:16:13", "2012-05-28 16:16:13", "<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/colores.jpg\"><img class=\"alignnone size-full wp-image-734\" title=\"Colores\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/colores.jpg\" alt=\"\" width=\"576\" height=\"200\" /></a>\r\n\r\nEl aglomerado SANTAMARGHERITA , a base de arenas de cuarzo y resina, es un producto de elevadas características estéticas con una alta resistencia a la flexión, a la abrasión y a los ácidos. Innovador y con altas prestaciones técnicas es un material que se presenta de manera muy homogénea y uniforme, además de ser particularmente versátil en lo que se refiere a la coloración.<em></em>\r\n\r\nLa amplia gama de colores y granulometrías y una tecnología de vanguardia se presentan bajo forma de superficies con varias posibilidades de uso, los colores neutros y las tonalidades más fuertes permiten combinaciones personales e inéditas.\r\n\r\n<span style=\"color: #339966;\">Fotos de los colores están en el CD hay que separarlos por línea:</span>\r\n\r\n<span style=\"color: #339966;\">-Trafficstone</span>\r\n\r\n[caption id=\"attachment_767\" align=\"alignnone\" width=\"116\" caption=\"Amalfi\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Amalfi-b.jpg\"><img class=\"size-thumbnail wp-image-767\" title=\"Amalfi\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Amalfi-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_768\" align=\"alignnone\" width=\"116\" caption=\"Antracite\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Antracite-b.jpg\"><img class=\"size-thumbnail wp-image-768\" title=\"Antracite\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Antracite-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n<span style=\"color: #339966;\">-Stardust</span>\r\n\r\n<span style=\"color: #339966;\">-Reff</span>\r\n\r\n&nbsp;", "Colores", "Amplia gama de colores y granulometrías.", "inherit", "open", "open", "", "379-revision-v1", "", "", "2012-05-28 12:16:13", "2012-05-28 16:16:13", "", "379", "http://santamargherita.s-m.cl/379-revision-11/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("540", "1", "2012-04-13 06:05:33", "2012-04-13 06:05:33", " ", "", "", "publish", "open", "closed", "", "empresa", "", "", "2014-04-30 12:03:40", "2014-04-30 16:03:40", "", "0", "http://s-m.cl/?p=540", "2", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("541", "1", "2012-04-13 06:05:33", "2012-04-13 06:05:33", "", "Home", "", "publish", "open", "closed", "", "home", "", "", "2014-04-30 12:03:40", "2014-04-30 16:03:40", "", "0", "http://s-m.cl/?p=541", "1", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("636", "1", "2012-04-19 15:40:57", "2012-04-19 19:40:57", "&nbsp;\r\n\r\n<img class=\"alignnone size-full wp-image-561\" src=\"http://s-m.cl/wp-content/uploads/2012/03/garantia_OK.jpg\" alt=\"\" width=\"576\" height=\"200\" />\r\n\r\n<strong>Garantía</strong>\r\n\r\nTecnocom ha desarrollado un compuesto de PVC bajo las mas estrictas normas de calidad. Es por esto que el los perfiles de color blanco cuentan con una garantía de 7 años. Para los perfiles de color, Tecnocom trabaja con la firma Alemana SKAI, la cual da una garantía de 5 años sobre el folio. Infórmese sobre las condiciones y alcances de la garantía.\r\n\r\n<strong>Calidad</strong>\r\n\r\nUn proceso de calidad contínuo es sinónimo de una marca líder. Desde la fabricación del compuesto hasta la extrusión y foliado del perfil. Tecnocom cuenta con un departamento de calidad para asegurar la entrega de un producto de clase mundial.\r\n\r\nDos laboratorios, uno de compuestos de PVC otro de Perfiles de PVC, colaboran continuamente en verificar los estándares de trabajo.", "Garantía &amp; calidad", "Un proceso de calidad contínuo es sinónimo de una marca líder.", "inherit", "open", "open", "", "372-revision-6", "", "", "2012-04-19 15:40:57", "2012-04-19 19:40:57", "", "372", "http://s-m.cl/372-revision-6/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("757", "1", "2012-05-24 16:35:29", "2012-05-24 20:35:29", "", "Texturas", "", "inherit", "open", "open", "", "dsc_0105", "", "", "2012-05-24 16:35:29", "2012-05-24 20:35:29", "", "0", "http://santamargherita.s-m.cl/wp-content/uploads/2012/03/DSC_0105.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("644", "1", "2012-04-26 09:49:31", "2012-04-26 13:49:31", "<a href=\"http://s-m.cl/wp-content/uploads/2012/03/calidad.jpg\"><img class=\"alignnone size-full wp-image-635\" title=\"calidad\" src=\"http://s-m.cl/wp-content/uploads/2012/03/calidad.jpg\" alt=\"Garantía &amp; calidad\" width=\"576\" height=\"200\" /></a>\r\n\r\n<strong>Garantía</strong>\r\n\r\nTecnocom ha desarrollado un compuesto de PVC bajo las mas estrictas normas de calidad. Es por esto que el los perfiles de color blanco cuentan con una garantía de 7 años. Para los perfiles de color, Tecnocom trabaja con la firma Alemana SKAI, la cual da una garantía de 5 años sobre el folio. Infórmese sobre las condiciones y alcances de la garantía.\r\n\r\n<strong>Calidad</strong>\r\n\r\nUn proceso de calidad contínuo es sinónimo de una marca líder. Desde la fabricación del compuesto hasta la extrusión y foliado del perfil. Tecnocom cuenta con un departamento de calidad para asegurar la entrega de un producto de clase mundial.\r\n\r\nDos laboratorios, uno de compuestos de PVC otro de Perfiles de PVC, colaboran continuamente en verificar los estándares de trabajo.", "Garantía &amp; calidad", "Un proceso de calidad contínuo es sinónimo de una marca líder.", "inherit", "open", "open", "", "372-revision-8", "", "", "2012-04-26 09:49:31", "2012-04-26 13:49:31", "", "372", "http://s-m.cl/372-revision-8/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1310", "1", "2012-06-25 10:24:07", "2012-06-25 14:24:07", "", "Garantí y Calidad", "", "inherit", "closed", "closed", "", "garantia-2", "", "", "2012-06-25 10:24:07", "2012-06-25 14:24:07", "", "372", "http://santamargherita.s-m.cl/wp-content/uploads/2012/03/garantia.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("1311", "1", "2012-06-11 15:56:44", "2012-06-11 19:56:44", "<img class=\"alignnone size-full wp-image-955\" title=\"Garantía &amp; Calidad\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/garantia.jpg\" alt=\"\" width=\"810\" height=\"328\" />\r\n<h3>GARANTÍA &amp; CALIDAD</h3>\r\n<img class=\"alignnone size-full wp-image-904\" title=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/santamargherita-logo-01.png\" alt=\"\" width=\"80\" height=\"15\" /> encierra sus valores en una única expresión <em>“The original italian surface”</em>.\r\n\r\n<strong><em>the original</em></strong> - La investigación constante, tanto tecnológica como estilística permite, desde hace más de cuarenta años, presentar al mercado un producto original en una gama de colores y acabados exclusivos.\r\n\r\n<strong><em>italian</em></strong> – Garantía de calidad y fiabilidad, asistencia constante y competencia son sólo algunas de las características principales que hacen que los productos “Made in Italy” sean los primeros en el mundo por lo que respecta a diseño y arquitectura. <img class=\"alignnone size-full wp-image-904\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/santamargherita-logo-01.png\" alt=\"\" width=\"80\" height=\"15\" /> mantiene estos valores y los traduce en productos únicos e inimitables.\r\n\r\n<strong><em>surface</em></strong> – Superﬁcies con base de mármol y de cuarzo, en esto se basa actualmente el know how de una empresa que no se detiene y mira hacia el futuro para desarrollarse cada vez más con la finalidad de brindar al cliente las más variadas posibilidades para revestir y decorar espacios habitacionales y grandes obras.", "Garantía &amp; calidad", "Santamargherita encierra sus valores en una única expresión “The original italian surface”.", "inherit", "closed", "closed", "", "372-revision-19", "", "", "2012-06-11 15:56:44", "2012-06-11 19:56:44", "", "372", "http://santamargherita.s-m.cl/372-revision-19/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("372", "1", "2012-03-26 22:09:31", "2012-03-27 05:09:31", "<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/garantia.jpg\"><img class=\"alignnone size-full wp-image-1310\" title=\"Garantí y Calidad\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/garantia.jpg\" alt=\"\" width=\"810\" height=\"328\" /></a>\r\n<h3>GARANTÍA &amp; CALIDAD</h3>\r\n<img class=\"alignnone size-full wp-image-904\" title=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/santamargherita-logo-01.png\" alt=\"\" width=\"80\" height=\"15\" /> encierra sus valores en una única expresión <em>“The original italian surface”</em>.\r\n\r\n<strong><em>the original</em></strong> - La investigación constante, tanto tecnológica como estilística permite, desde hace más de cuarenta años, presentar al mercado un producto original en una gama de colores y acabados exclusivos.\r\n\r\n<strong><em>italian</em></strong> – Garantía de calidad y fiabilidad, asistencia constante y competencia son sólo algunas de las características principales que hacen que los productos “Made in Italy” sean los primeros en el mundo por lo que respecta a diseño y arquitectura. <img class=\"alignnone size-full wp-image-904\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/santamargherita-logo-01.png\" alt=\"\" width=\"80\" height=\"15\" /> mantiene estos valores y los traduce en productos únicos e inimitables.\r\n\r\n<strong><em>surface</em></strong> – Superﬁcies con base de mármol y de cuarzo, en esto se basa actualmente el know how de una empresa que no se detiene y mira hacia el futuro para desarrollarse cada vez más con la finalidad de brindar al cliente las más variadas posibilidades para revestir y decorar espacios habitacionales y grandes obras.", "Garantía &amp; calidad", "Santamargherita encierra sus valores en una única expresión “The original italian surface”.", "publish", "closed", "closed", "", "garantia-calidad", "", "", "2012-06-25 10:24:31", "2012-06-25 14:24:31", "", "0", "http://www.navaja.org/multicancha/?p=372", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("379", "1", "2012-03-26 21:15:23", "2012-03-27 04:15:23", "<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/colores.jpg\"><img class=\"alignnone size-full wp-image-1312\" title=\"Colores\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/colores.jpg\" width=\"810\" height=\"328\" /></a>\r\n<h3>COLORES</h3>\r\nEl aglomerado <img class=\"alignnone size-full wp-image-904\" title=\"\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/santamargherita-logo-01.png\" width=\"80\" height=\"15\" />, a base de arenas de cuarzo y resina, es un producto de elevadas características estéticas con una alta resistencia a la flexión, a la abrasión y a los ácidos. Innovador y con altas prestaciones técnicas es un material que se presenta de manera muy homogénea y uniforme, además de ser particularmente versátil en lo que se refiere a la coloración.<em></em>\r\n\r\nLa amplia gama de colores y granulometrías y una tecnología de vanguardia se presentan bajo forma de superficies con varias posibilidades de uso, los colores neutros y las tonalidades más fuertes permiten combinaciones personales e inéditas.\r\n<div style=\"clear: both; height: 12px; width: 100%;\"></div>\r\n<h5>Línea Trafficstone</h5>\r\n[caption id=\"attachment_767\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Amalfi-b.jpg\"><img class=\" wp-image-767   \" title=\"Amalfi\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Amalfi-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Amalfi[/caption]\r\n\r\n[caption id=\"attachment_768\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Antracite-b.jpg\"><img class=\" wp-image-768  \" title=\"Antracite\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Antracite-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Antracite[/caption]\r\n\r\n[caption id=\"attachment_770\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Aosta-b.jpg\"><img class=\" wp-image-770  \" title=\"Aosta\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Aosta-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Aosta[/caption]\r\n\r\n[caption id=\"attachment_772\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Apulia-b.jpg\"><img class=\" wp-image-772  \" title=\"Apulia\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Apulia-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Apulia[/caption]\r\n\r\n[caption id=\"attachment_773\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Atena-b.jpg\"><img class=\" wp-image-773  \" title=\"Atena\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Atena-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Atena[/caption]\r\n\r\n[caption id=\"attachment_775\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Auby-b.jpg\"><img class=\" wp-image-775  \" title=\"Auby\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Auby-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Auby[/caption]\r\n\r\n[caption id=\"attachment_776\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Belvedere-b.jpg\"><img class=\" wp-image-776  \" title=\"Belvedere-b\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Belvedere-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Belvedere[/caption]\r\n\r\n[caption id=\"attachment_804\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Breda-b.jpg\"><img class=\" wp-image-804   \" title=\"Breda\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Breda-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Breda[/caption]\r\n\r\n[caption id=\"attachment_805\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Caledonia-b.jpg\"><img class=\" wp-image-805   \" title=\"Caledonia\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Caledonia-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Caledonia[/caption]\r\n\r\n[caption id=\"attachment_806\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Camargue-b.jpg\"><img class=\" wp-image-806   \" title=\"Camargue\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Camargue-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Camargue[/caption]\r\n\r\n[caption id=\"attachment_807\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Carnia-b.jpg\"><img class=\" wp-image-807   \" title=\"Carnia\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Carnia-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Carnia[/caption]\r\n\r\n[caption id=\"attachment_808\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Catalina-b.jpg\"><img class=\" wp-image-808   \" title=\"Catalina\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Catalina-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Catalina[/caption]\r\n\r\n[caption id=\"attachment_809\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Friuli-b.jpg\"><img class=\" wp-image-809   \" title=\"Friuli\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Friuli-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Friuli[/caption]\r\n\r\n[caption id=\"attachment_812\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Hermitage-b.jpg\"><img class=\" wp-image-812  \" title=\"Hermitage\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Hermitage-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Hermitage[/caption]\r\n\r\n[caption id=\"attachment_813\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Istria-b.jpg\"><img class=\" wp-image-813  \" title=\"Istria\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Istria-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Istria[/caption]\r\n\r\n[caption id=\"attachment_814\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Itaca-b.jpg\"><img class=\" wp-image-814  \" title=\"Itaca\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Itaca-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Itaca[/caption]\r\n\r\n[caption id=\"attachment_815\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Miami-b.jpg\"><img class=\" wp-image-815  \" title=\"Miami\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Miami-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Miami[/caption]\r\n\r\n[caption id=\"attachment_816\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Miramare-b.jpg\"><img class=\" wp-image-816  \" title=\"Miramare\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Miramare-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Miramare[/caption]\r\n\r\n[caption id=\"attachment_817\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Modena-b.jpg\"><img class=\" wp-image-817  \" title=\"Modena\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Modena-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Modena[/caption]\r\n\r\n[caption id=\"attachment_818\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Naxos-b.jpg\"><img class=\" wp-image-818  \" title=\"Naxos\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Naxos-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Naxos[/caption]\r\n\r\n[caption id=\"attachment_819\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Nero-b.jpg\"><img class=\" wp-image-819  \" title=\"Nero\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Nero-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Nero[/caption]\r\n\r\n[caption id=\"attachment_820\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Otello-b.jpg\"><img class=\" wp-image-820  \" title=\"Otello\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Otello-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Otello[/caption]\r\n\r\n[caption id=\"attachment_821\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Pompei-b.jpg\"><img class=\" wp-image-821  \" title=\"Pompei\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Pompei-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Pompei[/caption]\r\n\r\n[caption id=\"attachment_822\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Prussia-b.jpg\"><img class=\" wp-image-822  \" title=\"Prussia\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Prussia-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Prussia[/caption]\r\n\r\n[caption id=\"attachment_823\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Rinmini-b.jpg\"><img class=\" wp-image-823  \" title=\"Rinmini\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Rinmini-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Rinmini[/caption]\r\n\r\n<div style=\"clear: both; height: 12px; width: 100%;\"></div>\r\n<h5>Línea Stardust</h5>\r\n[caption id=\"attachment_840\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Beige-Stardust-b.jpg\"><img class=\" wp-image-840  \" title=\"Beige Stardust\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Beige-Stardust-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Beige Stardust[/caption]\r\n\r\n[caption id=\"attachment_841\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Bianco-Stardust-b.jpg\"><img class=\" wp-image-841  \" title=\"Bianco Stardust\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Bianco-Stardust-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Bianco Stardust[/caption]\r\n\r\n[caption id=\"attachment_842\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Blu-Stardust-b.jpg\"><img class=\" wp-image-842  \" title=\"Blu Stardust\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Blu-Stardust-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Blu Stardust[/caption]\r\n\r\n[caption id=\"attachment_843\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Giallo-Stardust-b.jpg\"><img class=\" wp-image-843  \" title=\"Giallo Stardust\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Giallo-Stardust-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Giallo Stardust[/caption]\r\n\r\n[caption id=\"attachment_844\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Nero-Stardust-b.jpg\"><img class=\" wp-image-844  \" title=\"Nero Stardust\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Nero-Stardust-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Nero Stardust[/caption]\r\n\r\n[caption id=\"attachment_845\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Pastel-Green-Stardust-b.jpg\"><img class=\" wp-image-845  \" title=\"Pastel Green Stardust\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Pastel-Green-Stardust-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Pastel Green St.[/caption]\r\n\r\n[caption id=\"attachment_846\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Rosa-Stardust-b.jpg\"><img class=\" wp-image-846  \" title=\"Rosa Stardust\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Rosa-Stardust-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Rosa Stardust[/caption]\r\n\r\n[caption id=\"attachment_847\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Rosso-Stardust-b.jpg\"><img class=\" wp-image-847  \" title=\"Rosso Stardust\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Rosso-Stardust-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Rosso Stardust[/caption]\r\n\r\n[caption id=\"attachment_848\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Sky-Stardust-b.jpg\"><img class=\" wp-image-848  \" title=\"Sky Stardust\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Sky-Stardust-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Sky Stardust[/caption]\r\n\r\n<div style=\"clear: both; height: 12px; width: 100%;\"></div>\r\n<h5>Línea Reef</h5>\r\n[caption id=\"attachment_1083\" align=\"alignleft\" width=\"80\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/Beige.jpg\"><img class=\" wp-image-1083   \" title=\"Beige\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Beige_t.jpg\" width=\"80\" height=\"80\" /></a> Beige[/caption]\r\n\r\n[caption id=\"attachment_1084\" align=\"alignleft\" width=\"80\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/Black.jpg\"><img class=\" wp-image-1084 \" title=\"Black\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Black_t.jpg\" width=\"80\" height=\"80\" /></a> Black[/caption]\r\n\r\n[caption id=\"attachment_1085\" align=\"alignleft\" width=\"80\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/Brown.jpg\"><img class=\" wp-image-1085 \" title=\"Brown\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Brown_t.jpg\" width=\"80\" height=\"80\" /></a> Brown[/caption]\r\n\r\n[caption id=\"attachment_1086\" align=\"alignleft\" width=\"80\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/Grey.jpg\"><img class=\" wp-image-1086 \" title=\"Grey\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Grey_t.jpg\" width=\"80\" height=\"80\" /></a> Grey[/caption]\r\n\r\n[caption id=\"attachment_1087\" align=\"alignleft\" width=\"80\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/White.jpg\"><img class=\" wp-image-1087 \" title=\"White\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/White_t.jpg\" width=\"80\" height=\"80\" /></a> White[/caption]\r\n\r\n<div style=\"clear: both; height: 12px; width: 100%;\"></div>\r\n<h5>Línea Glitter</h5>\r\n[caption id=\"attachment_1102\" align=\"alignleft\" width=\"80\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/Bronze.jpg\"><img class=\" wp-image-1102 \" title=\"Bronze\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Bronze_t.jpg\" width=\"80\" height=\"80\" /></a> Bronze[/caption]\r\n\r\n[caption id=\"attachment_1098\" align=\"alignleft\" width=\"80\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/Gold.jpg\"><img class=\" wp-image-1098 \" title=\"Gold\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Gold_t.jpg\" width=\"80\" height=\"80\" /></a> Gold[/caption]\r\n\r\n[caption id=\"attachment_1099\" align=\"alignleft\" width=\"80\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/Iron.jpg\"><img class=\" wp-image-1099 \" title=\"Iron\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Iron_t.jpg\" width=\"80\" height=\"80\" /></a> Iron[/caption]\r\n\r\n[caption id=\"attachment_1100\" align=\"alignleft\" width=\"80\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/Pewter.jpg\"><img class=\" wp-image-1100 \" title=\"Pewter\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Pewter_t.jpg\" width=\"80\" height=\"80\" /></a> Pewter[/caption]\r\n\r\n[caption id=\"attachment_1101\" align=\"alignleft\" width=\"80\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/Silver.jpg\"><img class=\" wp-image-1101 \" title=\"Silver\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Silver_t.jpg\" width=\"80\" height=\"80\" /></a> Silver[/caption]", "Colores", "Amplia gama de colores y granulometrías.", "publish", "open", "open", "", "colores", "", "", "2013-08-07 17:03:35", "2013-08-07 21:03:35", "", "0", "http://www.navaja.org/multicancha/?p=379", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("909", "1", "2012-05-28 20:03:34", "2012-05-29 00:03:34", "<img class=\"alignnone size-full wp-image-801\" title=\"Certificaciones\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/certificaciones2.jpg\" alt=\"\" width=\"810\" height=\"328\" />\r\n<h3>CERTIFICACIONES</h3>\r\nLos objetivos principales de SANTAMARGHERITA son la calidad y seguridad de sus productos. Nuestro laboratorio de Investigación y Desarrollo pone siempre toda su atención en la realización de aglomerados capaces de hacer frente, por un lado a los criterios establecidos en relación con las emisiones de materiales para la decoración de interiores, para grandes espacios y para la industria de la construcción, y por otro lado, a los relacionados con el proyecto y realización de edificios energéticamente eficientes y con bajo impacto ambiental.\r\nGracias a esta atención y a la colaboración con institutos prestigiosos a nivel internacional, los productos SANTAMARGHERITA han obtenido las importantes certiﬁcaciones NSF y GREENGUARD. Además, gracias a la cooperación con el Green Building Council Italia, del cual SANTAMARGHERITA es Miembro Ordinario, y con el Distretto Tecnologico Trentino, la empresa ha elaborado su propio “Protocolo LEED” según las normas del United States Green Building Council - USGBC (Consejo de la Construcción Ecológica de Estados Unidos).", "Certificaciones", "Los productos Santamargherita han obtenido importantes certiﬁcaciones, como NSF y GREENGUARD.", "inherit", "open", "open", "", "383-revision-9", "", "", "2012-05-28 20:03:34", "2012-05-29 00:03:34", "", "383", "http://santamargherita.s-m.cl/383-revision-9/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("737", "1", "2012-04-19 15:33:29", "2012-04-19 19:33:29", "&nbsp;\r\n\r\n<img class=\"alignnone size-full wp-image-563\" title=\"eficiencia_OK\" src=\"http://s-m.cl/wp-content/uploads/2012/03/eficiencia_OK.jpg\" alt=\"\" width=\"576\" height=\"200\" />\r\n\r\nNuestro compromiso con el medio ambiente se basa desde el reciclaje de nuestros productos, de manera de ahorrar energía en los procesos de producción y en la fabricación de materias primas, además de cumplir con los estándares Europeos de fabricación para no dañar el medio ambiente.\r\n\r\nConstantemente estamos desarrollando tecnologías que nos permitan crear perfiles que tengan una mayor capacidad aislante, para llevar hasta tu casa el concepto de ahorro de energía y de esta manera contribuir con el medio ambiente como compromiso no solo de nuestra empresa, sino también a través de cada uno de nuestros clientes.", "Eficiencia energética", "Desarrollamos tecnologías que nos permiten crear perfiles de mayor capacidad aislante.", "inherit", "open", "open", "", "383-revision-5", "", "", "2012-04-19 15:33:29", "2012-04-19 19:33:29", "", "383", "http://santamargherita.s-m.cl/383-revision-5/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("383", "1", "2012-03-26 20:18:19", "2012-03-27 03:18:19", "<img class=\"alignnone size-full wp-image-908\" title=\"Certificaciones\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/limones.jpg\" alt=\"\" width=\"810\" height=\"328\" />\r\n<h3>CERTIFICACIONES</h3>\r\nLos objetivos principales de <img class=\"alignnone size-full wp-image-904\" title=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/santamargherita-logo-01.png\" alt=\"\" width=\"80\" height=\"15\" /> son la calidad y seguridad de sus productos. Nuestro laboratorio de Investigación y Desarrollo pone siempre toda su atención en la realización de aglomerados capaces de hacer frente, por un lado a los criterios establecidos en relación con las emisiones de materiales para la decoración de interiores, para grandes espacios y para la industria de la construcción, y por otro lado, a los relacionados con el proyecto y realización de edificios energéticamente eficientes y con bajo impacto ambiental.\r\n\r\nGracias a esta atención y a la colaboración con institutos prestigiosos a nivel internacional, los productos <img class=\"alignnone size-full wp-image-904\" title=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/santamargherita-logo-01.png\" alt=\"\" width=\"80\" height=\"15\" /> han obtenido las importantes certiﬁcaciones <strong>NSF</strong> y <strong>Greenguard</strong>. Además, gracias a la cooperación con el Green Building Council Italia, del cual <img class=\"alignnone size-full wp-image-904\" title=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/santamargherita-logo-01.png\" alt=\"\" width=\"80\" height=\"15\" /> es Miembro Ordinario, y con el Distretto Tecnologico Trentino, la empresa ha elaborado su propio “Protocolo LEED” según las normas del <strong>United States Green Building Council - USGBC</strong> (Consejo de la Construcción Ecológica de Estados Unidos).\r\n\r\n&nbsp;\r\n\r\n<span style=\"color: #ffffff;\">...............................</span><img class=\" wp-image-934 alignnone\" title=\"Certificación NSF\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/certificacion-nsf.jpg\" alt=\"\" width=\"74\" height=\"69\" />                                                   <img class=\" wp-image-935 alignnone\" title=\"GGEnvironmentalInstitute\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/certificacion-greenguard.jpg\" alt=\"\" width=\"126\" height=\"69\" />                                             <img class=\"alignnone  wp-image-936\" title=\"Green Building Council\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/certificacion-gbc.gif\" alt=\"\" width=\"69\" height=\"69\" />", "Certificaciones", "Los productos Santamargherita han obtenido importantes certiﬁcaciones, como NSF y Greenguard.", "publish", "open", "open", "", "certificaciones", "", "", "2012-06-14 13:10:34", "2012-06-14 17:10:34", "", "0", "http://www.navaja.org/multicancha/?p=383", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("386", "1", "2012-03-26 19:27:08", "2012-03-27 02:27:08", "<img class=\"alignnone size-full wp-image-796\" title=\"Aplicaciones Baño\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/aplicaciones2.jpg\" alt=\"\" width=\"810\" height=\"328\" />\r\n<h3>APLICACIONES</h3>\r\n<h5><strong>Aglomerado de Cuarzo para encimeras de Cocina y Baño</strong></h5>\r\nCada casa refleja la personalidad de quienes viven en ella. Caracteres, gustos y estilos que pueden llegar a ser infinitos, opuestos entre ellos; desde el neoclásico hasta el barroco, desde la ostentación hasta el minimalismo, con el uso de una paleta de colores desde las tonalidades más claras hasta las más fuertes.<strong><em></em></strong>\r\n\r\n<img class=\"alignnone size-full wp-image-904\" title=\"santamargherita\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/santamargherita-logo-01.png\" alt=\"\" width=\"80\" height=\"15\" />, a través de una investigación constante, crea superficies con altas prestaciones técnicas y que son estéticamente capaces de hacer que los ambientes domésticos sean únicos satisfaciendo perfectamente las diferentes exigencias.\r\n\r\nEl material ideal para pavimentos y revestimientos, cabinas de ducha y encimeras de cocina y baño se caracteriza, por un lado, por la alta resistencia a la flexión, abrasión y ácidos, y por el otro, por la variedad de colores y texturas más neutras o con mayor profundidad y efectos de movimiento.\r\n\r\nActualmente en el diseño de interiores está marcado el uso de tamaño cada vez más grandes y personalizados, por tanto las colecciones de aglomerado con base de cuarzo <img class=\"alignnone size-full wp-image-904\" title=\"santamargherita\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/santamargherita-logo-01.png\" alt=\"\" width=\"80\" height=\"15\" /> se proponen en baldosas de dimensiones estándares o variables. Para cada proyecto, para cada exigencia, para cada gusto, <img class=\"alignnone size-full wp-image-904\" title=\"santamargherita\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/santamargherita-logo-01.png\" alt=\"\" width=\"80\" height=\"15\" /> dispone de la superficie ideal.\r\n<h5><strong>Aglomerado de Cuarzo para superficies de grandes obras</strong></h5>\r\nAeropuertos, estaciones de trenes, centros comerciales, grandes superficies en todo el mundo ostentan actualmente pavimentos y revestimientos con la marca <img class=\"alignnone size-full wp-image-904\" title=\"santamargherita\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/santamargherita-logo-01.png\" alt=\"\" width=\"80\" height=\"15\" />. Las potencialidades del aglomerado de cuarzo permiten que <img class=\"alignnone size-full wp-image-904\" title=\"santamargherita\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/santamargherita-logo-01.png\" alt=\"\" width=\"80\" height=\"15\" /> responda a las exigencias en lo que se refiere a complejidad y personalidad de cada proyecto, a partir del suministro de grandes volúmenes hasta un servicio de investigación y desarrollo de nuevos colores personalizados que dan originalidad y unicidad al producto.\r\n\r\n<strong><a title=\"Obras\" href=\"http://santamargherita.s-m.cl/obras/\">Ver Obras »</a></strong>", "Aplicaciones", "Cada casa refleja la personalidad de quienes viven en ella.", "publish", "open", "open", "", "aplicaciones", "", "", "2012-06-18 11:13:19", "2012-06-18 15:13:19", "", "0", "http://www.navaja.org/multicancha/?p=386", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("398", "1", "2012-03-26 18:39:35", "2012-03-27 01:39:35", "<img class=\"alignnone size-full wp-image-916\" title=\"Proyectos destacados\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/bano.jpg\" alt=\"\" width=\"810\" height=\"328\" />\r\n<h3>PROYECTOS DESTACADOS</h3>\r\n<h5><strong>Parque Espoz</strong></h5>\r\n<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/banner_espoz_02.jpg\"><img class=\"alignnone\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/banner_espoz_02-196x88.jpg\" alt=\"\" width=\"196\" height=\"88\" /></a>  <a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/espoz_equip_04.jpg\"><img class=\"alignnone\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/espoz_equip_04-196x88.jpg\" alt=\"\" width=\"196\" height=\"88\" /></a>\r\n<h5><strong>Departamentos Rafel Sanzio</strong></h5>\r\n<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/rafael-sanzio-departamentos.jpg\"><img class=\"alignnone\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/rafael-sanzio-departamentos-196x88.jpg\" alt=\"\" width=\"196\" height=\"88\" /></a>", "Proyectos destacados", "Proyectos destacados realizados por nuestra empresa.", "publish", "closed", "closed", "", "proyectos-destacados", "", "", "2012-06-18 11:14:02", "2012-06-18 15:14:02", "", "0", "http://www.navaja.org/multicancha/?p=398", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("792", "1", "2012-05-28 15:14:04", "2012-05-28 19:14:04", "", "Garantía & Calidad", "", "inherit", "open", "open", "", "garantia2", "", "", "2012-05-28 15:14:04", "2012-05-28 19:14:04", "", "372", "http://santamargherita.s-m.cl/wp-content/uploads/2012/03/garantia2.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("762", "1", "2012-04-19 15:44:14", "2012-04-19 19:44:14", "<img class=\"alignnone size-full wp-image-481\" title=\"empresa_OK\" src=\"http://s-m.cl/wp-content/uploads/2012/04/empresa_OK.jpg\" alt=\"\" width=\"576\" height=\"200\" />\r\n<h4><a name=\"empresa\"></a>La Empresa</h4>\r\nTecnocom inicia sus actividades comerciales en 1975, y desde entonces ha venido desarrollando un importante proceso de expansión, demostrando desde sus inicios una constante vitalidad y crecimiento, cualidades que sumadas  a la alta tecnología utilizada le permite ocupar una posición de liderazgo.\r\n\r\nEn la actualidad tiene 3 divisiones: Compuestos de PVC, Mangueras de PVC y Perfiles de PVC que en conjunto facturan al año aproximadamente US$100 millones.\r\n\r\nSon tres las instalaciones industriales con las que cuenta, dos en Buenos Aires y una en San Luis\r\n\r\nLa división perfiles se creó hace 7 años con la más moderna tecnología europea con el objetivo de ser un actor relevante en este segmento de productos en Latinoamérica.\r\n\r\nHoy Tecnocom con sus perfiles para ventanas y puertas de PVC es líder el mercado argentino con más de 55 armadores y hoy tiene presencia en México, Centro América, Colombia, Perú, Brasil, Bolivia, Uruguay y Chile.\r\n\r\nLos sistemas de perfiles son fabricados bajo las normas europeas UNE-EN 12608, que aseguran un producto de calidad que cumple todas las exigencias referidas a pruebas de Dimensionado, Pruebas Mecánicas, Pruebas Térmicas, Resistencia a los rayos UV, entre otros. (Si requiere de las normas y sus resultados no dude en solicitarlas).\r\n<h4><a name=\"objetivos\"></a>Nuestros Objetivos</h4>\r\nResponder  a las expectativas de los clientes, colaboradores y la comunidad, participando en el desarrollo de aplicaciones para mejorar la calidad de vida de la sociedad.\r\n\r\nNos esforzamos por ser los lideres y referentes del mercado en la producción y comercialización de artículos de óptima calidad. Este es nuestro compromiso con la comunidad latinoamericana de la que formamos parte.\r\n<h4><a name=\"tecnologia\"></a>Nuestra Tecnología</h4>\r\nNuestras plantas están equipadas con las mejores líneas de producción de origen alemán, italiano y austríaco, las que están diseñadas para responder a las mas altas exigencias de productividad y calidad.\r\n<h4><a name=\"personal\"></a>Nuestro Personal</h4>\r\nEs nuestro principal activo para el logro de nuestros objetivos, porque es la fuente de nuestra energía e inteligencia.\r\n\r\nEstamos convencidos de que detrás de toda gran empresa, siempre hay un gran grupo humano, y que solo con el personal idóneo y comprometido con los objetivos de la empresa es posible producir más y mejores soluciones.\r\n<h4><a name=\"mundo\"></a>TECNOCOM EN EL MUNDO</h4>\r\nCualquier empresa líder debe abrirse a mercados extranjeros. Tecnocom hoy cuenta con oficinas propias o representantes en toda Latinoamerica.\r\n\r\nCada mercado es único y Tecnocom lo entiende. Es por ello que se han desarrollado líneas y colores específicos para poder cumplir con demandas locales.\r\n\r\nHoy para Latinoamérica Tecnocom cuenta con la más amplia gama de soluciones que combinan alto nivel estético, tecnología, eficiencia energética y cuidado del medio ambiente.\r\n<h4><a name=\"laboratorio\"></a>LABORATORIO</h4>\r\nLos controles diarios que realizan los expertos en nuestro laboratorio interno, son uno de los pilares básicos del <strong>control de calidad contínuo</strong> al que se someten los perfiles de PVC Tecnocom.\r\n\r\nTodas las características de las materias primas, los perfiles extrusionados y los sistemas de ventanas y puertas de PVC acabadas, se controlan cuidadosamente de acuerdo con los criterios más estrictos, fijados por una serie de instituciones de ámbito nacional e internacional.\r\n\r\nTecnocom cuenta con un laboratorio de primer nivel donde en forma diaria se controlan todos los lotes de producción.\r\n\r\nLa inalterabilidad de las superficies, resistencia al impacto y la autenticidad del color blanco están garantizadas según norma europea UNE 53.360.\r\n<h4><a name=\"ensayo\"></a>BANCO DE ENSAYO</h4>\r\nDesde la inauguración de la planta de perfiles de PVC, Tecnocom cuenta con uno de los mas modernos bancos de ensayo alemán K Schulten.\r\n\r\nDefectos de productos que aparecen y reclamos, por regla general acarrean desagradables problemas financieros y de prestigio.\r\nEstos efectos secundarios negativos exigen una necesidad de seguridad.\r\nLa aplicación de propios bancos de ensayos para ventanas, dan garantía de estándares de calidad y de seguridad de muchos productores de ventanas.\r\n\r\nLa función del banco de ensayo es poder analizar el comportamiento de una ventana ante distintas presiones de viento y agua. Esto permite a Tecnocom analizar el comportamiento de los perfiles y los otros componentes de la ventana ante distintas situaciones emulando condiciones reales.\r\n<p style=\"text-align: left;\"><strong>- Ensayo de Estanqueidad al Agua</strong></p>\r\n\r\n<ul style=\"text-align: left;\">\r\n	<li>ESTANQUEIDAD AL AGUA: capacidad de una ventana de oponerse a las infiltraciones de agua en distintos niveles de presión estática.</li>\r\n	<li>INFILTRACIÓN: penetración continua o intermitente de agua en contacto con elementos de construcción no previstos para ser mojados.</li>\r\n	<li>LÍMITE DE ESTANQUEIDAD AL AGUA: presión máxima registrada en el curso del ensayo, para la cual está asegurada la estanqueidad al agua.</li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>- Ensayo a la acción del viento</strong></p>\r\n\r\n<ul style=\"text-align: justify;\">\r\n	<li style=\"text-align: left;\">Deformación residual permanente: modificación de la forma o de las medidas, producida por la aplicación de presiones, que no desaparece después que las presiones han dejado de aplicarse.</li>\r\n	<li style=\"text-align: left;\">Deformación residual temporal: modificación de la forma o de las medidas producidas por la aplicación de presiones, que desaparece progresivamente después que las presiones han dejado de aplicarse.</li>\r\n	<li style=\"text-align: left;\">Desplazamiento frontal: desplazamiento de un punto de un elemento de ventana medido perpendicularmente al plano de la ventana.</li>\r\n	<li style=\"text-align: left;\">Flecha frontal: diferencia máxima entre los desplazamientos frontales, tomada a lo largo de un mismo elemento de ventana (después de que se ha compensado el efecto de los desplazamientos frontales de las extremidades de este elemento).</li>\r\n	<li style=\"text-align: left;\">Flecha frontal relativa: Valor de la flecha frontal en relación con la distancia entre las dos extremidades del elemento de ventana examinado.</li>\r\n</ul>", "Quienes somos", "", "inherit", "open", "open", "", "432-revision-2", "", "", "2012-04-19 15:44:14", "2012-04-19 19:44:14", "", "432", "http://santamargherita.s-m.cl/432-revision-2/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("401", "1", "2012-03-26 17:41:46", "2012-03-27 00:41:46", "<img class=\"alignnone size-full wp-image-788\" title=\"Novedades\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/novedades3.jpg\" alt=\"\" width=\"810\" height=\"328\" />\r\n<h3>NOVEDADES</h3>\r\nSANTAMARGHERITA además de los tradicionales efectos brillante, pulido, cepillado y envejecido, añade a sus colecciones de aglomerado de base de cuarzo, acabados nuevos y originales, que son fruto de una investigación a fondo y de un diseño sofisticado. La posibilidad de combinarlos y mezclarlos libremente permite obtener ambientes donde las superficies asumen la características de suavidad y movimiento.\r\n\r\nAdemás de la línea Trafficstone contamos con otras líneas de productos que se trabajan actualmente en Chile a pedido:\r\n\r\n<strong><em>Agglosimplex</em></strong>\r\n\r\nAglomerado a base de fragmentos de mármol seleccionados; una colección compuesta de baldosas con texturas de los mármoles más prestigiosos. La uniformidad de los colores, la estabilidad dimensional y la elevada resistencia a la abrasión, a los golpes y a las flexiones hacen que la colección AGGLOSIMPLEX sea la elección ideal tanto para uso doméstico como para la pavimentación de grandes obras.\r\n\r\n<strong><em>Marghestone</em></strong>\r\n\r\nMARGHESTONE, el aglomerado a base de granulados de mármol y de especiales resinas de poliéster, a pesar de su sencillez, valoriza el aspecto minimalista de los edificios de alto prestigio. La elección cromática de tonalidades neutras refinadas, desde el Bianco Ghiaccio hasta el Grigio Piave, o que se esfuman en las tonalidades de beige, desde el Toscana hasta el Golden Beige, enriquecidos por el Bianco Mandorla y el Crema, permite crear entornos elegantes y luminosos.\r\n\r\n&nbsp;\r\n\r\n<img class=\"alignnone size-full wp-image-1079\" title=\"glitters\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/glitters.jpg\" alt=\"\" width=\"593\" height=\"134\" />\r\n\r\nEstá por lanzarse la nueva gama a base de cuarzo de la empresa veronesa <strong>Santa Margherita S.p.A</strong>., empresa veronesa especializada en la producción y comercialización de aglomerados de mármol y cuarzo, no deja de sorprender y presenta una nueva gama de colores “glitter” que ha sido creada por el profundo interés de la empresa en la arquitectura y diseño, uniendo investigación y experimentación.\r\n\r\nDespués del éxito obtenido en la feria Marmomacc 2010 por el concepto de exposición “The HALL by Santamargherita®” que reproducía la recepción de un gran hotel de lujo, la empresa propone actualmente una nueva solución destinada a embellecer y a hacer únicos los ambientes prestigiosos y de alto nivel.\r\n\r\nSe ha creado por tanto una colección exclusiva con base de cuarzo y glitter en fondos metálicos y refinados, cuyas muestras están siendo realizadas actualmente por <strong>SANTAMARGHERITA®</strong> en los tonos <strong>Gold</strong>, <strong>Silver</strong> y <strong>Pewter</strong>; posteriormente se ampliará la gama de colores disponibles sobre la base de los pedidos de los diseñadores de interiores y de sus clientes clave.\r\n\r\nEsta nueva colección es apropiada para todo tipo de aplicaciones, pero principalmente ha sido creada para las encimeras de baño de alto nivel, pavimentos, revestimientos y para la decoración de negocios, los nuevos cuarzos glitter serán presentados oficialmente, como se acostumbra, durante las próximas ferias en las que la empresa participará.\r\n\r\n&nbsp;", "Novedades", "Nuevos y originales acabados, fruto de una investigación a fondo y un diseño sofisticado.", "publish", "closed", "closed", "", "novedades", "", "", "2012-06-13 15:25:32", "2012-06-13 19:25:32", "", "0", "http://www.navaja.org/multicancha/?p=401", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("404", "1", "2012-03-26 16:43:34", "2012-03-26 23:43:34", "<img class=\"alignnone size-full wp-image-914\" title=\"Ventajas\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/neroa.jpg\" alt=\"\" width=\"810\" height=\"328\" />\r\n<h3><strong>VENTAJAS</strong></h3>\r\nSu composición de un 93% de piedras naturales y un 7% de resina poliéster otorgan al material diferentes características que lo llevan a posicionarse como un material muy superior a las piedras naturales con altas prestaciones técnicas, las más importantes son:\r\n<ul>\r\n	<li>Resistente al rayado.</li>\r\n	<li>Resistente al impacto</li>\r\n	<li>Resistente a los acidos</li>\r\n	<li>Resistente a las manchas</li>\r\n	<li>Resistente a la formación de bacterias</li>\r\n	<li>Resistente al calor.</li>\r\n</ul>", "Ventajas", "Su composición lo hace ser un material muy superior a las piedras naturales.", "publish", "open", "open", "", "ventajas", "", "", "2012-06-06 12:33:07", "2012-06-06 16:33:07", "", "0", "http://www.navaja.org/multicancha/?p=404", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("753", "1", "2012-05-24 16:16:30", "2012-05-24 20:16:30", "<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/novedades.jpg\"><img class=\"alignnone size-full wp-image-748\" title=\"Novedades\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/novedades.jpg\" alt=\"\" width=\"576\" height=\"200\" /></a>\r\n\r\nSANTAMARGHERITA además de los tradicionales efectos brillante, pulido, cepillado y envejecido, añade a sus colecciones de aglomerado de base de cuarzo, acabados nuevos y originales, que son fruto de una investigación a fondo y de un diseño sofisticado. La posibilidad de combinarlos y mezclarlos libremente permite obtener ambientes donde las superficies asumen la características de suavidad y movimiento.\r\n\r\nAdemás de la línea Trafficstone contamos con otras líneas de productos que se trabajan actualmente en Chile a pedido:\r\n\r\n&nbsp;\r\n\r\n<strong><em>Agglosimplex</em></strong>\r\n\r\nAglomerado a base de fragmentos de mármol seleccionados; una colección compuesta de baldosas con texturas de los mármoles más prestigiosos. La uniformidad de los colores, la estabilidad dimensional y la elevada resistencia a la abrasión, a los golpes y a las flexiones hacen que la colección AGGLOSIMPLEX sea la elección ideal tanto para uso doméstico como para la pavimentación de grandes obras.\r\n\r\n&nbsp;\r\n\r\n<strong><em>Marghestone</em></strong>\r\n\r\nMARGHESTONE, el aglomerado a base de granulados de mármol y de especiales resinas de poliéster, a pesar de su sencillez, valoriza el aspecto minimalista de los edificios de alto prestigio. La elección cromática de tonalidades neutras refinadas, desde el Bianco Ghiaccio hasta el Grigio Piave, o que se esfuman en las tonalidades de beige, desde el Toscana hasta el Golden Beige, enriquecidos por el Bianco Mandorla y el Crema, permite crear entornos elegantes y luminosos.", "Novedades", "Nuevos y originales acabados, fruto de una investigación a fondo y de un diseño sofisticad", "inherit", "open", "open", "", "401-revision-12", "", "", "2012-05-24 16:16:30", "2012-05-24 20:16:30", "", "401", "http://santamargherita.s-m.cl/401-revision-12/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("755", "1", "2012-05-14 16:25:45", "2012-05-14 20:25:45", "<a href=\"http://s-m.cl/wp-content/uploads/2012/03/mantencion-copia.jpg\"><img class=\"alignnone size-full wp-image-655\" title=\"mantencion copia\" src=\"http://s-m.cl/wp-content/uploads/2012/03/mantencion-copia.jpg\" alt=\"Mantención\" width=\"576\" height=\"200\" /></a>\r\n\r\nEl PVC es un material inerte, al que no le afecta la salinidad del mar, es insensible a la humedad, y altamente recomendable en ambientes agresivos; pero aún así es necesario mantener algunas condiciones mínimas de limpieza para asegurar su durabilidad.<strong id=\"internal-source-marker_0.037745180539786816\"></strong>\r\n<h4>PAUTAS DE LIMPIEZA</h4>\r\n<ul>\r\n	<li> Las ventanas poseen <strong>ranuras de aireación</strong>, éstas deben mantenerse limpias y sin residuos, de lo contrario, será difícil que cumplan su función.</li>\r\n	<li>Los <strong>perfiles</strong> tienen que limpiarse con un paño suave, agua y jabón neutro. Es necesario aclarar con agua abundante para evitar que queden residuos de jabón.</li>\r\n	<li>Una vez al año, conviene limpiar los <strong>elementos metálicos</strong> (herrajes) y engrasar todas las piezas móviles con aceite exento de ácidos.</li>\r\n	<li>Las <strong>juntas</strong> de cierre y acristalamiento (gomas) se deben limpiar con agua y jabón neutro.</li>\r\n	<li>No se debe utilizar ningún elemento abrasivo o ácidos para limpiar las ventanas.</li>\r\n</ul>\r\n<strong id=\"internal-source-marker_0.037745180539786816\">\r\n</strong>Debido al cierre hermético de las ventanas, es recomendable ventilar los recintos un mínimo de dos veces al día. \"En zonas geográficas con mayor grado de humedad\", es recomendable ampliar los tiempos de ventilación.\r\n\r\n<strong id=\"internal-source-marker_0.037745180539786816\">\r\n</strong>Si tienes alguna duda con respecto a tus ventanas TECNOCOM contáctanos al <strong>+56 (2) 7287186</strong> o a través de nuestro correo electrónico <strong>info@s-m.cl</strong>.\r\n\r\n&nbsp;", "Mantencion Post venta", "Es necesario mantener algunas condiciones de limpieza para asegurar la durabilidad del PVC.", "inherit", "open", "open", "", "407-revision-7", "", "", "2012-05-14 16:25:45", "2012-05-14 20:25:45", "", "407", "http://santamargherita.s-m.cl/407-revision-7/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("407", "1", "2012-03-26 13:45:24", "2012-03-26 20:45:24", "<img class=\"alignnone size-full wp-image-957\" title=\"Mantenimiento\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/mantenimiento.jpg\" alt=\"\" width=\"810\" height=\"328\" />\r\n<h3>MANTENIMIENTO</h3>\r\nLa composición especial, 93% de minerales naturales y 7% de resina de poliéster y pigmentos colorados, da al producto las variaciones de color, medida, forma o distribución de la gravilla de cuarzo y un color de fondo que hacen que sea exclusivo y único, manteniendo inalteradas las características técnicas. Las superficies no necesitan ser tratadas con ceras y, con la finalidad de mantener el estado de limpieza adecuado, se recomienda utilizar productos detergentes con base de alcohol y pH neutro, como por ejemplo productos para la limpieza de superficies de mármol (advertencia: no deben contener ceras).\r\n\r\nNo utilizar productos detergentes demasiado agresivos (pH muy alto o muy bajo). Se recomienda encarecidamente usar soportes para ollas o similares para evitar el contacto directo entre las superficies <img class=\"alignnone size-full wp-image-904\" title=\"santamargherita\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/santamargherita-logo-01.png\" alt=\"\" width=\"80\" height=\"15\" /> y las fuentes de calor (ollas, paellas o platos quitandose del fuego). Para las encimeras con inserciones de nácar es necesario utilizar un producto detergente neutro de uso doméstico.\r\n\r\n<strong>Sustancias Químicas y Disolventes</strong> – Debe evitarse en lo posible el contacto entre las superficies y las sustancias químicas y disolventes, como por ejemplo amoniaco puro o productos detergentes a base de amoniaco, disolventes para uñas, blanqueantes, pinceles con tinta indeleble, jabones aceitosos, disolventes en general (especialmente los disolventes para las pinturas que contienen tricloroetileno y cloruro de metileno), etc.\r\n\r\nEn caso de contacto entre las sustancias antes indicadas y las superficies <img class=\"alignnone size-full wp-image-904\" title=\"santamargherita\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/santamargherita-logo-01.png\" alt=\"\" width=\"80\" height=\"15\" /> aclarar abundantemente de inmediato.", "Mantenimiento", "Condiciones de mantenimiento.", "publish", "open", "open", "", "mantenimiento", "", "", "2012-06-15 00:59:42", "2012-06-15 04:59:42", "", "0", "http://www.navaja.org/multicancha/?p=407", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("801", "1", "2012-05-28 15:29:24", "2012-05-28 19:29:24", "", "Certificaciones", "", "inherit", "open", "open", "", "certificaciones2", "", "", "2012-05-28 15:29:24", "2012-05-28 19:29:24", "", "383", "http://santamargherita.s-m.cl/wp-content/uploads/2012/03/certificaciones2.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("756", "1", "2012-05-24 16:29:17", "2012-05-24 20:29:17", "<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/mantenimiento.jpg\"><img class=\"alignnone size-full wp-image-754\" title=\"Mantenimiento\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/mantenimiento.jpg\" alt=\"\" width=\"576\" height=\"200\" /></a>\r\n\r\nLa composición especial, 93% de minerales naturales y 7% de resina de poliéster y pigmentos colorados, da al producto las variaciones de color, medida, forma o distribución de la gravilla de cuarzo y un color de fondo que hacen que sea exclusivo y único, manteniendo inalteradas las características técnicas. Las superficies no necesitan ser tratadas con ceras y, con la finalidad de mantener el estado de limpieza adecuado, se recomienda utilizar productos detergentes con base de alcohol y pH neutro, como por ejemplo productos para la limpieza de superficies de mármol (advertencia: no deben contener ceras).\r\n\r\nNo utilizar productos detergentes demasiado agresivos (pH muy alto o muy bajo). Se recomienda encarecidamente usar soportes para ollas o similares para evitar el contacto directo entre las superficies SANTAMARGHERITA y las fuentes de calor (ollas, paellas o platos quitandose del fuego). Para las encimeras con inserciones de nácar es necesario utilizar un producto detergente neutro de uso doméstico.\r\n\r\nSUSTANCIAS QUÍMICAS Y DISOLVENTES – Debe evitarse en lo posible el contacto entre las superficies y las sustancias químicas y disolventes, como por ejemplo amoniaco puro o productos detergentes a base de amoniaco, disolventes para uñas, blanqueantes, pinceles con tinta indeleble, jabones aceitosos, disolventes en general (especialmente los disolventes para las pinturas que contienen tricloroetileno y cloruro de metileno), etc.\r\n\r\nEn caso de contacto entre las sustancias antes indicadas y las superficies SANTAMARGHERITA aclarar abundantemente de inmediato.", "Mantenimiento", "Es necesario mantener algunas condiciones de limpieza para asegurar la durabilidad del PVC.", "inherit", "open", "open", "", "407-revision-8", "", "", "2012-05-24 16:29:17", "2012-05-24 20:29:17", "", "407", "http://santamargherita.s-m.cl/407-revision-8/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1317", "1", "2012-06-28 12:13:09", "2012-06-28 16:13:09", "<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/partners2.jpeg\"><img class=\"alignnone size-full wp-image-1063\" title=\"partners2\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/partners2.jpeg\" alt=\"\" width=\"810\" height=\"328\" /></a>\r\n<h3>PARTNERS</h3>\r\n<a href=\"http://kubli.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1050\" title=\"Kubli\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-kubli1.jpg\" alt=\"\" width=\"394\" height=\"78\" /></a><a href=\"http://aei.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1040\" title=\"AEI\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-aei.jpg\" alt=\"\" width=\"386\" height=\"78\" /></a>\r\n\r\n<a href=\"http://bmdiseno.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1042\" title=\"BM Diseño\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-bm.jpg\" alt=\"\" width=\"393\" height=\"112\" /></a><a href=\"http://www.mobel.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1044\" title=\"Mobel\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-mobel.jpg\" alt=\"\" width=\"382\" height=\"112\" /></a>\r\n\r\n<a href=\"http://comercialsym.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1046\" title=\"SYM\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-sym.jpg\" alt=\"\" width=\"392\" height=\"104\" /></a><a href=\"http://unna.com.br\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1047\" title=\"Unna\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-unna.jpg\" alt=\"\" width=\"381\" height=\"103\" /></a>\r\n\r\n<a href=\"http://www.florense.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1314\" title=\"p-florense\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-florense.png\" alt=\"\" width=\"393\" height=\"82\" /></a>\r\n\r\n&nbsp;\r\n<h5>En Regiones:</h5>\r\n<img class=\"alignnone size-full wp-image-1053\" title=\"Casa Kit\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-casakit.jpg\" alt=\"\" width=\"292\" height=\"108\" /><a href=\"http://www.madestone.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1054\" title=\"Madestone\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-madestone.jpg\" alt=\"\" width=\"256\" height=\"110\" /></a><a href=\"http://www.espaciodinamico.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1055\" title=\"Espacio Dinámico\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-espaciodinamico.jpg\" alt=\"\" width=\"233\" height=\"111\" /></a>\r\n\r\n<a href=\"http://www.mobilinares.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1056\" title=\"Mobilinares\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-mobilinares.jpg\" alt=\"\" width=\"291\" height=\"78\" /></a><a href=\"http://www.staubmuebles.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1057\" title=\"Staub\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-staub.jpg\" alt=\"\" width=\"255\" height=\"77\" /></a><a href=\"http://www.disypro.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1058\" title=\"disypro\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-disypro.jpg\" alt=\"\" width=\"231\" height=\"79\" /></a>", "Partners", "", "inherit", "closed", "closed", "", "969-revision-v1", "", "", "2012-06-28 12:13:09", "2012-06-28 16:13:09", "", "969", "http://santamargherita.s-m.cl/969-revision-18/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("901", "1", "2012-05-28 20:12:00", "2012-05-29 00:12:00", "<img class=\"alignnone size-full wp-image-794\" title=\"Colores\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/colores2.jpg\" alt=\"\" width=\"810\" height=\"328\" />\r\n<h3>COLORES</h3>\r\nEl aglomerado SANTAMARGHERITA , a base de arenas de cuarzo y resina, es un producto de elevadas características estéticas con una alta resistencia a la flexión, a la abrasión y a los ácidos. Innovador y con altas prestaciones técnicas es un material que se presenta de manera muy homogénea y uniforme, además de ser particularmente versátil en lo que se refiere a la coloración.<em></em>\r\n\r\nLa amplia gama de colores y granulometrías y una tecnología de vanguardia se presentan bajo forma de superficies con varias posibilidades de uso, los colores neutros y las tonalidades más fuertes permiten combinaciones personales e inéditas.\r\n<div style=\"clear: both; height: 12px; border-top: 1px solid #000; width: 100%;\"></div>\r\n<strong><em>Línea Trafficstone</em></strong>\r\n\r\n[caption id=\"attachment_767\" align=\"alignleft\" width=\"84\" caption=\"Amalfi\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Amalfi-b.jpg\"><img class=\" wp-image-767   \" title=\"Amalfi\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Amalfi-b-116x116.jpg\" alt=\"\" width=\"84\" height=\"84\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_768\" align=\"alignleft\" width=\"84\" caption=\"Antracite\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Antracite-b.jpg\"><img class=\" wp-image-768  \" title=\"Antracite\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Antracite-b-116x116.jpg\" alt=\"\" width=\"84\" height=\"84\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_770\" align=\"alignleft\" width=\"84\" caption=\"Aosta\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Aosta-b.jpg\"><img class=\" wp-image-770  \" title=\"Aosta\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Aosta-b-116x116.jpg\" alt=\"\" width=\"84\" height=\"84\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_772\" align=\"alignleft\" width=\"84\" caption=\"Apulia\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Apulia-b.jpg\"><img class=\" wp-image-772  \" title=\"Apulia\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Apulia-b-116x116.jpg\" alt=\"\" width=\"84\" height=\"84\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_773\" align=\"alignleft\" width=\"84\" caption=\"Atena\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Atena-b.jpg\"><img class=\" wp-image-773  \" title=\"Atena\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Atena-b-116x116.jpg\" alt=\"\" width=\"84\" height=\"84\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_775\" align=\"alignleft\" width=\"84\" caption=\"Auby\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Auby-b.jpg\"><img class=\" wp-image-775  \" title=\"Auby\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Auby-b-116x116.jpg\" alt=\"\" width=\"84\" height=\"84\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_776\" align=\"alignleft\" width=\"84\" caption=\"Belvedere\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Belvedere-b.jpg\"><img class=\" wp-image-776  \" title=\"Belvedere-b\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Belvedere-b-116x116.jpg\" alt=\"\" width=\"84\" height=\"84\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_804\" align=\"alignleft\" width=\"84\" caption=\"Breda\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Breda-b.jpg\"><img class=\" wp-image-804   \" title=\"Breda\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Breda-b-116x116.jpg\" alt=\"\" width=\"84\" height=\"84\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_805\" align=\"alignleft\" width=\"84\" caption=\"Caledonia\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Caledonia-b.jpg\"><img class=\" wp-image-805   \" title=\"Caledonia\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Caledonia-b-116x116.jpg\" alt=\"\" width=\"84\" height=\"84\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_806\" align=\"alignleft\" width=\"84\" caption=\"Camargue\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Camargue-b.jpg\"><img class=\" wp-image-806   \" title=\"Camargue\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Camargue-b-116x116.jpg\" alt=\"\" width=\"84\" height=\"84\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_807\" align=\"alignleft\" width=\"84\" caption=\"Carnia\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Carnia-b.jpg\"><img class=\" wp-image-807   \" title=\"Carnia\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Carnia-b-116x116.jpg\" alt=\"\" width=\"84\" height=\"84\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_808\" align=\"alignleft\" width=\"84\" caption=\"Catalina\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Catalina-b.jpg\"><img class=\" wp-image-808   \" title=\"Catalina\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Catalina-b-116x116.jpg\" alt=\"\" width=\"84\" height=\"84\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_809\" align=\"alignleft\" width=\"84\" caption=\"Friuli\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Friuli-b.jpg\"><img class=\" wp-image-809   \" title=\"Friuli\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Friuli-b-116x116.jpg\" alt=\"\" width=\"84\" height=\"84\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_812\" align=\"alignleft\" width=\"84\" caption=\"Hermitage\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Hermitage-b.jpg\"><img class=\" wp-image-812  \" title=\"Hermitage\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Hermitage-b-116x116.jpg\" alt=\"\" width=\"84\" height=\"84\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_813\" align=\"alignleft\" width=\"84\" caption=\"Istria\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Istria-b.jpg\"><img class=\" wp-image-813  \" title=\"Istria\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Istria-b-116x116.jpg\" alt=\"\" width=\"84\" height=\"84\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_814\" align=\"alignleft\" width=\"84\" caption=\"Itaca\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Itaca-b.jpg\"><img class=\" wp-image-814  \" title=\"Itaca\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Itaca-b-116x116.jpg\" alt=\"\" width=\"84\" height=\"84\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_815\" align=\"alignleft\" width=\"84\" caption=\"Miami\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Miami-b.jpg\"><img class=\" wp-image-815  \" title=\"Miami\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Miami-b-116x116.jpg\" alt=\"\" width=\"84\" height=\"84\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_816\" align=\"alignleft\" width=\"84\" caption=\"Miramare\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Miramare-b.jpg\"><img class=\" wp-image-816  \" title=\"Miramare\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Miramare-b-116x116.jpg\" alt=\"\" width=\"84\" height=\"84\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_817\" align=\"alignleft\" width=\"84\" caption=\"Modena\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Modena-b.jpg\"><img class=\" wp-image-817  \" title=\"Modena\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Modena-b-116x116.jpg\" alt=\"\" width=\"84\" height=\"84\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_818\" align=\"alignleft\" width=\"84\" caption=\"Naxos\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Naxos-b.jpg\"><img class=\" wp-image-818  \" title=\"Naxos\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Naxos-b-116x116.jpg\" alt=\"\" width=\"84\" height=\"84\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_819\" align=\"alignleft\" width=\"84\" caption=\"Nero\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Nero-b.jpg\"><img class=\" wp-image-819  \" title=\"Nero\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Nero-b-116x116.jpg\" alt=\"\" width=\"84\" height=\"84\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_820\" align=\"alignleft\" width=\"84\" caption=\"Otello\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Otello-b.jpg\"><img class=\" wp-image-820  \" title=\"Otello\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Otello-b-116x116.jpg\" alt=\"\" width=\"84\" height=\"84\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_821\" align=\"alignleft\" width=\"84\" caption=\"Pompei\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Pompei-b.jpg\"><img class=\" wp-image-821  \" title=\"Pompei\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Pompei-b-116x116.jpg\" alt=\"\" width=\"84\" height=\"84\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_822\" align=\"alignleft\" width=\"84\" caption=\"Prussia\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Prussia-b.jpg\"><img class=\" wp-image-822  \" title=\"Prussia\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Prussia-b-116x116.jpg\" alt=\"\" width=\"84\" height=\"84\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_823\" align=\"alignleft\" width=\"84\" caption=\"Rinmini\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Rinmini-b.jpg\"><img class=\" wp-image-823  \" title=\"Rinmini\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Rinmini-b-116x116.jpg\" alt=\"\" width=\"84\" height=\"84\" /></a>[/caption]\r\n\r\n<div style=\"clear: both; height: 12px; border-top: 1px solid #000; width: 100%;\"></div>\r\n<strong><em>Línea Stardust</em></strong>\r\n\r\n[caption id=\"attachment_840\" align=\"alignleft\" width=\"84\" caption=\"Beige Stardust\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Beige-Stardust-b.jpg\"><img class=\" wp-image-840  \" title=\"Beige Stardust\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Beige-Stardust-b-116x116.jpg\" alt=\"\" width=\"84\" height=\"84\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_841\" align=\"alignleft\" width=\"84\" caption=\"Bianco Stardust\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Bianco-Stardust-b.jpg\"><img class=\" wp-image-841  \" title=\"Bianco Stardust\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Bianco-Stardust-b-116x116.jpg\" alt=\"\" width=\"84\" height=\"84\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_842\" align=\"alignleft\" width=\"84\" caption=\"Blu Stardust\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Blu-Stardust-b.jpg\"><img class=\" wp-image-842  \" title=\"Blu Stardust\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Blu-Stardust-b-116x116.jpg\" alt=\"\" width=\"84\" height=\"84\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_843\" align=\"alignleft\" width=\"84\" caption=\"Giallo Stardust\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Giallo-Stardust-b.jpg\"><img class=\" wp-image-843  \" title=\"Giallo Stardust\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Giallo-Stardust-b-116x116.jpg\" alt=\"\" width=\"84\" height=\"84\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_844\" align=\"alignleft\" width=\"84\" caption=\"Nero Stardust\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Nero-Stardust-b.jpg\"><img class=\" wp-image-844  \" title=\"Nero Stardust\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Nero-Stardust-b-116x116.jpg\" alt=\"\" width=\"84\" height=\"84\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_845\" align=\"alignleft\" width=\"84\" caption=\"Pastel Green St.\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Pastel-Green-Stardust-b.jpg\"><img class=\" wp-image-845  \" title=\"Pastel Green Stardust\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Pastel-Green-Stardust-b-116x116.jpg\" alt=\"\" width=\"84\" height=\"84\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_846\" align=\"alignleft\" width=\"84\" caption=\"Rosa Stardust\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Rosa-Stardust-b.jpg\"><img class=\" wp-image-846  \" title=\"Rosa Stardust\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Rosa-Stardust-b-116x116.jpg\" alt=\"\" width=\"84\" height=\"84\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_847\" align=\"alignleft\" width=\"84\" caption=\"Rosso Stardust\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Rosso-Stardust-b.jpg\"><img class=\" wp-image-847  \" title=\"Rosso Stardust\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Rosso-Stardust-b-116x116.jpg\" alt=\"\" width=\"84\" height=\"84\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_848\" align=\"alignleft\" width=\"84\" caption=\"Sky Stardust\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Sky-Stardust-b.jpg\"><img class=\" wp-image-848  \" title=\"Sky Stardust\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Sky-Stardust-b-116x116.jpg\" alt=\"\" width=\"84\" height=\"84\" /></a>[/caption]\r\n\r\n<div style=\"clear: both; height: 12px; border-top: 1px solid #000; width: 100%;\"></div>\r\n<em><strong>Línea Reff</strong></em>", "Colores", "Amplia gama de colores y granulometrías.", "inherit", "open", "open", "", "379-revision-v1", "", "", "2012-05-28 20:12:00", "2012-05-29 00:12:00", "", "379", "http://santamargherita.s-m.cl/379-revision-44/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("452", "1", "2012-04-05 01:16:52", "2012-04-05 08:16:52", "<div style=\"position:relative;top:-18px;\">\r\n<h3><img class=\"alignnone size-full wp-image-860\" title=\"Contacto\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/04/contacto.jpg\" alt=\"\" width=\"810\" height=\"328\" /></h3>\r\n<h3>CONTACTO</h3>\r\n[contact_form]\r\n</div>", "Contacto", "", "publish", "closed", "closed", "", "contacto", "", "", "2012-05-30 10:30:47", "2012-05-30 14:30:47", "", "0", "http://www.navaja.org/multicancha/?page_id=452", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("456", "1", "2012-04-05 01:19:40", "2012-04-05 08:19:40", "<img class=\"alignnone size-full wp-image-874\" title=\"Profesional\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/05/cocina1.jpg\" alt=\"\" width=\"810\" height=\"328\" />\r\n<h3>PROFESIONAL</h3>\r\n<div style=\"float: left; width: 410px;\"><strong>Ficha técnica Cuarzo</strong>\r\n[gview file=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/04/Ficha-tecnica-cuarzo.pdf\"]</div>\r\n<div style=\"float: left; width: 380px;\"><strong>Ficha técnica Mármol</strong>\r\n[gview file=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/04/Ficha-tecnica-Marmol.pdf\"]</div>", "Profesional", "", "publish", "closed", "closed", "", "profesional", "", "", "2012-06-13 12:38:00", "2012-06-13 16:38:00", "", "0", "http://www.navaja.org/multicancha/?page_id=456", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("718", "1", "2012-04-26 10:32:07", "2012-04-26 14:32:07", "<a href=\"http://s-m.cl/wp-content/uploads/2012/03/mantencion-copia.jpg\"><img class=\"alignnone size-full wp-image-655\" title=\"mantencion copia\" src=\"http://s-m.cl/wp-content/uploads/2012/03/mantencion-copia.jpg\" alt=\"Mantención\" width=\"576\" height=\"200\" /></a>\r\n\r\nEl PVC es un material inerte, al que no le afecta la salinidad del mar, es insensible a la humedad, y altamente recomendable en ambientes agresivos; pero aún así es necesario mantener algunas condiciones mínimas de limpieza para asegurar su durabilidad.<strong id=\"internal-source-marker_0.037745180539786816\"></strong>\r\n<h4>PAUTAS DE LIMPIEZA</h4>\r\n<ul>\r\n	<li> Las ventanas poseen <strong>ranuras de aireación</strong>, éstas deben mantenerse limpias y sin residuos, de lo contrario, será difícil que cumplan su función.</li>\r\n	<li>Los <strong>perfiles</strong> tienen que limpiarse con un paño suave, agua y jabón neutro. Es necesario aclarar con agua abundante para evitar que queden residuos de jabón.</li>\r\n	<li>Una vez al año, conviene limpiar los <strong>elementos metálicos</strong> (herrajes) y engrasar todas las piezas móviles con aceite exento de ácidos.</li>\r\n	<li>Las <strong>juntas</strong> de cierre y acristalamiento (gomas) se deben limpiar con agua y jabón neutro.</li>\r\n	<li>No se debe utilizar ningún elemento abrasivo o ácidos para limpiar las ventanas.</li>\r\n</ul>\r\n<strong id=\"internal-source-marker_0.037745180539786816\">\r\n</strong>Debido al cierre hermético de las ventanas, es recomendable ventilar los recintos un mínimo de dos veces al día. \"En zonas geográficas con mayor grado de humedad\", es recomendable ampliar los tiempos de ventilación.\r\n\r\n<strong id=\"internal-source-marker_0.037745180539786816\">\r\n</strong>Si tienes alguna duda con respecto a tus ventanas TECNOCOM comunícate con nuestro servicio de Post-Venta al número de teléfono\r\n<strong>+56 (2) 7287186.</strong>\r\n\r\n<strong></strong>\r\nTambién puedes contactarte con nosotros a través de nuestro correo electrónico <em>info@s-m.cl</em> o visitar nuestra página web <strong>www.s-m.cl</strong>\r\n\r\n&nbsp;", "Mantencion Post venta", "Es necesario mantener algunas condiciones de limpieza para asegurar la durabilidad del PVC.", "inherit", "open", "open", "", "407-revision-5", "", "", "2012-04-26 10:32:07", "2012-04-26 14:32:07", "", "407", "http://s-m.cl/407-revision-5/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("557", "1", "2012-04-13 06:05:43", "2012-04-13 06:05:43", " ", "", "", "publish", "open", "closed", "", "557", "", "", "2014-04-30 12:03:40", "2014-04-30 16:03:40", "", "0", "http://s-m.cl/?p=557", "7", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("564", "1", "2012-03-26 20:18:19", "2012-03-27 03:18:19", "<img class=\"alignnone size-large wp-image-384\" title=\"eficiencia\" src=\"http://s-m.cl/wp-content/uploads/2012/03/eficiencia-500x375.jpg\" alt=\"\" width=\"500\" height=\"375\" />\n\nNuestro compromiso con el medio ambiente se basa desde el reciclaje de nuestros productos, de manera de ahorrar energía en los procesos de producción y en la fabricación de materias primas, además de cumplir con los estándares Europeos de fabricación para no dañar el medio ambiente.\n\nConstantemente estamos desarrollando tecnologías que nos permitan crear perfiles que tengan una mayor capacidad aislante, para llevar hasta tu casa el concepto de ahorro de energía y de esta manera contribuir con el medio ambiente como compromiso no solo de nuestra empresa, sino también a través de cada uno de nuestros clientes.", "Eficiencia energética", "", "inherit", "open", "open", "", "383-revision", "", "", "2012-03-26 20:18:19", "2012-03-27 03:18:19", "", "383", "http://s-m.cl/383-revision/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("562", "1", "2012-03-26 22:09:31", "2012-03-27 05:09:31", "<img class=\"alignnone size-full wp-image-373\" title=\"garantia\" src=\"http://s-m.cl/wp-content/uploads/2012/03/garantia.jpg\" alt=\"\" width=\"400\" height=\"460\" />\n\n<strong>Garantía</strong>\n\nTecnocom ha desarrollado un compuesto de PVC bajo las mas estrictas normas de calidad. Es por esto que el los perfiles de color blanco cuentan con una garantía de 7 años. Para los perfiles de color, Tecnocom trabaja con la firma Alemana SKAI, la cual da una garantía de 5 años sobre el folio. Infórmese sobre las condiciones y alcances de la garantía.\n\n<strong>Calidad</strong>\n\nUn proceso de calidad continuo es sinónimo de una marca líder. Desde la fabricación del compuesto hasta la extrusión y foliado del perfil, Tecnocom cuenta con un departamento de calidad para asegurar la entrega de un producto de clase mundial.\n\nDos laboratorios, uno de compuestos de PVC otro de Perfiles de PVC, colaboran continuamente en verificar los estándares de trabajo.", "Garantía &amp; calidad", "", "inherit", "open", "open", "", "372-revision", "", "", "2012-03-26 22:09:31", "2012-03-27 05:09:31", "", "372", "http://s-m.cl/372-revision/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("743", "1", "2012-05-24 15:44:04", "2012-05-24 19:44:04", "<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/aplicaciones.jpg\"><img class=\"alignnone size-full wp-image-738\" title=\"Aplicaciones\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/aplicaciones.jpg\" alt=\"\" width=\"576\" height=\"200\" /></a>\r\n\r\n@font-face { font-family: \"Calibri\"; }p.MsoNormal, li.MsoNormal, div.MsoNormal { margin: 0cm 0cm 10pt; line-height: 115%; font-size: 11pt; font-family: \"Times New Roman\"; }div.Section1 { page: Section1; }\r\n\r\n<strong><em>Aglomerado de Cuarzo para encimeras de Cocina y Baño</em></strong>\r\n\r\nCada casa refleja la personalidad de quienes viven en ella. Caracteres, gustos y estilos que pueden llegar a ser infinitos, opuestos entre ellos; desde el neoclásico hasta el barroco, desde la ostentación hasta el minimalismo, con el uso de una paleta de colores desde las tonalidades más claras hasta las más fuertes.<strong><em></em></strong>\r\n\r\nSANTAMARGHERITA, a través de una investigación constante, crea superficies con altas prestaciones técnicas y que son estéticamente capaces de hacer que los ambientes domésticos sean únicos satisfaciendo perfectamente las diferentes exigencias.\r\n\r\nEl material ideal para pavimentos y revestimientos, cabinas de ducha y encimeras de cocina y baño se caracteriza, por un lado, por la alta resistencia a la flexión, abrasión y ácidos, y por el otro, por la variedad de colores y texturas más neutras o con mayor profundidad y efectos de movimiento.\r\n\r\nActualmente en el diseño de interiores está marcado el uso de tamaño cada vez más grandes y personalizados, por tanto las colecciones de aglomerado con base de cuarzo SANTAMARGHERITA se proponen en baldosas de dimensiones estándares o variables. Para cada proyecto, para cada exigencia, para cada gusto, SANTAMARGHERITA dispone de la superficie ideal.\r\n\r\n&nbsp;\r\n\r\n<strong><em>Aglomerado de Cuarzo para superficies de grandes obras</em></strong>\r\n\r\nAeropuertos, estaciones de trenes, centros comerciales, grandes superficies en todo el mundo ostentan actualmente pavimentos y revestimientos con la marca SANTAMARGHERITA. Las potencialidades del aglomerado de cuarzo permiten que SANTAMARGHERITA responda a las exigencias en lo que se refiere a complejidad y personalidad de cada proyecto, a partir del suministro de grandes volúmenes hasta un servicio de investigación y desarrollo de nuevos colores personalizados que dan originalidad y unicidad al producto.\r\n\r\n&nbsp;", "Aplicaciones", "El sistema de gestión de calidad se encuentra certificado por IRAM.", "inherit", "open", "open", "", "386-revision-5", "", "", "2012-05-24 15:44:04", "2012-05-24 19:44:04", "", "386", "http://santamargherita.s-m.cl/386-revision-5/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("566", "1", "2012-03-26 19:27:08", "2012-03-27 02:27:08", "<img class=\"alignnone size-full wp-image-387\" title=\"certificado\" src=\"http://s-m.cl/wp-content/uploads/2012/03/certificado.jpg\" alt=\"\" width=\"305\" height=\"397\" />\n\nEl sistema de gestión de calidad para la fabricación de compuestos y masterbatch de PVC de la planta de Pablo de Podestá, se encuentra certificado por IRAM, con las normas ISO 9001:2008 y está acreditado ante INN (Chile), OAA (Argentina) e IQNet (Red Internacional).\n\n&nbsp;", "Certificaciones", "", "inherit", "open", "open", "", "386-revision", "", "", "2012-03-26 19:27:08", "2012-03-27 02:27:08", "", "386", "http://s-m.cl/386-revision/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("568", "1", "2012-03-26 18:39:35", "2012-03-27 01:39:35", "<h4><img class=\"alignnone size-full wp-image-532\" title=\"proyectos_OK\" src=\"http://s-m.cl/wp-content/uploads/2012/03/proyectos_OK.jpg\" alt=\"\" width=\"576\" height=\"200\" /></h4>\n<h4>Explora</h4>\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora1.jpg\"><img class=\"alignnone  wp-image-512\" title=\"explora1\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora2.jpg\"><img class=\"alignnone  wp-image-513\" title=\"explora2\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora3.jpg\"><img class=\"alignnone  wp-image-514\" title=\"explora3\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora4.jpg\"><img class=\"alignnone  wp-image-515\" title=\"explora4\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora5.jpg\"><img class=\"alignnone  wp-image-516\" title=\"explora5\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\n<h4>Los Bravos</h4>\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos1.jpg\"><img class=\"alignnone  wp-image-523\" title=\"bravos1\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos2.jpg\"><img class=\"alignnone  wp-image-526\" title=\"bravos2\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos3.jpg\"><img class=\"alignnone  wp-image-524\" title=\"bravos3\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos4.jpg\"><img class=\"alignnone  wp-image-525\" title=\"bravos4\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos5.jpg\"><img class=\"alignnone  wp-image-527\" title=\"bravos5\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\n<h4>Los Candiles</h4>\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles1.jpeg\"><img class=\"alignnone  wp-image-529\" title=\"candiles1\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <img class=\"alignnone  wp-image-533\" title=\"candiles2\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-530\" title=\"candiles3\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-531\" title=\"candiles4\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-534\" title=\"candiles5\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />\n<h4>Hotel Zapallar</h4>\n<img class=\"alignnone  wp-image-536\" title=\"IMG_5194\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5194-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-537\" title=\"IMG_5195\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5195-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-549\" title=\"IMG_5197\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5197-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-550\" title=\"IMG_5200\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5200-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-551\" title=\"IMG_5201\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5201-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /><img class=\"alignnone  wp-image-552\" title=\"IMG_5204\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5204-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-552\" title=\"IMG_5204\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5204-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-553\" title=\"IMG_5206\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5206-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-554\" title=\"IMG_5209\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5209-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />\n<h4>Casa Vichuquen</h4>\n<img class=\"alignnone  wp-image-539\" title=\"comedor\" src=\"http://s-m.cl/wp-content/uploads/2012/03/comedor-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-540\" title=\"Living\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Living-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-541\" title=\"pasillo interior\" src=\"http://s-m.cl/wp-content/uploads/2012/03/pasillo-interior-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-542\" title=\"Puerta 2\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta-2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-543\" title=\"Puerta\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /><img class=\"alignnone  wp-image-544\" title=\"Terraza 3\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-545\" title=\"Terraza 4\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-546\" title=\"Terraza\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />", "Proyectos destacados", "", "inherit", "open", "open", "", "398-revision", "", "", "2012-03-26 18:39:35", "2012-03-27 01:39:35", "", "398", "http://s-m.cl/398-revision/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("567", "1", "2012-04-13 04:34:18", "2012-04-13 08:34:18", "&nbsp;\r\n\r\n<img class=\"alignnone size-full wp-image-565\" title=\"certificaciones_OK\" src=\"http://s-m.cl/wp-content/uploads/2012/03/certificaciones_OK.jpg\" alt=\"\" width=\"576\" height=\"200\" />\r\n\r\nEl sistema de gestión de calidad para la fabricación de compuestos y masterbatch de PVC de la planta de Pablo de Podestá, se encuentra certificado por IRAM, con las normas ISO 9001:2008 y está acreditado ante INN (Chile), OAA (Argentina) e IQNet (Red Internacional).\r\n\r\n&nbsp;", "Certificaciones", "", "inherit", "open", "open", "", "386-revision-2", "", "", "2012-04-13 04:34:18", "2012-04-13 08:34:18", "", "386", "http://s-m.cl/386-revision-2/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("570", "1", "2012-06-13 15:26:38", "2012-06-13 19:26:38", "<img class=\"alignnone size-full wp-image-788\" title=\"Novedades\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/novedades3.jpg\" alt=\"\" width=\"810\" height=\"328\" />\n<h3>NOVEDADES</h3>\nSANTAMARGHERITA además de los tradicionales efectos brillante, pulido, cepillado y envejecido, añade a sus colecciones de aglomerado de base de cuarzo, acabados nuevos y originales, que son fruto de una investigación a fondo y de un diseño sofisticado. La posibilidad de combinarlos y mezclarlos libremente permite obtener ambientes donde las superficies asumen la características de suavidad y movimiento.\n\nAdemás de la línea Trafficstone contamos con otras líneas de productos que se trabajan actualmente en Chile a pedido:\n\n<strong><em>Agglosimplex</em></strong>\n\nAglomerado a base de fragmentos de mármol seleccionados; una colección compuesta de baldosas con texturas de los mármoles más prestigiosos. La uniformidad de los colores, la estabilidad dimensional y la elevada resistencia a la abrasión, a los golpes y a las flexiones hacen que la colección AGGLOSIMPLEX sea la elección ideal tanto para uso doméstico como para la pavimentación de grandes obras.\n\n<strong><em>Marghestone</em></strong>\n\nMARGHESTONE, el aglomerado a base de granulados de mármol y de especiales resinas de poliéster, a pesar de su sencillez, valoriza el aspecto minimalista de los edificios de alto prestigio. La elección cromática de tonalidades neutras refinadas, desde el Bianco Ghiaccio hasta el Grigio Piave, o que se esfuman en las tonalidades de beige, desde el Toscana hasta el Golden Beige, enriquecidos por el Bianco Mandorla y el Crema, permite crear entornos elegantes y luminosos.\n\n&nbsp;\n\n<img class=\"alignnone size-full wp-image-1079\" title=\"glitters\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/glitters.jpg\" alt=\"\" width=\"593\" height=\"134\" />\n\nEstá por lanzarse la nueva gama a base de cuarzo de la empresa veronesa <strong>Santa Margherita S.p.A</strong>., empresa veronesa especializada en la producción y comercialización de aglomerados de mármol y cuarzo, no deja de sorprender y presenta una nueva gama de colores “glitter” que ha sido creada por el profundo interés de la empresa en la arquitectura y diseño, uniendo investigación y experimentación.\n\nDespués del éxito obtenido en la feria Marmomacc 2010 por el concepto de exposición “The HALL by Santamargherita®” que reproducía la recepción de un gran hotel de lujo, la empresa propone actualmente una nueva solución destinada a embellecer y a hacer únicos los ambientes prestigiosos y de alto nivel.\n\nSe ha creado por tanto una colección exclusiva con base de cuarzo y glitter en fondos metálicos y refinados, cuyas muestras están siendo realizadas actualmente por <strong>SANTAMARGHERITA®</strong> en los tonos <strong>Gold</strong>, <strong>Silver</strong> y <strong>Pewter</strong>; posteriormente se ampliará la gama de colores disponibles sobre la base de los pedidos de los diseñadores de interiores y de sus clientes clave.\n\nEsta nueva colección es apropiada para todo tipo de aplicaciones, pero principalmente ha sido creada para las encimeras de baño de alto nivel, pavimentos, revestimientos y para la decoración de negocios, los nuevos cuarzos glitter serán presentados oficialmente, como se acostumbra, durante las próximas ferias en las que la empresa participará.\n\n&nbsp;", "Novedades", "Nuevos y originales acabados, fruto de una investigación a fondo y un diseño sofisticado.", "inherit", "open", "open", "", "401-autosave", "", "", "2012-06-13 15:26:38", "2012-06-13 19:26:38", "", "401", "http://s-m.cl/401-autosave/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("571", "1", "2012-03-26 17:41:46", "2012-03-27 00:41:46", "<img class=\"alignnone size-full wp-image-402\" title=\"news\" src=\"http://s-m.cl/wp-content/uploads/2012/03/news.jpg\" alt=\"\" width=\"421\" height=\"500\" />\n\n<strong>Sistema de apertura corredizo/paño fijo</strong>\n\n<strong>\n</strong>PVC Tecnocom ha lanzado al mercado un nuevo sistema de apertura CORREDIZO/PAÑO FIJO,  con el se pueden combinar aperturas de hojas móviles y paños fijos de medidas variadas y de hasta cuatro paños fijos.\n\n<span style=\"color: #ff0000;\"><strong>Falta esquema de ventanas.</strong></span>\n\n<strong>\nFolio Interior en ventanas de piso a cielo.</strong>\n\n<strong>\n</strong>PVC Tecnocom ha desarrollado dentro de sus productos una línea de perfiles destinada a entregar soluciones para ventanas de hojas móviles de piso a cielo, con el interior del marco foliado del mismo tono que el exterior del perfil, de manera de otorgar a las terminaciones de sus ventanas un acabado pulcro y homogéneo.\nSouth Merchants es la primera empresa en Chile en incorporar esta tecnología a sus soluciones de ventanas, entregándole al cliente un plus para el diseño de sus proyectos.\n\n<strong>\n<span style=\"color: #ff0000;\">Falta foto perfil foliado interiormente.</span></strong>", "Novedades", "", "inherit", "open", "open", "", "401-revision", "", "", "2012-03-26 17:41:46", "2012-03-27 00:41:46", "", "401", "http://s-m.cl/401-revision/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("573", "1", "2012-03-26 13:45:24", "2012-03-26 20:45:24", "<img class=\"alignnone  wp-image-408\" title=\"mantencion\" src=\"http://s-m.cl/wp-content/uploads/2012/03/mantencion.jpg\" alt=\"\" width=\"510\" height=\"383\" />\n\nEl PVC es un material inerte, al que no le afecta la salinidad del mar, es insensible a la humedad, y altamente recomendable en ambientes agresivos; pero aún así es necesario mantener algunas condiciones mínimas de limpieza para asegurar su durabilidad.<strong id=\"internal-source-marker_0.037745180539786816\">\n\nPAUTAS DE LIMPIEZA\n</strong>\n<ul>\n	<li> Las ventanas poseen <strong>ranuras de aireación</strong>, éstas deben mantenerse limpias y sin residuos, de lo contrario, será difícil que cumplan su función.</li>\n	<li>Los <strong>perfiles</strong> tienen que limpiarse con un paño suave, agua y jabón neutro. Es necesario aclarar con agua abundante para evitar que queden residuos de jabón.</li>\n	<li>Una vez al año, conviene limpiar los <strong>elementos metálicos</strong> (herrajes) y engrasar todas las piezas móviles con aceite exento de ácidos.</li>\n	<li>Las <strong>juntas</strong> de cierre y acristalamiento (gomas) se deben limpiar con agua y jabón neutro.</li>\n	<li>No se debe utilizar ningún elemento abrasivo o ácidos para limpiar las ventanas.</li>\n</ul>\n<strong id=\"internal-source-marker_0.037745180539786816\">\n</strong>Debido al cierre hermético de las ventanas, es recomendable ventilar los recintos un mínimo de dos veces al día. \"En zonas geográficas con mayor grado de humedad\", es recomendable ampliar los tiempos de ventilación.\n\n<strong id=\"internal-source-marker_0.037745180539786816\">\n</strong>Si tienes alguna duda con respecto a\ntus ventanas TECNOCOM\ncomunícate con nuestro servicio de\nPost-Venta al número de teléfono\n<strong>+56 (2) 7287186</strong>\nTambién puedes contactarte con\nnosotros a través de nuestro correo\nelectrónico <em>info@s-m.cl</em> o visitar\nnuestra página web <strong>www.s-m.cl</strong>\n\n&nbsp;", "Mantencion Post venta", "", "inherit", "open", "open", "", "407-revision", "", "", "2012-03-26 13:45:24", "2012-03-26 20:45:24", "", "407", "http://s-m.cl/407-revision/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("574", "1", "2012-04-13 04:40:13", "2012-04-13 08:40:13", "&nbsp;\r\n\r\n<img class=\"alignnone size-full wp-image-572\" title=\"mantencion_OK\" src=\"http://s-m.cl/wp-content/uploads/2012/03/mantencion_OK.jpg\" alt=\"\" width=\"576\" height=\"200\" />\r\n\r\nEl PVC es un material inerte, al que no le afecta la salinidad del mar, es insensible a la humedad, y altamente recomendable en ambientes agresivos; pero aún así es necesario mantener algunas condiciones mínimas de limpieza para asegurar su durabilidad.<strong id=\"internal-source-marker_0.037745180539786816\"></strong>\r\n\r\nPAUTAS DE LIMPIEZA\r\n<ul>\r\n	<li> Las ventanas poseen <strong>ranuras de aireación</strong>, éstas deben mantenerse limpias y sin residuos, de lo contrario, será difícil que cumplan su función.</li>\r\n	<li>Los <strong>perfiles</strong> tienen que limpiarse con un paño suave, agua y jabón neutro. Es necesario aclarar con agua abundante para evitar que queden residuos de jabón.</li>\r\n	<li>Una vez al año, conviene limpiar los <strong>elementos metálicos</strong> (herrajes) y engrasar todas las piezas móviles con aceite exento de ácidos.</li>\r\n	<li>Las <strong>juntas</strong> de cierre y acristalamiento (gomas) se deben limpiar con agua y jabón neutro.</li>\r\n	<li>No se debe utilizar ningún elemento abrasivo o ácidos para limpiar las ventanas.</li>\r\n</ul>\r\n<strong id=\"internal-source-marker_0.037745180539786816\">\r\n</strong>Debido al cierre hermético de las ventanas, es recomendable ventilar los recintos un mínimo de dos veces al día. \"En zonas geográficas con mayor grado de humedad\", es recomendable ampliar los tiempos de ventilación.\r\n\r\n<strong id=\"internal-source-marker_0.037745180539786816\">\r\n</strong>Si tienes alguna duda con respecto a\r\ntus ventanas TECNOCOM\r\ncomunícate con nuestro servicio de\r\nPost-Venta al número de teléfono\r\n<strong>+56 (2) 7287186</strong>\r\nTambién puedes contactarte con\r\nnosotros a través de nuestro correo\r\nelectrónico <em>info@s-m.cl</em> o visitar\r\nnuestra página web <strong>www.s-m.cl</strong>\r\n\r\n&nbsp;", "Mantencion Post venta", "", "inherit", "open", "open", "", "407-revision-2", "", "", "2012-04-13 04:40:13", "2012-04-13 08:40:13", "", "407", "http://s-m.cl/407-revision-2/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("575", "1", "2013-08-07 16:56:00", "2013-08-07 20:56:00", "<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/colores.jpg\"><img class=\"alignnone size-full wp-image-1312\" title=\"Colores\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/colores.jpg\" width=\"810\" height=\"328\" /></a>\n<h3>COLORES</h3>\nEl aglomerado <img class=\"alignnone size-full wp-image-904\" title=\"\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/santamargherita-logo-01.png\" width=\"80\" height=\"15\" />, a base de arenas de cuarzo y resina, es un producto de elevadas características estéticas con una alta resistencia a la flexión, a la abrasión y a los ácidos. Innovador y con altas prestaciones técnicas es un material que se presenta de manera muy homogénea y uniforme, además de ser particularmente versátil en lo que se refiere a la coloración.<em></em>\n\nLa amplia gama de colores y granulometrías y una tecnología de vanguardia se presentan bajo forma de superficies con varias posibilidades de uso, los colores neutros y las tonalidades más fuertes permiten combinaciones personales e inéditas.\n<div style=\"clear: both; height: 12px; width: 100%;\"></div>\n<h5>Línea Trafficstone</h5>\n[caption id=\"attachment_767\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Amalfi-b.jpg\"><img class=\" wp-image-767   \" title=\"Amalfi\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Amalfi-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Amalfi[/caption]\n\n[caption id=\"attachment_768\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Antracite-b.jpg\"><img class=\" wp-image-768  \" title=\"Antracite\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Antracite-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Antracite[/caption]\n\n[caption id=\"attachment_770\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Aosta-b.jpg\"><img class=\" wp-image-770  \" title=\"Aosta\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Aosta-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Aosta[/caption]\n\n[caption id=\"attachment_772\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Apulia-b.jpg\"><img class=\" wp-image-772  \" title=\"Apulia\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Apulia-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Apulia[/caption]\n\n[caption id=\"attachment_773\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Atena-b.jpg\"><img class=\" wp-image-773  \" title=\"Atena\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Atena-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Atena[/caption]\n\n[caption id=\"attachment_775\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Auby-b.jpg\"><img class=\" wp-image-775  \" title=\"Auby\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Auby-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Auby[/caption]\n\n[caption id=\"attachment_776\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Belvedere-b.jpg\"><img class=\" wp-image-776  \" title=\"Belvedere-b\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Belvedere-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Belvedere[/caption]\n\n[caption id=\"attachment_804\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Breda-b.jpg\"><img class=\" wp-image-804   \" title=\"Breda\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Breda-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Breda[/caption]\n\n[caption id=\"attachment_805\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Caledonia-b.jpg\"><img class=\" wp-image-805   \" title=\"Caledonia\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Caledonia-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Caledonia[/caption]\n\n[caption id=\"attachment_806\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Camargue-b.jpg\"><img class=\" wp-image-806   \" title=\"Camargue\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Camargue-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Camargue[/caption]\n\n[caption id=\"attachment_807\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Carnia-b.jpg\"><img class=\" wp-image-807   \" title=\"Carnia\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Carnia-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Carnia[/caption]\n\n[caption id=\"attachment_808\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Catalina-b.jpg\"><img class=\" wp-image-808   \" title=\"Catalina\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Catalina-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Catalina[/caption]\n\n[caption id=\"attachment_809\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Friuli-b.jpg\"><img class=\" wp-image-809   \" title=\"Friuli\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Friuli-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Friuli[/caption]\n\n[caption id=\"attachment_812\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Hermitage-b.jpg\"><img class=\" wp-image-812  \" title=\"Hermitage\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Hermitage-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Hermitage[/caption]\n\n[caption id=\"attachment_813\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Istria-b.jpg\"><img class=\" wp-image-813  \" title=\"Istria\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Istria-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Istria[/caption]\n\n[caption id=\"attachment_814\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Itaca-b.jpg\"><img class=\" wp-image-814  \" title=\"Itaca\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Itaca-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Itaca[/caption]\n\n[caption id=\"attachment_815\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Miami-b.jpg\"><img class=\" wp-image-815  \" title=\"Miami\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Miami-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Miami[/caption]\n\n[caption id=\"attachment_816\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Miramare-b.jpg\"><img class=\" wp-image-816  \" title=\"Miramare\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Miramare-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Miramare[/caption]\n\n[caption id=\"attachment_817\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Modena-b.jpg\"><img class=\" wp-image-817  \" title=\"Modena\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Modena-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Modena[/caption]\n\n[caption id=\"attachment_818\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Naxos-b.jpg\"><img class=\" wp-image-818  \" title=\"Naxos\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Naxos-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Naxos[/caption]\n\n[caption id=\"attachment_819\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Nero-b.jpg\"><img class=\" wp-image-819  \" title=\"Nero\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Nero-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Nero[/caption]\n\n[caption id=\"attachment_820\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Otello-b.jpg\"><img class=\" wp-image-820  \" title=\"Otello\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Otello-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Otello[/caption]\n\n[caption id=\"attachment_821\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Pompei-b.jpg\"><img class=\" wp-image-821  \" title=\"Pompei\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Pompei-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Pompei[/caption]\n\n[caption id=\"attachment_822\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Prussia-b.jpg\"><img class=\" wp-image-822  \" title=\"Prussia\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Prussia-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Prussia[/caption]\n\n[caption id=\"attachment_823\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Rinmini-b.jpg\"><img class=\" wp-image-823  \" title=\"Rinmini\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Rinmini-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Rinmini[/caption]\n\n<div style=\"clear: both; height: 12px; width: 100%;\"></div>\n<h5>Línea Stardust</h5>\n[caption id=\"attachment_840\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Beige-Stardust-b.jpg\"><img class=\" wp-image-840  \" title=\"Beige Stardust\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Beige-Stardust-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Beige Stardust[/caption]\n\n[caption id=\"attachment_841\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Bianco-Stardust-b.jpg\"><img class=\" wp-image-841  \" title=\"Bianco Stardust\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Bianco-Stardust-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Bianco Stardust[/caption]\n\n[caption id=\"attachment_842\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Blu-Stardust-b.jpg\"><img class=\" wp-image-842  \" title=\"Blu Stardust\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Blu-Stardust-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Blu Stardust[/caption]\n\n[caption id=\"attachment_843\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Giallo-Stardust-b.jpg\"><img class=\" wp-image-843  \" title=\"Giallo Stardust\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Giallo-Stardust-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Giallo Stardust[/caption]\n\n[caption id=\"attachment_844\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Nero-Stardust-b.jpg\"><img class=\" wp-image-844  \" title=\"Nero Stardust\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Nero-Stardust-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Nero Stardust[/caption]\n\n[caption id=\"attachment_845\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Pastel-Green-Stardust-b.jpg\"><img class=\" wp-image-845  \" title=\"Pastel Green Stardust\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Pastel-Green-Stardust-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Pastel Green St.[/caption]\n\n[caption id=\"attachment_846\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Rosa-Stardust-b.jpg\"><img class=\" wp-image-846  \" title=\"Rosa Stardust\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Rosa-Stardust-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Rosa Stardust[/caption]\n\n[caption id=\"attachment_847\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Rosso-Stardust-b.jpg\"><img class=\" wp-image-847  \" title=\"Rosso Stardust\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Rosso-Stardust-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Rosso Stardust[/caption]\n\n[caption id=\"attachment_848\" align=\"alignleft\" width=\"84\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Sky-Stardust-b.jpg\"><img class=\" wp-image-848  \" title=\"Sky Stardust\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Sky-Stardust-b-116x116.jpg\" width=\"84\" height=\"84\" /></a> Sky Stardust[/caption]\n\n<div style=\"clear: both; height: 12px; width: 100%;\"></div>\n<h5>Línea Reef</h5>\n<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/Beige.jpg\"><img class=\" wp-image-1083  \" title=\"Beige\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Beige_t.jpg\" width=\"80\" height=\"80\" /></a>\n\n[caption id=\"attachment_1083\" align=\"alignleft\" width=\"80\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/Black.jpg\"><img class=\" wp-image-1084 \" title=\"Black\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Black_t.jpg\" width=\"80\" height=\"80\" /></a> Beige[/caption]\n\n[caption id=\"attachment_1084\" align=\"alignleft\" width=\"80\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/Black.jpg\"><img class=\" wp-image-1084 \" title=\"Black\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Black_t.jpg\" width=\"80\" height=\"80\" /></a> Black[/caption]\n\n[caption id=\"attachment_1085\" align=\"alignleft\" width=\"80\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/Brown.jpg\"><img class=\" wp-image-1085 \" title=\"Brown\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Brown_t.jpg\" width=\"80\" height=\"80\" /></a> Brown[/caption]\n\n[caption id=\"attachment_1086\" align=\"alignleft\" width=\"80\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/Grey.jpg\"><img class=\" wp-image-1086 \" title=\"Grey\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Grey_t.jpg\" width=\"80\" height=\"80\" /></a> Grey[/caption]\n\n[caption id=\"attachment_1087\" align=\"alignleft\" width=\"80\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/White.jpg\"><img class=\" wp-image-1087 \" title=\"White\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/White_t.jpg\" width=\"80\" height=\"80\" /></a> White[/caption]\n\n<div style=\"clear: both; height: 12px; width: 100%;\"></div>\n<h5>Línea Glitter</h5>\n[caption id=\"attachment_1102\" align=\"alignleft\" width=\"80\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/Bronze.jpg\"><img class=\" wp-image-1102 \" title=\"Bronze\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Bronze_t.jpg\" width=\"80\" height=\"80\" /></a> Bronze[/caption]\n\n[caption id=\"attachment_1098\" align=\"alignleft\" width=\"80\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/Gold.jpg\"><img class=\" wp-image-1098 \" title=\"Gold\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Gold_t.jpg\" width=\"80\" height=\"80\" /></a> Gold[/caption]\n\n[caption id=\"attachment_1099\" align=\"alignleft\" width=\"80\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/Iron.jpg\"><img class=\" wp-image-1099 \" title=\"Iron\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Iron_t.jpg\" width=\"80\" height=\"80\" /></a> Iron[/caption]\n\n[caption id=\"attachment_1100\" align=\"alignleft\" width=\"80\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/Pewter.jpg\"><img class=\" wp-image-1100 \" title=\"Pewter\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Pewter_t.jpg\" width=\"80\" height=\"80\" /></a> Pewter[/caption]\n\n[caption id=\"attachment_1101\" align=\"alignleft\" width=\"80\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/Silver.jpg\"><img class=\" wp-image-1101 \" title=\"Silver\" alt=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Silver_t.jpg\" width=\"80\" height=\"80\" /></a> Silver[/caption]", "Colores", "Amplia gama de colores y granulometrías.", "inherit", "open", "open", "", "379-autosave-v1", "", "", "2013-08-07 16:56:00", "2013-08-07 20:56:00", "", "379", "http://s-m.cl/379-autosave/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("767", "1", "2012-05-28 12:03:28", "2012-05-28 16:03:28", "", "Amalfi", "Amalfi", "inherit", "open", "open", "", "amalfi-b", "", "", "2012-05-28 12:03:28", "2012-05-28 16:03:28", "", "379", "http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Amalfi-b.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("735", "1", "2012-04-19 15:29:50", "2012-04-19 19:29:50", "<p style=\"text-align: justify;\">El color es otorgado a nuestros perfiles través de un proceso denominado “foliado”, para este proceso se emplean laminas de PVC procedentes de Alemania, que son las encargadas de entregar las distintas terminaciones, texturas y colores a los perfiles, además de la protección UV, la calidad de estos productos está avalada por años de desarrollo e investigación a cargo de la empresa skai (<a href=\"http://www.skai.es\">www.skai.es</a>)</p>\r\n\r\n\r\n[caption id=\"attachment_581\" align=\"alignleft\" width=\"104\" caption=\"Techprofil\"]<a href=\"http://s-m.cl/wp-content/uploads/2012/03/techprofil.jpg\"><img class=\"wp-image-581 \" title=\"Techprofil\" src=\"http://s-m.cl/wp-content/uploads/2012/03/techprofil-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_580\" align=\"alignleft\" width=\"104\" caption=\"Staufereiche Terra\"]<a href=\"http://s-m.cl/wp-content/uploads/2012/03/staufereiche_terra.jpg\"><img class=\"wp-image-580   \" title=\"Staufereiche Terra\" src=\"http://s-m.cl/wp-content/uploads/2012/03/staufereiche_terra-116x116.jpg\" alt=\"Staufereiche Terra\" width=\"104\" height=\"104\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_579\" align=\"alignleft\" width=\"104\" caption=\"Staufereiche Kolonial\"]<a href=\"http://s-m.cl/wp-content/uploads/2012/03/staufereiche_kolonial.jpg\"><img class=\"wp-image-579  \" title=\"Staufereiche Kolonial\" src=\"http://s-m.cl/wp-content/uploads/2012/03/staufereiche_kolonial-116x116.jpg\" alt=\"Staufereiche Kolonial\" width=\"104\" height=\"104\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_578\" align=\"alignleft\" width=\"104\" caption=\"Metbrush Silver\"]<a href=\"http://s-m.cl/wp-content/uploads/2012/03/metbrush_silver.jpg\"><img class=\"wp-image-578  \" title=\"Metbrush Silver\" src=\"http://s-m.cl/wp-content/uploads/2012/03/metbrush_silver-116x116.jpg\" alt=\"Metbrush Silver\" width=\"104\" height=\"104\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_576\" align=\"alignleft\" width=\"104\" caption=\"Anthrazitgrau\"]<a href=\"http://s-m.cl/wp-content/uploads/2012/03/anthrazitgrau.jpg\"><img class=\"wp-image-576  \" title=\"Anthrazitgrau\" src=\"http://s-m.cl/wp-content/uploads/2012/03/anthrazitgrau-116x116.jpg\" alt=\"Anthrazitgrau\" width=\"104\" height=\"104\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_577\" align=\"alignleft\" width=\"104\" caption=\"Macoree\"]<a href=\"http://s-m.cl/wp-content/uploads/2012/03/macoree.jpg\"><img class=\"wp-image-577  \" title=\"Macoree\" src=\"http://s-m.cl/wp-content/uploads/2012/03/macoree-116x116.jpg\" alt=\"Macoree\" width=\"104\" height=\"104\" /></a>[/caption]", "Colores", "El color es otorgado a nuestros perfiles través de un proceso denominado “foliado”.", "inherit", "open", "open", "", "379-revision-v1", "", "", "2012-04-19 15:29:50", "2012-04-19 19:29:50", "", "379", "http://santamargherita.s-m.cl/379-revision-8/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("582", "1", "2012-03-26 21:15:23", "2012-03-27 04:15:23", "&nbsp;\n\n&nbsp;\n\nEl color es otorgado a nuestros perfiles través de un proceso denominado “foliado”, para este proceso se emplean laminas de PVC procedentes de Alemania, que son las encargadas de entregar las distintas terminaciones, texturas y colores a los perfiles, además de la protección UV, la calidad de estos productos está avalada por años de desarrollo e investigación a cargo de la empresa skai (<a href=\"http://www.skai.es\">www.skai.es</a>)", "Colores", "", "inherit", "open", "open", "", "379-revision-v1", "", "", "2012-03-26 21:15:23", "2012-03-27 04:15:23", "", "379", "http://s-m.cl/379-revision/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("583", "1", "2012-04-13 04:51:14", "2012-04-13 08:51:14", "El color es otorgado a nuestros perfiles través de un proceso denominado “foliado”, para este proceso se emplean laminas de PVC procedentes de Alemania, que son las encargadas de entregar las distintas terminaciones, texturas y colores a los perfiles, además de la protección UV, la calidad de estos productos está avalada por años de desarrollo e investigación a cargo de la empresa skai (<a href=\"http://www.skai.es\">www.skai.es</a>)\r\n\r\n[caption id=\"attachment_581\" align=\"alignnone\" width=\"104\" caption=\"Techprofil\"]<a href=\"http://s-m.cl/wp-content/uploads/2012/03/techprofil.jpg\"><img class=\" wp-image-581 \" title=\"Techprofil\" src=\"http://s-m.cl/wp-content/uploads/2012/03/techprofil-116x116.jpg\" alt=\"Techprofil\" width=\"104\" height=\"104\" /></a>[/caption]", "Colores", "", "inherit", "open", "open", "", "379-revision-v1", "", "", "2012-04-13 04:51:14", "2012-04-13 08:51:14", "", "379", "http://s-m.cl/379-revision-2/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("584", "1", "2012-04-13 04:55:08", "2012-04-13 08:55:08", "El color es otorgado a nuestros perfiles través de un proceso denominado “foliado”, para este proceso se emplean laminas de PVC procedentes de Alemania, que son las encargadas de entregar las distintas terminaciones, texturas y colores a los perfiles, además de la protección UV, la calidad de estos productos está avalada por años de desarrollo e investigación a cargo de la empresa skai (<a href=\"http://www.skai.es\">www.skai.es</a>)\r\n\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/techprofil.jpg\"><img class=\" wp-image-581  alignnone\" title=\"Techprofil\" src=\"http://s-m.cl/wp-content/uploads/2012/03/techprofil-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/staufereiche_terra.jpg\"><img class=\"alignnone  wp-image-580\" title=\"staufereiche_terra\" src=\"http://s-m.cl/wp-content/uploads/2012/03/staufereiche_terra-116x116.jpg\" alt=\"Staufereiche Terra\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/staufereiche_kolonial.jpg\"><img class=\"alignnone  wp-image-579\" title=\"staufereiche_kolonial\" src=\"http://s-m.cl/wp-content/uploads/2012/03/staufereiche_kolonial-116x116.jpg\" alt=\"Staufereiche Kolonial\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/metbrush_silver.jpg\"><img class=\"alignnone  wp-image-578\" title=\"metbrush_silver\" src=\"http://s-m.cl/wp-content/uploads/2012/03/metbrush_silver-116x116.jpg\" alt=\"Metbrush Silver\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/macoree.jpg\"><img class=\"alignnone  wp-image-577\" title=\"macoree\" src=\"http://s-m.cl/wp-content/uploads/2012/03/macoree-116x116.jpg\" alt=\"Macoree\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/anthrazitgrau.jpg\"><img class=\"alignnone  wp-image-576\" title=\"anthrazitgrau\" src=\"http://s-m.cl/wp-content/uploads/2012/03/anthrazitgrau-116x116.jpg\" alt=\"Anthrazitgrau\" width=\"104\" height=\"104\" /></a>", "Colores", "", "inherit", "open", "open", "", "379-revision-v1", "", "", "2012-04-13 04:55:08", "2012-04-13 08:55:08", "", "379", "http://s-m.cl/379-revision-3/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("585", "1", "2012-04-13 04:56:00", "2012-04-13 08:56:00", "El color es otorgado a nuestros perfiles través de un proceso denominado “foliado”, para este proceso se emplean laminas de PVC procedentes de Alemania, que son las encargadas de entregar las distintas terminaciones, texturas y colores a los perfiles, además de la protección UV, la calidad de estos productos está avalada por años de desarrollo e investigación a cargo de la empresa skai (<a href=\"http://www.skai.es\">www.skai.es</a>)\r\n\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/techprofil.jpg\"><img class=\" wp-image-581  alignnone\" title=\"Techprofil\" src=\"http://s-m.cl/wp-content/uploads/2012/03/techprofil-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>      <a href=\"http://s-m.cl/wp-content/uploads/2012/03/staufereiche_terra.jpg\"><img class=\"alignnone  wp-image-580\" title=\"staufereiche_terra\" src=\"http://s-m.cl/wp-content/uploads/2012/03/staufereiche_terra-116x116.jpg\" alt=\"Staufereiche Terra\" width=\"104\" height=\"104\" /></a>      <a href=\"http://s-m.cl/wp-content/uploads/2012/03/staufereiche_kolonial.jpg\"><img class=\"alignnone  wp-image-579\" title=\"staufereiche_kolonial\" src=\"http://s-m.cl/wp-content/uploads/2012/03/staufereiche_kolonial-116x116.jpg\" alt=\"Staufereiche Kolonial\" width=\"104\" height=\"104\" /></a>      <a href=\"http://s-m.cl/wp-content/uploads/2012/03/metbrush_silver.jpg\"><img class=\"alignnone  wp-image-578\" title=\"metbrush_silver\" src=\"http://s-m.cl/wp-content/uploads/2012/03/metbrush_silver-116x116.jpg\" alt=\"Metbrush Silver\" width=\"104\" height=\"104\" /></a>      <a href=\"http://s-m.cl/wp-content/uploads/2012/03/macoree.jpg\"><img class=\"alignnone  wp-image-577\" title=\"macoree\" src=\"http://s-m.cl/wp-content/uploads/2012/03/macoree-116x116.jpg\" alt=\"Macoree\" width=\"104\" height=\"104\" /></a>      <a href=\"http://s-m.cl/wp-content/uploads/2012/03/anthrazitgrau.jpg\"><img class=\"alignnone  wp-image-576\" title=\"anthrazitgrau\" src=\"http://s-m.cl/wp-content/uploads/2012/03/anthrazitgrau-116x116.jpg\" alt=\"Anthrazitgrau\" width=\"104\" height=\"104\" /></a>", "Colores", "", "inherit", "open", "open", "", "379-revision-v1", "", "", "2012-04-13 04:56:00", "2012-04-13 08:56:00", "", "379", "http://s-m.cl/379-revision-4/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("586", "1", "2012-04-13 04:57:29", "2012-04-13 08:57:29", "El color es otorgado a nuestros perfiles través de un proceso denominado “foliado”, para este proceso se emplean laminas de PVC procedentes de Alemania, que son las encargadas de entregar las distintas terminaciones, texturas y colores a los perfiles, además de la protección UV, la calidad de estos productos está avalada por años de desarrollo e investigación a cargo de la empresa skai (<a href=\"http://www.skai.es\">www.skai.es</a>)\r\n\r\n[caption id=\"attachment_581\" align=\"alignleft\" width=\"104\" caption=\"Techprofil\"]<a href=\"http://s-m.cl/wp-content/uploads/2012/03/techprofil.jpg\"><img class=\"wp-image-581 \" title=\"Techprofil\" src=\"http://s-m.cl/wp-content/uploads/2012/03/techprofil-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_580\" align=\"alignleft\" width=\"104\" caption=\"Staufereiche Terra\"]<a href=\"http://s-m.cl/wp-content/uploads/2012/03/staufereiche_terra.jpg\"><img class=\"wp-image-580  \" title=\"staufereiche_terra\" src=\"http://s-m.cl/wp-content/uploads/2012/03/staufereiche_terra-116x116.jpg\" alt=\"Staufereiche Terra\" width=\"104\" height=\"104\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_579\" align=\"alignleft\" width=\"104\" caption=\"Staufereiche Kolonial\"]<a href=\"http://s-m.cl/wp-content/uploads/2012/03/staufereiche_kolonial.jpg\"><img class=\"wp-image-579 \" title=\"staufereiche_kolonial\" src=\"http://s-m.cl/wp-content/uploads/2012/03/staufereiche_kolonial-116x116.jpg\" alt=\"Staufereiche Kolonial\" width=\"104\" height=\"104\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_578\" align=\"alignleft\" width=\"104\" caption=\"Metbrush Silver\"]<a href=\"http://s-m.cl/wp-content/uploads/2012/03/metbrush_silver.jpg\"><img class=\"wp-image-578 \" title=\"metbrush_silver\" src=\"http://s-m.cl/wp-content/uploads/2012/03/metbrush_silver-116x116.jpg\" alt=\"Metbrush Silver\" width=\"104\" height=\"104\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_576\" align=\"alignleft\" width=\"104\" caption=\"Anthrazitgrau\"]<a href=\"http://s-m.cl/wp-content/uploads/2012/03/anthrazitgrau.jpg\"><img class=\"wp-image-576 \" title=\"anthrazitgrau\" src=\"http://s-m.cl/wp-content/uploads/2012/03/anthrazitgrau-116x116.jpg\" alt=\"Anthrazitgrau\" width=\"104\" height=\"104\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_577\" align=\"alignleft\" width=\"104\" caption=\"Macoree\"]<a href=\"http://s-m.cl/wp-content/uploads/2012/03/macoree.jpg\"><img class=\"wp-image-577 \" title=\"macoree\" src=\"http://s-m.cl/wp-content/uploads/2012/03/macoree-116x116.jpg\" alt=\"Macoree\" width=\"104\" height=\"104\" /></a>[/caption]", "Colores", "", "inherit", "open", "open", "", "379-revision-v1", "", "", "2012-04-13 04:57:29", "2012-04-13 08:57:29", "", "379", "http://s-m.cl/379-revision-5/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("587", "1", "2012-04-13 04:57:54", "2012-04-13 08:57:54", "<p style=\"text-align: justify;\">El color es otorgado a nuestros perfiles través de un proceso denominado “foliado”, para este proceso se emplean laminas de PVC procedentes de Alemania, que son las encargadas de entregar las distintas terminaciones, texturas y colores a los perfiles, además de la protección UV, la calidad de estos productos está avalada por años de desarrollo e investigación a cargo de la empresa skai (<a href=\"http://www.skai.es\">www.skai.es</a>)</p>\r\n\r\n\r\n[caption id=\"attachment_581\" align=\"alignleft\" width=\"104\" caption=\"Techprofil\"]<a href=\"http://s-m.cl/wp-content/uploads/2012/03/techprofil.jpg\"><img class=\"wp-image-581 \" title=\"Techprofil\" src=\"http://s-m.cl/wp-content/uploads/2012/03/techprofil-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_580\" align=\"alignleft\" width=\"104\" caption=\"Staufereiche Terra\"]<a href=\"http://s-m.cl/wp-content/uploads/2012/03/staufereiche_terra.jpg\"><img class=\"wp-image-580  \" title=\"staufereiche_terra\" src=\"http://s-m.cl/wp-content/uploads/2012/03/staufereiche_terra-116x116.jpg\" alt=\"Staufereiche Terra\" width=\"104\" height=\"104\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_579\" align=\"alignleft\" width=\"104\" caption=\"Staufereiche Kolonial\"]<a href=\"http://s-m.cl/wp-content/uploads/2012/03/staufereiche_kolonial.jpg\"><img class=\"wp-image-579 \" title=\"staufereiche_kolonial\" src=\"http://s-m.cl/wp-content/uploads/2012/03/staufereiche_kolonial-116x116.jpg\" alt=\"Staufereiche Kolonial\" width=\"104\" height=\"104\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_578\" align=\"alignleft\" width=\"104\" caption=\"Metbrush Silver\"]<a href=\"http://s-m.cl/wp-content/uploads/2012/03/metbrush_silver.jpg\"><img class=\"wp-image-578 \" title=\"metbrush_silver\" src=\"http://s-m.cl/wp-content/uploads/2012/03/metbrush_silver-116x116.jpg\" alt=\"Metbrush Silver\" width=\"104\" height=\"104\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_576\" align=\"alignleft\" width=\"104\" caption=\"Anthrazitgrau\"]<a href=\"http://s-m.cl/wp-content/uploads/2012/03/anthrazitgrau.jpg\"><img class=\"wp-image-576 \" title=\"anthrazitgrau\" src=\"http://s-m.cl/wp-content/uploads/2012/03/anthrazitgrau-116x116.jpg\" alt=\"Anthrazitgrau\" width=\"104\" height=\"104\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_577\" align=\"alignleft\" width=\"104\" caption=\"Macoree\"]<a href=\"http://s-m.cl/wp-content/uploads/2012/03/macoree.jpg\"><img class=\"wp-image-577 \" title=\"macoree\" src=\"http://s-m.cl/wp-content/uploads/2012/03/macoree-116x116.jpg\" alt=\"Macoree\" width=\"104\" height=\"104\" /></a>[/caption]", "Colores", "", "inherit", "open", "open", "", "379-revision-v1", "", "", "2012-04-13 04:57:54", "2012-04-13 08:57:54", "", "379", "http://s-m.cl/379-revision-6/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("588", "1", "2012-06-14 16:00:48", "2012-06-14 20:00:48", "<img class=\"alignnone size-full wp-image-916\" title=\"Proyectos destacados\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/bano.jpg\" alt=\"\" width=\"810\" height=\"328\" />\n<h3>PROYECTOS DESTACADOS</h3>\n<strong>Parque Espoz</strong>\n\n<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/banner_espoz_02.jpg\"><img class=\"alignnone\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/banner_espoz_02-196x88.jpg\" alt=\"\" width=\"196\" height=\"88\" /></a>  <a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/espoz_equip_04.jpg\"><img class=\"alignnone\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/espoz_equip_04-196x88.jpg\" alt=\"\" width=\"196\" height=\"88\" /></a>\n\n<strong>Departamentos Rafel Sanzio</strong>\n\n<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/rafael-sanzio-departamentos.jpg\"><img class=\"alignnone\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/rafael-sanzio-departamentos-196x88.jpg\" alt=\"\" width=\"196\" height=\"88\" /></a>", "Proyectos destacados", "Proyectos destacados realizados por nuestra empresa.", "inherit", "open", "open", "", "398-autosave", "", "", "2012-06-14 16:00:48", "2012-06-14 20:00:48", "", "398", "http://s-m.cl/398-autosave/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("918", "1", "2012-06-06 12:34:20", "2012-06-06 16:34:20", "<img class=\"alignnone size-full wp-image-916\" title=\"Proyectos destacados\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/bano.jpg\" alt=\"\" width=\"810\" height=\"328\" />\r\n<h3>PROYECTOS DESTACADOS</h3>", "Proyectos destacados", "Proyectos destacados realizados por nuestra empresa.", "inherit", "open", "open", "", "398-revision-19", "", "", "2012-06-06 12:34:20", "2012-06-06 16:34:20", "", "398", "http://santamargherita.s-m.cl/398-revision-19/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("749", "1", "2012-05-24 16:03:53", "2012-05-24 20:03:53", "<img class=\"alignnone size-full wp-image-481\" title=\"empresa_OK\" src=\"http://s-m.cl/wp-content/uploads/2012/04/empresa_OK.jpg\" alt=\"\" width=\"576\" height=\"200\" />\r\n<h4><a name=\"empresa\"></a>La Empresa</h4>\r\nTecnocom inicia sus actividades comerciales en 1975, y desde entonces ha venido desarrollando un importante proceso de expansión, demostrando desde sus inicios una constante vitalidad y crecimiento, cualidades que sumadas  a la alta tecnología utilizada le permite ocupar una posición de liderazgo.\r\n\r\nEn la actualidad tiene 3 divisiones: Compuestos de PVC, Mangueras de PVC y Perfiles de PVC que en conjunto facturan al año aproximadamente US$100 millones.\r\n\r\nSon tres las instalaciones industriales con las que cuenta, dos en Buenos Aires y una en San Luis\r\n\r\nLa división perfiles se creó hace 7 años con la más moderna tecnología europea con el objetivo de ser un actor relevante en este segmento de productos en Latinoamérica.\r\n\r\nHoy Tecnocom con sus perfiles para ventanas y puertas de PVC es líder el mercado argentino con más de 55 armadores y hoy tiene presencia en México, Centro América, Colombia, Perú, Brasil, Bolivia, Uruguay y Chile.\r\n\r\nLos sistemas de perfiles son fabricados bajo las normas europeas UNE-EN 12608, que aseguran un producto de calidad que cumple todas las exigencias referidas a pruebas de Dimensionado, Pruebas Mecánicas, Pruebas Térmicas, Resistencia a los rayos UV, entre otros. (Si requiere de las normas y sus resultados no dude en solicitarlas).\r\n<h4><a name=\"objetivos\"></a>Nuestros Objetivos</h4>\r\nResponder  a las expectativas de los clientes, colaboradores y la comunidad, participando en el desarrollo de aplicaciones para mejorar la calidad de vida de la sociedad.\r\n\r\nNos esforzamos por ser los lideres y referentes del mercado en la producción y comercialización de artículos de óptima calidad. Este es nuestro compromiso con la comunidad latinoamericana de la que formamos parte.\r\n<h4><a name=\"tecnologia\"></a>Nuestra Tecnología</h4>\r\nNuestras plantas están equipadas con las mejores líneas de producción de origen alemán, italiano y austríaco, las que están diseñadas para responder a las mas altas exigencias de productividad y calidad.\r\n<h4><a name=\"personal\"></a>Nuestro Personal</h4>\r\nEs nuestro principal activo para el logro de nuestros objetivos, porque es la fuente de nuestra energía e inteligencia.\r\n\r\nEstamos convencidos de que detrás de toda gran empresa, siempre hay un gran grupo humano, y que solo con el personal idóneo y comprometido con los objetivos de la empresa es posible producir más y mejores soluciones.\r\n<h4><a name=\"mundo\"></a>TECNOCOM EN EL MUNDO</h4>\r\nCualquier empresa líder debe abrirse a mercados extranjeros. Tecnocom hoy cuenta con oficinas propias o representantes en toda Latinoamerica.\r\n\r\nCada mercado es único y Tecnocom lo entiende. Es por ello que se han desarrollado líneas y colores específicos para poder cumplir con demandas locales.\r\n\r\nHoy para Latinoamérica Tecnocom cuenta con la más amplia gama de soluciones que combinan alto nivel estético, tecnología, eficiencia energética y cuidado del medio ambiente.\r\n<h4><a name=\"laboratorio\"></a>LABORATORIO</h4>\r\nLos controles diarios que realizan los expertos en nuestro laboratorio interno, son uno de los pilares básicos del <strong>control de calidad contínuo</strong> al que se someten los perfiles de PVC Tecnocom.\r\n\r\nTodas las características de las materias primas, los perfiles extrusionados y los sistemas de ventanas y puertas de PVC acabadas, se controlan cuidadosamente de acuerdo con los criterios más estrictos, fijados por una serie de instituciones de ámbito nacional e internacional.\r\n\r\nTecnocom cuenta con un laboratorio de primer nivel donde en forma diaria se controlan todos los lotes de producción.\r\n\r\nLa inalterabilidad de las superficies, resistencia al impacto y la autenticidad del color blanco están garantizadas según norma europea UNE 53.360.\r\n<h4><a name=\"ensayo\"></a>BANCO DE ENSAYO</h4>\r\nDesde la inauguración de la planta de perfiles de PVC, Tecnocom cuenta con uno de los mas modernos bancos de ensayo alemán K Schulten.\r\n\r\nDefectos de productos que aparecen y reclamos, por regla general acarrean desagradables problemas financieros y de prestigio.\r\nEstos efectos secundarios negativos exigen una necesidad de seguridad.\r\nLa aplicación de propios bancos de ensayos para ventanas, dan garantía de estándares de calidad y de seguridad de muchos productores de ventanas.\r\n\r\nLa función del banco de ensayo es poder analizar el comportamiento de una ventana ante distintas presiones de viento y agua. Esto permite a Tecnocom analizar el comportamiento de los perfiles y los otros componentes de la ventana ante distintas situaciones emulando condiciones reales.\r\n<p style=\"text-align: left;\"><strong>- Ensayo de Estanqueidad al Agua</strong></p>\r\n\r\n<ul style=\"text-align: left;\">\r\n	<li>ESTANQUEIDAD AL AGUA: capacidad de una ventana de oponerse a las infiltraciones de agua en distintos niveles de presión estática.</li>\r\n	<li>INFILTRACIÓN: penetración continua o intermitente de agua en contacto con elementos de construcción no previstos para ser mojados.</li>\r\n	<li>LÍMITE DE ESTANQUEIDAD AL AGUA: presión máxima registrada en el curso del ensayo, para la cual está asegurada la estanqueidad al agua.</li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>- Ensayo a la acción del viento</strong></p>\r\n\r\n<ul style=\"text-align: justify;\">\r\n	<li style=\"text-align: left;\">Deformación residual permanente: modificación de la forma o de las medidas, producida por la aplicación de presiones, que no desaparece después que las presiones han dejado de aplicarse.</li>\r\n	<li style=\"text-align: left;\">Deformación residual temporal: modificación de la forma o de las medidas producidas por la aplicación de presiones, que desaparece progresivamente después que las presiones han dejado de aplicarse.</li>\r\n	<li style=\"text-align: left;\">Desplazamiento frontal: desplazamiento de un punto de un elemento de ventana medido perpendicularmente al plano de la ventana.</li>\r\n	<li style=\"text-align: left;\">Flecha frontal: diferencia máxima entre los desplazamientos frontales, tomada a lo largo de un mismo elemento de ventana (después de que se ha compensado el efecto de los desplazamientos frontales de las extremidades de este elemento).</li>\r\n	<li style=\"text-align: left;\">Flecha frontal relativa: Valor de la flecha frontal en relación con la distancia entre las dos extremidades del elemento de ventana examinado.</li>\r\n</ul>", "Novedades", "PVC Tecnocom ha lanzado al mercado un nuevo sistema de apertura.", "inherit", "open", "open", "", "401-revision-10", "", "", "2012-05-24 16:03:53", "2012-05-24 20:03:53", "", "401", "http://santamargherita.s-m.cl/401-revision-10/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("589", "1", "2012-04-13 04:36:09", "2012-04-13 08:36:09", "<h4><img class=\"alignnone size-full wp-image-532\" title=\"proyectos_OK\" src=\"http://s-m.cl/wp-content/uploads/2012/03/proyectos_OK.jpg\" alt=\"\" width=\"576\" height=\"200\" /></h4>\r\n<h4>Explora</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora1.jpg\"><img class=\"alignnone  wp-image-512\" title=\"explora1\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora2.jpg\"><img class=\"alignnone  wp-image-513\" title=\"explora2\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora3.jpg\"><img class=\"alignnone  wp-image-514\" title=\"explora3\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora4.jpg\"><img class=\"alignnone  wp-image-515\" title=\"explora4\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora5.jpg\"><img class=\"alignnone  wp-image-516\" title=\"explora5\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Los Bravos</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos1.jpg\"><img class=\"alignnone  wp-image-523\" title=\"bravos1\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos2.jpg\"><img class=\"alignnone  wp-image-526\" title=\"bravos2\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos3.jpg\"><img class=\"alignnone  wp-image-524\" title=\"bravos3\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos4.jpg\"><img class=\"alignnone  wp-image-525\" title=\"bravos4\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos5.jpg\"><img class=\"alignnone  wp-image-527\" title=\"bravos5\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Los Candiles</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles1.jpeg\"><img class=\"alignnone  wp-image-529\" title=\"candiles1\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <img class=\"alignnone  wp-image-533\" title=\"candiles2\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-530\" title=\"candiles3\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-531\" title=\"candiles4\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-534\" title=\"candiles5\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />\r\n<h4>Hotel Zapallar</h4>\r\n<img class=\"alignnone  wp-image-536\" title=\"IMG_5194\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5194-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-537\" title=\"IMG_5195\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5195-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-549\" title=\"IMG_5197\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5197-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-550\" title=\"IMG_5200\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5200-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-551\" title=\"IMG_5201\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5201-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /><img class=\"alignnone  wp-image-552\" title=\"IMG_5204\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5204-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-552\" title=\"IMG_5204\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5204-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-553\" title=\"IMG_5206\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5206-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-554\" title=\"IMG_5209\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5209-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />\r\n<h4>Casa Vichuquen</h4>\r\n<img class=\"alignnone  wp-image-539\" title=\"comedor\" src=\"http://s-m.cl/wp-content/uploads/2012/03/comedor-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-540\" title=\"Living\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Living-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-541\" title=\"pasillo interior\" src=\"http://s-m.cl/wp-content/uploads/2012/03/pasillo-interior-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-542\" title=\"Puerta 2\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta-2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-543\" title=\"Puerta\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /><img class=\"alignnone  wp-image-544\" title=\"Terraza 3\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-545\" title=\"Terraza 4\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-546\" title=\"Terraza\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />", "Proyectos destacados", "Proyectos destacados realizados por nosotros", "inherit", "open", "open", "", "398-revision-2", "", "", "2012-04-13 04:36:09", "2012-04-13 08:36:09", "", "398", "http://s-m.cl/398-revision-2/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("590", "1", "2012-04-19 14:57:37", "2012-04-19 18:57:37", "<h4><img class=\"alignnone size-full wp-image-532\" title=\"proyectos_OK\" src=\"http://s-m.cl/wp-content/uploads/2012/03/proyectos_OK.jpg\" alt=\"\" width=\"576\" height=\"200\" /></h4>\r\n<h4>Explora</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora1.jpg\"><img class=\"alignnone  wp-image-512\" title=\"explora1\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora2.jpg\"><img class=\"alignnone  wp-image-513\" title=\"explora2\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora3.jpg\"><img class=\"alignnone  wp-image-514\" title=\"explora3\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora4.jpg\"><img class=\"alignnone  wp-image-515\" title=\"explora4\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora5.jpg\"><img class=\"alignnone  wp-image-516\" title=\"explora5\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Los Bravos</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos1.jpg\"><img class=\"alignnone  wp-image-523\" title=\"bravos1\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos2.jpg\"><img class=\"alignnone  wp-image-526\" title=\"bravos2\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos3.jpg\"><img class=\"alignnone  wp-image-524\" title=\"bravos3\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos4.jpg\"><img class=\"alignnone  wp-image-525\" title=\"bravos4\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos5.jpg\"><img class=\"alignnone  wp-image-527\" title=\"bravos5\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Los Candiles</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles1.jpeg\"><img class=\"alignnone  wp-image-529\" title=\"candiles1\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles2.jpeg\"><img class=\"alignnone  wp-image-533\" title=\"candiles2\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles3.jpeg\"><img class=\"alignnone  wp-image-530\" title=\"candiles3\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <img class=\"alignnone  wp-image-531\" title=\"candiles4\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-534\" title=\"candiles5\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />\r\n<h4>Hotel Zapallar</h4>\r\n<img class=\"alignnone  wp-image-536\" title=\"IMG_5194\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5194-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-537\" title=\"IMG_5195\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5195-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-549\" title=\"IMG_5197\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5197-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-550\" title=\"IMG_5200\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5200-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-551\" title=\"IMG_5201\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5201-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /><img class=\"alignnone  wp-image-552\" title=\"IMG_5204\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5204-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-552\" title=\"IMG_5204\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5204-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-553\" title=\"IMG_5206\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5206-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-554\" title=\"IMG_5209\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5209-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />\r\n<h4>Casa Vichuquen</h4>\r\n<img class=\"alignnone  wp-image-539\" title=\"comedor\" src=\"http://s-m.cl/wp-content/uploads/2012/03/comedor-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-540\" title=\"Living\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Living-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-541\" title=\"pasillo interior\" src=\"http://s-m.cl/wp-content/uploads/2012/03/pasillo-interior-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-542\" title=\"Puerta 2\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta-2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-543\" title=\"Puerta\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /><img class=\"alignnone  wp-image-544\" title=\"Terraza 3\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-545\" title=\"Terraza 4\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-546\" title=\"Terraza\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />", "Proyectos destacados", "Proyectos destacados realizados por nosotros", "inherit", "open", "open", "", "398-revision-3", "", "", "2012-04-19 14:57:37", "2012-04-19 18:57:37", "", "398", "http://s-m.cl/398-revision-3/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("591", "1", "2012-04-19 14:58:52", "2012-04-19 18:58:52", "<h4><img class=\"alignnone size-full wp-image-532\" title=\"proyectos_OK\" src=\"http://s-m.cl/wp-content/uploads/2012/03/proyectos_OK.jpg\" alt=\"\" width=\"576\" height=\"200\" /></h4>\r\n<h4>Explora</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora1.jpg\"><img class=\"alignnone  wp-image-512\" title=\"explora1\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora2.jpg\"><img class=\"alignnone  wp-image-513\" title=\"explora2\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora3.jpg\"><img class=\"alignnone  wp-image-514\" title=\"explora3\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora4.jpg\"><img class=\"alignnone  wp-image-515\" title=\"explora4\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora5.jpg\"><img class=\"alignnone  wp-image-516\" title=\"explora5\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Los Bravos</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos1.jpg\"><img class=\"alignnone  wp-image-523\" title=\"bravos1\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos2.jpg\"><img class=\"alignnone  wp-image-526\" title=\"bravos2\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos3.jpg\"><img class=\"alignnone  wp-image-524\" title=\"bravos3\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos4.jpg\"><img class=\"alignnone  wp-image-525\" title=\"bravos4\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos5.jpg\"><img class=\"alignnone  wp-image-527\" title=\"bravos5\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Los Candiles</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles1.jpeg\"><img class=\"alignnone  wp-image-529\" title=\"candiles1\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles2.jpeg\"><img class=\"alignnone  wp-image-533\" title=\"candiles2\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles3.jpeg\"><img class=\"alignnone  wp-image-530\" title=\"candiles3\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles4.jpeg\"><img class=\"alignnone  wp-image-531\" title=\"candiles4\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles5.jpeg\"><img class=\"alignnone  wp-image-534\" title=\"candiles5\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Hotel Zapallar</h4>\r\n<img class=\"alignnone  wp-image-536\" title=\"IMG_5194\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5194-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-537\" title=\"IMG_5195\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5195-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-549\" title=\"IMG_5197\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5197-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-550\" title=\"IMG_5200\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5200-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-551\" title=\"IMG_5201\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5201-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /><img class=\"alignnone  wp-image-552\" title=\"IMG_5204\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5204-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-552\" title=\"IMG_5204\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5204-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-553\" title=\"IMG_5206\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5206-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-554\" title=\"IMG_5209\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5209-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />\r\n<h4>Casa Vichuquen</h4>\r\n<img class=\"alignnone  wp-image-539\" title=\"comedor\" src=\"http://s-m.cl/wp-content/uploads/2012/03/comedor-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-540\" title=\"Living\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Living-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-541\" title=\"pasillo interior\" src=\"http://s-m.cl/wp-content/uploads/2012/03/pasillo-interior-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-542\" title=\"Puerta 2\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta-2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-543\" title=\"Puerta\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /><img class=\"alignnone  wp-image-544\" title=\"Terraza 3\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-545\" title=\"Terraza 4\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-546\" title=\"Terraza\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />", "Proyectos destacados", "Proyectos destacados realizados por nosotros", "inherit", "open", "open", "", "398-revision-4", "", "", "2012-04-19 14:58:52", "2012-04-19 18:58:52", "", "398", "http://s-m.cl/398-revision-4/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("592", "1", "2012-04-19 15:04:25", "2012-04-19 19:04:25", "<h4><img class=\"alignnone size-full wp-image-532\" title=\"proyectos_OK\" src=\"http://s-m.cl/wp-content/uploads/2012/03/proyectos_OK.jpg\" alt=\"\" width=\"576\" height=\"200\" /></h4>\r\n<h4>Explora</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora1.jpg\"><img class=\"alignnone  wp-image-512\" title=\"explora1\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora2.jpg\"><img class=\"alignnone  wp-image-513\" title=\"explora2\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora3.jpg\"><img class=\"alignnone  wp-image-514\" title=\"explora3\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora4.jpg\"><img class=\"alignnone  wp-image-515\" title=\"explora4\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora5.jpg\"><img class=\"alignnone  wp-image-516\" title=\"explora5\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Los Bravos</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos1.jpg\"><img class=\"alignnone  wp-image-523\" title=\"bravos1\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos2.jpg\"><img class=\"alignnone  wp-image-526\" title=\"bravos2\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos3.jpg\"><img class=\"alignnone  wp-image-524\" title=\"bravos3\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos4.jpg\"><img class=\"alignnone  wp-image-525\" title=\"bravos4\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos5.jpg\"><img class=\"alignnone  wp-image-527\" title=\"bravos5\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Los Candiles</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles1.jpeg\"><img class=\"alignnone  wp-image-529\" title=\"candiles1\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles2.jpeg\"><img class=\"alignnone  wp-image-533\" title=\"candiles2\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles3.jpeg\"><img class=\"alignnone  wp-image-530\" title=\"candiles3\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles4.jpeg\"><img class=\"alignnone  wp-image-531\" title=\"candiles4\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles5.jpeg\"><img class=\"alignnone  wp-image-534\" title=\"candiles5\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Hotel Zapallar</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5194.jpeg\"><img class=\"alignnone  wp-image-536\" title=\"IMG_5194\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5194-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5195.jpeg\"><img class=\"alignnone  wp-image-537\" title=\"IMG_5195\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5195-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5197.jpeg\"><img class=\"alignnone  wp-image-549\" title=\"IMG_5197\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5197-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_IMG_5200.jpeg\"><img class=\"alignnone  wp-image-550\" title=\"IMG_5200\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5200-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_IMG_5201.jpeg\"><img class=\"alignnone  wp-image-551\" title=\"IMG_5201\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5201-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_IMG_5204.jpeg\"><img class=\"alignnone  wp-image-552\" title=\"IMG_5204\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5204-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_IMG_5206.jpeg\"><img class=\"alignnone  wp-image-553\" title=\"IMG_5206\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5206-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_IMG_5209.jpeg\"><img class=\"alignnone  wp-image-554\" title=\"IMG_5209\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5209-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Casa Vichuquen</h4>\r\n<img class=\"alignnone  wp-image-539\" title=\"comedor\" src=\"http://s-m.cl/wp-content/uploads/2012/03/comedor-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-540\" title=\"Living\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Living-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-541\" title=\"pasillo interior\" src=\"http://s-m.cl/wp-content/uploads/2012/03/pasillo-interior-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-542\" title=\"Puerta 2\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta-2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-543\" title=\"Puerta\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /><img class=\"alignnone  wp-image-544\" title=\"Terraza 3\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-545\" title=\"Terraza 4\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-546\" title=\"Terraza\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />", "Proyectos destacados", "Proyectos destacados realizados por nosotros", "inherit", "open", "open", "", "398-revision-5", "", "", "2012-04-19 15:04:25", "2012-04-19 19:04:25", "", "398", "http://s-m.cl/398-revision-5/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("593", "1", "2012-04-19 15:07:22", "2012-04-19 19:07:22", "<h4><img class=\"alignnone size-full wp-image-532\" title=\"proyectos_OK\" src=\"http://s-m.cl/wp-content/uploads/2012/03/proyectos_OK.jpg\" alt=\"\" width=\"576\" height=\"200\" /></h4>\r\n<h4>Explora</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora1.jpg\"><img class=\"alignnone  wp-image-512\" title=\"explora1\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora2.jpg\"><img class=\"alignnone  wp-image-513\" title=\"explora2\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora3.jpg\"><img class=\"alignnone  wp-image-514\" title=\"explora3\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora4.jpg\"><img class=\"alignnone  wp-image-515\" title=\"explora4\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora5.jpg\"><img class=\"alignnone  wp-image-516\" title=\"explora5\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Los Bravos</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos1.jpg\"><img class=\"alignnone  wp-image-523\" title=\"bravos1\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos2.jpg\"><img class=\"alignnone  wp-image-526\" title=\"bravos2\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos3.jpg\"><img class=\"alignnone  wp-image-524\" title=\"bravos3\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos4.jpg\"><img class=\"alignnone  wp-image-525\" title=\"bravos4\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos5.jpg\"><img class=\"alignnone  wp-image-527\" title=\"bravos5\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Los Candiles</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles1.jpeg\"><img class=\"alignnone  wp-image-529\" title=\"candiles1\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles2.jpeg\"><img class=\"alignnone  wp-image-533\" title=\"candiles2\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles3.jpeg\"><img class=\"alignnone  wp-image-530\" title=\"candiles3\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles4.jpeg\"><img class=\"alignnone  wp-image-531\" title=\"candiles4\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles5.jpeg\"><img class=\"alignnone  wp-image-534\" title=\"candiles5\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Hotel Zapallar</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5194.jpg\"><img class=\"alignnone  wp-image-536\" title=\"IMG_5194\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5194-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5195.jpeg\"><img class=\"alignnone  wp-image-537\" title=\"IMG_5195\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5195-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5197.jpeg\"><img class=\"alignnone  wp-image-549\" title=\"IMG_5197\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5197-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_IMG_5200.jpeg\"><img class=\"alignnone  wp-image-550\" title=\"IMG_5200\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5200-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_IMG_5201.jpeg\"><img class=\"alignnone  wp-image-551\" title=\"IMG_5201\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5201-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_IMG_5204.jpeg\"><img class=\"alignnone  wp-image-552\" title=\"IMG_5204\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5204-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_IMG_5206.jpeg\"><img class=\"alignnone  wp-image-553\" title=\"IMG_5206\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5206-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_IMG_5209.jpeg\"><img class=\"alignnone  wp-image-554\" title=\"IMG_5209\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5209-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Casa Vichuquen</h4>\r\n<img class=\"alignnone  wp-image-539\" title=\"comedor\" src=\"http://s-m.cl/wp-content/uploads/2012/03/comedor-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-540\" title=\"Living\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Living-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-541\" title=\"pasillo interior\" src=\"http://s-m.cl/wp-content/uploads/2012/03/pasillo-interior-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-542\" title=\"Puerta 2\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta-2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-543\" title=\"Puerta\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /><img class=\"alignnone  wp-image-544\" title=\"Terraza 3\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-545\" title=\"Terraza 4\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-546\" title=\"Terraza\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />", "Proyectos destacados", "Proyectos destacados realizados por nosotros", "inherit", "open", "open", "", "398-revision-6", "", "", "2012-04-19 15:07:22", "2012-04-19 19:07:22", "", "398", "http://s-m.cl/398-revision-6/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("597", "1", "2012-04-19 15:20:50", "2012-04-19 19:20:50", "<h4><img class=\"alignnone size-full wp-image-532\" title=\"proyectos_OK\" src=\"http://s-m.cl/wp-content/uploads/2012/03/proyectos_OK.jpg\" alt=\"\" width=\"576\" height=\"200\" /></h4>\r\n<h4>Explora</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora1.jpg\"><img class=\"alignnone  wp-image-512\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora2.jpg\"><img class=\"alignnone  wp-image-513\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora3.jpg\"><img class=\"alignnone  wp-image-514\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora4.jpg\"><img class=\"alignnone  wp-image-515\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora5.jpg\"><img class=\"alignnone  wp-image-516\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Los Bravos</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos1.jpg\"><img class=\"alignnone  wp-image-523\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos2.jpg\"><img class=\"alignnone  wp-image-526\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos3.jpg\"><img class=\"alignnone  wp-image-524\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos4.jpg\"><img class=\"alignnone  wp-image-525\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos5.jpg\"><img class=\"alignnone  wp-image-527\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Los Candiles</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles1.jpeg\"><img class=\"alignnone  wp-image-529\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles2.jpeg\"><img class=\"alignnone  wp-image-533\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles3.jpeg\"><img class=\"alignnone  wp-image-530\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles4.jpeg\"><img class=\"alignnone  wp-image-531\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles5.jpeg\"><img class=\"alignnone  wp-image-534\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Hotel Zapallar</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5194.jpg\"><img class=\"alignnone  wp-image-536\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5194-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5195.jpg\"><img class=\"alignnone  wp-image-537\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5195-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5197.jpg\"><img class=\"alignnone  wp-image-549\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5197-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5200.jpg\"><img class=\"alignnone  wp-image-550\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5200-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5201.jpg\"><img class=\"alignnone  wp-image-551\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5201-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a> <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5204.jpg\"><img class=\"alignnone  wp-image-552\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5204-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5206.jpg\"><img class=\"alignnone  wp-image-553\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5206-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5209.jpg\"><img class=\"alignnone  wp-image-554\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5209-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Casa Vichuquen</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/comedor.jpg\"><img class=\"alignnone  wp-image-539\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/comedor-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Living.jpg\"><img class=\"alignnone  wp-image-540\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Living-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/pasillo-interior.jpg\"><img class=\"alignnone  wp-image-541\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/pasillo-interior-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta-2.jpg\"><img class=\"alignnone  wp-image-542\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta-2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta.jpg\"><img class=\"alignnone  wp-image-543\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a> <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-3.jpg\"><img class=\"alignnone  wp-image-544\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-4.jpg\"><img class=\"alignnone  wp-image-545\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>    <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza.jpg\"><img class=\"alignnone  wp-image-546\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>", "Proyectos destacados", "Proyectos destacados realizados por nosotros", "inherit", "open", "open", "", "398-revision-10", "", "", "2012-04-19 15:20:50", "2012-04-19 19:20:50", "", "398", "http://s-m.cl/398-revision-10/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("594", "1", "2012-04-19 15:09:17", "2012-04-19 19:09:17", "<h4><img class=\"alignnone size-full wp-image-532\" title=\"proyectos_OK\" src=\"http://s-m.cl/wp-content/uploads/2012/03/proyectos_OK.jpg\" alt=\"\" width=\"576\" height=\"200\" /></h4>\r\n<h4>Explora</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora1.jpg\"><img class=\"alignnone  wp-image-512\" title=\"explora1\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora2.jpg\"><img class=\"alignnone  wp-image-513\" title=\"explora2\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora3.jpg\"><img class=\"alignnone  wp-image-514\" title=\"explora3\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora4.jpg\"><img class=\"alignnone  wp-image-515\" title=\"explora4\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora5.jpg\"><img class=\"alignnone  wp-image-516\" title=\"explora5\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Los Bravos</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos1.jpg\"><img class=\"alignnone  wp-image-523\" title=\"bravos1\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos2.jpg\"><img class=\"alignnone  wp-image-526\" title=\"bravos2\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos3.jpg\"><img class=\"alignnone  wp-image-524\" title=\"bravos3\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos4.jpg\"><img class=\"alignnone  wp-image-525\" title=\"bravos4\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos5.jpg\"><img class=\"alignnone  wp-image-527\" title=\"bravos5\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Los Candiles</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles1.jpeg\"><img class=\"alignnone  wp-image-529\" title=\"candiles1\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles2.jpeg\"><img class=\"alignnone  wp-image-533\" title=\"candiles2\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles3.jpeg\"><img class=\"alignnone  wp-image-530\" title=\"candiles3\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles4.jpeg\"><img class=\"alignnone  wp-image-531\" title=\"candiles4\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles5.jpeg\"><img class=\"alignnone  wp-image-534\" title=\"candiles5\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Hotel Zapallar</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5194.jpg\"><img class=\"alignnone  wp-image-536\" title=\"IMG_5194\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5194-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5195.jpg\"><img class=\"alignnone  wp-image-537\" title=\"IMG_5195\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5195-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5197.jpg\"><img class=\"alignnone  wp-image-549\" title=\"IMG_5197\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5197-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_IMG_5200.jpg\"><img class=\"alignnone  wp-image-550\" title=\"IMG_5200\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5200-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_IMG_5201.jpg\"><img class=\"alignnone  wp-image-551\" title=\"IMG_5201\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5201-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_IMG_5204.jpg\"><img class=\"alignnone  wp-image-552\" title=\"IMG_5204\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5204-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_IMG_5206.jpg\"><img class=\"alignnone  wp-image-553\" title=\"IMG_5206\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5206-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_IMG_5209.jpg\"><img class=\"alignnone  wp-image-554\" title=\"IMG_5209\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5209-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Casa Vichuquen</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/comedor.jpg\"><img class=\"alignnone  wp-image-539\" title=\"comedor\" src=\"http://s-m.cl/wp-content/uploads/2012/03/comedor-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <img class=\"alignnone  wp-image-540\" title=\"Living\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Living-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-541\" title=\"pasillo interior\" src=\"http://s-m.cl/wp-content/uploads/2012/03/pasillo-interior-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-542\" title=\"Puerta 2\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta-2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-543\" title=\"Puerta\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /><img class=\"alignnone  wp-image-544\" title=\"Terraza 3\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-545\" title=\"Terraza 4\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />   <img class=\"alignnone  wp-image-546\" title=\"Terraza\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" />", "Proyectos destacados", "Proyectos destacados realizados por nosotros", "inherit", "open", "open", "", "398-revision-7", "", "", "2012-04-19 15:09:17", "2012-04-19 19:09:17", "", "398", "http://s-m.cl/398-revision-7/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("598", "1", "2012-04-19 15:22:03", "2012-04-19 19:22:03", "<h4><img class=\"alignnone size-full wp-image-532\" title=\"proyectos_OK\" src=\"http://s-m.cl/wp-content/uploads/2012/03/proyectos_OK.jpg\" alt=\"\" width=\"576\" height=\"200\" /></h4>\r\n<h4>Explora</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora1.jpg\"><img class=\"alignnone  wp-image-512\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora2.jpg\"><img class=\"alignnone  wp-image-513\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora3.jpg\"><img class=\"alignnone  wp-image-514\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora4.jpg\"><img class=\"alignnone  wp-image-515\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora5.jpg\"><img class=\"alignnone  wp-image-516\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Los Bravos</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos1.jpg\"><img class=\"alignnone  wp-image-523\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos2.jpg\"><img class=\"alignnone  wp-image-526\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos3.jpg\"><img class=\"alignnone  wp-image-524\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos4.jpg\"><img class=\"alignnone  wp-image-525\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos5.jpg\"><img class=\"alignnone  wp-image-527\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Los Candiles</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles1.jpeg\"><img class=\"alignnone  wp-image-529\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles2.jpeg\"><img class=\"alignnone  wp-image-533\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles3.jpeg\"><img class=\"alignnone  wp-image-530\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles4.jpeg\"><img class=\"alignnone  wp-image-531\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles5.jpeg\"><img class=\"alignnone  wp-image-534\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Hotel Zapallar</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5194.jpg\"><img class=\"alignnone  wp-image-536\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5194-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5195.jpg\"><img class=\"alignnone  wp-image-537\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5195-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5197.jpg\"><img class=\"alignnone  wp-image-549\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5197-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5200.jpg\"><img class=\"alignnone  wp-image-550\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5200-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5201.jpg\"><img class=\"alignnone  wp-image-551\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5201-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5204.jpg\"><img class=\"alignnone  wp-image-552\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5204-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5206.jpg\"><img class=\"alignnone  wp-image-553\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5206-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5209.jpg\"><img class=\"alignnone  wp-image-554\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5209-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Casa Vichuquen</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/comedor.jpg\"><img class=\"alignnone  wp-image-539\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/comedor-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Living.jpg\"><img class=\"alignnone  wp-image-540\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Living-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/pasillo-interior.jpg\"><img class=\"alignnone  wp-image-541\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/pasillo-interior-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta-2.jpg\"><img class=\"alignnone  wp-image-542\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta-2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta.jpg\"><img class=\"alignnone  wp-image-543\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-3.jpg\"><img class=\"alignnone  wp-image-544\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-4.jpg\"><img class=\"alignnone  wp-image-545\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza.jpg\"><img class=\"alignnone  wp-image-546\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>", "Proyectos destacados", "Proyectos destacados realizados por nosotros", "inherit", "open", "open", "", "398-revision-11", "", "", "2012-04-19 15:22:03", "2012-04-19 19:22:03", "", "398", "http://s-m.cl/398-revision-11/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("596", "1", "2012-04-19 15:17:35", "2012-04-19 19:17:35", "<h4><img class=\"alignnone size-full wp-image-532\" title=\"proyectos_OK\" src=\"http://s-m.cl/wp-content/uploads/2012/03/proyectos_OK.jpg\" alt=\"\" width=\"576\" height=\"200\" /></h4>\r\n<h4>Explora</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora1.jpg\"><img class=\"alignnone  wp-image-512\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora2.jpg\"><img class=\"alignnone  wp-image-513\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora3.jpg\"><img class=\"alignnone  wp-image-514\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora4.jpg\"><img class=\"alignnone  wp-image-515\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora5.jpg\"><img class=\"alignnone  wp-image-516\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Los Bravos</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos1.jpg\"><img class=\"alignnone  wp-image-523\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos2.jpg\"><img class=\"alignnone  wp-image-526\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos3.jpg\"><img class=\"alignnone  wp-image-524\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos4.jpg\"><img class=\"alignnone  wp-image-525\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos5.jpg\"><img class=\"alignnone  wp-image-527\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Los Candiles</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles1.jpeg\"><img class=\"alignnone  wp-image-529\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles2.jpeg\"><img class=\"alignnone  wp-image-533\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles3.jpeg\"><img class=\"alignnone  wp-image-530\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles4.jpeg\"><img class=\"alignnone  wp-image-531\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles5.jpeg\"><img class=\"alignnone  wp-image-534\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Hotel Zapallar</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5194.jpg\"><img class=\"alignnone  wp-image-536\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5194-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5195.jpg\"><img class=\"alignnone  wp-image-537\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5195-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5197.jpg\"><img class=\"alignnone  wp-image-549\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5197-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5200.jpg\"><img class=\"alignnone  wp-image-550\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5200-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5201.jpg\"><img class=\"alignnone  wp-image-551\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5201-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5204.jpg\"><img class=\"alignnone  wp-image-552\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5204-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5206.jpg\"><img class=\"alignnone  wp-image-553\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5206-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5209.jpg\"><img class=\"alignnone  wp-image-554\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5209-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Casa Vichuquen</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/comedor.jpg\"><img class=\"alignnone  wp-image-539\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/comedor-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Living.jpg\"><img class=\"alignnone  wp-image-540\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Living-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/pasillo-interior.jpg\"><img class=\"alignnone  wp-image-541\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/pasillo-interior-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta-2.jpg\"><img class=\"alignnone  wp-image-542\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta-2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta.jpg\"><img class=\"alignnone  wp-image-543\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-3.jpg\"><img class=\"alignnone  wp-image-544\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-4.jpg\"><img class=\"alignnone  wp-image-545\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>    <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza.jpg\"><img class=\"alignnone  wp-image-546\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>", "Proyectos destacados", "Proyectos destacados realizados por nosotros", "inherit", "open", "open", "", "398-revision-9", "", "", "2012-04-19 15:17:35", "2012-04-19 19:17:35", "", "398", "http://s-m.cl/398-revision-9/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("595", "1", "2012-04-19 15:14:10", "2012-04-19 19:14:10", "<h4><img class=\"alignnone size-full wp-image-532\" title=\"proyectos_OK\" src=\"http://s-m.cl/wp-content/uploads/2012/03/proyectos_OK.jpg\" alt=\"\" width=\"576\" height=\"200\" /></h4>\r\n<h4>Explora</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora1.jpg\"><img class=\"alignnone  wp-image-512\" title=\"explora1\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora2.jpg\"><img class=\"alignnone  wp-image-513\" title=\"explora2\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora3.jpg\"><img class=\"alignnone  wp-image-514\" title=\"explora3\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora4.jpg\"><img class=\"alignnone  wp-image-515\" title=\"explora4\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora5.jpg\"><img class=\"alignnone  wp-image-516\" title=\"explora5\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Los Bravos</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos1.jpg\"><img class=\"alignnone  wp-image-523\" title=\"bravos1\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos2.jpg\"><img class=\"alignnone  wp-image-526\" title=\"bravos2\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos3.jpg\"><img class=\"alignnone  wp-image-524\" title=\"bravos3\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos4.jpg\"><img class=\"alignnone  wp-image-525\" title=\"bravos4\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos5.jpg\"><img class=\"alignnone  wp-image-527\" title=\"bravos5\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Los Candiles</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles1.jpeg\"><img class=\"alignnone  wp-image-529\" title=\"candiles1\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles2.jpeg\"><img class=\"alignnone  wp-image-533\" title=\"candiles2\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles3.jpeg\"><img class=\"alignnone  wp-image-530\" title=\"candiles3\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles4.jpeg\"><img class=\"alignnone  wp-image-531\" title=\"candiles4\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles5.jpeg\"><img class=\"alignnone  wp-image-534\" title=\"candiles5\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Hotel Zapallar</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5194.jpg\"><img class=\"alignnone  wp-image-536\" title=\"IMG_5194\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5194-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5195.jpg\"><img class=\"alignnone  wp-image-537\" title=\"IMG_5195\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5195-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5197.jpg\"><img class=\"alignnone  wp-image-549\" title=\"IMG_5197\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5197-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5200.jpg\"><img class=\"alignnone  wp-image-550\" title=\"IMG_5200\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5200-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5201.jpg\"><img class=\"alignnone  wp-image-551\" title=\"IMG_5201\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5201-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5204.jpg\"><img class=\"alignnone  wp-image-552\" title=\"IMG_5204\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5204-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5206.jpg\"><img class=\"alignnone  wp-image-553\" title=\"IMG_5206\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5206-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5209.jpg\"><img class=\"alignnone  wp-image-554\" title=\"IMG_5209\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5209-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Casa Vichuquen</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/comedor.jpg\"><img class=\"alignnone  wp-image-539\" title=\"comedor\" src=\"http://s-m.cl/wp-content/uploads/2012/03/comedor-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Living.jpg\"><img class=\"alignnone  wp-image-540\" title=\"Living\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Living-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/pasillo-interior.jpg\"><img class=\"alignnone  wp-image-541\" title=\"pasillo interior\" src=\"http://s-m.cl/wp-content/uploads/2012/03/pasillo-interior-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta-2.jpg\"><img class=\"alignnone  wp-image-542\" title=\"Puerta 2\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta-2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta.jpg\"><img class=\"alignnone  wp-image-543\" title=\"Puerta\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-3.jpg\"><img class=\"alignnone  wp-image-544\" title=\"Terraza 3\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>   <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-4.jpg\"><img class=\"alignnone  wp-image-545\" title=\"Terraza 4\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>    <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza.jpg\"><img class=\"alignnone  wp-image-546\" title=\"Terraza\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>", "Proyectos destacados", "Proyectos destacados realizados por nosotros", "inherit", "open", "open", "", "398-revision-8", "", "", "2012-04-19 15:14:10", "2012-04-19 19:14:10", "", "398", "http://s-m.cl/398-revision-8/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("604", "1", "2012-04-13 04:32:00", "2012-04-13 08:32:00", "&nbsp;\r\n\r\n<img class=\"alignnone size-full wp-image-561\" title=\"garantia_OK\" src=\"http://s-m.cl/wp-content/uploads/2012/03/garantia_OK.jpg\" alt=\"\" width=\"576\" height=\"200\" />\r\n\r\n<strong>Garantía</strong>\r\n\r\nTecnocom ha desarrollado un compuesto de PVC bajo las mas estrictas normas de calidad. Es por esto que el los perfiles de color blanco cuentan con una garantía de 7 años. Para los perfiles de color, Tecnocom trabaja con la firma Alemana SKAI, la cual da una garantía de 5 años sobre el folio. Infórmese sobre las condiciones y alcances de la garantía.\r\n\r\n<strong>Calidad</strong>\r\n\r\nUn proceso de calidad continuo es sinónimo de una marca líder. Desde la fabricación del compuesto hasta la extrusión y foliado del perfil, Tecnocom cuenta con un departamento de calidad para asegurar la entrega de un producto de clase mundial.\r\n\r\nDos laboratorios, uno de compuestos de PVC otro de Perfiles de PVC, colaboran continuamente en verificar los estándares de trabajo.", "Garantía &amp; calidad", "", "inherit", "open", "open", "", "372-revision-2", "", "", "2012-04-13 04:32:00", "2012-04-13 08:32:00", "", "372", "http://s-m.cl/372-revision-2/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("606", "1", "2012-04-13 04:59:21", "2012-04-13 08:59:21", "<p style=\"text-align: justify;\">El color es otorgado a nuestros perfiles través de un proceso denominado “foliado”, para este proceso se emplean laminas de PVC procedentes de Alemania, que son las encargadas de entregar las distintas terminaciones, texturas y colores a los perfiles, además de la protección UV, la calidad de estos productos está avalada por años de desarrollo e investigación a cargo de la empresa skai (<a href=\"http://www.skai.es\">www.skai.es</a>)</p>\r\n\r\n\r\n[caption id=\"attachment_581\" align=\"alignleft\" width=\"104\" caption=\"Techprofil\"]<a href=\"http://s-m.cl/wp-content/uploads/2012/03/techprofil.jpg\"><img class=\"wp-image-581 \" title=\"Techprofil\" src=\"http://s-m.cl/wp-content/uploads/2012/03/techprofil-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_580\" align=\"alignleft\" width=\"104\" caption=\"Staufereiche Terra\"]<a href=\"http://s-m.cl/wp-content/uploads/2012/03/staufereiche_terra.jpg\"><img class=\"wp-image-580   \" title=\"Staufereiche Terra\" src=\"http://s-m.cl/wp-content/uploads/2012/03/staufereiche_terra-116x116.jpg\" alt=\"Staufereiche Terra\" width=\"104\" height=\"104\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_579\" align=\"alignleft\" width=\"104\" caption=\"Staufereiche Kolonial\"]<a href=\"http://s-m.cl/wp-content/uploads/2012/03/staufereiche_kolonial.jpg\"><img class=\"wp-image-579  \" title=\"Staufereiche Kolonial\" src=\"http://s-m.cl/wp-content/uploads/2012/03/staufereiche_kolonial-116x116.jpg\" alt=\"Staufereiche Kolonial\" width=\"104\" height=\"104\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_578\" align=\"alignleft\" width=\"104\" caption=\"Metbrush Silver\"]<a href=\"http://s-m.cl/wp-content/uploads/2012/03/metbrush_silver.jpg\"><img class=\"wp-image-578  \" title=\"Metbrush Silver\" src=\"http://s-m.cl/wp-content/uploads/2012/03/metbrush_silver-116x116.jpg\" alt=\"Metbrush Silver\" width=\"104\" height=\"104\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_576\" align=\"alignleft\" width=\"104\" caption=\"Anthrazitgrau\"]<a href=\"http://s-m.cl/wp-content/uploads/2012/03/anthrazitgrau.jpg\"><img class=\"wp-image-576  \" title=\"Anthrazitgrau\" src=\"http://s-m.cl/wp-content/uploads/2012/03/anthrazitgrau-116x116.jpg\" alt=\"Anthrazitgrau\" width=\"104\" height=\"104\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_577\" align=\"alignleft\" width=\"104\" caption=\"Macoree\"]<a href=\"http://s-m.cl/wp-content/uploads/2012/03/macoree.jpg\"><img class=\"wp-image-577  \" title=\"Macoree\" src=\"http://s-m.cl/wp-content/uploads/2012/03/macoree-116x116.jpg\" alt=\"Macoree\" width=\"104\" height=\"104\" /></a>[/caption]", "Colores", "", "inherit", "open", "open", "", "379-revision-v1", "", "", "2012-04-13 04:59:21", "2012-04-13 08:59:21", "", "379", "http://s-m.cl/379-revision-7/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("605", "1", "2012-04-19 15:27:58", "2012-04-19 19:27:58", "&nbsp;\r\n\r\n<img class=\"alignnone size-full wp-image-561\" title=\"garantia_OK\" src=\"http://s-m.cl/wp-content/uploads/2012/03/garantia_OK.jpg\" alt=\"\" width=\"576\" height=\"200\" />\r\n\r\n<strong>Garantía</strong>\r\n\r\nTecnocom ha desarrollado un compuesto de PVC bajo las mas estrictas normas de calidad. Es por esto que el los perfiles de color blanco cuentan con una garantía de 7 años. Para los perfiles de color, Tecnocom trabaja con la firma Alemana SKAI, la cual da una garantía de 5 años sobre el folio. Infórmese sobre las condiciones y alcances de la garantía.\r\n\r\n<strong>Calidad</strong>\r\n\r\nUn proceso de calidad continuo es sinónimo de una marca líder. Desde la fabricación del compuesto hasta la extrusión y foliado del perfil. Tecnocom cuenta con un departamento de calidad para asegurar la entrega de un producto de clase mundial.\r\n\r\nDos laboratorios, uno de compuestos de PVC otro de Perfiles de PVC, colaboran continuamente en verificar los estándares de trabajo.", "Garantía &amp; calidad", "Un proceso de calidad continuo es sinónimo de una marca líder. Desde la fabricación del compuesto hasta la extrusión y foliado del perfil. ", "inherit", "open", "open", "", "372-revision-3", "", "", "2012-04-19 15:27:58", "2012-04-19 19:27:58", "", "372", "http://s-m.cl/372-revision-3/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("608", "1", "2012-06-06 13:45:03", "2012-06-06 17:45:03", "<img class=\"alignnone size-full wp-image-908\" title=\"Certificaciones\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/limones.jpg\" alt=\"\" width=\"810\" height=\"328\" />\n<h3>CERTIFICACIONES</h3>\nLos objetivos principales de <img class=\"alignnone size-full wp-image-904\" title=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/santamargherita-logo-01.png\" alt=\"\" width=\"80\" height=\"15\" /> son la calidad y seguridad de sus productos. Nuestro laboratorio de Investigación y Desarrollo pone siempre toda su atención en la realización de aglomerados capaces de hacer frente, por un lado a los criterios establecidos en relación con las emisiones de materiales para la decoración de interiores, para grandes espacios y para la industria de la construcción, y por otro lado, a los relacionados con el proyecto y realización de edificios energéticamente eficientes y con bajo impacto ambiental.\n\nGracias a esta atención y a la colaboración con institutos prestigiosos a nivel internacional, los productos <img class=\"alignnone size-full wp-image-904\" title=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/santamargherita-logo-01.png\" alt=\"\" width=\"80\" height=\"15\" /> han obtenido las importantes certiﬁcaciones <strong>NSF</strong> y <strong>Greenguard</strong>. Además, gracias a la cooperación con el Green Building Council Italia, del cual <img class=\"alignnone size-full wp-image-904\" title=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/santamargherita-logo-01.png\" alt=\"\" width=\"80\" height=\"15\" /> es Miembro Ordinario, y con el Distretto Tecnologico Trentino, la empresa ha elaborado su propio “Protocolo LEED” según las normas del <strong>United States Green Building Council - USGBC</strong> (Consejo de la Construcción Ecológica de Estados Unidos).\n\n&nbsp;\n\n<span style=\"color: #ffffff;\">...............................</span><img class=\" wp-image-934 alignnone\" title=\"Certificación NSF\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/certificacion-nsf.jpg\" alt=\"\" width=\"74\" height=\"69\" />                                                   <img class=\" wp-image-935 alignnone\" title=\"GGEnvironmentalInstitute\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/certificacion-greenguard.jpg\" alt=\"\" width=\"126\" height=\"69\" />                                             <img class=\"alignnone  wp-image-936\" title=\"Green Building Council\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/certificacion-gbc.gif\" alt=\"\" width=\"69\" height=\"69\" />", "Certificaciones", "Los productos Santamargherita han obtenido importantes certiﬁcaciones, como NSF y Greenguard.", "inherit", "open", "open", "", "383-autosave", "", "", "2012-06-06 13:45:03", "2012-06-06 17:45:03", "", "383", "http://s-m.cl/383-autosave/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("609", "1", "2012-04-13 04:33:09", "2012-04-13 08:33:09", "&nbsp;\r\n\r\n<img class=\"alignnone size-full wp-image-563\" title=\"eficiencia_OK\" src=\"http://s-m.cl/wp-content/uploads/2012/03/eficiencia_OK.jpg\" alt=\"\" width=\"576\" height=\"200\" />\r\n\r\nNuestro compromiso con el medio ambiente se basa desde el reciclaje de nuestros productos, de manera de ahorrar energía en los procesos de producción y en la fabricación de materias primas, además de cumplir con los estándares Europeos de fabricación para no dañar el medio ambiente.\r\n\r\nConstantemente estamos desarrollando tecnologías que nos permitan crear perfiles que tengan una mayor capacidad aislante, para llevar hasta tu casa el concepto de ahorro de energía y de esta manera contribuir con el medio ambiente como compromiso no solo de nuestra empresa, sino también a través de cada uno de nuestros clientes.", "Eficiencia energética", "", "inherit", "open", "open", "", "383-revision-2", "", "", "2012-04-13 04:33:09", "2012-04-13 08:33:09", "", "383", "http://s-m.cl/383-revision-2/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("610", "1", "2012-04-19 15:32:41", "2012-04-19 19:32:41", "&nbsp;\r\n\r\n<img class=\"alignnone size-full wp-image-563\" title=\"eficiencia_OK\" src=\"http://s-m.cl/wp-content/uploads/2012/03/eficiencia_OK.jpg\" alt=\"\" width=\"576\" height=\"200\" />\r\n\r\nNuestro compromiso con el medio ambiente se basa desde el reciclaje de nuestros productos, de manera de ahorrar energía en los procesos de producción y en la fabricación de materias primas, además de cumplir con los estándares Europeos de fabricación para no dañar el medio ambiente.\r\n\r\nConstantemente estamos desarrollando tecnologías que nos permitan crear perfiles que tengan una mayor capacidad aislante, para llevar hasta tu casa el concepto de ahorro de energía y de esta manera contribuir con el medio ambiente como compromiso no solo de nuestra empresa, sino también a través de cada uno de nuestros clientes.", "Eficiencia energética", "Constantemente estamos desarrollando tecnologías que nos permitan crear perfiles de mayor capacidad aislante.", "inherit", "open", "open", "", "383-revision-3", "", "", "2012-04-19 15:32:41", "2012-04-19 19:32:41", "", "383", "http://s-m.cl/383-revision-3/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("611", "1", "2012-04-19 15:33:12", "2012-04-19 19:33:12", "&nbsp;\r\n\r\n<img class=\"alignnone size-full wp-image-563\" title=\"eficiencia_OK\" src=\"http://s-m.cl/wp-content/uploads/2012/03/eficiencia_OK.jpg\" alt=\"\" width=\"576\" height=\"200\" />\r\n\r\nNuestro compromiso con el medio ambiente se basa desde el reciclaje de nuestros productos, de manera de ahorrar energía en los procesos de producción y en la fabricación de materias primas, además de cumplir con los estándares Europeos de fabricación para no dañar el medio ambiente.\r\n\r\nConstantemente estamos desarrollando tecnologías que nos permitan crear perfiles que tengan una mayor capacidad aislante, para llevar hasta tu casa el concepto de ahorro de energía y de esta manera contribuir con el medio ambiente como compromiso no solo de nuestra empresa, sino también a través de cada uno de nuestros clientes.", "Eficiencia energética", "Desarrollando tecnologías que nos permiten crear perfiles de mayor capacidad aislante.", "inherit", "open", "open", "", "383-revision-4", "", "", "2012-04-19 15:33:12", "2012-04-19 19:33:12", "", "383", "http://s-m.cl/383-revision-4/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("612", "1", "2012-04-13 04:34:39", "2012-04-13 08:34:39", "<img class=\"alignnone size-full wp-image-565\" title=\"certificaciones_OK\" src=\"http://s-m.cl/wp-content/uploads/2012/03/certificaciones_OK.jpg\" alt=\"\" width=\"576\" height=\"200\" />\r\n\r\nEl sistema de gestión de calidad para la fabricación de compuestos y masterbatch de PVC de la planta de Pablo de Podestá, se encuentra certificado por IRAM, con las normas ISO 9001:2008 y está acreditado ante INN (Chile), OAA (Argentina) e IQNet (Red Internacional).\r\n\r\n&nbsp;", "Certificaciones", "", "inherit", "open", "open", "", "386-revision-3", "", "", "2012-04-13 04:34:39", "2012-04-13 08:34:39", "", "386", "http://s-m.cl/386-revision-3/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("613", "1", "2012-04-13 04:39:11", "2012-04-13 08:39:11", "&nbsp;\r\n\r\n<img class=\"alignnone size-full wp-image-569\" title=\"novedades_OK\" src=\"http://s-m.cl/wp-content/uploads/2012/03/novedades_OK.jpg\" alt=\"\" width=\"576\" height=\"200\" />\r\n\r\n<strong>Sistema de apertura corredizo/paño fijo</strong>\r\n\r\n<strong>\r\n</strong>PVC Tecnocom ha lanzado al mercado un nuevo sistema de apertura CORREDIZO/PAÑO FIJO,  con el se pueden combinar aperturas de hojas móviles y paños fijos de medidas variadas y de hasta cuatro paños fijos.\r\n\r\n<strong>\r\nFolio Interior en ventanas de piso a cielo.</strong>\r\n\r\n<strong>\r\n</strong>PVC Tecnocom ha desarrollado dentro de sus productos una línea de perfiles destinada a entregar soluciones para ventanas de hojas móviles de piso a cielo, con el interior del marco foliado del mismo tono que el exterior del perfil, de manera de otorgar a las terminaciones de sus ventanas un acabado pulcro y homogéneo.\r\nSouth Merchants es la primera empresa en Chile en incorporar esta tecnología a sus soluciones de ventanas, entregándole al cliente un plus para el diseño de sus proyectos.", "Novedades", "", "inherit", "open", "open", "", "401-revision-2", "", "", "2012-04-13 04:39:11", "2012-04-13 08:39:11", "", "401", "http://s-m.cl/401-revision-2/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("614", "1", "2012-03-26 16:43:34", "2012-03-26 23:43:34", "<img class=\"alignnone size-full wp-image-478\" title=\"ventajas_OK\" src=\"http://s-m.cl/wp-content/uploads/2012/03/ventajas_OK.jpg\" alt=\"\" width=\"576\" height=\"200\" />\n\nLos perfiles Tecnocom son fabricados con una selección de PVC de primera calidad, además utilizamos avanzada tecnología en su proceso de fabricación de manera de garantizar altos estándares de calidad en el producto final.\n\nNuestros perfiles son sometidos a exigentes pruebas de calidad en nuestro laboratorio lo que permite su resistencia al envejecimiento sin ningún tratamiento de protección o mantenimiento adicional.\n\nNuestro principal objetivo es entregar a nuestros clientes un producto de excelente calidad.\n\nNuestros perfiles poseen las siguientes características:\n<h4><a name=\"acustico\"></a>Aislamiento Acústico:</h4>\nLa permeabilidad acústica en una construcción se produce a través de los vanos existentes en las fachadas, las ventanas Tecnocom ayudan a revertir estos niveles a través de cámaras interiores que cortan las ondas sonoras evitando su propagación, esto se complementa con un vidrio termopanal que contiene una cámara de aire interior que produce el mismo efecto, llegando a reducir en un 40% el ruido exterior, este porcentaje puede aumentar si se utiliza un vidrio acústico laminado.\n<h4><a name=\"termico\"></a>Aislamiento Térmico:</h4>\nEl PVC es un material de baja conductividad, esto permite que el material no transfiera las diferencias de temperatura de un recinto a otro, tampoco necesitan rotura del puente térmico ya que el perfil en toda su extensión rompe el puente térmico.\n\nTal como en el caso de la aislación acústica, las cámaras interiores contribuyen como barreras térmicas al exterior.\n<h4><a name=\"impacto\"></a>Resistencia al impacto y autoextincion:</h4>\nEl PVC por naturaleza es un material con alta resistencia al impacto y autoetinguible, nuestras ventanas al estar fabricadas con altos estándares de calidad y además con un refuerzo interior de acero por todo su perímetro, da como resultado un producto altamente resistente a todo tipo de golpes.\n\nEn el caso del fuego, son necesarias temperaturas continuas sobre los 300°C para que logre ignición y comiencen a consumirse muy lentamente.\n<h4><a name=\"con\"></a>Condensación:</h4>\nEn los materiales que poseen mayor conductividad se produce mayor condensación, el PVC al ser  un material de poca conductividad, prácticamente no condensa si los espacios son ventilados de manera correcta.\n<h4><a name=\"agua\"></a>Estanqueidad al Agua y Viento:</h4>\nEn el proceso de fabricación de las ventanas de PVC todas las partes que la componen van soldadas entre sí, lo que provoca total hermeticidad interior, logrando mayor estanqueidad al agua y al viento.\n<h4><a name=\"seguridad\"></a>Seguridad:</h4>\nTodas las virtudes del PVC en cuanto a su dureza, resistencia y hermeticidad se ven potenciadas por la alta tecnología que contienen los herrajes, lo que nos lleva a entregar cierres casi en un 100% herméticos, otorgando mayor seguridad y protección ante cualquier tipo de agresión externa.\n<h4><a name=\"diseno\"></a>Versatilidad de Diseño:</h4>\nEl PVC es un material que se puede modelar con el uso de temperatura, esta cualidad permite la creación de distintos diseños tales como figuras irregulares, arcos, ventanas asimétricas, etc. además existen distintos tipos y tonos de vidrios que pueden aportar en las distintas composiciones de fachadas.\n\nLa variedad de colores también nos permite generar contrastes y mimetizaciones con los distintos tipos de construcción, dependiendo del carácter que cada Arquitecto le quiera dar a la obra.", "Ventajas", "", "inherit", "open", "open", "", "404-revision", "", "", "2012-03-26 16:43:34", "2012-03-26 23:43:34", "", "404", "http://s-m.cl/404-revision/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("615", "1", "2012-05-14 16:22:13", "2012-05-14 20:22:13", "<a href=\"http://s-m.cl/wp-content/uploads/2012/03/mantencion-copia.jpg\"><img class=\"alignnone size-full wp-image-655\" title=\"mantencion copia\" src=\"http://s-m.cl/wp-content/uploads/2012/03/mantencion-copia.jpg\" alt=\"Mantención\" width=\"576\" height=\"200\" /></a>\n\nEl PVC es un material inerte, al que no le afecta la salinidad del mar, es insensible a la humedad, y altamente recomendable en ambientes agresivos; pero aún así es necesario mantener algunas condiciones mínimas de limpieza para asegurar su durabilidad.<strong id=\"internal-source-marker_0.037745180539786816\"></strong>\n<h4>PAUTAS DE LIMPIEZA</h4>\n<ul>\n	<li> Las ventanas poseen <strong>ranuras de aireación</strong>, éstas deben mantenerse limpias y sin residuos, de lo contrario, será difícil que cumplan su función.</li>\n	<li>Los <strong>perfiles</strong> tienen que limpiarse con un paño suave, agua y jabón neutro. Es necesario aclarar con agua abundante para evitar que queden residuos de jabón.</li>\n	<li>Una vez al año, conviene limpiar los <strong>elementos metálicos</strong> (herrajes) y engrasar todas las piezas móviles con aceite exento de ácidos.</li>\n	<li>Las <strong>juntas</strong> de cierre y acristalamiento (gomas) se deben limpiar con agua y jabón neutro.</li>\n	<li>No se debe utilizar ningún elemento abrasivo o ácidos para limpiar las ventanas.</li>\n</ul>\n<strong id=\"internal-source-marker_0.037745180539786816\">\n</strong>Debido al cierre hermético de las ventanas, es recomendable ventilar los recintos un mínimo de dos veces al día. \"En zonas geográficas con mayor grado de humedad\", es recomendable ampliar los tiempos de ventilación.\n\n<strong id=\"internal-source-marker_0.037745180539786816\">\n</strong>Si tienes alguna duda con respecto a tus ventanas TECNOCOM contáctanos al <strong>+56 (2) 7287186</strong> o a través de nuestro correo electrónico <em>info@s-m.cl</em>.\n\n&nbsp;", "Mantencion Post venta", "Es necesario mantener algunas condiciones de limpieza para asegurar la durabilidad del PVC.", "inherit", "open", "open", "", "407-autosave", "", "", "2012-05-14 16:22:13", "2012-05-14 20:22:13", "", "407", "http://s-m.cl/407-autosave/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("616", "1", "2012-04-13 04:41:35", "2012-04-13 08:41:35", "<img class=\"alignnone size-full wp-image-572\" title=\"mantencion_OK\" src=\"http://s-m.cl/wp-content/uploads/2012/03/mantencion_OK.jpg\" alt=\"\" width=\"576\" height=\"200\" />\r\n\r\nEl PVC es un material inerte, al que no le afecta la salinidad del mar, es insensible a la humedad, y altamente recomendable en ambientes agresivos; pero aún así es necesario mantener algunas condiciones mínimas de limpieza para asegurar su durabilidad.<strong id=\"internal-source-marker_0.037745180539786816\"></strong>\r\n<h4>PAUTAS DE LIMPIEZA</h4>\r\n<ul>\r\n	<li> Las ventanas poseen <strong>ranuras de aireación</strong>, éstas deben mantenerse limpias y sin residuos, de lo contrario, será difícil que cumplan su función.</li>\r\n	<li>Los <strong>perfiles</strong> tienen que limpiarse con un paño suave, agua y jabón neutro. Es necesario aclarar con agua abundante para evitar que queden residuos de jabón.</li>\r\n	<li>Una vez al año, conviene limpiar los <strong>elementos metálicos</strong> (herrajes) y engrasar todas las piezas móviles con aceite exento de ácidos.</li>\r\n	<li>Las <strong>juntas</strong> de cierre y acristalamiento (gomas) se deben limpiar con agua y jabón neutro.</li>\r\n	<li>No se debe utilizar ningún elemento abrasivo o ácidos para limpiar las ventanas.</li>\r\n</ul>\r\n<strong id=\"internal-source-marker_0.037745180539786816\">\r\n</strong>Debido al cierre hermético de las ventanas, es recomendable ventilar los recintos un mínimo de dos veces al día. \"En zonas geográficas con mayor grado de humedad\", es recomendable ampliar los tiempos de ventilación.\r\n\r\n<strong id=\"internal-source-marker_0.037745180539786816\">\r\n</strong>Si tienes alguna duda con respecto a tus ventanas TECNOCOM comunícate con nuestro servicio de Post-Venta al número de teléfono\r\n<strong>+56 (2) 7287186.</strong>\r\n\r\n<strong></strong>\r\nTambién puedes contactarte con nosotros a través de nuestro correo electrónico <em>info@s-m.cl</em> o visitar nuestra página web <strong>www.s-m.cl</strong>\r\n\r\n&nbsp;", "Mantencion Post venta", "", "inherit", "open", "open", "", "407-revision-3", "", "", "2012-04-13 04:41:35", "2012-04-13 08:41:35", "", "407", "http://s-m.cl/407-revision-3/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("719", "1", "2012-05-14 16:21:08", "2012-05-14 20:21:08", "<a href=\"http://s-m.cl/wp-content/uploads/2012/03/mantencion-copia.jpg\"><img class=\"alignnone size-full wp-image-655\" title=\"mantencion copia\" src=\"http://s-m.cl/wp-content/uploads/2012/03/mantencion-copia.jpg\" alt=\"Mantención\" width=\"576\" height=\"200\" /></a>\r\n\r\nEl PVC es un material inerte, al que no le afecta la salinidad del mar, es insensible a la humedad, y altamente recomendable en ambientes agresivos; pero aún así es necesario mantener algunas condiciones mínimas de limpieza para asegurar su durabilidad.<strong id=\"internal-source-marker_0.037745180539786816\"></strong>\r\n<h4>PAUTAS DE LIMPIEZA</h4>\r\n<ul>\r\n	<li> Las ventanas poseen <strong>ranuras de aireación</strong>, éstas deben mantenerse limpias y sin residuos, de lo contrario, será difícil que cumplan su función.</li>\r\n	<li>Los <strong>perfiles</strong> tienen que limpiarse con un paño suave, agua y jabón neutro. Es necesario aclarar con agua abundante para evitar que queden residuos de jabón.</li>\r\n	<li>Una vez al año, conviene limpiar los <strong>elementos metálicos</strong> (herrajes) y engrasar todas las piezas móviles con aceite exento de ácidos.</li>\r\n	<li>Las <strong>juntas</strong> de cierre y acristalamiento (gomas) se deben limpiar con agua y jabón neutro.</li>\r\n	<li>No se debe utilizar ningún elemento abrasivo o ácidos para limpiar las ventanas.</li>\r\n</ul>\r\n<strong id=\"internal-source-marker_0.037745180539786816\">\r\n</strong>Debido al cierre hermético de las ventanas, es recomendable ventilar los recintos un mínimo de dos veces al día. \"En zonas geográficas con mayor grado de humedad\", es recomendable ampliar los tiempos de ventilación.\r\n\r\n<strong id=\"internal-source-marker_0.037745180539786816\">\r\n</strong>Si tienes alguna duda con respecto a tus ventanas TECNOCOM contáctanos al <strong>+56 (2) 7287186</strong> o a través de nuestro correo electrónico <em>info@s-m.cl</em>.\r\n\r\n&nbsp;", "Mantencion Post venta", "Es necesario mantener algunas condiciones de limpieza para asegurar la durabilidad del PVC.", "inherit", "open", "open", "", "407-revision-6", "", "", "2012-05-14 16:21:08", "2012-05-14 20:21:08", "", "407", "http://s-m.cl/407-revision-6/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("617", "1", "2012-04-19 15:22:56", "2012-04-19 19:22:56", "<h4><img class=\"alignnone size-full wp-image-532\" title=\"proyectos_OK\" src=\"http://s-m.cl/wp-content/uploads/2012/03/proyectos_OK.jpg\" alt=\"\" width=\"576\" height=\"200\" /></h4>\r\n<h4>Explora</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora1.jpg\"><img class=\"alignnone  wp-image-512\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora2.jpg\"><img class=\"alignnone  wp-image-513\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora3.jpg\"><img class=\"alignnone  wp-image-514\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora4.jpg\"><img class=\"alignnone  wp-image-515\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora5.jpg\"><img class=\"alignnone  wp-image-516\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Los Bravos</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos1.jpg\"><img class=\"alignnone  wp-image-523\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos2.jpg\"><img class=\"alignnone  wp-image-526\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos3.jpg\"><img class=\"alignnone  wp-image-524\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos4.jpg\"><img class=\"alignnone  wp-image-525\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos5.jpg\"><img class=\"alignnone  wp-image-527\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Los Candiles</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles1.jpeg\"><img class=\"alignnone  wp-image-529\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles2.jpeg\"><img class=\"alignnone  wp-image-533\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles3.jpeg\"><img class=\"alignnone  wp-image-530\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles4.jpeg\"><img class=\"alignnone  wp-image-531\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles5.jpeg\"><img class=\"alignnone  wp-image-534\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Hotel Zapallar</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5194.jpg\"><img class=\"alignnone  wp-image-536\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5194-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5195.jpg\"><img class=\"alignnone  wp-image-537\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5195-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5197.jpg\"><img class=\"alignnone  wp-image-549\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5197-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5200.jpg\"><img class=\"alignnone  wp-image-550\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5200-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5201.jpg\"><img class=\"alignnone  wp-image-551\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5201-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5204.jpg\"><img class=\"alignnone  wp-image-552\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5204-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5206.jpg\"><img class=\"alignnone  wp-image-553\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5206-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5209.jpg\"><img class=\"alignnone  wp-image-554\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5209-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Casa Vichuquen</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/comedor.jpg\"><img class=\"alignnone  wp-image-539\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/comedor-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Living.jpg\"><img class=\"alignnone  wp-image-540\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Living-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/pasillo-interior.jpg\"><img class=\"alignnone  wp-image-541\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/pasillo-interior-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta-2.jpg\"><img class=\"alignnone  wp-image-542\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta-2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta.jpg\"><img class=\"alignnone  wp-image-543\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-3.jpg\"><img class=\"alignnone  wp-image-544\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-4.jpg\"><img class=\"alignnone  wp-image-545\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza.jpg\"><img class=\"alignnone  wp-image-546\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>", "Proyectos destacados", "Proyectos destacados realizados por nosotros", "inherit", "open", "open", "", "398-revision-12", "", "", "2012-04-19 15:22:56", "2012-04-19 19:22:56", "", "398", "http://s-m.cl/398-revision-12/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("618", "1", "2012-04-19 15:28:36", "2012-04-19 19:28:36", "&nbsp;\r\n\r\n<img class=\"alignnone size-full wp-image-561\" title=\"garantia_OK\" src=\"http://s-m.cl/wp-content/uploads/2012/03/garantia_OK.jpg\" alt=\"\" width=\"576\" height=\"200\" />\r\n\r\n<strong>Garantía</strong>\r\n\r\nTecnocom ha desarrollado un compuesto de PVC bajo las mas estrictas normas de calidad. Es por esto que el los perfiles de color blanco cuentan con una garantía de 7 años. Para los perfiles de color, Tecnocom trabaja con la firma Alemana SKAI, la cual da una garantía de 5 años sobre el folio. Infórmese sobre las condiciones y alcances de la garantía.\r\n\r\n<strong>Calidad</strong>\r\n\r\nUn proceso de calidad continuo es sinónimo de una marca líder. Desde la fabricación del compuesto hasta la extrusión y foliado del perfil. Tecnocom cuenta con un departamento de calidad para asegurar la entrega de un producto de clase mundial.\r\n\r\nDos laboratorios, uno de compuestos de PVC otro de Perfiles de PVC, colaboran continuamente en verificar los estándares de trabajo.", "Garantía &amp; calidad", "Un proceso de calidad continuo es sinónimo de una marca líder.", "inherit", "open", "open", "", "372-revision-4", "", "", "2012-04-19 15:28:36", "2012-04-19 19:28:36", "", "372", "http://s-m.cl/372-revision-4/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("619", "1", "2012-04-19 15:40:42", "2012-04-19 19:40:42", "&nbsp;\r\n\r\n<img class=\"alignnone size-full wp-image-561\" title=\"garantia_OK\" src=\"http://s-m.cl/wp-content/uploads/2012/03/garantia_OK.jpg\" alt=\"\" width=\"576\" height=\"200\" />\r\n\r\n<strong>Garantía</strong>\r\n\r\nTecnocom ha desarrollado un compuesto de PVC bajo las mas estrictas normas de calidad. Es por esto que el los perfiles de color blanco cuentan con una garantía de 7 años. Para los perfiles de color, Tecnocom trabaja con la firma Alemana SKAI, la cual da una garantía de 5 años sobre el folio. Infórmese sobre las condiciones y alcances de la garantía.\r\n\r\n<strong>Calidad</strong>\r\n\r\nUn proceso de calidad contínuo es sinónimo de una marca líder. Desde la fabricación del compuesto hasta la extrusión y foliado del perfil. Tecnocom cuenta con un departamento de calidad para asegurar la entrega de un producto de clase mundial.\r\n\r\nDos laboratorios, uno de compuestos de PVC otro de Perfiles de PVC, colaboran continuamente en verificar los estándares de trabajo.", "Garantía &amp; calidad", "Un proceso de calidad contínuo es sinónimo de una marca líder.", "inherit", "open", "open", "", "372-revision-5", "", "", "2012-04-19 15:40:42", "2012-04-19 19:40:42", "", "372", "http://s-m.cl/372-revision-5/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("620", "1", "2012-06-06 12:53:02", "2012-06-06 16:53:02", "<img class=\"alignnone size-full wp-image-858\" title=\"Santamargherita\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/04/somos.jpg\" alt=\"\" width=\"810\" height=\"328\" />\n<h3>QUIENES SOMOS</h3>\n<img class=\"alignnone size-full wp-image-904\" title=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/santamargherita-logo-01.png\" alt=\"\" width=\"80\" height=\"15\" /> es una empresa Italiana líder en el mercado de los aglomerados, con más de 40 años de trayectoria y presente en más de 70 Países, siempre atenta a las nuevas tendencias de la arquitectura y del diseño interior, la empresa ubicada en Volargne di Dolcè (Verona) con más de 100.000 metros construidos, satisface las exigencias de diseño y calidad, ofreciendo a sus clientes líneas sobrias y esenciales, con tonalidades neutras y elegantes y líneas más innovadoras y exclusivas con colores cautivadores y acabados únicos.\n\nSantamargherita llega a Chile con su línea trafficstone para dar solución a los más variados proyectos tanto residenciales como públicos; su composición de 93% de cuarzo y un 7% de resina poliéster, le otorga cualidades únicas en el mercado, transformándolo en la mejor solución para cubiertas de baños y cocinas, además de revestimientos de muros y pisos.", "Quienes somos", "", "inherit", "open", "open", "", "432-autosave", "", "", "2012-06-06 12:53:02", "2012-06-06 16:53:02", "", "432", "http://s-m.cl/432-autosave/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("764", "1", "2012-05-24 15:56:25", "2012-05-24 19:56:25", "<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/aplicaciones.jpg\"><img class=\"alignnone size-full wp-image-738\" title=\"Aplicaciones\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/aplicaciones.jpg\" alt=\"\" width=\"576\" height=\"200\" /></a>\r\n\r\n<a name=\"bano\"></a><strong><em>Aglomerado de Cuarzo para encimeras de Cocina y Baño</em></strong>\r\n\r\nCada casa refleja la personalidad de quienes viven en ella. Caracteres, gustos y estilos que pueden llegar a ser infinitos, opuestos entre ellos; desde el neoclásico hasta el barroco, desde la ostentación hasta el minimalismo, con el uso de una paleta de colores desde las tonalidades más claras hasta las más fuertes.<strong><em></em></strong>\r\n\r\nSANTAMARGHERITA, a través de una investigación constante, crea superficies con altas prestaciones técnicas y que son estéticamente capaces de hacer que los ambientes domésticos sean únicos satisfaciendo perfectamente las diferentes exigencias.\r\n\r\nEl material ideal para pavimentos y revestimientos, cabinas de ducha y encimeras de cocina y baño se caracteriza, por un lado, por la alta resistencia a la flexión, abrasión y ácidos, y por el otro, por la variedad de colores y texturas más neutras o con mayor profundidad y efectos de movimiento.\r\n\r\nActualmente en el diseño de interiores está marcado el uso de tamaño cada vez más grandes y personalizados, por tanto las colecciones de aglomerado con base de cuarzo SANTAMARGHERITA se proponen en baldosas de dimensiones estándares o variables. Para cada proyecto, para cada exigencia, para cada gusto, SANTAMARGHERITA dispone de la superficie ideal.\r\n\r\n&nbsp;\r\n\r\n<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/aeropuerto.jpg\"><img class=\"alignnone size-full wp-image-742\" title=\"Aeropuerto\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/aeropuerto.jpg\" alt=\"\" width=\"576\" height=\"200\" /></a>\r\n\r\n<a name=\"aeropuerto\"></a><strong><em>Aglomerado de Cuarzo para superficies de grandes obras</em></strong>\r\n\r\nAeropuertos, estaciones de trenes, centros comerciales, grandes superficies en todo el mundo ostentan actualmente pavimentos y revestimientos con la marca SANTAMARGHERITA. Las potencialidades del aglomerado de cuarzo permiten que SANTAMARGHERITA responda a las exigencias en lo que se refiere a complejidad y personalidad de cada proyecto, a partir del suministro de grandes volúmenes hasta un servicio de investigación y desarrollo de nuevos colores personalizados que dan originalidad y unicidad al producto.\r\n\r\n&nbsp;", "Aplicaciones", "Cada casa refleja la personalidad de quienes viven en ella.", "inherit", "open", "open", "", "386-revision-7", "", "", "2012-05-24 15:56:25", "2012-05-24 19:56:25", "", "386", "http://santamargherita.s-m.cl/386-revision-7/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("765", "1", "2012-05-28 11:49:24", "2012-05-28 15:49:24", "", "bgceleste", "", "inherit", "open", "open", "", "bgceleste", "", "", "2012-05-28 11:49:24", "2012-05-28 15:49:24", "", "0", "http://santamargherita.s-m.cl/wp-content/uploads/2012/05/bgceleste.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("766", "1", "2012-05-24 15:39:38", "2012-05-24 19:39:38", "<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/certificaciones.jpg\"><img class=\"alignnone size-full wp-image-736\" title=\"Certificaciones\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/certificaciones.jpg\" alt=\"\" width=\"576\" height=\"200\" /></a>\r\n\r\nLos objetivos principales de SANTAMARGHERITA son la calidad y seguridad de sus productos. Nuestro laboratorio de Investigación y Desarrollo pone siempre toda su atención en la realización de aglomerados capaces de hacer frente, por un lado a los criterios establecidos en relación con las emisiones de materiales para la decoración de interiores, para grandes espacios y para la industria de la construcción, y por otro lado, a los relacionados con el proyecto y realización de edificios energéticamente eficientes y con bajo impacto ambiental.\r\nGracias a esta atención y a la colaboración con institutos prestigiosos a nivel internacional, los productos SANTAMARGHERITA han obtenido las importantes certiﬁcaciones NSF y GREENGUARD. Además, gracias a la cooperación con el Green Building Council Italia, del cual SANTAMARGHERITA es Miembro Ordinario, y con el Distretto Tecnologico Trentino, la empresa ha elaborado su propio “Protocolo LEED” según las normas del United States Green Building Council - USGBC (Consejo de la Construcción Ecológica de Estados Unidos).", "Certificaciones", "Los productos Santamargherita han obtenido importantes certiﬁcaciones, como NSF y GREENGUARD.", "inherit", "open", "open", "", "383-revision-6", "", "", "2012-05-24 15:39:38", "2012-05-24 19:39:38", "", "383", "http://santamargherita.s-m.cl/383-revision-6/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("768", "1", "2012-05-28 12:15:00", "2012-05-28 16:15:00", "", "Antracite", "Antracite", "inherit", "open", "open", "", "antracite-b", "", "", "2012-05-28 12:15:00", "2012-05-28 16:15:00", "", "379", "http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Antracite-b.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("621", "1", "2012-04-02 18:08:52", "2012-04-03 01:08:52", "<img class=\"alignnone size-full wp-image-481\" title=\"empresa_OK\" src=\"http://s-m.cl/wp-content/uploads/2012/04/empresa_OK.jpg\" alt=\"\" width=\"576\" height=\"200\" />\n<h4><a name=\"empresa\"></a>La Empresa</h4>\nTecnocom inicia sus actividades comerciales en 1975, y desde entonces ha venido desarrollando un importante proceso de expansión, demostrando desde sus inicios una constante vitalidad y crecimiento, cualidades que sumadas  a la alta tecnología utilizada le permite ocupar una posición de liderazgo.\n\nEn la actualidad tiene 3 divisiones: Compuestos de PVC, Mangueras de PVC y Perfiles de PVC que en conjunto facturan al año aproximadamente US$100 millones.\n\nSon tres las instalaciones industriales con las que cuenta, dos en Buenos Aires y una en San Luis\n\nLa división perfiles se creó hace 7 años con la más moderna tecnología europea con el objetivo de ser un actor relevante en este segmento de productos en Latinoamérica.\n\nHoy Tecnocom con sus perfiles para ventanas y puertas de PVC es líder el mercado argentino con más de 55 armadores y hoy tiene presencia en México, Centro América, Colombia, Perú, Brasil, Bolivia, Uruguay y Chile.\n\nLos sistemas de perfiles son fabricados bajo las normas europeas UNE-EN 12608, que aseguran un producto de calidad que cumple todas las exigencias referidas a pruebas de Dimensionado, Pruebas Mecánicas, Pruebas Térmicas, Resistencia a los rayos UV, entre otros. (Si requiere de las normas y sus resultados no dude en solicitarlas).\n<h4><a name=\"objetivos\"></a>Nuestros Objetivos</h4>\nResponder  a las expectativas de los clientes, colaboradores y la comunidad, participando en el desarrollo de aplicaciones para mejorar la calidad de vida de la sociedad.\n\nNos esforzamos por ser los lideres y referentes del mercado en la producción y comercialización de artículos de óptima calidad. Este es nuestro compromiso con la comunidad latinoamericana de la que formamos parte.\n<h4><a name=\"tecnologia\"></a>Nuestra Tecnología</h4>\nNuestras plantas están equipadas con las mejores líneas de producción de otigen Aleman, Italiano y Austriaco, las que están diseñadas para responder a las mas añtas exigencias de productividad y calidad.\n<h4><a name=\"personal\"></a>Nuestro Personal</h4>\nEs nuestro principal activo para el logro de nuestros objetivos, porque es la fuente de nuestra energía e inteligencia.\n\nEstamos convencidos de que detrás de toda gran empresa, siempre hay un gran grupo humano, y que solo con el personal idóneo y comprometido con los objetivos de la empresa es posible producir más y mejores soluciones.\n<h4><a name=\"mundo\"></a>TECNOCOM EN EL MUNDO</h4>\nCualquier empresa líder debe abrirse a mercados extranjeros. Tecnocom hoy cuenta con oficinas propias o representantes en toda Latinoamerica.\n\nCada mercado es único y Tecnocom lo entiende. Es por ello que se han desarrollado líneas y colores específicos para poder cumplir con demandas locales.\n\nHoy para Latinoamérica Tecnocom cuenta con la más amplia gama de soluciones que combinan alto nivel estético, tecnología, eficiencia energética y cuidado del medio ambiente.\n<h4><a name=\"laboratorio\"></a>LABORATORIO</h4>\nLos controles diarios que realizan los expertos en nuestro laboratorio interno, son uno de los pilares básicos del <strong>control de calidad continuo</strong> al que se someten los perfiles de PVC Tecnocom.\n\nTodas las características de las materias primas, los perfiles extrusionados y los sistemas de ventanas y puertas de PVC acabadas, se controlan cuidadosamente de acuerdo con los criterios más estrictos, fijados por una serie de instituciones de ámbito nacional e internacional.\n\nTecnocom cuenta con un laboratorio de primer nivel donde en forma diaria se controlan todos los lotes de producción.\n\nLa inalterabilidad de las superficies, resistencia al impacto y la autenticidad del color blanco están garantizadas según norma europea UNE 53.360.\n<h4><a name=\"ensayo\"></a>BANCO DE ENSAYO</h4>\nDesde la inauguración de la planta de perfiles de PVC, Tecnocom cuenta con uno de los mas modernos bancos de ensayo alemán K Schulten.\n\nDefectos de productos que aparecen y reclamos, por regla general acarrean desagradables problemas financieros y de prestigio.\nEstos efectos secundarios negativos exigen una necesidad de seguridad.\nLa aplicación de propios bancos de ensayos para ventanas, dan garantía de estándares de calidad y de seguridad de muchos productores de ventanas.\n\nLa función del banco de ensayo es poder analizar el comportamiento de una ventana ante distintas presiones de viento y agua. Esto permite a Tecnocom analizar el comportamiento de los perfiles y los otros componentes de la ventana ante distintas situaciones emulando condiciones reales.\n<p style=\"text-align: left;\"><strong>- Ensayo de Estaquiedad al Agua</strong></p>\n\n<ul style=\"text-align: left;\">\n	<li>ESTANQUEIDAD AL AGUA: capacidad de una ventana de oponerse a las infiltraciones de agua en distintos niveles de presión estática.</li>\n	<li>INFILTRACIÓN: penetración continua o intermitente de agua en contacto con elementos de construcción no previstos para ser mojados.</li>\n	<li>LÍMITE DE ESTANQUEIDAD AL AGUA: presión máxima registrada en el curso del ensayo, para la cual está asegurada la estanqueidad al agua.</li>\n</ul>\n<p style=\"text-align: left;\"><strong>- Ensayo a la acción del viento</strong></p>\n\n<ul style=\"text-align: justify;\">\n	<li style=\"text-align: left;\">Deformación residual permanente: modificación de la forma o de las medidas, producida por la aplicación de presiones, que no desaparece después que las presiones han dejado de aplicarse.</li>\n	<li style=\"text-align: left;\">Deformación residual temporal: modificación de la forma o de las medidas producidas por la aplicación de presiones, que desaparece progresivamente después que las presiones han dejado de aplicarse.</li>\n	<li style=\"text-align: left;\">Desplazamiento frontal: desplazamiento de un punto de un elemento de ventana medido perpendicularmente al plano de la ventana.</li>\n	<li style=\"text-align: left;\">Flecha frontal: diferencia máxima entre los desplazamientos frontales, tomada a lo largo de un mismo elemento de ventana (después de que se ha compensado el efecto de los desplazamientos frontales de las extremidades de este elemento).</li>\n	<li style=\"text-align: left;\">Flecha frontal relativa: Valor de la flecha frontal en relación con la distancia entre las dos extremidades del elemento de ventana examinado.</li>\n</ul>", "Quienes somos", "", "inherit", "open", "open", "", "432-revision", "", "", "2012-04-02 18:08:52", "2012-04-03 01:08:52", "", "432", "http://s-m.cl/432-revision/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("622", "1", "2012-04-19 15:39:56", "2012-04-19 19:39:56", "<h4><img class=\"alignnone size-full wp-image-532\" title=\"proyectos_OK\" src=\"http://s-m.cl/wp-content/uploads/2012/03/proyectos_OK.jpg\" alt=\"\" width=\"576\" height=\"200\" /></h4>\r\n<h4>Explora</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora1.jpg\"><img class=\"alignnone  wp-image-512\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora2.jpg\"><img class=\"alignnone  wp-image-513\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora3.jpg\"><img class=\"alignnone  wp-image-514\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora4.jpg\"><img class=\"alignnone  wp-image-515\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora5.jpg\"><img class=\"alignnone  wp-image-516\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Los Bravos</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos1.jpg\"><img class=\"alignnone  wp-image-523\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos2.jpg\"><img class=\"alignnone  wp-image-526\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos3.jpg\"><img class=\"alignnone  wp-image-524\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos4.jpg\"><img class=\"alignnone  wp-image-525\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos5.jpg\"><img class=\"alignnone  wp-image-527\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Los Candiles</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles1.jpeg\"><img class=\"alignnone  wp-image-529\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles2.jpeg\"><img class=\"alignnone  wp-image-533\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles3.jpeg\"><img class=\"alignnone  wp-image-530\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles4.jpeg\"><img class=\"alignnone  wp-image-531\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles5.jpeg\"><img class=\"alignnone  wp-image-534\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Hotel Zapallar</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5194.jpg\"><img class=\"alignnone  wp-image-536\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5194-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5195.jpg\"><img class=\"alignnone  wp-image-537\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5195-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5197.jpg\"><img class=\"alignnone  wp-image-549\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5197-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5200.jpg\"><img class=\"alignnone  wp-image-550\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5200-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5201.jpg\"><img class=\"alignnone  wp-image-551\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5201-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5204.jpg\"><img class=\"alignnone  wp-image-552\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5204-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5206.jpg\"><img class=\"alignnone  wp-image-553\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5206-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5209.jpg\"><img class=\"alignnone  wp-image-554\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5209-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Casa Vichuquen</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/comedor.jpg\"><img class=\"alignnone  wp-image-539\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/comedor-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Living.jpg\"><img class=\"alignnone  wp-image-540\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Living-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/pasillo-interior.jpg\"><img class=\"alignnone  wp-image-541\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/pasillo-interior-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta-2.jpg\"><img class=\"alignnone  wp-image-542\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta-2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta.jpg\"><img class=\"alignnone  wp-image-543\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-3.jpg\"><img class=\"alignnone  wp-image-544\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-4.jpg\"><img class=\"alignnone  wp-image-545\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza.jpg\"><img class=\"alignnone  wp-image-546\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>", "Proyectos destacados", "Proyectos destacados realizados por nosotros.", "inherit", "open", "open", "", "398-revision-13", "", "", "2012-04-19 15:39:56", "2012-04-19 19:39:56", "", "398", "http://s-m.cl/398-revision-13/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("624", "1", "2012-04-25 12:06:27", "2012-04-25 16:06:27", "Puede visitarnos en Santa Inés 2175, Conchalí. Santiago de Chile y\ncontactarnos a través del teléfono (56 2) 7287186.\n\nPara escribirnos utilice el e-mail info@s-m.cl o complete el siguiente formulario.\nLe responderemos a la brevedad.\n\n[contact_form]", "Contacto", "", "inherit", "open", "open", "", "452-autosave", "", "", "2012-04-25 12:06:27", "2012-04-25 16:06:27", "", "452", "http://s-m.cl/452-autosave/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("625", "1", "2012-04-05 01:16:52", "2012-04-05 08:16:52", "[contact_form] ", "Contacto", "", "inherit", "open", "open", "", "452-revision", "", "", "2012-04-05 01:16:52", "2012-04-05 08:16:52", "", "452", "http://s-m.cl/452-revision/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("626", "1", "2012-04-25 12:00:53", "2012-04-25 16:00:53", "Puede visitarnos en Santa Inés 2175, Conchalí. Santiago de Chile, o llamarnos al teléfono (56 2) 7287186.\r\nTambién puede escribirnos al e-mail info@s-m.cl o completando el siguiente formulario.\r\n\r\n[contact_form]", "Contacto", "", "inherit", "open", "open", "", "452-revision-2", "", "", "2012-04-25 12:00:53", "2012-04-25 16:00:53", "", "452", "http://s-m.cl/452-revision-2/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("627", "1", "2012-04-25 12:02:14", "2012-04-25 16:02:14", "Puede visitarnos en Santa Inés 2175, Conchalí. Santiago de Chile o\r\ncontactarnos a través del teléfono (56 2) 7287186.\r\nTambién puede escribirnos al e-mail <strong>info@s-m.cl</strong> o completando el siguiente formulario.\r\n\r\n[contact_form]", "Contacto", "", "inherit", "open", "open", "", "452-revision-3", "", "", "2012-04-25 12:02:14", "2012-04-25 16:02:14", "", "452", "http://s-m.cl/452-revision-3/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("628", "1", "2012-04-25 12:02:57", "2012-04-25 16:02:57", "Puede visitarnos en Santa Inés 2175, Conchalí. Santiago de Chile o\r\ncontactarnos a través del teléfono (56 2) 7287186.\r\nTambién puede escribirnos al e-mail info@s-m.cl o completando el siguiente formulario.\r\n\r\n[contact_form]", "Contacto", "", "inherit", "open", "open", "", "452-revision-4", "", "", "2012-04-25 12:02:57", "2012-04-25 16:02:57", "", "452", "http://s-m.cl/452-revision-4/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("629", "1", "2012-04-25 12:03:11", "2012-04-25 16:03:11", "Puede visitarnos en Santa Inés 2175, Conchalí. Santiago de Chile o\r\ncontactarnos a través del teléfono (56 2) 7287186.\r\nTambién puede escribirnos al e-mail info@s-m.cl o completando el siguiente formulario.\r\n\r\n[contact_form]", "Contacto", "", "inherit", "open", "open", "", "452-revision-5", "", "", "2012-04-25 12:03:11", "2012-04-25 16:03:11", "", "452", "http://s-m.cl/452-revision-5/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("630", "1", "2012-04-25 12:03:20", "2012-04-25 16:03:20", "Puede visitarnos en Santa Inés 2175, Conchalí. Santiago de Chile o\r\ncontactarnos a través del teléfono (56 2) 7287186.\r\n\r\n&nbsp;\r\nTambién puede escribirnos al e-mail info@s-m.cl o completando el siguiente formulario.\r\n\r\n[contact_form]", "Contacto", "", "inherit", "open", "open", "", "452-revision-6", "", "", "2012-04-25 12:03:20", "2012-04-25 16:03:20", "", "452", "http://s-m.cl/452-revision-6/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("631", "1", "2012-04-25 12:03:59", "2012-04-25 16:03:59", "Puede visitarnos en Santa Inés 2175, Conchalí. Santiago de Chile y\r\ncontactarnos a través del teléfono (56 2) 7287186.\r\nTambién puede escribirnos al e-mail info@s-m.cl o completando el siguiente formulario.\r\n\r\n[contact_form]", "Contacto", "", "inherit", "open", "open", "", "452-revision-7", "", "", "2012-04-25 12:03:59", "2012-04-25 16:03:59", "", "452", "http://s-m.cl/452-revision-7/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("632", "1", "2012-04-25 12:04:58", "2012-04-25 16:04:58", "Puede visitarnos en Santa Inés 2175, Conchalí. Santiago de Chile y\r\ncontactarnos a través del teléfono (56 2) 7287186.\r\nPara escribirnos utilice el e-mail info@s-m.cl o complete el siguiente formulario. Le responderemos a la brevedad.\r\n\r\n[contact_form]", "Contacto", "", "inherit", "open", "open", "", "452-revision-8", "", "", "2012-04-25 12:04:58", "2012-04-25 16:04:58", "", "452", "http://s-m.cl/452-revision-8/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("634", "1", "2012-04-25 12:05:24", "2012-04-25 16:05:24", "Puede visitarnos en Santa Inés 2175, Conchalí. Santiago de Chile y\r\ncontactarnos a través del teléfono (56 2) 7287186.\r\n\r\nPara escribirnos utilice el e-mail info@s-m.cl o complete el siguiente formulario.\r\nLe responderemos a la brevedad.\r\n\r\n[contact_form]", "Contacto", "", "inherit", "open", "open", "", "452-revision-9", "", "", "2012-04-25 12:05:24", "2012-04-25 16:05:24", "", "452", "http://s-m.cl/452-revision-9/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("640", "1", "2012-04-19 15:52:02", "2012-04-19 19:52:02", "<h4><img class=\"alignnone size-full wp-image-532\" title=\"proyectos_OK\" src=\"http://s-m.cl/wp-content/uploads/2012/03/proyectos_OK.jpg\" alt=\"\" width=\"576\" height=\"200\" /></h4>\r\n<h4>Explora</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora1.jpg\"><img class=\"alignnone  wp-image-512\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora2.jpg\"><img class=\"alignnone  wp-image-513\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora3.jpg\"><img class=\"alignnone  wp-image-514\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora4.jpg\"><img class=\"alignnone  wp-image-515\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora5.jpg\"><img class=\"alignnone  wp-image-516\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Los Bravos</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos1.jpg\"><img class=\"alignnone  wp-image-523\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos2.jpg\"><img class=\"alignnone  wp-image-526\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos3.jpg\"><img class=\"alignnone  wp-image-524\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos4.jpg\"><img class=\"alignnone  wp-image-525\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos5.jpg\"><img class=\"alignnone  wp-image-527\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Los Candiles</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles1.jpeg\"><img class=\"alignnone  wp-image-529\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles2.jpeg\"><img class=\"alignnone  wp-image-533\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles3.jpeg\"><img class=\"alignnone  wp-image-530\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles4.jpeg\"><img class=\"alignnone  wp-image-531\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles5.jpeg\"><img class=\"alignnone  wp-image-534\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Hotel Zapallar</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5194.jpg\"><img class=\"alignnone  wp-image-536\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5194-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5195.jpg\"><img class=\"alignnone  wp-image-537\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5195-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5197.jpg\"><img class=\"alignnone  wp-image-549\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5197-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5200.jpg\"><img class=\"alignnone  wp-image-550\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5200-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5201.jpg\"><img class=\"alignnone  wp-image-551\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5201-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5204.jpg\"><img class=\"alignnone  wp-image-552\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5204-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5206.jpg\"><img class=\"alignnone  wp-image-553\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5206-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5209.jpg\"><img class=\"alignnone  wp-image-554\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5209-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Casa Vichuquen</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/comedor.jpg\"><img class=\"alignnone  wp-image-539\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/comedor-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Living.jpg\"><img class=\"alignnone  wp-image-540\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Living-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/pasillo-interior.jpg\"><img class=\"alignnone  wp-image-541\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/pasillo-interior-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta-2.jpg\"><img class=\"alignnone  wp-image-542\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta-2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta.jpg\"><img class=\"alignnone  wp-image-543\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-3.jpg\"><img class=\"alignnone  wp-image-544\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-4.jpg\"><img class=\"alignnone  wp-image-545\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza.jpg\"><img class=\"alignnone  wp-image-546\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>", "Proyectos destacados", "Proyectos destacados realizados por nuestra empresa.", "inherit", "open", "open", "", "398-revision-14", "", "", "2012-04-19 15:52:02", "2012-04-19 19:52:02", "", "398", "http://s-m.cl/398-revision-14/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("641", "1", "2012-04-26 09:41:18", "2012-04-26 13:41:18", "&nbsp;\r\n\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/calidad.jpg\"><img class=\"alignnone size-full wp-image-635\" title=\"calidad\" src=\"http://s-m.cl/wp-content/uploads/2012/03/calidad.jpg\" alt=\"Garantía &amp; Calidad\" width=\"576\" height=\"200\" /></a>\r\n\r\n<strong>Garantía</strong>\r\n\r\nTecnocom ha desarrollado un compuesto de PVC bajo las mas estrictas normas de calidad. Es por esto que el los perfiles de color blanco cuentan con una garantía de 7 años. Para los perfiles de color, Tecnocom trabaja con la firma Alemana SKAI, la cual da una garantía de 5 años sobre el folio. Infórmese sobre las condiciones y alcances de la garantía.\r\n\r\n<strong>Calidad</strong>\r\n\r\nUn proceso de calidad contínuo es sinónimo de una marca líder. Desde la fabricación del compuesto hasta la extrusión y foliado del perfil. Tecnocom cuenta con un departamento de calidad para asegurar la entrega de un producto de clase mundial.\r\n\r\nDos laboratorios, uno de compuestos de PVC otro de Perfiles de PVC, colaboran continuamente en verificar los estándares de trabajo.", "Garantía &amp; calidad", "Un proceso de calidad contínuo es sinónimo de una marca líder.", "inherit", "open", "open", "", "372-revision-7", "", "", "2012-04-26 09:41:18", "2012-04-26 13:41:18", "", "372", "http://s-m.cl/372-revision-7/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("642", "1", "2012-04-26 09:47:52", "2012-04-26 13:47:52", "<h4><a href=\"http://s-m.cl/wp-content/uploads/2012/03/proyectos.jpg\"><img class=\"alignnone size-full wp-image-638\" title=\"proyectos\" src=\"http://s-m.cl/wp-content/uploads/2012/03/proyectos.jpg\" alt=\"Proyectos destacados\" width=\"576\" height=\"200\" /></a></h4>\r\n<h4>Explora</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora1.jpg\"><img class=\"alignnone  wp-image-512\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora2.jpg\"><img class=\"alignnone  wp-image-513\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora3.jpg\"><img class=\"alignnone  wp-image-514\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora4.jpg\"><img class=\"alignnone  wp-image-515\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora5.jpg\"><img class=\"alignnone  wp-image-516\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Los Bravos</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos1.jpg\"><img class=\"alignnone  wp-image-523\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos2.jpg\"><img class=\"alignnone  wp-image-526\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos3.jpg\"><img class=\"alignnone  wp-image-524\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos4.jpg\"><img class=\"alignnone  wp-image-525\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos5.jpg\"><img class=\"alignnone  wp-image-527\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Los Candiles</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles1.jpeg\"><img class=\"alignnone  wp-image-529\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles2.jpeg\"><img class=\"alignnone  wp-image-533\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles3.jpeg\"><img class=\"alignnone  wp-image-530\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles4.jpeg\"><img class=\"alignnone  wp-image-531\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles5.jpeg\"><img class=\"alignnone  wp-image-534\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Hotel Zapallar</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5194.jpg\"><img class=\"alignnone  wp-image-536\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5194-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5195.jpg\"><img class=\"alignnone  wp-image-537\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5195-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5197.jpg\"><img class=\"alignnone  wp-image-549\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5197-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5200.jpg\"><img class=\"alignnone  wp-image-550\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5200-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5201.jpg\"><img class=\"alignnone  wp-image-551\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5201-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5204.jpg\"><img class=\"alignnone  wp-image-552\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5204-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5206.jpg\"><img class=\"alignnone  wp-image-553\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5206-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5209.jpg\"><img class=\"alignnone  wp-image-554\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5209-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Casa Vichuquen</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/comedor.jpg\"><img class=\"alignnone  wp-image-539\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/comedor-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Living.jpg\"><img class=\"alignnone  wp-image-540\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Living-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/pasillo-interior.jpg\"><img class=\"alignnone  wp-image-541\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/pasillo-interior-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta-2.jpg\"><img class=\"alignnone  wp-image-542\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta-2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta.jpg\"><img class=\"alignnone  wp-image-543\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-3.jpg\"><img class=\"alignnone  wp-image-544\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-4.jpg\"><img class=\"alignnone  wp-image-545\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza.jpg\"><img class=\"alignnone  wp-image-546\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>", "Proyectos destacados", "Proyectos destacados realizados por nuestra empresa.", "inherit", "open", "open", "", "398-revision-15", "", "", "2012-04-26 09:47:52", "2012-04-26 13:47:52", "", "398", "http://s-m.cl/398-revision-15/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1345", "1", "2013-06-26 12:37:34", "2013-06-26 16:37:34", "<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/partners2.jpeg\"><img class=\"alignnone size-full wp-image-1063\" title=\"partners2\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/partners2.jpeg\" alt=\"\" width=\"810\" height=\"328\" /></a>\r\n<h3>PARTNERS</h3>\r\n<a href=\"http://kubli.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1050\" title=\"Kubli\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-kubli1.jpg\" alt=\"\" width=\"394\" height=\"78\" /></a><a href=\"http://aei.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1040\" title=\"AEI\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-aei.jpg\" alt=\"\" width=\"386\" height=\"78\" /></a>\r\n\r\n<a href=\"http://bmdiseno.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1042\" title=\"BM Diseño\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-bm.jpg\" alt=\"\" width=\"393\" height=\"112\" /></a><a href=\"http://www.mobel.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1044\" title=\"Mobel\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-mobel.jpg\" alt=\"\" width=\"382\" height=\"112\" /></a>\r\n\r\n<a href=\"http://comercialsym.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1046\" title=\"SYM\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-sym.jpg\" alt=\"\" width=\"392\" height=\"104\" /></a><a href=\"http://unna.com.br\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1047\" title=\"Unna\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-unna.jpg\" alt=\"\" width=\"381\" height=\"103\" /></a>\r\n\r\n<a href=\"http://www.florense.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1314\" title=\"p-florense\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-florense.png\" alt=\"\" width=\"393\" height=\"82\" /></a><a href=\"http://www.topkitchen.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1316\" title=\"Top Kitchen\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-topkitchen.jpg\" alt=\"\" width=\"386\" height=\"81\" /></a>\r\n\r\n<a href=\"http://www.rojoynegro.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1318\" title=\"Rojo y Negro\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-rojoynegro.jpg\" alt=\"\" width=\"393\" height=\"120\" /></a><a href=\"http://www.kitchencenter.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1319\" title=\"Kitchen Center\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-kitchencenter.jpg\" alt=\"\" width=\"385\" height=\"119\" /></a>\r\n\r\n<a href=\"http://www.houseco.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1335\" title=\"House and Co\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-houseco2.jpg\" alt=\"\" width=\"394\" height=\"82\" /></a><a href=\"http://www.kitchenhome.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1327\" title=\"Kitchen Home\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-kitchenhome.jpg\" alt=\"\" width=\"384\" height=\"81\" /></a>\r\n\r\n&nbsp;\r\n<h5>En Regiones:</h5>\r\n\r\n<div style=\"float:left\"><img class=\"alignnone size-full wp-image-1053\" title=\"Casa Kit\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-casakit.jpg\" alt=\"\" width=\"292\" height=\"108\" /></div>\r\n\r\n<div style=\"float:left\"><a href=\"http://www.madestone.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1054\" title=\"Madestone\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-madestone.jpg\" alt=\"\" width=\"256\" height=\"110\" /></a></div>\r\n\r\n<div style=\"float:left\"><a href=\"http://www.espaciodinamico.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1055\" title=\"Espacio Dinámico\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-espaciodinamico.jpg\" alt=\"\" width=\"233\" height=\"111\" /></a></div>\r\n\r\n<div style=\"float:left\"><a href=\"http://www.mobilinares.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1056\" title=\"Mobilinares\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-mobilinares.jpg\" alt=\"\" width=\"291\" height=\"78\" /></a></div>\r\n\r\n<div style=\"float:left\"><a href=\"http://www.staubmuebles.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1057\" title=\"Staub\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-staub.jpg\" alt=\"\" width=\"255\" height=\"77\" /></a></div>\r\n\r\n<div style=\"float:left\"><a href=\"http://www.disypro.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1058\" title=\"disypro\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-disypro.jpg\" alt=\"\" width=\"231\" height=\"79\" /></a></div>\r\n\r\n<div style=\"float:left\"><a href=\"http://www.todoforma.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1330\" title=\"Todo Forma\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-todoforma.jpg\" alt=\"\" width=\"394\" height=\"88\" /></a></div>\r\n\r\n<div style=\"float:left;padding-top:30px;margin-right:20px;\"><a href=\"http://www.phrana.cl\" title=\"Phrana Muebles\" target=\"_blank\"><img src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-phrana.jpg\" alt=\"Phrana Muebles\" title=\"p-phrana\" width=\"74\" height=\"68\" class=\"alignnone size-full wp-image-1339\" /></a></div>\r\n<div style=\"float:left;padding-top:30px;font-size:10px;line-height:10px;\">El Trapiche 1280, G4, Barrio industrial, Coquimbo<br />(+56 51) 486300<br /><a href=\"http://www.phrana.cl\" title=\"Muebles Phrana\" target=\"_blank\">www.phrana.cl</a></div>", "Partners", "", "inherit", "closed", "closed", "", "969-revision-v1", "", "", "2013-06-26 12:37:34", "2013-06-26 16:37:34", "", "969", "http://santamargherita.s-m.cl/969-revision-38/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("647", "1", "2012-04-19 15:35:31", "2012-04-19 19:35:31", "&nbsp;\r\n\r\n<img class=\"alignnone size-full wp-image-569\" title=\"novedades_OK\" src=\"http://s-m.cl/wp-content/uploads/2012/03/novedades_OK.jpg\" alt=\"\" width=\"576\" height=\"200\" />\r\n\r\n<strong>Sistema de apertura corredizo/paño fijo</strong>\r\n\r\n<strong>\r\n</strong>PVC Tecnocom ha lanzado al mercado un nuevo sistema de apertura CORREDIZO/PAÑO FIJO,  con el se pueden combinar aperturas de hojas móviles y paños fijos de medidas variadas y de hasta cuatro paños fijos.\r\n\r\n<strong>\r\nFolio Interior en ventanas de piso a cielo.</strong>\r\n\r\n<strong>\r\n</strong>PVC Tecnocom ha desarrollado dentro de sus productos una línea de perfiles destinada a entregar soluciones para ventanas de hojas móviles de piso a cielo, con el interior del marco foliado del mismo tono que el exterior del perfil, de manera de otorgar a las terminaciones de sus ventanas un acabado pulcro y homogéneo.\r\nSouth Merchants es la primera empresa en Chile en incorporar esta tecnología a sus soluciones de ventanas, entregándole al cliente un plus para el diseño de sus proyectos.", "Novedades", "PVC Tecnocom ha lanzado al mercado un nuevo sistema de apertura.", "inherit", "open", "open", "", "401-revision-3", "", "", "2012-04-19 15:35:31", "2012-04-19 19:35:31", "", "401", "http://s-m.cl/401-revision-3/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("650", "1", "2012-05-28 13:25:04", "2012-05-28 17:25:04", "<img class=\"alignnone size-full wp-image-784\" title=\"Ventajas\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/ventajas3.jpg\" alt=\"\" width=\"810\" height=\"328\" />\n<h3><strong>VENTAJAS</strong></h3>\nSu composición de un 93% de piedras naturales y un 7% de resina poliéster otorgan al material diferentes características que lo llevan a posicionarse como un material muy superior a las piedras naturales con altas prestaciones técnicas, las más importantes son:\n<ul>\n	<li>Resistente al rayado.</li>\n	<li>Resistente al impacto</li>\n	<li>Resistente a los acidos</li>\n	<li>Resistente a las manchas</li>\n	<li>Resistente a la formación de bacterias</li>\n	<li>Resistente al calor.</li>\n</ul>", "Ventajas", "Su composición lo hace ser un material muy superior a las piedras naturales.", "inherit", "open", "open", "", "404-autosave", "", "", "2012-05-28 13:25:04", "2012-05-28 17:25:04", "", "404", "http://s-m.cl/404-autosave/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("780", "1", "2012-05-24 16:22:43", "2012-05-24 20:22:43", "<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/ventajas.jpg\"><img class=\"alignnone size-full wp-image-751\" title=\"Ventajas\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/ventajas.jpg\" alt=\"\" width=\"576\" height=\"200\" /></a>\r\n\r\nSu composición de un 93% de piedras naturales y un 7% de resina poliéster otorgan al material diferentes características que lo llevan a posicionarse como un material muy superior a las piedras naturales con altas prestaciones técnicas, las más importantes son:\r\n<ul>\r\n	<li>Resistente al rayado.</li>\r\n	<li>Resistente al impacto</li>\r\n	<li>Resistente a los acidos</li>\r\n	<li>Resistente a las manchas</li>\r\n	<li>Resistente a la formación de bacterias</li>\r\n	<li>Resistente al calor.</li>\r\n</ul>", "Ventajas", "Su composición lo hace ser un material muy superior a las piedras naturales.", "inherit", "open", "open", "", "404-revision-4", "", "", "2012-05-24 16:22:43", "2012-05-24 20:22:43", "", "404", "http://santamargherita.s-m.cl/404-revision-4/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("752", "1", "2012-04-26 10:21:26", "2012-04-26 14:21:26", "<a href=\"http://s-m.cl/wp-content/uploads/2012/03/ventajas0.jpg\"><img class=\"alignnone size-full wp-image-649\" title=\"ventajas0\" src=\"http://s-m.cl/wp-content/uploads/2012/03/ventajas0.jpg\" alt=\"Ventajas\" width=\"576\" height=\"200\" /></a>\r\n\r\nLos perfiles Tecnocom son fabricados con una selección de PVC de primera calidad, además utilizamos avanzada tecnología en su proceso de fabricación de manera de garantizar altos estándares de calidad en el producto final.\r\n\r\nNuestros perfiles son sometidos a exigentes pruebas de calidad en nuestro laboratorio lo que permite su resistencia al envejecimiento sin ningún tratamiento de protección o mantenimiento adicional.\r\n\r\nNuestro principal objetivo es entregar a nuestros clientes un producto de excelente calidad.\r\n\r\nNuestros perfiles poseen las siguientes características:\r\n<h4><a name=\"acustico\"></a>Aislamiento Acústico:</h4>\r\nLa permeabilidad acústica en una construcción se produce a través de los vanos existentes en las fachadas, las ventanas Tecnocom ayudan a revertir estos niveles a través de cámaras interiores que cortan las ondas sonoras evitando su propagación, esto se complementa con un vidrio termopanal que contiene una cámara de aire interior que produce el mismo efecto, llegando a reducir en un 40% el ruido exterior, este porcentaje puede aumentar si se utiliza un vidrio acústico laminado.\r\n<h4><a name=\"termico\"></a>Aislamiento Térmico:</h4>\r\nEl PVC es un material de baja conductividad, esto permite que el material no transfiera las diferencias de temperatura de un recinto a otro, tampoco necesitan rotura del puente térmico ya que el perfil en toda su extensión rompe el puente térmico.\r\n\r\nTal como en el caso de la aislación acústica, las cámaras interiores contribuyen como barreras térmicas al exterior.\r\n<h4><a name=\"impacto\"></a>Resistencia al impacto y autoextincion:</h4>\r\nEl PVC por naturaleza es un material con alta resistencia al impacto y autoetinguible, nuestras ventanas al estar fabricadas con altos estándares de calidad y además con un refuerzo interior de acero por todo su perímetro, da como resultado un producto altamente resistente a todo tipo de golpes.\r\n\r\nEn el caso del fuego, son necesarias temperaturas continuas sobre los 300°C para que logre ignición y comiencen a consumirse muy lentamente.\r\n<h4><a name=\"con\"></a>Condensación:</h4>\r\nEn los materiales que poseen mayor conductividad se produce mayor condensación, el PVC al ser  un material de poca conductividad, prácticamente no condensa si los espacios son ventilados de manera correcta.\r\n<h4><a name=\"agua\"></a>Estanqueidad al Agua y Viento:</h4>\r\nEn el proceso de fabricación de las ventanas de PVC todas las partes que la componen van soldadas entre sí, lo que provoca total hermeticidad interior, logrando mayor estanqueidad al agua y al viento.\r\n<h4><a name=\"seguridad\"></a>Seguridad:</h4>\r\nTodas las virtudes del PVC en cuanto a su dureza, resistencia y hermeticidad se ven potenciadas por la alta tecnología que contienen los herrajes, lo que nos lleva a entregar cierres casi en un 100% herméticos, otorgando mayor seguridad y protección ante cualquier tipo de agresión externa.\r\n<h4><a name=\"diseno\"></a>Versatilidad de Diseño:</h4>\r\nEl PVC es un material que se puede modelar con el uso de temperatura, esta cualidad permite la creación de distintos diseños tales como figuras irregulares, arcos, ventanas asimétricas, etc. además existen distintos tipos y tonos de vidrios que pueden aportar en las distintas composiciones de fachadas.\r\n\r\nLa variedad de colores también nos permite generar contrastes y mimetizaciones con los distintos tipos de construcción, dependiendo del carácter que cada Arquitecto le quiera dar a la obra.", "Ventajas", "Los perfiles Tecnocom son fabricados con una selección de PVC de primera calidad.", "inherit", "open", "open", "", "404-revision-3", "", "", "2012-04-26 10:21:26", "2012-04-26 14:21:26", "", "404", "http://santamargherita.s-m.cl/404-revision-3/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("648", "1", "2012-04-26 09:56:50", "2012-04-26 13:56:50", "<a href=\"http://s-m.cl/wp-content/uploads/2012/03/novedad.jpg\"><img class=\"alignnone size-full wp-image-646\" title=\"novedad\" src=\"http://s-m.cl/wp-content/uploads/2012/03/novedad.jpg\" alt=\"Novedades\" width=\"576\" height=\"200\" /></a>\r\n\r\n<img class=\"alignnone size-full wp-image-569\" title=\"novedades_OK\" src=\"http://s-m.cl/wp-content/uploads/2012/03/novedades_OK.jpg\" alt=\"\" width=\"576\" height=\"200\" />\r\n\r\n<strong>Sistema de apertura corredizo/paño fijo</strong>\r\n\r\n<strong>\r\n</strong>PVC Tecnocom ha lanzado al mercado un nuevo sistema de apertura CORREDIZO/PAÑO FIJO,  con el se pueden combinar aperturas de hojas móviles y paños fijos de medidas variadas y de hasta cuatro paños fijos.\r\n\r\n<strong>\r\nFolio Interior en ventanas de piso a cielo.</strong>\r\n\r\n<strong>\r\n</strong>PVC Tecnocom ha desarrollado dentro de sus productos una línea de perfiles destinada a entregar soluciones para ventanas de hojas móviles de piso a cielo, con el interior del marco foliado del mismo tono que el exterior del perfil, de manera de otorgar a las terminaciones de sus ventanas un acabado pulcro y homogéneo.\r\nSouth Merchants es la primera empresa en Chile en incorporar esta tecnología a sus soluciones de ventanas, entregándole al cliente un plus para el diseño de sus proyectos.", "Novedades", "PVC Tecnocom ha lanzado al mercado un nuevo sistema de apertura.", "inherit", "open", "open", "", "401-revision-4", "", "", "2012-04-26 09:56:50", "2012-04-26 13:56:50", "", "401", "http://s-m.cl/401-revision-4/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("652", "1", "2012-04-19 15:36:31", "2012-04-19 19:36:31", "<img class=\"alignnone size-full wp-image-478\" title=\"ventajas_OK\" src=\"http://s-m.cl/wp-content/uploads/2012/03/ventajas_OK.jpg\" alt=\"\" width=\"576\" height=\"200\" />\r\n\r\nLos perfiles Tecnocom son fabricados con una selección de PVC de primera calidad, además utilizamos avanzada tecnología en su proceso de fabricación de manera de garantizar altos estándares de calidad en el producto final.\r\n\r\nNuestros perfiles son sometidos a exigentes pruebas de calidad en nuestro laboratorio lo que permite su resistencia al envejecimiento sin ningún tratamiento de protección o mantenimiento adicional.\r\n\r\nNuestro principal objetivo es entregar a nuestros clientes un producto de excelente calidad.\r\n\r\nNuestros perfiles poseen las siguientes características:\r\n<h4><a name=\"acustico\"></a>Aislamiento Acústico:</h4>\r\nLa permeabilidad acústica en una construcción se produce a través de los vanos existentes en las fachadas, las ventanas Tecnocom ayudan a revertir estos niveles a través de cámaras interiores que cortan las ondas sonoras evitando su propagación, esto se complementa con un vidrio termopanal que contiene una cámara de aire interior que produce el mismo efecto, llegando a reducir en un 40% el ruido exterior, este porcentaje puede aumentar si se utiliza un vidrio acústico laminado.\r\n<h4><a name=\"termico\"></a>Aislamiento Térmico:</h4>\r\nEl PVC es un material de baja conductividad, esto permite que el material no transfiera las diferencias de temperatura de un recinto a otro, tampoco necesitan rotura del puente térmico ya que el perfil en toda su extensión rompe el puente térmico.\r\n\r\nTal como en el caso de la aislación acústica, las cámaras interiores contribuyen como barreras térmicas al exterior.\r\n<h4><a name=\"impacto\"></a>Resistencia al impacto y autoextincion:</h4>\r\nEl PVC por naturaleza es un material con alta resistencia al impacto y autoetinguible, nuestras ventanas al estar fabricadas con altos estándares de calidad y además con un refuerzo interior de acero por todo su perímetro, da como resultado un producto altamente resistente a todo tipo de golpes.\r\n\r\nEn el caso del fuego, son necesarias temperaturas continuas sobre los 300°C para que logre ignición y comiencen a consumirse muy lentamente.\r\n<h4><a name=\"con\"></a>Condensación:</h4>\r\nEn los materiales que poseen mayor conductividad se produce mayor condensación, el PVC al ser  un material de poca conductividad, prácticamente no condensa si los espacios son ventilados de manera correcta.\r\n<h4><a name=\"agua\"></a>Estanqueidad al Agua y Viento:</h4>\r\nEn el proceso de fabricación de las ventanas de PVC todas las partes que la componen van soldadas entre sí, lo que provoca total hermeticidad interior, logrando mayor estanqueidad al agua y al viento.\r\n<h4><a name=\"seguridad\"></a>Seguridad:</h4>\r\nTodas las virtudes del PVC en cuanto a su dureza, resistencia y hermeticidad se ven potenciadas por la alta tecnología que contienen los herrajes, lo que nos lleva a entregar cierres casi en un 100% herméticos, otorgando mayor seguridad y protección ante cualquier tipo de agresión externa.\r\n<h4><a name=\"diseno\"></a>Versatilidad de Diseño:</h4>\r\nEl PVC es un material que se puede modelar con el uso de temperatura, esta cualidad permite la creación de distintos diseños tales como figuras irregulares, arcos, ventanas asimétricas, etc. además existen distintos tipos y tonos de vidrios que pueden aportar en las distintas composiciones de fachadas.\r\n\r\nLa variedad de colores también nos permite generar contrastes y mimetizaciones con los distintos tipos de construcción, dependiendo del carácter que cada Arquitecto le quiera dar a la obra.", "Ventajas", "Los perfiles Tecnocom son fabricados con una selección de PVC de primera calidad.", "inherit", "open", "open", "", "404-revision-2", "", "", "2012-04-19 15:36:31", "2012-04-19 19:36:31", "", "404", "http://s-m.cl/404-revision-2/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("656", "1", "2012-04-19 15:38:18", "2012-04-19 19:38:18", "<img class=\"alignnone size-full wp-image-572\" title=\"mantencion_OK\" src=\"http://s-m.cl/wp-content/uploads/2012/03/mantencion_OK.jpg\" alt=\"\" width=\"576\" height=\"200\" />\r\n\r\nEl PVC es un material inerte, al que no le afecta la salinidad del mar, es insensible a la humedad, y altamente recomendable en ambientes agresivos; pero aún así es necesario mantener algunas condiciones mínimas de limpieza para asegurar su durabilidad.<strong id=\"internal-source-marker_0.037745180539786816\"></strong>\r\n<h4>PAUTAS DE LIMPIEZA</h4>\r\n<ul>\r\n	<li> Las ventanas poseen <strong>ranuras de aireación</strong>, éstas deben mantenerse limpias y sin residuos, de lo contrario, será difícil que cumplan su función.</li>\r\n	<li>Los <strong>perfiles</strong> tienen que limpiarse con un paño suave, agua y jabón neutro. Es necesario aclarar con agua abundante para evitar que queden residuos de jabón.</li>\r\n	<li>Una vez al año, conviene limpiar los <strong>elementos metálicos</strong> (herrajes) y engrasar todas las piezas móviles con aceite exento de ácidos.</li>\r\n	<li>Las <strong>juntas</strong> de cierre y acristalamiento (gomas) se deben limpiar con agua y jabón neutro.</li>\r\n	<li>No se debe utilizar ningún elemento abrasivo o ácidos para limpiar las ventanas.</li>\r\n</ul>\r\n<strong id=\"internal-source-marker_0.037745180539786816\">\r\n</strong>Debido al cierre hermético de las ventanas, es recomendable ventilar los recintos un mínimo de dos veces al día. \"En zonas geográficas con mayor grado de humedad\", es recomendable ampliar los tiempos de ventilación.\r\n\r\n<strong id=\"internal-source-marker_0.037745180539786816\">\r\n</strong>Si tienes alguna duda con respecto a tus ventanas TECNOCOM comunícate con nuestro servicio de Post-Venta al número de teléfono\r\n<strong>+56 (2) 7287186.</strong>\r\n\r\n<strong></strong>\r\nTambién puedes contactarte con nosotros a través de nuestro correo electrónico <em>info@s-m.cl</em> o visitar nuestra página web <strong>www.s-m.cl</strong>\r\n\r\n&nbsp;", "Mantencion Post venta", "Es necesario mantener algunas condiciones de limpieza para asegurar la durabilidad del PVC.", "inherit", "open", "open", "", "407-revision-4", "", "", "2012-04-19 15:38:18", "2012-04-19 19:38:18", "", "407", "http://s-m.cl/407-revision-4/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("658", "1", "2012-04-26 09:57:06", "2012-04-26 13:57:06", "&nbsp;\r\n\r\n<img class=\"alignnone size-full wp-image-569\" title=\"novedades_OK\" src=\"http://s-m.cl/wp-content/uploads/2012/03/novedades_OK.jpg\" alt=\"\" width=\"576\" height=\"200\" />\r\n\r\n<strong>Sistema de apertura corredizo/paño fijo</strong>\r\n\r\n<strong>\r\n</strong>PVC Tecnocom ha lanzado al mercado un nuevo sistema de apertura CORREDIZO/PAÑO FIJO,  con el se pueden combinar aperturas de hojas móviles y paños fijos de medidas variadas y de hasta cuatro paños fijos.\r\n\r\n<strong>\r\nFolio Interior en ventanas de piso a cielo.</strong>\r\n\r\n<strong>\r\n</strong>PVC Tecnocom ha desarrollado dentro de sus productos una línea de perfiles destinada a entregar soluciones para ventanas de hojas móviles de piso a cielo, con el interior del marco foliado del mismo tono que el exterior del perfil, de manera de otorgar a las terminaciones de sus ventanas un acabado pulcro y homogéneo.\r\nSouth Merchants es la primera empresa en Chile en incorporar esta tecnología a sus soluciones de ventanas, entregándole al cliente un plus para el diseño de sus proyectos.", "Novedades", "PVC Tecnocom ha lanzado al mercado un nuevo sistema de apertura.", "inherit", "open", "open", "", "401-revision-5", "", "", "2012-04-26 09:57:06", "2012-04-26 13:57:06", "", "401", "http://s-m.cl/401-revision-5/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("660", "1", "2012-04-26 10:39:41", "2012-04-26 14:39:41", "<a href=\"http://s-m.cl/wp-content/uploads/2012/03/novedad1.jpg\"><img class=\"alignnone size-full wp-image-657\" title=\"novedad\" src=\"http://s-m.cl/wp-content/uploads/2012/03/novedad1.jpg\" alt=\"Novedades\" width=\"576\" height=\"200\" /></a>\r\n\r\n<strong>Sistema de apertura corredizo/paño fijo</strong>\r\n\r\n<strong>\r\n</strong>PVC Tecnocom ha lanzado al mercado un nuevo sistema de apertura CORREDIZO/PAÑO FIJO,  con el se pueden combinar aperturas de hojas móviles y paños fijos de medidas variadas y de hasta cuatro paños fijos.\r\n\r\n<strong>\r\nFolio Interior en ventanas de piso a cielo.</strong>\r\n\r\n<strong>\r\n</strong>PVC Tecnocom ha desarrollado dentro de sus productos una línea de perfiles destinada a entregar soluciones para ventanas de hojas móviles de piso a cielo, con el interior del marco foliado del mismo tono que el exterior del perfil, de manera de otorgar a las terminaciones de sus ventanas un acabado pulcro y homogéneo.\r\nSouth Merchants es la primera empresa en Chile en incorporar esta tecnología a sus soluciones de ventanas, entregándole al cliente un plus para el diseño de sus proyectos.", "Novedades", "PVC Tecnocom ha lanzado al mercado un nuevo sistema de apertura.", "inherit", "open", "open", "", "401-revision-6", "", "", "2012-04-26 10:39:41", "2012-04-26 14:39:41", "", "401", "http://s-m.cl/401-revision-6/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("663", "1", "2012-04-26 10:41:01", "2012-04-26 14:41:01", "<a href=\"http://s-m.cl/wp-content/uploads/2012/03/novedad2.jpg\"><img class=\"alignnone size-full wp-image-659\" title=\"novedad2\" src=\"http://s-m.cl/wp-content/uploads/2012/03/novedad2.jpg\" alt=\"Novedades\" width=\"576\" height=\"200\" /></a>\r\n\r\n<strong>Sistema de apertura corredizo/paño fijo</strong>\r\n\r\n<strong>\r\n</strong>PVC Tecnocom ha lanzado al mercado un nuevo sistema de apertura CORREDIZO/PAÑO FIJO,  con el se pueden combinar aperturas de hojas móviles y paños fijos de medidas variadas y de hasta cuatro paños fijos.\r\n\r\n<strong>\r\nFolio Interior en ventanas de piso a cielo.</strong>\r\n\r\n<strong>\r\n</strong>PVC Tecnocom ha desarrollado dentro de sus productos una línea de perfiles destinada a entregar soluciones para ventanas de hojas móviles de piso a cielo, con el interior del marco foliado del mismo tono que el exterior del perfil, de manera de otorgar a las terminaciones de sus ventanas un acabado pulcro y homogéneo.\r\nSouth Merchants es la primera empresa en Chile en incorporar esta tecnología a sus soluciones de ventanas, entregándole al cliente un plus para el diseño de sus proyectos.", "Novedades", "PVC Tecnocom ha lanzado al mercado un nuevo sistema de apertura.", "inherit", "open", "open", "", "401-revision-8", "", "", "2012-04-26 10:41:01", "2012-04-26 14:41:01", "", "401", "http://s-m.cl/401-revision-8/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("661", "1", "2012-04-26 10:40:37", "2012-04-26 14:40:37", "<a href=\"http://s-m.cl/wp-content/uploads/2012/03/novedad2.jpg\"><img class=\"alignnone size-full wp-image-659\" title=\"novedad2\" src=\"http://s-m.cl/wp-content/uploads/2012/03/novedad2.jpg\" alt=\"Novedades\" width=\"576\" height=\"200\" /></a>\r\n\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/novedad1.jpg\"><img class=\"alignnone size-full wp-image-657\" title=\"novedad\" src=\"http://s-m.cl/wp-content/uploads/2012/03/novedad1.jpg\" alt=\"Novedades\" width=\"576\" height=\"200\" /></a>\r\n\r\n<strong>Sistema de apertura corredizo/paño fijo</strong>\r\n\r\n<strong>\r\n</strong>PVC Tecnocom ha lanzado al mercado un nuevo sistema de apertura CORREDIZO/PAÑO FIJO,  con el se pueden combinar aperturas de hojas móviles y paños fijos de medidas variadas y de hasta cuatro paños fijos.\r\n\r\n<strong>\r\nFolio Interior en ventanas de piso a cielo.</strong>\r\n\r\n<strong>\r\n</strong>PVC Tecnocom ha desarrollado dentro de sus productos una línea de perfiles destinada a entregar soluciones para ventanas de hojas móviles de piso a cielo, con el interior del marco foliado del mismo tono que el exterior del perfil, de manera de otorgar a las terminaciones de sus ventanas un acabado pulcro y homogéneo.\r\nSouth Merchants es la primera empresa en Chile en incorporar esta tecnología a sus soluciones de ventanas, entregándole al cliente un plus para el diseño de sus proyectos.", "Novedades", "PVC Tecnocom ha lanzado al mercado un nuevo sistema de apertura.", "inherit", "open", "open", "", "401-revision-7", "", "", "2012-04-26 10:40:37", "2012-04-26 14:40:37", "", "401", "http://s-m.cl/401-revision-7/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1344", "1", "2013-06-26 12:36:55", "2013-06-26 16:36:55", "<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/partners2.jpeg\"><img class=\"alignnone size-full wp-image-1063\" title=\"partners2\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/partners2.jpeg\" alt=\"\" width=\"810\" height=\"328\" /></a>\r\n<h3>PARTNERS</h3>\r\n<a href=\"http://kubli.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1050\" title=\"Kubli\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-kubli1.jpg\" alt=\"\" width=\"394\" height=\"78\" /></a><a href=\"http://aei.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1040\" title=\"AEI\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-aei.jpg\" alt=\"\" width=\"386\" height=\"78\" /></a>\r\n\r\n<a href=\"http://bmdiseno.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1042\" title=\"BM Diseño\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-bm.jpg\" alt=\"\" width=\"393\" height=\"112\" /></a><a href=\"http://www.mobel.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1044\" title=\"Mobel\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-mobel.jpg\" alt=\"\" width=\"382\" height=\"112\" /></a>\r\n\r\n<a href=\"http://comercialsym.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1046\" title=\"SYM\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-sym.jpg\" alt=\"\" width=\"392\" height=\"104\" /></a><a href=\"http://unna.com.br\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1047\" title=\"Unna\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-unna.jpg\" alt=\"\" width=\"381\" height=\"103\" /></a>\r\n\r\n<a href=\"http://www.florense.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1314\" title=\"p-florense\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-florense.png\" alt=\"\" width=\"393\" height=\"82\" /></a><a href=\"http://www.topkitchen.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1316\" title=\"Top Kitchen\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-topkitchen.jpg\" alt=\"\" width=\"386\" height=\"81\" /></a>\r\n\r\n<a href=\"http://www.rojoynegro.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1318\" title=\"Rojo y Negro\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-rojoynegro.jpg\" alt=\"\" width=\"393\" height=\"120\" /></a><a href=\"http://www.kitchencenter.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1319\" title=\"Kitchen Center\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-kitchencenter.jpg\" alt=\"\" width=\"385\" height=\"119\" /></a>\r\n\r\n<a href=\"http://www.houseco.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1335\" title=\"House and Co\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-houseco2.jpg\" alt=\"\" width=\"394\" height=\"82\" /></a><a href=\"http://www.kitchenhome.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1327\" title=\"Kitchen Home\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-kitchenhome.jpg\" alt=\"\" width=\"384\" height=\"81\" /></a>\r\n\r\n&nbsp;\r\n<h5>En Regiones:</h5>\r\n\r\n<div style=\"float:left\"><img class=\"alignnone size-full wp-image-1053\" title=\"Casa Kit\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-casakit.jpg\" alt=\"\" width=\"292\" height=\"108\" /></div>\r\n\r\n<div style=\"float:left\"><a href=\"http://www.madestone.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1054\" title=\"Madestone\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-madestone.jpg\" alt=\"\" width=\"256\" height=\"110\" /></a></div>\r\n\r\n<div style=\"float:left\"><a href=\"http://www.espaciodinamico.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1055\" title=\"Espacio Dinámico\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-espaciodinamico.jpg\" alt=\"\" width=\"233\" height=\"111\" /></a></div>\r\n\r\n<div style=\"float:left\"><a href=\"http://www.mobilinares.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1056\" title=\"Mobilinares\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-mobilinares.jpg\" alt=\"\" width=\"291\" height=\"78\" /></a></div>\r\n\r\n<div style=\"float:left\"><a href=\"http://www.staubmuebles.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1057\" title=\"Staub\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-staub.jpg\" alt=\"\" width=\"255\" height=\"77\" /></a></div>\r\n\r\n<div style=\"float:left\"><a href=\"http://www.disypro.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1058\" title=\"disypro\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-disypro.jpg\" alt=\"\" width=\"231\" height=\"79\" /></a></div>\r\n\r\n<div style=\"float:left\"><a href=\"http://www.todoforma.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1330\" title=\"Todo Forma\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-todoforma.jpg\" alt=\"\" width=\"394\" height=\"88\" /></a></div>\r\n\r\n<div style=\"float:left;padding-top:30px;margin-right:20px;\"><a href=\"http://www.phrana.cl\" title=\"Phrana Muebles\" target=\"_blank\"><img src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-phrana.jpg\" alt=\"Phrana Muebles\" title=\"p-phrana\" width=\"74\" height=\"68\" class=\"alignnone size-full wp-image-1339\" /></a></div>\r\n<div style=\"float:left;padding-top:30px;font-size:10px;line/height:10px;\">El Trapiche 1280, G4, Barrio industrial, Coquimbo<br />(+56 51) 486300<br /><a href=\"http://www.phrana.cl\" title=\"Muebles Phrana\" target=\"_blank\">www.phrana.cl</a></div>", "Partners", "", "inherit", "closed", "closed", "", "969-revision-v1", "", "", "2013-06-26 12:36:55", "2013-06-26 16:36:55", "", "969", "http://santamargherita.s-m.cl/969-revision-37/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1326", "1", "2012-10-29 14:59:29", "2012-10-29 18:59:29", "<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/partners2.jpeg\"><img class=\"alignnone size-full wp-image-1063\" title=\"partners2\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/partners2.jpeg\" alt=\"\" width=\"810\" height=\"328\" /></a>\r\n<h3>PARTNERS</h3>\r\n<a href=\"http://kubli.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1050\" title=\"Kubli\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-kubli1.jpg\" alt=\"\" width=\"394\" height=\"78\" /></a><a href=\"http://aei.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1040\" title=\"AEI\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-aei.jpg\" alt=\"\" width=\"386\" height=\"78\" /></a>\r\n\r\n<a href=\"http://bmdiseno.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1042\" title=\"BM Diseño\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-bm.jpg\" alt=\"\" width=\"393\" height=\"112\" /></a><a href=\"http://www.mobel.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1044\" title=\"Mobel\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-mobel.jpg\" alt=\"\" width=\"382\" height=\"112\" /></a>\r\n\r\n<a href=\"http://comercialsym.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1046\" title=\"SYM\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-sym.jpg\" alt=\"\" width=\"392\" height=\"104\" /></a><a href=\"http://unna.com.br\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1047\" title=\"Unna\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-unna.jpg\" alt=\"\" width=\"381\" height=\"103\" /></a>\r\n\r\n<a href=\"http://www.florense.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1314\" title=\"p-florense\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-florense.png\" alt=\"\" width=\"393\" height=\"82\" /></a><a href=\"http://www.topkitchen.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1316\" title=\"Top Kitchen\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-topkitchen.jpg\" alt=\"\" width=\"386\" height=\"81\" /></a>\r\n\r\n<a href=\"http://www.rojoynegro.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1318\" title=\"Rojo y Negro\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-rojoynegro.jpg\" alt=\"\" width=\"393\" height=\"120\" /></a><a href=\"http://www.kitchencenter.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1319\" title=\"Kitchen Center\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-kitchencenter.jpg\" alt=\"\" width=\"385\" height=\"119\" /></a>\r\n\r\n<a href=\"http://www.houseco.cl\"><img src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-houseco.jpg\" alt=\"\" title=\"House and Co\" class=\"alignnone size-full wp-image-1322\" /></a>\r\n\r\n&nbsp;\r\n<h5>En Regiones:</h5>\r\n<img class=\"alignnone size-full wp-image-1053\" title=\"Casa Kit\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-casakit.jpg\" alt=\"\" width=\"292\" height=\"108\" /><a href=\"http://www.madestone.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1054\" title=\"Madestone\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-madestone.jpg\" alt=\"\" width=\"256\" height=\"110\" /></a><a href=\"http://www.espaciodinamico.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1055\" title=\"Espacio Dinámico\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-espaciodinamico.jpg\" alt=\"\" width=\"233\" height=\"111\" /></a>\r\n\r\n<a href=\"http://www.mobilinares.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1056\" title=\"Mobilinares\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-mobilinares.jpg\" alt=\"\" width=\"291\" height=\"78\" /></a><a href=\"http://www.staubmuebles.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1057\" title=\"Staub\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-staub.jpg\" alt=\"\" width=\"255\" height=\"77\" /></a><a href=\"http://www.disypro.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1058\" title=\"disypro\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-disypro.jpg\" alt=\"\" width=\"231\" height=\"79\" /></a>", "Partners", "", "inherit", "closed", "closed", "", "969-revision-v1", "", "", "2012-10-29 14:59:29", "2012-10-29 18:59:29", "", "969", "http://santamargherita.s-m.cl/969-revision-24/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1328", "1", "2012-10-29 15:00:42", "2012-10-29 19:00:42", "<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/partners2.jpeg\"><img class=\"alignnone size-full wp-image-1063\" title=\"partners2\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/partners2.jpeg\" alt=\"\" width=\"810\" height=\"328\" /></a>\r\n<h3>PARTNERS</h3>\r\n<a href=\"http://kubli.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1050\" title=\"Kubli\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-kubli1.jpg\" alt=\"\" width=\"394\" height=\"78\" /></a><a href=\"http://aei.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1040\" title=\"AEI\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-aei.jpg\" alt=\"\" width=\"386\" height=\"78\" /></a>\r\n\r\n<a href=\"http://bmdiseno.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1042\" title=\"BM Diseño\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-bm.jpg\" alt=\"\" width=\"393\" height=\"112\" /></a><a href=\"http://www.mobel.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1044\" title=\"Mobel\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-mobel.jpg\" alt=\"\" width=\"382\" height=\"112\" /></a>\r\n\r\n<a href=\"http://comercialsym.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1046\" title=\"SYM\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-sym.jpg\" alt=\"\" width=\"392\" height=\"104\" /></a><a href=\"http://unna.com.br\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1047\" title=\"Unna\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-unna.jpg\" alt=\"\" width=\"381\" height=\"103\" /></a>\r\n\r\n<a href=\"http://www.florense.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1314\" title=\"p-florense\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-florense.png\" alt=\"\" width=\"393\" height=\"82\" /></a><a href=\"http://www.topkitchen.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1316\" title=\"Top Kitchen\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-topkitchen.jpg\" alt=\"\" width=\"386\" height=\"81\" /></a>\r\n\r\n<a href=\"http://www.rojoynegro.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1318\" title=\"Rojo y Negro\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-rojoynegro.jpg\" alt=\"\" width=\"393\" height=\"120\" /></a><a href=\"http://www.kitchencenter.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1319\" title=\"Kitchen Center\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-kitchencenter.jpg\" alt=\"\" width=\"385\" height=\"119\" /></a>\r\n\r\n<a href=\"http://www.houseco.cl\" target=\"_blank\"><img src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-houseco.jpg\" alt=\"\" title=\"House and Co\" class=\"alignnone size-full wp-image-1322\" /></a>\r\n\r\n&nbsp;\r\n<h5>En Regiones:</h5>\r\n<img class=\"alignnone size-full wp-image-1053\" title=\"Casa Kit\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-casakit.jpg\" alt=\"\" width=\"292\" height=\"108\" /><a href=\"http://www.madestone.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1054\" title=\"Madestone\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-madestone.jpg\" alt=\"\" width=\"256\" height=\"110\" /></a><a href=\"http://www.espaciodinamico.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1055\" title=\"Espacio Dinámico\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-espaciodinamico.jpg\" alt=\"\" width=\"233\" height=\"111\" /></a>\r\n\r\n<a href=\"http://www.mobilinares.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1056\" title=\"Mobilinares\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-mobilinares.jpg\" alt=\"\" width=\"291\" height=\"78\" /></a><a href=\"http://www.staubmuebles.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1057\" title=\"Staub\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-staub.jpg\" alt=\"\" width=\"255\" height=\"77\" /></a><a href=\"http://www.disypro.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1058\" title=\"disypro\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-disypro.jpg\" alt=\"\" width=\"231\" height=\"79\" /></a>", "Partners", "", "inherit", "closed", "closed", "", "969-revision-v1", "", "", "2012-10-29 15:00:42", "2012-10-29 19:00:42", "", "969", "http://santamargherita.s-m.cl/969-revision-25/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1329", "1", "2013-03-04 15:23:10", "2013-03-04 19:23:10", "<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/partners2.jpeg\"><img class=\"alignnone size-full wp-image-1063\" title=\"partners2\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/partners2.jpeg\" alt=\"\" width=\"810\" height=\"328\" /></a>\r\n<h3>PARTNERS</h3>\r\n<a href=\"http://kubli.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1050\" title=\"Kubli\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-kubli1.jpg\" alt=\"\" width=\"394\" height=\"78\" /></a><a href=\"http://aei.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1040\" title=\"AEI\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-aei.jpg\" alt=\"\" width=\"386\" height=\"78\" /></a>\r\n\r\n<a href=\"http://bmdiseno.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1042\" title=\"BM Diseño\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-bm.jpg\" alt=\"\" width=\"393\" height=\"112\" /></a><a href=\"http://www.mobel.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1044\" title=\"Mobel\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-mobel.jpg\" alt=\"\" width=\"382\" height=\"112\" /></a>\r\n\r\n<a href=\"http://comercialsym.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1046\" title=\"SYM\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-sym.jpg\" alt=\"\" width=\"392\" height=\"104\" /></a><a href=\"http://unna.com.br\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1047\" title=\"Unna\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-unna.jpg\" alt=\"\" width=\"381\" height=\"103\" /></a>\r\n\r\n<a href=\"http://www.florense.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1314\" title=\"p-florense\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-florense.png\" alt=\"\" width=\"393\" height=\"82\" /></a><a href=\"http://www.topkitchen.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1316\" title=\"Top Kitchen\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-topkitchen.jpg\" alt=\"\" width=\"386\" height=\"81\" /></a>\r\n\r\n<a href=\"http://www.rojoynegro.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1318\" title=\"Rojo y Negro\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-rojoynegro.jpg\" alt=\"\" width=\"393\" height=\"120\" /></a><a href=\"http://www.kitchencenter.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1319\" title=\"Kitchen Center\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-kitchencenter.jpg\" alt=\"\" width=\"385\" height=\"119\" /></a>\r\n\r\n<a href=\"http://www.houseco.cl\" target=\"_blank\"><img src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-houseco.jpg\" alt=\"\" title=\"House and Co\" class=\"alignnone size-full wp-image-1322\" /></a><a href=\"http://www.kitchenhome.cl\"><img src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-kitchenhome.jpg\" alt=\"\" title=\"Kitchen Home\" width=\"384\" height=\"81\" class=\"alignnone size-full wp-image-1327\" /></a>\r\n\r\n&nbsp;\r\n<h5>En Regiones:</h5>\r\n<img class=\"alignnone size-full wp-image-1053\" title=\"Casa Kit\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-casakit.jpg\" alt=\"\" width=\"292\" height=\"108\" /><a href=\"http://www.madestone.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1054\" title=\"Madestone\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-madestone.jpg\" alt=\"\" width=\"256\" height=\"110\" /></a><a href=\"http://www.espaciodinamico.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1055\" title=\"Espacio Dinámico\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-espaciodinamico.jpg\" alt=\"\" width=\"233\" height=\"111\" /></a>\r\n\r\n<a href=\"http://www.mobilinares.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1056\" title=\"Mobilinares\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-mobilinares.jpg\" alt=\"\" width=\"291\" height=\"78\" /></a><a href=\"http://www.staubmuebles.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1057\" title=\"Staub\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-staub.jpg\" alt=\"\" width=\"255\" height=\"77\" /></a><a href=\"http://www.disypro.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1058\" title=\"disypro\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-disypro.jpg\" alt=\"\" width=\"231\" height=\"79\" /></a>", "Partners", "", "inherit", "closed", "closed", "", "969-revision-v1", "", "", "2013-03-04 15:23:10", "2013-03-04 19:23:10", "", "969", "http://santamargherita.s-m.cl/969-revision-26/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("799", "1", "2012-05-28 15:23:59", "2012-05-28 19:23:59", "", "Mantenimiento", "", "inherit", "open", "open", "", "mantenimiento2", "", "", "2012-05-28 15:23:59", "2012-05-28 19:23:59", "", "407", "http://santamargherita.s-m.cl/wp-content/uploads/2012/03/mantenimiento2.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("744", "1", "2012-05-24 15:52:08", "2012-05-24 19:52:08", "<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/aplicaciones.jpg\"><img class=\"alignnone size-full wp-image-738\" title=\"Aplicaciones\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/aplicaciones.jpg\" alt=\"\" width=\"576\" height=\"200\" /></a>\r\n\r\n<strong><em>Aglomerado de Cuarzo para encimeras de Cocina y Baño</em></strong>\r\n\r\nCada casa refleja la personalidad de quienes viven en ella. Caracteres, gustos y estilos que pueden llegar a ser infinitos, opuestos entre ellos; desde el neoclásico hasta el barroco, desde la ostentación hasta el minimalismo, con el uso de una paleta de colores desde las tonalidades más claras hasta las más fuertes.<strong><em></em></strong>\r\n\r\nSANTAMARGHERITA, a través de una investigación constante, crea superficies con altas prestaciones técnicas y que son estéticamente capaces de hacer que los ambientes domésticos sean únicos satisfaciendo perfectamente las diferentes exigencias.\r\n\r\nEl material ideal para pavimentos y revestimientos, cabinas de ducha y encimeras de cocina y baño se caracteriza, por un lado, por la alta resistencia a la flexión, abrasión y ácidos, y por el otro, por la variedad de colores y texturas más neutras o con mayor profundidad y efectos de movimiento.\r\n\r\nActualmente en el diseño de interiores está marcado el uso de tamaño cada vez más grandes y personalizados, por tanto las colecciones de aglomerado con base de cuarzo SANTAMARGHERITA se proponen en baldosas de dimensiones estándares o variables. Para cada proyecto, para cada exigencia, para cada gusto, SANTAMARGHERITA dispone de la superficie ideal.\r\n\r\n&nbsp;\r\n\r\n<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/aeropuerto.jpg\"><img class=\"alignnone size-full wp-image-742\" title=\"Aeropuerto\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/aeropuerto.jpg\" alt=\"\" width=\"576\" height=\"200\" /></a>\r\n\r\n<strong><em>Aglomerado de Cuarzo para superficies de grandes obras</em></strong>\r\n\r\nAeropuertos, estaciones de trenes, centros comerciales, grandes superficies en todo el mundo ostentan actualmente pavimentos y revestimientos con la marca SANTAMARGHERITA. Las potencialidades del aglomerado de cuarzo permiten que SANTAMARGHERITA responda a las exigencias en lo que se refiere a complejidad y personalidad de cada proyecto, a partir del suministro de grandes volúmenes hasta un servicio de investigación y desarrollo de nuevos colores personalizados que dan originalidad y unicidad al producto.\r\n\r\n&nbsp;", "Aplicaciones", "El sistema de gestión de calidad se encuentra certificado por IRAM.", "inherit", "open", "open", "", "386-revision-6", "", "", "2012-05-24 15:52:08", "2012-05-24 19:52:08", "", "386", "http://santamargherita.s-m.cl/386-revision-6/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1343", "1", "2013-06-26 12:36:17", "2013-06-26 16:36:17", "<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/partners2.jpeg\"><img class=\"alignnone size-full wp-image-1063\" title=\"partners2\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/partners2.jpeg\" alt=\"\" width=\"810\" height=\"328\" /></a>\r\n<h3>PARTNERS</h3>\r\n<a href=\"http://kubli.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1050\" title=\"Kubli\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-kubli1.jpg\" alt=\"\" width=\"394\" height=\"78\" /></a><a href=\"http://aei.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1040\" title=\"AEI\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-aei.jpg\" alt=\"\" width=\"386\" height=\"78\" /></a>\r\n\r\n<a href=\"http://bmdiseno.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1042\" title=\"BM Diseño\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-bm.jpg\" alt=\"\" width=\"393\" height=\"112\" /></a><a href=\"http://www.mobel.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1044\" title=\"Mobel\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-mobel.jpg\" alt=\"\" width=\"382\" height=\"112\" /></a>\r\n\r\n<a href=\"http://comercialsym.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1046\" title=\"SYM\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-sym.jpg\" alt=\"\" width=\"392\" height=\"104\" /></a><a href=\"http://unna.com.br\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1047\" title=\"Unna\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-unna.jpg\" alt=\"\" width=\"381\" height=\"103\" /></a>\r\n\r\n<a href=\"http://www.florense.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1314\" title=\"p-florense\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-florense.png\" alt=\"\" width=\"393\" height=\"82\" /></a><a href=\"http://www.topkitchen.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1316\" title=\"Top Kitchen\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-topkitchen.jpg\" alt=\"\" width=\"386\" height=\"81\" /></a>\r\n\r\n<a href=\"http://www.rojoynegro.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1318\" title=\"Rojo y Negro\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-rojoynegro.jpg\" alt=\"\" width=\"393\" height=\"120\" /></a><a href=\"http://www.kitchencenter.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1319\" title=\"Kitchen Center\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-kitchencenter.jpg\" alt=\"\" width=\"385\" height=\"119\" /></a>\r\n\r\n<a href=\"http://www.houseco.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1335\" title=\"House and Co\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-houseco2.jpg\" alt=\"\" width=\"394\" height=\"82\" /></a><a href=\"http://www.kitchenhome.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1327\" title=\"Kitchen Home\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-kitchenhome.jpg\" alt=\"\" width=\"384\" height=\"81\" /></a>\r\n\r\n&nbsp;\r\n<h5>En Regiones:</h5>\r\n\r\n<div style=\"float:left\"><img class=\"alignnone size-full wp-image-1053\" title=\"Casa Kit\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-casakit.jpg\" alt=\"\" width=\"292\" height=\"108\" /></div>\r\n\r\n<div style=\"float:left\"><a href=\"http://www.madestone.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1054\" title=\"Madestone\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-madestone.jpg\" alt=\"\" width=\"256\" height=\"110\" /></a></div>\r\n\r\n<div style=\"float:left\"><a href=\"http://www.espaciodinamico.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1055\" title=\"Espacio Dinámico\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-espaciodinamico.jpg\" alt=\"\" width=\"233\" height=\"111\" /></a></div>\r\n\r\n<div style=\"float:left\"><a href=\"http://www.mobilinares.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1056\" title=\"Mobilinares\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-mobilinares.jpg\" alt=\"\" width=\"291\" height=\"78\" /></a></div>\r\n\r\n<div style=\"float:left\"><a href=\"http://www.staubmuebles.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1057\" title=\"Staub\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-staub.jpg\" alt=\"\" width=\"255\" height=\"77\" /></a></div>\r\n\r\n<div style=\"float:left\"><a href=\"http://www.disypro.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1058\" title=\"disypro\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-disypro.jpg\" alt=\"\" width=\"231\" height=\"79\" /></a></div>\r\n\r\n<div style=\"float:left\"><a href=\"http://www.todoforma.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1330\" title=\"Todo Forma\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-todoforma.jpg\" alt=\"\" width=\"394\" height=\"88\" /></a></div>\r\n\r\n<div style=\"float:left;padding-top:30px;margin-right:20px;\"><a href=\"http://www.phrana.cl\" title=\"Phrana Muebles\" target=\"_blank\"><img src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-phrana.jpg\" alt=\"Phrana Muebles\" title=\"p-phrana\" width=\"74\" height=\"68\" class=\"alignnone size-full wp-image-1339\" /></a></div>\r\n<div style=\"float:left;padding-top:30px;font-size:10px;line/height:10px;\">El Trapiche 1280, G4, Barrio industrial, Coquimbo<br />\r\n(+56 51) 486300<br />\r\nwww.phrana.cl</div>", "Partners", "", "inherit", "closed", "closed", "", "969-revision-v1", "", "", "2013-06-26 12:36:17", "2013-06-26 16:36:17", "", "969", "http://santamargherita.s-m.cl/969-revision-36/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1342", "1", "2013-06-26 12:35:15", "2013-06-26 16:35:15", "<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/partners2.jpeg\"><img class=\"alignnone size-full wp-image-1063\" title=\"partners2\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/partners2.jpeg\" alt=\"\" width=\"810\" height=\"328\" /></a>\r\n<h3>PARTNERS</h3>\r\n<a href=\"http://kubli.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1050\" title=\"Kubli\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-kubli1.jpg\" alt=\"\" width=\"394\" height=\"78\" /></a><a href=\"http://aei.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1040\" title=\"AEI\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-aei.jpg\" alt=\"\" width=\"386\" height=\"78\" /></a>\r\n\r\n<a href=\"http://bmdiseno.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1042\" title=\"BM Diseño\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-bm.jpg\" alt=\"\" width=\"393\" height=\"112\" /></a><a href=\"http://www.mobel.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1044\" title=\"Mobel\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-mobel.jpg\" alt=\"\" width=\"382\" height=\"112\" /></a>\r\n\r\n<a href=\"http://comercialsym.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1046\" title=\"SYM\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-sym.jpg\" alt=\"\" width=\"392\" height=\"104\" /></a><a href=\"http://unna.com.br\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1047\" title=\"Unna\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-unna.jpg\" alt=\"\" width=\"381\" height=\"103\" /></a>\r\n\r\n<a href=\"http://www.florense.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1314\" title=\"p-florense\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-florense.png\" alt=\"\" width=\"393\" height=\"82\" /></a><a href=\"http://www.topkitchen.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1316\" title=\"Top Kitchen\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-topkitchen.jpg\" alt=\"\" width=\"386\" height=\"81\" /></a>\r\n\r\n<a href=\"http://www.rojoynegro.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1318\" title=\"Rojo y Negro\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-rojoynegro.jpg\" alt=\"\" width=\"393\" height=\"120\" /></a><a href=\"http://www.kitchencenter.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1319\" title=\"Kitchen Center\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-kitchencenter.jpg\" alt=\"\" width=\"385\" height=\"119\" /></a>\r\n\r\n<a href=\"http://www.houseco.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1335\" title=\"House and Co\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-houseco2.jpg\" alt=\"\" width=\"394\" height=\"82\" /></a><a href=\"http://www.kitchenhome.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1327\" title=\"Kitchen Home\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-kitchenhome.jpg\" alt=\"\" width=\"384\" height=\"81\" /></a>\r\n\r\n&nbsp;\r\n<h5>En Regiones:</h5>\r\n\r\n<div style=\"float:left\"><img class=\"alignnone size-full wp-image-1053\" title=\"Casa Kit\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-casakit.jpg\" alt=\"\" width=\"292\" height=\"108\" /></div>\r\n\r\n<div style=\"float:left\"><a href=\"http://www.madestone.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1054\" title=\"Madestone\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-madestone.jpg\" alt=\"\" width=\"256\" height=\"110\" /></a></div>\r\n\r\n<div style=\"float:left\"><a href=\"http://www.espaciodinamico.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1055\" title=\"Espacio Dinámico\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-espaciodinamico.jpg\" alt=\"\" width=\"233\" height=\"111\" /></a></div>\r\n\r\n<div style=\"float:left\"><a href=\"http://www.mobilinares.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1056\" title=\"Mobilinares\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-mobilinares.jpg\" alt=\"\" width=\"291\" height=\"78\" /></a></div>\r\n\r\n<div style=\"float:left\"><a href=\"http://www.staubmuebles.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1057\" title=\"Staub\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-staub.jpg\" alt=\"\" width=\"255\" height=\"77\" /></a></div>\r\n\r\n<div style=\"float:left\"><a href=\"http://www.disypro.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1058\" title=\"disypro\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-disypro.jpg\" alt=\"\" width=\"231\" height=\"79\" /></a></div>\r\n\r\n<div style=\"float:left\"><a href=\"http://www.todoforma.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1330\" title=\"Todo Forma\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-todoforma.jpg\" alt=\"\" width=\"394\" height=\"88\" /></a></div>\r\n\r\n<div style=\"float:left;padding-top:30px;\"><a href=\"http://www.phrana.cl\" title=\"Phrana Muebles\" target=\"_blank\"><img src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-phrana.jpg\" alt=\"Phrana Muebles\" title=\"p-phrana\" width=\"74\" height=\"68\" class=\"alignnone size-full wp-image-1339\" /></a></div>\r\n<div style=\"float:left;padding-top:30px;font-size:9px\">El Trapiche 1280, G4, Barrio industrial, Coquimbo<br />\r\n(+56 51) 486300<br />\r\nwww.phrana.cl</div>", "Partners", "", "inherit", "closed", "closed", "", "969-revision-v1", "", "", "2013-06-26 12:35:15", "2013-06-26 16:35:15", "", "969", "http://santamargherita.s-m.cl/969-revision-35/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1341", "1", "2013-06-26 12:34:09", "2013-06-26 16:34:09", "<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/partners2.jpeg\"><img class=\"alignnone size-full wp-image-1063\" title=\"partners2\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/partners2.jpeg\" alt=\"\" width=\"810\" height=\"328\" /></a>\r\n<h3>PARTNERS</h3>\r\n<a href=\"http://kubli.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1050\" title=\"Kubli\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-kubli1.jpg\" alt=\"\" width=\"394\" height=\"78\" /></a><a href=\"http://aei.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1040\" title=\"AEI\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-aei.jpg\" alt=\"\" width=\"386\" height=\"78\" /></a>\r\n\r\n<a href=\"http://bmdiseno.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1042\" title=\"BM Diseño\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-bm.jpg\" alt=\"\" width=\"393\" height=\"112\" /></a><a href=\"http://www.mobel.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1044\" title=\"Mobel\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-mobel.jpg\" alt=\"\" width=\"382\" height=\"112\" /></a>\r\n\r\n<a href=\"http://comercialsym.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1046\" title=\"SYM\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-sym.jpg\" alt=\"\" width=\"392\" height=\"104\" /></a><a href=\"http://unna.com.br\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1047\" title=\"Unna\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-unna.jpg\" alt=\"\" width=\"381\" height=\"103\" /></a>\r\n\r\n<a href=\"http://www.florense.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1314\" title=\"p-florense\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-florense.png\" alt=\"\" width=\"393\" height=\"82\" /></a><a href=\"http://www.topkitchen.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1316\" title=\"Top Kitchen\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-topkitchen.jpg\" alt=\"\" width=\"386\" height=\"81\" /></a>\r\n\r\n<a href=\"http://www.rojoynegro.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1318\" title=\"Rojo y Negro\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-rojoynegro.jpg\" alt=\"\" width=\"393\" height=\"120\" /></a><a href=\"http://www.kitchencenter.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1319\" title=\"Kitchen Center\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-kitchencenter.jpg\" alt=\"\" width=\"385\" height=\"119\" /></a>\r\n\r\n<a href=\"http://www.houseco.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1335\" title=\"House and Co\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-houseco2.jpg\" alt=\"\" width=\"394\" height=\"82\" /></a><a href=\"http://www.kitchenhome.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1327\" title=\"Kitchen Home\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-kitchenhome.jpg\" alt=\"\" width=\"384\" height=\"81\" /></a>\r\n\r\n&nbsp;\r\n<h5>En Regiones:</h5>\r\n\r\n<div style=\"float:left\"><img class=\"alignnone size-full wp-image-1053\" title=\"Casa Kit\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-casakit.jpg\" alt=\"\" width=\"292\" height=\"108\" /></div>\r\n\r\n<div style=\"float:left\"><a href=\"http://www.madestone.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1054\" title=\"Madestone\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-madestone.jpg\" alt=\"\" width=\"256\" height=\"110\" /></a></div>\r\n\r\n<div style=\"float:left\"><a href=\"http://www.espaciodinamico.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1055\" title=\"Espacio Dinámico\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-espaciodinamico.jpg\" alt=\"\" width=\"233\" height=\"111\" /></a></div>\r\n\r\n<div style=\"float:left\"><a href=\"http://www.mobilinares.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1056\" title=\"Mobilinares\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-mobilinares.jpg\" alt=\"\" width=\"291\" height=\"78\" /></a></div>\r\n\r\n<div style=\"float:left\"><a href=\"http://www.staubmuebles.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1057\" title=\"Staub\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-staub.jpg\" alt=\"\" width=\"255\" height=\"77\" /></a></div>\r\n\r\n<div style=\"float:left\"><a href=\"http://www.disypro.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1058\" title=\"disypro\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-disypro.jpg\" alt=\"\" width=\"231\" height=\"79\" /></a></div>\r\n\r\n<div style=\"float:left\"><a href=\"http://www.todoforma.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1330\" title=\"Todo Forma\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-todoforma.jpg\" alt=\"\" width=\"394\" height=\"88\" /></a></div>\r\n\r\n<div style=\"float:left\"><a href=\"http://www.phrana.cl\" title=\"Phrana Muebles\" target=\"_blank\"><img src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-phrana.jpg\" alt=\"Phrana Muebles\" title=\"p-phrana\" width=\"74\" height=\"68\" class=\"alignnone size-full wp-image-1339\" /></a></div><div style=\"float:left\">El Trapiche 1280, G4, Barrio industrial, Coquimbo<br />\r\n(+56 51) 486300<br />\r\nwww.phrana.cl</div>", "Partners", "", "inherit", "closed", "closed", "", "969-revision-v1", "", "", "2013-06-26 12:34:09", "2013-06-26 16:34:09", "", "969", "http://santamargherita.s-m.cl/969-revision-34/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1490", "1", "2014-04-30 12:03:40", "2014-04-30 16:03:40", " ", "", "", "publish", "closed", "closed", "", "1490", "", "", "2014-04-30 12:03:40", "2014-04-30 16:03:40", "", "0", "http://santamargherita.s-m.cl/?p=1490", "5", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1340", "1", "2013-06-26 12:27:55", "2013-06-26 16:27:55", "<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/partners2.jpeg\"><img class=\"alignnone size-full wp-image-1063\" title=\"partners2\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/partners2.jpeg\" alt=\"\" width=\"810\" height=\"328\" /></a>\r\n<h3>PARTNERS</h3>\r\n<a href=\"http://kubli.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1050\" title=\"Kubli\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-kubli1.jpg\" alt=\"\" width=\"394\" height=\"78\" /></a><a href=\"http://aei.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1040\" title=\"AEI\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-aei.jpg\" alt=\"\" width=\"386\" height=\"78\" /></a>\r\n\r\n<a href=\"http://bmdiseno.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1042\" title=\"BM Diseño\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-bm.jpg\" alt=\"\" width=\"393\" height=\"112\" /></a><a href=\"http://www.mobel.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1044\" title=\"Mobel\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-mobel.jpg\" alt=\"\" width=\"382\" height=\"112\" /></a>\r\n\r\n<a href=\"http://comercialsym.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1046\" title=\"SYM\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-sym.jpg\" alt=\"\" width=\"392\" height=\"104\" /></a><a href=\"http://unna.com.br\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1047\" title=\"Unna\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-unna.jpg\" alt=\"\" width=\"381\" height=\"103\" /></a>\r\n\r\n<a href=\"http://www.florense.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1314\" title=\"p-florense\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-florense.png\" alt=\"\" width=\"393\" height=\"82\" /></a><a href=\"http://www.topkitchen.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1316\" title=\"Top Kitchen\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-topkitchen.jpg\" alt=\"\" width=\"386\" height=\"81\" /></a>\r\n\r\n<a href=\"http://www.rojoynegro.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1318\" title=\"Rojo y Negro\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-rojoynegro.jpg\" alt=\"\" width=\"393\" height=\"120\" /></a><a href=\"http://www.kitchencenter.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1319\" title=\"Kitchen Center\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-kitchencenter.jpg\" alt=\"\" width=\"385\" height=\"119\" /></a>\r\n\r\n<a href=\"http://www.houseco.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1335\" title=\"House and Co\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-houseco2.jpg\" alt=\"\" width=\"394\" height=\"82\" /></a><a href=\"http://www.kitchenhome.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1327\" title=\"Kitchen Home\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-kitchenhome.jpg\" alt=\"\" width=\"384\" height=\"81\" /></a>\r\n\r\n&nbsp;\r\n<h5>En Regiones:</h5>\r\n\r\n<div style=\"float:left\"><img class=\"alignnone size-full wp-image-1053\" title=\"Casa Kit\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-casakit.jpg\" alt=\"\" width=\"292\" height=\"108\" /></div>\r\n\r\n<div style=\"float:left\"><a href=\"http://www.madestone.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1054\" title=\"Madestone\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-madestone.jpg\" alt=\"\" width=\"256\" height=\"110\" /></a></div>\r\n\r\n<div style=\"float:left\"><a href=\"http://www.espaciodinamico.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1055\" title=\"Espacio Dinámico\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-espaciodinamico.jpg\" alt=\"\" width=\"233\" height=\"111\" /></a></div>\r\n\r\n<div style=\"float:left\"><a href=\"http://www.mobilinares.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1056\" title=\"Mobilinares\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-mobilinares.jpg\" alt=\"\" width=\"291\" height=\"78\" /></a></div>\r\n\r\n<a href=\"http://www.staubmuebles.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1057\" title=\"Staub\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-staub.jpg\" alt=\"\" width=\"255\" height=\"77\" /></a><a href=\"http://www.disypro.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1058\" title=\"disypro\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-disypro.jpg\" alt=\"\" width=\"231\" height=\"79\" /></a>\r\n\r\n<a href=\"http://www.todoforma.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1330\" title=\"Todo Forma\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-todoforma.jpg\" alt=\"\" width=\"394\" height=\"88\" /></a>", "Partners", "", "inherit", "closed", "closed", "", "969-revision-v1", "", "", "2013-06-26 12:27:55", "2013-06-26 16:27:55", "", "969", "http://santamargherita.s-m.cl/969-revision-33/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1338", "1", "2013-06-26 12:26:52", "2013-06-26 16:26:52", "<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/partners2.jpeg\"><img class=\"alignnone size-full wp-image-1063\" title=\"partners2\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/partners2.jpeg\" alt=\"\" width=\"810\" height=\"328\" /></a>\r\n<h3>PARTNERS</h3>\r\n<a href=\"http://kubli.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1050\" title=\"Kubli\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-kubli1.jpg\" alt=\"\" width=\"394\" height=\"78\" /></a><a href=\"http://aei.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1040\" title=\"AEI\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-aei.jpg\" alt=\"\" width=\"386\" height=\"78\" /></a>\r\n\r\n<a href=\"http://bmdiseno.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1042\" title=\"BM Diseño\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-bm.jpg\" alt=\"\" width=\"393\" height=\"112\" /></a><a href=\"http://www.mobel.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1044\" title=\"Mobel\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-mobel.jpg\" alt=\"\" width=\"382\" height=\"112\" /></a>\r\n\r\n<a href=\"http://comercialsym.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1046\" title=\"SYM\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-sym.jpg\" alt=\"\" width=\"392\" height=\"104\" /></a><a href=\"http://unna.com.br\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1047\" title=\"Unna\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-unna.jpg\" alt=\"\" width=\"381\" height=\"103\" /></a>\r\n\r\n<a href=\"http://www.florense.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1314\" title=\"p-florense\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-florense.png\" alt=\"\" width=\"393\" height=\"82\" /></a><a href=\"http://www.topkitchen.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1316\" title=\"Top Kitchen\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-topkitchen.jpg\" alt=\"\" width=\"386\" height=\"81\" /></a>\r\n\r\n<a href=\"http://www.rojoynegro.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1318\" title=\"Rojo y Negro\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-rojoynegro.jpg\" alt=\"\" width=\"393\" height=\"120\" /></a><a href=\"http://www.kitchencenter.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1319\" title=\"Kitchen Center\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-kitchencenter.jpg\" alt=\"\" width=\"385\" height=\"119\" /></a>\r\n\r\n<a href=\"http://www.houseco.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1335\" title=\"House and Co\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-houseco2.jpg\" alt=\"\" width=\"394\" height=\"82\" /></a><a href=\"http://www.kitchenhome.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1327\" title=\"Kitchen Home\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-kitchenhome.jpg\" alt=\"\" width=\"384\" height=\"81\" /></a>\r\n\r\n&nbsp;\r\n<h5>En Regiones:</h5>\r\n\r\n<div style=\"float:left\"><img class=\"alignnone size-full wp-image-1053\" title=\"Casa Kit\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-casakit.jpg\" alt=\"\" width=\"292\" height=\"108\" /></div>\r\n\r\n<div style=\"float:left\"><a href=\"http://www.madestone.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1054\" title=\"Madestone\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-madestone.jpg\" alt=\"\" width=\"256\" height=\"110\" /></a></div>\r\n\r\n<a href=\"http://www.espaciodinamico.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1055\" title=\"Espacio Dinámico\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-espaciodinamico.jpg\" alt=\"\" width=\"233\" height=\"111\" /></a>\r\n\r\n<a href=\"http://www.mobilinares.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1056\" title=\"Mobilinares\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-mobilinares.jpg\" alt=\"\" width=\"291\" height=\"78\" /></a><a href=\"http://www.staubmuebles.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1057\" title=\"Staub\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-staub.jpg\" alt=\"\" width=\"255\" height=\"77\" /></a><a href=\"http://www.disypro.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1058\" title=\"disypro\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-disypro.jpg\" alt=\"\" width=\"231\" height=\"79\" /></a>\r\n\r\n<a href=\"http://www.todoforma.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1330\" title=\"Todo Forma\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-todoforma.jpg\" alt=\"\" width=\"394\" height=\"88\" /></a>", "Partners", "", "inherit", "closed", "closed", "", "969-revision-v1", "", "", "2013-06-26 12:26:52", "2013-06-26 16:26:52", "", "969", "http://santamargherita.s-m.cl/969-revision-32/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1337", "1", "2013-03-26 14:12:17", "2013-03-26 18:12:17", "<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/partners2.jpeg\"><img class=\"alignnone size-full wp-image-1063\" title=\"partners2\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/partners2.jpeg\" alt=\"\" width=\"810\" height=\"328\" /></a>\r\n<h3>PARTNERS</h3>\r\n<a href=\"http://kubli.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1050\" title=\"Kubli\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-kubli1.jpg\" alt=\"\" width=\"394\" height=\"78\" /></a><a href=\"http://aei.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1040\" title=\"AEI\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-aei.jpg\" alt=\"\" width=\"386\" height=\"78\" /></a>\r\n\r\n<a href=\"http://bmdiseno.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1042\" title=\"BM Diseño\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-bm.jpg\" alt=\"\" width=\"393\" height=\"112\" /></a><a href=\"http://www.mobel.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1044\" title=\"Mobel\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-mobel.jpg\" alt=\"\" width=\"382\" height=\"112\" /></a>\r\n\r\n<a href=\"http://comercialsym.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1046\" title=\"SYM\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-sym.jpg\" alt=\"\" width=\"392\" height=\"104\" /></a><a href=\"http://unna.com.br\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1047\" title=\"Unna\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-unna.jpg\" alt=\"\" width=\"381\" height=\"103\" /></a>\r\n\r\n<a href=\"http://www.florense.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1314\" title=\"p-florense\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-florense.png\" alt=\"\" width=\"393\" height=\"82\" /></a><a href=\"http://www.topkitchen.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1316\" title=\"Top Kitchen\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-topkitchen.jpg\" alt=\"\" width=\"386\" height=\"81\" /></a>\r\n\r\n<a href=\"http://www.rojoynegro.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1318\" title=\"Rojo y Negro\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-rojoynegro.jpg\" alt=\"\" width=\"393\" height=\"120\" /></a><a href=\"http://www.kitchencenter.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1319\" title=\"Kitchen Center\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-kitchencenter.jpg\" alt=\"\" width=\"385\" height=\"119\" /></a>\r\n\r\n<a href=\"http://www.houseco.cl/\" target=\"_blank\"><img src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-houseco2.jpg\" alt=\"\" title=\"House and Co\" width=\"394\" height=\"82\" class=\"alignnone size-full wp-image-1335\" /></a><a href=\"http://www.kitchenhome.cl\" target=\"_blank\"><img src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-kitchenhome.jpg\" alt=\"\" title=\"Kitchen Home\" width=\"384\" height=\"81\" class=\"alignnone size-full wp-image-1327\" /></a>\r\n\r\n&nbsp;\r\n<h5>En Regiones:</h5>\r\n<img class=\"alignnone size-full wp-image-1053\" title=\"Casa Kit\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-casakit.jpg\" alt=\"\" width=\"292\" height=\"108\" /><a href=\"http://www.madestone.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1054\" title=\"Madestone\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-madestone.jpg\" alt=\"\" width=\"256\" height=\"110\" /></a><a href=\"http://www.espaciodinamico.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1055\" title=\"Espacio Dinámico\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-espaciodinamico.jpg\" alt=\"\" width=\"233\" height=\"111\" /></a>\r\n\r\n<a href=\"http://www.mobilinares.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1056\" title=\"Mobilinares\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-mobilinares.jpg\" alt=\"\" width=\"291\" height=\"78\" /></a><a href=\"http://www.staubmuebles.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1057\" title=\"Staub\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-staub.jpg\" alt=\"\" width=\"255\" height=\"77\" /></a><a href=\"http://www.disypro.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1058\" title=\"disypro\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-disypro.jpg\" alt=\"\" width=\"231\" height=\"79\" /></a>\r\n\r\n<a href=\"http://www.todoforma.cl\" target=\"_blank\"><img src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-todoforma.jpg\" alt=\"\" title=\"Todo Forma\" width=\"394\" height=\"88\" class=\"alignnone size-full wp-image-1330\" /></a>", "Partners", "", "inherit", "closed", "closed", "", "969-revision-v1", "", "", "2013-03-26 14:12:17", "2013-03-26 18:12:17", "", "969", "http://santamargherita.s-m.cl/969-revision-31/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("798", "1", "2012-05-28 15:19:12", "2012-05-28 19:19:12", "<img class=\"alignnone size-full wp-image-796\" title=\"Aplicaciones Baño\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/aplicaciones2.jpg\" alt=\"\" width=\"810\" height=\"328\" />\r\n\r\n<strong><em>Aglomerado de Cuarzo para encimeras de Cocina y Baño</em></strong>\r\n\r\nCada casa refleja la personalidad de quienes viven en ella. Caracteres, gustos y estilos que pueden llegar a ser infinitos, opuestos entre ellos; desde el neoclásico hasta el barroco, desde la ostentación hasta el minimalismo, con el uso de una paleta de colores desde las tonalidades más claras hasta las más fuertes.<strong><em></em></strong>\r\n\r\nSANTAMARGHERITA, a través de una investigación constante, crea superficies con altas prestaciones técnicas y que son estéticamente capaces de hacer que los ambientes domésticos sean únicos satisfaciendo perfectamente las diferentes exigencias.\r\n\r\nEl material ideal para pavimentos y revestimientos, cabinas de ducha y encimeras de cocina y baño se caracteriza, por un lado, por la alta resistencia a la flexión, abrasión y ácidos, y por el otro, por la variedad de colores y texturas más neutras o con mayor profundidad y efectos de movimiento.\r\n\r\nActualmente en el diseño de interiores está marcado el uso de tamaño cada vez más grandes y personalizados, por tanto las colecciones de aglomerado con base de cuarzo SANTAMARGHERITA se proponen en baldosas de dimensiones estándares o variables. Para cada proyecto, para cada exigencia, para cada gusto, SANTAMARGHERITA dispone de la superficie ideal.\r\n\r\n&nbsp;\r\n\r\n<a name=\"aeropuerto\"></a><a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/aeropuerto.jpg\"><img class=\"alignnone size-full wp-image-742\" title=\"Aeropuerto\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/aeropuerto.jpg\" alt=\"\" width=\"576\" height=\"200\" /></a>\r\n\r\n<strong><em>Aglomerado de Cuarzo para superficies de grandes obras</em></strong>\r\n\r\nAeropuertos, estaciones de trenes, centros comerciales, grandes superficies en todo el mundo ostentan actualmente pavimentos y revestimientos con la marca SANTAMARGHERITA. Las potencialidades del aglomerado de cuarzo permiten que SANTAMARGHERITA responda a las exigencias en lo que se refiere a complejidad y personalidad de cada proyecto, a partir del suministro de grandes volúmenes hasta un servicio de investigación y desarrollo de nuevos colores personalizados que dan originalidad y unicidad al producto.\r\n\r\n&nbsp;", "Aplicaciones", "Cada casa refleja la personalidad de quienes viven en ella.", "inherit", "open", "open", "", "386-revision-9", "", "", "2012-05-28 15:19:12", "2012-05-28 19:19:12", "", "386", "http://santamargherita.s-m.cl/386-revision-9/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("745", "1", "2012-04-26 10:42:19", "2012-04-26 14:42:19", "<a href=\"http://s-m.cl/wp-content/uploads/2012/03/novedad2.jpg\"><img class=\"alignnone size-full wp-image-659\" title=\"novedad2\" src=\"http://s-m.cl/wp-content/uploads/2012/03/novedad2.jpg\" alt=\"Novedades\" width=\"576\" height=\"200\" /></a>\r\n\r\n<strong>Sistema de apertura corredizo/paño fijo</strong>\r\n\r\n<strong>\r\n</strong>PVC Tecnocom ha lanzado al mercado un nuevo sistema de apertura CORREDIZO/PAÑO FIJO,  con el se pueden combinar aperturas de hojas móviles y paños fijos de medidas variadas y de hasta cuatro paños fijos.\r\n\r\n<strong>\r\nFolio Interior en ventanas de piso a cielo.</strong>\r\n\r\n<strong>\r\n</strong>PVC Tecnocom ha desarrollado dentro de sus productos una línea de perfiles destinada a entregar soluciones para ventanas de hojas móviles de piso a cielo, con el interior del marco foliado del mismo tono que el exterior del perfil, de manera de otorgar a las terminaciones de sus ventanas un acabado pulcro y homogéneo.\r\nSouth Merchants es la primera empresa en Chile en incorporar esta tecnología a sus soluciones de ventanas, entregándole al cliente un plus para el diseño de sus proyectos.", "Novedades", "PVC Tecnocom ha lanzado al mercado un nuevo sistema de apertura.", "inherit", "open", "open", "", "401-revision-9", "", "", "2012-04-26 10:42:19", "2012-04-26 14:42:19", "", "401", "http://santamargherita.s-m.cl/401-revision-9/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("922", "1", "2012-05-28 17:28:28", "2012-05-28 21:28:28", "<img class=\"alignnone size-full wp-image-858\" title=\"Santamargherita\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/04/somos.jpg\" alt=\"\" width=\"810\" height=\"328\" />\r\n<h3>QUIENES SOMOS</h3>\r\nSantamargherita es una empresa Italiana líder en el mercado de los aglomerados, con más de 40 años de trayectoria y presente en más de 70 Países, siempre atenta a las nuevas tendencias de la arquitectura y del diseño interior, la empresa ubicada en Volargne di Dolcè (Verona) con más de 100.000 metros construidos, satisface las exigencias de diseño y calidad, ofreciendo a sus clientes líneas sobrias y esenciales, con tonalidades neutras y elegantes y líneas más innovadoras y exclusivas con colores cautivadores y acabados únicos.\r\n\r\nSantamargherita llega a Chile con su línea trafficstone para dar solución a los más variados proyectos tanto residenciales como públicos; su composición de 93% de cuarzo y un 7% de resina poliéster, le otorga cualidades únicas en el mercado, transformándolo en la mejor solución para cubiertas de baños y cocinas, además de revestimientos de muros y pisos.", "Quienes somos", "", "inherit", "open", "open", "", "432-revision-7", "", "", "2012-05-28 17:28:28", "2012-05-28 21:28:28", "", "432", "http://santamargherita.s-m.cl/432-revision-7/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("923", "1", "2012-06-06 12:51:58", "2012-06-06 16:51:58", "<img class=\"alignnone size-full wp-image-858\" title=\"Santamargherita\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/04/somos.jpg\" alt=\"\" width=\"810\" height=\"328\" />\r\n<h3>QUIENES SOMOS</h3>\r\n<img class=\"alignnone size-full wp-image-904\" title=\"\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/santamargherita-logo-01.png\" alt=\"\" width=\"80\" height=\"15\" /> es una empresa Italiana líder en el mercado de los aglomerados, con más de 40 años de trayectoria y presente en más de 70 Países, siempre atenta a las nuevas tendencias de la arquitectura y del diseño interior, la empresa ubicada en Volargne di Dolcè (Verona) con más de 100.000 metros construidos, satisface las exigencias de diseño y calidad, ofreciendo a sus clientes líneas sobrias y esenciales, con tonalidades neutras y elegantes y líneas más innovadoras y exclusivas con colores cautivadores y acabados únicos.\r\n\r\nSantamargherita llega a Chile con su línea trafficstone para dar solución a los más variados proyectos tanto residenciales como públicos; su composición de 93% de cuarzo y un 7% de resina poliéster, le otorga cualidades únicas en el mercado, transformándolo en la mejor solución para cubiertas de baños y cocinas, además de revestimientos de muros y pisos.", "Quienes somos", "", "inherit", "open", "open", "", "432-revision-8", "", "", "2012-06-06 12:51:58", "2012-06-06 16:51:58", "", "432", "http://santamargherita.s-m.cl/432-revision-8/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("925", "1", "2012-06-06 12:48:28", "2012-06-06 16:48:28", "<img class=\"alignnone size-full wp-image-916\" title=\"Proyectos destacados\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/bano.jpg\" alt=\"\" width=\"810\" height=\"328\" />\r\n<h3>PROYECTOS DESTACADOS</h3>", "Proyectos destacados", "Proyectos destacados realizados por nuestra empresa.", "inherit", "open", "open", "", "398-revision-21", "", "", "2012-06-06 12:48:28", "2012-06-06 16:48:28", "", "398", "http://santamargherita.s-m.cl/398-revision-21/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1332", "1", "2013-03-25 13:43:49", "2013-03-25 17:43:49", "<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/partners2.jpeg\"><img class=\"alignnone size-full wp-image-1063\" title=\"partners2\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/partners2.jpeg\" alt=\"\" width=\"810\" height=\"328\" /></a>\r\n<h3>PARTNERS</h3>\r\n<a href=\"http://kubli.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1050\" title=\"Kubli\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-kubli1.jpg\" alt=\"\" width=\"394\" height=\"78\" /></a><a href=\"http://aei.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1040\" title=\"AEI\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-aei.jpg\" alt=\"\" width=\"386\" height=\"78\" /></a>\r\n\r\n<a href=\"http://bmdiseno.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1042\" title=\"BM Diseño\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-bm.jpg\" alt=\"\" width=\"393\" height=\"112\" /></a><a href=\"http://www.mobel.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1044\" title=\"Mobel\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-mobel.jpg\" alt=\"\" width=\"382\" height=\"112\" /></a>\r\n\r\n<a href=\"http://comercialsym.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1046\" title=\"SYM\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-sym.jpg\" alt=\"\" width=\"392\" height=\"104\" /></a><a href=\"http://unna.com.br\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1047\" title=\"Unna\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-unna.jpg\" alt=\"\" width=\"381\" height=\"103\" /></a>\r\n\r\n<a href=\"http://www.florense.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1314\" title=\"p-florense\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-florense.png\" alt=\"\" width=\"393\" height=\"82\" /></a><a href=\"http://www.topkitchen.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1316\" title=\"Top Kitchen\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-topkitchen.jpg\" alt=\"\" width=\"386\" height=\"81\" /></a>\r\n\r\n<a href=\"http://www.rojoynegro.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1318\" title=\"Rojo y Negro\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-rojoynegro.jpg\" alt=\"\" width=\"393\" height=\"120\" /></a><a href=\"http://www.kitchencenter.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1319\" title=\"Kitchen Center\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-kitchencenter.jpg\" alt=\"\" width=\"385\" height=\"119\" /></a>\r\n\r\n<a href=\"http://www.houseco.cl\" target=\"_blank\"><img src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-houseco.jpg\" alt=\"\" title=\"House and Co\" class=\"alignnone size-full wp-image-1322\" /></a><a href=\"http://www.kitchenhome.cl\" target=\"_blank\"><img src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-kitchenhome.jpg\" alt=\"\" title=\"Kitchen Home\" width=\"384\" height=\"81\" class=\"alignnone size-full wp-image-1327\" /></a>\r\n\r\n&nbsp;\r\n<h5>En Regiones:</h5>\r\n<img class=\"alignnone size-full wp-image-1053\" title=\"Casa Kit\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-casakit.jpg\" alt=\"\" width=\"292\" height=\"108\" /><a href=\"http://www.madestone.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1054\" title=\"Madestone\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-madestone.jpg\" alt=\"\" width=\"256\" height=\"110\" /></a><a href=\"http://www.espaciodinamico.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1055\" title=\"Espacio Dinámico\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-espaciodinamico.jpg\" alt=\"\" width=\"233\" height=\"111\" /></a>\r\n\r\n<a href=\"http://www.mobilinares.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1056\" title=\"Mobilinares\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-mobilinares.jpg\" alt=\"\" width=\"291\" height=\"78\" /></a><a href=\"http://www.staubmuebles.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1057\" title=\"Staub\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-staub.jpg\" alt=\"\" width=\"255\" height=\"77\" /></a><a href=\"http://www.disypro.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1058\" title=\"disypro\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-disypro.jpg\" alt=\"\" width=\"231\" height=\"79\" /></a>\r\n\r\n<a href=\"http://www.todoforma.cl\" target=\"_blank\"><img src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-todoforma.jpg\" alt=\"\" title=\"Todo Forma\" width=\"394\" height=\"88\" class=\"alignnone size-full wp-image-1330\" /></a>", "Partners", "", "inherit", "closed", "closed", "", "969-revision-v1", "", "", "2013-03-25 13:43:49", "2013-03-25 17:43:49", "", "969", "http://santamargherita.s-m.cl/969-revision-28/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("788", "1", "2012-05-28 15:07:22", "2012-05-28 19:07:22", "", "Novedades", "", "inherit", "open", "open", "", "novedades3", "", "", "2012-05-28 15:07:22", "2012-05-28 19:07:22", "", "401", "http://santamargherita.s-m.cl/wp-content/uploads/2012/03/novedades3.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("1325", "1", "2012-10-29 14:58:45", "2012-10-29 18:58:45", "<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/partners2.jpeg\"><img class=\"alignnone size-full wp-image-1063\" title=\"partners2\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/partners2.jpeg\" alt=\"\" width=\"810\" height=\"328\" /></a>\r\n<h3>PARTNERS</h3>\r\n<a href=\"http://kubli.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1050\" title=\"Kubli\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-kubli1.jpg\" alt=\"\" width=\"394\" height=\"78\" /></a><a href=\"http://aei.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1040\" title=\"AEI\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-aei.jpg\" alt=\"\" width=\"386\" height=\"78\" /></a>\r\n\r\n<a href=\"http://bmdiseno.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1042\" title=\"BM Diseño\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-bm.jpg\" alt=\"\" width=\"393\" height=\"112\" /></a><a href=\"http://www.mobel.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1044\" title=\"Mobel\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-mobel.jpg\" alt=\"\" width=\"382\" height=\"112\" /></a>\r\n\r\n<a href=\"http://comercialsym.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1046\" title=\"SYM\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-sym.jpg\" alt=\"\" width=\"392\" height=\"104\" /></a><a href=\"http://unna.com.br\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1047\" title=\"Unna\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-unna.jpg\" alt=\"\" width=\"381\" height=\"103\" /></a>\r\n\r\n<a href=\"http://www.florense.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1314\" title=\"p-florense\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-florense.png\" alt=\"\" width=\"393\" height=\"82\" /></a><a href=\"http://www.topkitchen.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1316\" title=\"Top Kitchen\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-topkitchen.jpg\" alt=\"\" width=\"386\" height=\"81\" /></a>\r\n\r\n<a href=\"http://www.houseco.cl\"><img src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-houseco.jpg\" alt=\"\" title=\"House and Co\" class=\"alignnone size-full wp-image-1322\" /></a><a href=\"http://www.kitchencenter.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1319\" title=\"Kitchen Center\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-kitchencenter.jpg\" alt=\"\" width=\"385\" height=\"119\" /></a>\r\n\r\n<a href=\"http://www.rojoynegro.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1318\" title=\"Rojo y Negro\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-rojoynegro.jpg\" alt=\"\" width=\"393\" height=\"120\" /></a>\r\n\r\n&nbsp;\r\n<h5>En Regiones:</h5>\r\n<img class=\"alignnone size-full wp-image-1053\" title=\"Casa Kit\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-casakit.jpg\" alt=\"\" width=\"292\" height=\"108\" /><a href=\"http://www.madestone.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1054\" title=\"Madestone\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-madestone.jpg\" alt=\"\" width=\"256\" height=\"110\" /></a><a href=\"http://www.espaciodinamico.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1055\" title=\"Espacio Dinámico\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-espaciodinamico.jpg\" alt=\"\" width=\"233\" height=\"111\" /></a>\r\n\r\n<a href=\"http://www.mobilinares.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1056\" title=\"Mobilinares\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-mobilinares.jpg\" alt=\"\" width=\"291\" height=\"78\" /></a><a href=\"http://www.staubmuebles.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1057\" title=\"Staub\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-staub.jpg\" alt=\"\" width=\"255\" height=\"77\" /></a><a href=\"http://www.disypro.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1058\" title=\"disypro\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-disypro.jpg\" alt=\"\" width=\"231\" height=\"79\" /></a>", "Partners", "", "inherit", "closed", "closed", "", "969-revision-v1", "", "", "2012-10-29 14:58:45", "2012-10-29 18:58:45", "", "969", "http://santamargherita.s-m.cl/969-revision-23/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1324", "1", "2012-10-29 14:57:39", "2012-10-29 18:57:39", "<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/partners2.jpeg\"><img class=\"alignnone size-full wp-image-1063\" title=\"partners2\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/partners2.jpeg\" alt=\"\" width=\"810\" height=\"328\" /></a>\r\n<h3>PARTNERS</h3>\r\n<a href=\"http://kubli.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1050\" title=\"Kubli\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-kubli1.jpg\" alt=\"\" width=\"394\" height=\"78\" /></a><a href=\"http://aei.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1040\" title=\"AEI\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-aei.jpg\" alt=\"\" width=\"386\" height=\"78\" /></a>\r\n\r\n<a href=\"http://bmdiseno.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1042\" title=\"BM Diseño\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-bm.jpg\" alt=\"\" width=\"393\" height=\"112\" /></a><a href=\"http://www.mobel.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1044\" title=\"Mobel\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-mobel.jpg\" alt=\"\" width=\"382\" height=\"112\" /></a>\r\n\r\n<a href=\"http://comercialsym.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1046\" title=\"SYM\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-sym.jpg\" alt=\"\" width=\"392\" height=\"104\" /></a><a href=\"http://unna.com.br\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1047\" title=\"Unna\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-unna.jpg\" alt=\"\" width=\"381\" height=\"103\" /></a>\r\n\r\n<a href=\"http://www.florense.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1314\" title=\"p-florense\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-florense.png\" alt=\"\" width=\"393\" height=\"82\" /></a><a href=\"http://www.topkitchen.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1316\" title=\"Top Kitchen\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-topkitchen.jpg\" alt=\"\" width=\"386\" height=\"81\" /></a>\r\n\r\n<a href=\"http://www.rojoynegro.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1318\" title=\"Rojo y Negro\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-rojoynegro.jpg\" alt=\"\" width=\"393\" height=\"120\" /></a><a href=\"http://www.kitchencenter.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1319\" title=\"Kitchen Center\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-kitchencenter.jpg\" alt=\"\" width=\"385\" height=\"119\" /></a>\r\n\r\n<a href=\"http://www.houseco.cl\"><img src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-houseco.jpg\" alt=\"\" title=\"House and Co\" class=\"alignnone size-full wp-image-1322\" /></a>\r\n\r\n&nbsp;\r\n<h5>En Regiones:</h5>\r\n<img class=\"alignnone size-full wp-image-1053\" title=\"Casa Kit\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-casakit.jpg\" alt=\"\" width=\"292\" height=\"108\" /><a href=\"http://www.madestone.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1054\" title=\"Madestone\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-madestone.jpg\" alt=\"\" width=\"256\" height=\"110\" /></a><a href=\"http://www.espaciodinamico.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1055\" title=\"Espacio Dinámico\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-espaciodinamico.jpg\" alt=\"\" width=\"233\" height=\"111\" /></a>\r\n\r\n<a href=\"http://www.mobilinares.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1056\" title=\"Mobilinares\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-mobilinares.jpg\" alt=\"\" width=\"291\" height=\"78\" /></a><a href=\"http://www.staubmuebles.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1057\" title=\"Staub\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-staub.jpg\" alt=\"\" width=\"255\" height=\"77\" /></a><a href=\"http://www.disypro.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1058\" title=\"disypro\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-disypro.jpg\" alt=\"\" width=\"231\" height=\"79\" /></a>", "Partners", "", "inherit", "closed", "closed", "", "969-revision-v1", "", "", "2012-10-29 14:57:39", "2012-10-29 18:57:39", "", "969", "http://santamargherita.s-m.cl/969-revision-22/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1323", "1", "2012-10-03 09:47:18", "2012-10-03 13:47:18", "<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/partners2.jpeg\"><img class=\"alignnone size-full wp-image-1063\" title=\"partners2\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/partners2.jpeg\" alt=\"\" width=\"810\" height=\"328\" /></a>\r\n<h3>PARTNERS</h3>\r\n<a href=\"http://kubli.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1050\" title=\"Kubli\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-kubli1.jpg\" alt=\"\" width=\"394\" height=\"78\" /></a><a href=\"http://aei.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1040\" title=\"AEI\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-aei.jpg\" alt=\"\" width=\"386\" height=\"78\" /></a>\r\n\r\n<a href=\"http://bmdiseno.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1042\" title=\"BM Diseño\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-bm.jpg\" alt=\"\" width=\"393\" height=\"112\" /></a><a href=\"http://www.mobel.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1044\" title=\"Mobel\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-mobel.jpg\" alt=\"\" width=\"382\" height=\"112\" /></a>\r\n\r\n<a href=\"http://comercialsym.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1046\" title=\"SYM\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-sym.jpg\" alt=\"\" width=\"392\" height=\"104\" /></a><a href=\"http://unna.com.br\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1047\" title=\"Unna\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-unna.jpg\" alt=\"\" width=\"381\" height=\"103\" /></a>\r\n\r\n<a href=\"http://www.florense.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1314\" title=\"p-florense\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-florense.png\" alt=\"\" width=\"393\" height=\"82\" /></a><a href=\"http://www.topkitchen.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1316\" title=\"Top Kitchen\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-topkitchen.jpg\" alt=\"\" width=\"386\" height=\"81\" /></a>\r\n\r\n<a href=\"http://www.rojoynegro.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1318\" title=\"Rojo y Negro\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-rojoynegro.jpg\" alt=\"\" width=\"393\" height=\"120\" /></a><a href=\"http://www.kitchencenter.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1319\" title=\"Kitchen Center\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-kitchencenter.jpg\" alt=\"\" width=\"385\" height=\"119\" /></a>\r\n\r\n&nbsp;\r\n<h5>En Regiones:</h5>\r\n<img class=\"alignnone size-full wp-image-1053\" title=\"Casa Kit\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-casakit.jpg\" alt=\"\" width=\"292\" height=\"108\" /><a href=\"http://www.madestone.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1054\" title=\"Madestone\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-madestone.jpg\" alt=\"\" width=\"256\" height=\"110\" /></a><a href=\"http://www.espaciodinamico.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1055\" title=\"Espacio Dinámico\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-espaciodinamico.jpg\" alt=\"\" width=\"233\" height=\"111\" /></a>\r\n\r\n<a href=\"http://www.mobilinares.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1056\" title=\"Mobilinares\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-mobilinares.jpg\" alt=\"\" width=\"291\" height=\"78\" /></a><a href=\"http://www.staubmuebles.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1057\" title=\"Staub\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-staub.jpg\" alt=\"\" width=\"255\" height=\"77\" /></a><a href=\"http://www.disypro.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1058\" title=\"disypro\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-disypro.jpg\" alt=\"\" width=\"231\" height=\"79\" /></a>", "Partners", "", "inherit", "closed", "closed", "", "969-revision-v1", "", "", "2012-10-03 09:47:18", "2012-10-03 13:47:18", "", "969", "http://santamargherita.s-m.cl/969-revision-21/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1321", "1", "2012-10-03 09:46:01", "2012-10-03 13:46:01", "<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/partners2.jpeg\"><img class=\"alignnone size-full wp-image-1063\" title=\"partners2\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/partners2.jpeg\" alt=\"\" width=\"810\" height=\"328\" /></a>\r\n<h3>PARTNERS</h3>\r\n<a href=\"http://kubli.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1050\" title=\"Kubli\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-kubli1.jpg\" alt=\"\" width=\"394\" height=\"78\" /></a><a href=\"http://aei.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1040\" title=\"AEI\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-aei.jpg\" alt=\"\" width=\"386\" height=\"78\" /></a>\r\n\r\n<a href=\"http://bmdiseno.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1042\" title=\"BM Diseño\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-bm.jpg\" alt=\"\" width=\"393\" height=\"112\" /></a><a href=\"http://www.mobel.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1044\" title=\"Mobel\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-mobel.jpg\" alt=\"\" width=\"382\" height=\"112\" /></a>\r\n\r\n<a href=\"http://comercialsym.cl/\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1046\" title=\"SYM\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-sym.jpg\" alt=\"\" width=\"392\" height=\"104\" /></a><a href=\"http://unna.com.br\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1047\" title=\"Unna\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-unna.jpg\" alt=\"\" width=\"381\" height=\"103\" /></a>\r\n\r\n<a href=\"http://www.topkitchen.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1314\" title=\"p-florense\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-florense.png\" alt=\"\" width=\"393\" height=\"82\" /><img class=\"alignnone size-full wp-image-1316\" title=\"Top Kitchen\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-topkitchen.jpg\" alt=\"\" width=\"386\" height=\"81\" /></a>\r\n\r\n<img class=\"alignnone size-full wp-image-1318\" title=\"Rojo y Negro\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-rojoynegro.jpg\" alt=\"\" width=\"393\" height=\"120\" /><img class=\"alignnone size-full wp-image-1319\" title=\"Kitchen Center\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/06/p-kitchencenter.jpg\" alt=\"\" width=\"385\" height=\"119\" />\r\n\r\n&nbsp;\r\n<h5>En Regiones:</h5>\r\n<img class=\"alignnone size-full wp-image-1053\" title=\"Casa Kit\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-casakit.jpg\" alt=\"\" width=\"292\" height=\"108\" /><a href=\"http://www.madestone.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1054\" title=\"Madestone\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-madestone.jpg\" alt=\"\" width=\"256\" height=\"110\" /></a><a href=\"http://www.espaciodinamico.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1055\" title=\"Espacio Dinámico\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-espaciodinamico.jpg\" alt=\"\" width=\"233\" height=\"111\" /></a>\r\n\r\n<a href=\"http://www.mobilinares.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1056\" title=\"Mobilinares\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-mobilinares.jpg\" alt=\"\" width=\"291\" height=\"78\" /></a><a href=\"http://www.staubmuebles.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1057\" title=\"Staub\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-staub.jpg\" alt=\"\" width=\"255\" height=\"77\" /></a><a href=\"http://www.disypro.cl\" target=\"_blank\"><img class=\"alignnone size-full wp-image-1058\" title=\"disypro\" src=\"http://santamargherita.s-m.cl/wp-content/uploads//2012/06/p-disypro.jpg\" alt=\"\" width=\"231\" height=\"79\" /></a>", "Partners", "", "inherit", "closed", "closed", "", "969-revision-v1", "", "", "2012-10-03 09:46:01", "2012-10-03 13:46:01", "", "969", "http://santamargherita.s-m.cl/969-revision-20/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("750", "1", "2012-05-24 16:14:38", "2012-05-24 20:14:38", "<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/novedades.jpg\"><img class=\"alignnone size-full wp-image-748\" title=\"Novedades\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/novedades.jpg\" alt=\"\" width=\"576\" height=\"200\" /></a>\r\n\r\nSANTAMARGHERITA además de los tradicionales efectos brillante, pulido, cepillado y envejecido, añade a sus colecciones de aglomerado de base de cuarzo, acabados nuevos y originales, que son fruto de una investigación a fondo y de un diseño sofisticado. La posibilidad de combinarlos y mezclarlos libremente permite obtener ambientes donde las superficies asumen la características de suavidad y movimiento.\r\n\r\nAdemás de la línea Trafficstone contamos con otras líneas de productos que se trabajan actualmente en Chile a pedido:\r\n\r\n&nbsp;\r\n\r\n<strong><em>Agglosimplex</em></strong>\r\n\r\nAglomerado a base de fragmentos de mármol seleccionados; una colección compuesta de baldosas con texturas de los mármoles más prestigiosos. La uniformidad de los colores, la estabilidad dimensional y la elevada resistencia a la abrasión, a los golpes y a las flexiones hacen que la colección AGGLOSIMPLEX sea la elección ideal tanto para uso doméstico como para la pavimentación de grandes obras.\r\n\r\n&nbsp;\r\n\r\n<strong><em>Marghestone</em></strong>\r\n\r\nMARGHESTONE, el aglomerado a base de granulados de mármol y de especiales resinas de poliéster, a pesar de su sencillez, valoriza el aspecto minimalista de los edificios de alto prestigio. La elección cromática de tonalidades neutras refinadas, desde el Bianco Ghiaccio hasta el Grigio Piave, o que se esfuman en las tonalidades de beige, desde el Toscana hasta el Golden Beige, enriquecidos por el Bianco Mandorla y el Crema, permite crear entornos elegantes y luminosos.", "Novedades", "PVC Tecnocom ha lanzado al mercado un nuevo sistema de apertura.", "inherit", "open", "open", "", "401-revision-11", "", "", "2012-05-24 16:14:38", "2012-05-24 20:14:38", "", "401", "http://santamargherita.s-m.cl/401-revision-11/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("747", "1", "2012-04-26 09:49:53", "2012-04-26 13:49:53", "<h4><a href=\"http://s-m.cl/wp-content/uploads/2012/03/proyectos.jpg\"><img class=\"alignnone size-full wp-image-638\" title=\"proyectos\" src=\"http://s-m.cl/wp-content/uploads/2012/03/proyectos.jpg\" alt=\"Proyectos destacados\" width=\"576\" height=\"200\" /></a></h4>\r\n&nbsp;\r\n<h4>Explora</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora1.jpg\"><img class=\"alignnone  wp-image-512\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora2.jpg\"><img class=\"alignnone  wp-image-513\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora3.jpg\"><img class=\"alignnone  wp-image-514\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora4.jpg\"><img class=\"alignnone  wp-image-515\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/explora5.jpg\"><img class=\"alignnone  wp-image-516\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/explora5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Los Bravos</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos1.jpg\"><img class=\"alignnone  wp-image-523\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos2.jpg\"><img class=\"alignnone  wp-image-526\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos3.jpg\"><img class=\"alignnone  wp-image-524\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos4.jpg\"><img class=\"alignnone  wp-image-525\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/bravos5.jpg\"><img class=\"alignnone  wp-image-527\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/bravos5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Los Candiles</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles1.jpeg\"><img class=\"alignnone  wp-image-529\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles1-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles2.jpeg\"><img class=\"alignnone  wp-image-533\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles3.jpeg\"><img class=\"alignnone  wp-image-530\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles4.jpeg\"><img class=\"alignnone  wp-image-531\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/candiles5.jpeg\"><img class=\"alignnone  wp-image-534\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/candiles5-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Hotel Zapallar</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5194.jpg\"><img class=\"alignnone  wp-image-536\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5194-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5195.jpg\"><img class=\"alignnone  wp-image-537\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5195-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5197.jpg\"><img class=\"alignnone  wp-image-549\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5197-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5200.jpg\"><img class=\"alignnone  wp-image-550\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5200-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5201.jpg\"><img class=\"alignnone  wp-image-551\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5201-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5204.jpg\"><img class=\"alignnone  wp-image-552\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5204-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5206.jpg\"><img class=\"alignnone  wp-image-553\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5206-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5209.jpg\"><img class=\"alignnone  wp-image-554\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/IMG_5209-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>\r\n<h4>Casa Vichuquen</h4>\r\n<a href=\"http://s-m.cl/wp-content/uploads/2012/03/comedor.jpg\"><img class=\"alignnone  wp-image-539\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/comedor-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Living.jpg\"><img class=\"alignnone  wp-image-540\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Living-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/pasillo-interior.jpg\"><img class=\"alignnone  wp-image-541\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/pasillo-interior-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta-2.jpg\"><img class=\"alignnone  wp-image-542\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta-2-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta.jpg\"><img class=\"alignnone  wp-image-543\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Puerta-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-3.jpg\"><img class=\"alignnone  wp-image-544\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-3-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-4.jpg\"><img class=\"alignnone  wp-image-545\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-4-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>  <a href=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza.jpg\"><img class=\"alignnone  wp-image-546\" title=\"\" src=\"http://s-m.cl/wp-content/uploads/2012/03/Terraza-116x116.jpg\" alt=\"\" width=\"104\" height=\"104\" /></a>", "Proyectos destacados", "Proyectos destacados realizados por nuestra empresa.", "inherit", "open", "open", "", "398-revision-16", "", "", "2012-04-26 09:49:53", "2012-04-26 13:49:53", "", "398", "http://santamargherita.s-m.cl/398-revision-16/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("772", "1", "2012-05-28 12:26:52", "2012-05-28 16:26:52", "", "Apulia", "Apulia", "inherit", "open", "open", "", "apulia-b", "", "", "2012-05-28 12:26:52", "2012-05-28 16:26:52", "", "379", "http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Apulia-b.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("773", "1", "2012-05-28 12:27:41", "2012-05-28 16:27:41", "", "Atena", "Atena", "inherit", "open", "open", "", "atena-b", "", "", "2012-05-28 12:27:41", "2012-05-28 16:27:41", "", "379", "http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Atena-b.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("774", "1", "2012-05-28 12:25:25", "2012-05-28 16:25:25", "<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/colores.jpg\"><img class=\"alignnone size-full wp-image-734\" title=\"Colores\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/colores.jpg\" alt=\"\" width=\"576\" height=\"200\" /></a>\r\n\r\nEl aglomerado SANTAMARGHERITA , a base de arenas de cuarzo y resina, es un producto de elevadas características estéticas con una alta resistencia a la flexión, a la abrasión y a los ácidos. Innovador y con altas prestaciones técnicas es un material que se presenta de manera muy homogénea y uniforme, además de ser particularmente versátil en lo que se refiere a la coloración.<em></em>\r\n\r\nLa amplia gama de colores y granulometrías y una tecnología de vanguardia se presentan bajo forma de superficies con varias posibilidades de uso, los colores neutros y las tonalidades más fuertes permiten combinaciones personales e inéditas.\r\n\r\n<span style=\"color: #339966;\">Fotos de los colores están en el CD hay que separarlos por línea:</span>\r\n\r\n<span style=\"color: #339966;\">-Trafficstone</span>\r\n\r\n[caption id=\"attachment_767\" align=\"alignleft\" width=\"116\" caption=\"Amalfi\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Amalfi-b.jpg\"><img class=\"size-thumbnail wp-image-767 \" title=\"Amalfi\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Amalfi-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_768\" align=\"alignleft\" width=\"116\" caption=\"Antracite\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Antracite-b.jpg\"><img class=\"size-thumbnail wp-image-768\" title=\"Antracite\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Antracite-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_770\" align=\"alignleft\" width=\"116\" caption=\"Aosta\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Aosta-b.jpg\"><img class=\"size-thumbnail wp-image-770\" title=\"Aosta\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Aosta-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n<span style=\"color: #339966;\">-Stardust</span>\r\n\r\n<span style=\"color: #339966;\">-Reff</span>\r\n\r\n&nbsp;", "Colores", "Amplia gama de colores y granulometrías.", "inherit", "open", "open", "", "379-revision-v1", "", "", "2012-05-28 12:25:25", "2012-05-28 16:25:25", "", "379", "http://santamargherita.s-m.cl/379-revision-12/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("775", "1", "2012-05-28 12:34:33", "2012-05-28 16:34:33", "", "Auby", "Auby", "inherit", "open", "open", "", "auby-b", "", "", "2012-05-28 12:34:33", "2012-05-28 16:34:33", "", "379", "http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Auby-b.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("776", "1", "2012-05-28 12:36:57", "2012-05-28 16:36:57", "", "Belvedere", "Belvedere", "inherit", "open", "open", "", "belvedere-b", "", "", "2012-05-28 12:36:57", "2012-05-28 16:36:57", "", "379", "http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Belvedere-b.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("804", "1", "2012-05-28 15:39:26", "2012-05-28 19:39:26", "", "Breda", "Breda", "inherit", "open", "open", "", "breda-b", "", "", "2012-05-28 15:39:26", "2012-05-28 19:39:26", "", "379", "http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Breda-b.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("777", "1", "2012-05-28 12:31:44", "2012-05-28 16:31:44", "<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/colores.jpg\"><img class=\"alignnone size-full wp-image-734\" title=\"Colores\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/colores.jpg\" alt=\"\" width=\"576\" height=\"200\" /></a>\r\n\r\nEl aglomerado SANTAMARGHERITA , a base de arenas de cuarzo y resina, es un producto de elevadas características estéticas con una alta resistencia a la flexión, a la abrasión y a los ácidos. Innovador y con altas prestaciones técnicas es un material que se presenta de manera muy homogénea y uniforme, además de ser particularmente versátil en lo que se refiere a la coloración.<em></em>\r\n\r\nLa amplia gama de colores y granulometrías y una tecnología de vanguardia se presentan bajo forma de superficies con varias posibilidades de uso, los colores neutros y las tonalidades más fuertes permiten combinaciones personales e inéditas.\r\n\r\n<span style=\"color: #339966;\">Fotos de los colores están en el CD hay que separarlos por línea:</span>\r\n\r\n<span style=\"color: #339966;\">-Trafficstone</span>\r\n\r\n[caption id=\"attachment_767\" align=\"alignleft\" width=\"116\" caption=\"Amalfi\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Amalfi-b.jpg\"><img class=\"size-thumbnail wp-image-767 \" title=\"Amalfi\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Amalfi-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_768\" align=\"alignleft\" width=\"116\" caption=\"Antracite\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Antracite-b.jpg\"><img class=\"size-thumbnail wp-image-768\" title=\"Antracite\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Antracite-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_770\" align=\"alignleft\" width=\"116\" caption=\"Aosta\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Aosta-b.jpg\"><img class=\"size-thumbnail wp-image-770\" title=\"Aosta\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Aosta-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_772\" align=\"alignleft\" width=\"116\" caption=\"Apulia\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Apulia-b.jpg\"><img class=\"size-thumbnail wp-image-772\" title=\"Apulia\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Apulia-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_773\" align=\"alignleft\" width=\"116\" caption=\"Atena\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Atena-b.jpg\"><img class=\"size-thumbnail wp-image-773\" title=\"Atena\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Atena-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n&nbsp;\r\n\r\n<span style=\"color: #339966;\">-Stardust</span>\r\n\r\n<span style=\"color: #339966;\">-Reff</span>\r\n\r\n&nbsp;", "Colores", "Amplia gama de colores y granulometrías.", "inherit", "open", "open", "", "379-revision-v1", "", "", "2012-05-28 12:31:44", "2012-05-28 16:31:44", "", "379", "http://santamargherita.s-m.cl/379-revision-13/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("778", "1", "2012-05-28 12:38:10", "2012-05-28 16:38:10", "<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/colores.jpg\"><img class=\"alignnone size-full wp-image-734\" title=\"Colores\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/colores.jpg\" alt=\"\" width=\"576\" height=\"200\" /></a>\r\n\r\nEl aglomerado SANTAMARGHERITA , a base de arenas de cuarzo y resina, es un producto de elevadas características estéticas con una alta resistencia a la flexión, a la abrasión y a los ácidos. Innovador y con altas prestaciones técnicas es un material que se presenta de manera muy homogénea y uniforme, además de ser particularmente versátil en lo que se refiere a la coloración.<em></em>\r\n\r\nLa amplia gama de colores y granulometrías y una tecnología de vanguardia se presentan bajo forma de superficies con varias posibilidades de uso, los colores neutros y las tonalidades más fuertes permiten combinaciones personales e inéditas.\r\n\r\n<strong>Líneas:</strong>\r\n\r\nTrafficstone\r\n\r\n[caption id=\"attachment_767\" align=\"alignleft\" width=\"116\" caption=\"Amalfi\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Amalfi-b.jpg\"><img class=\"size-thumbnail wp-image-767 \" title=\"Amalfi\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Amalfi-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_768\" align=\"alignleft\" width=\"116\" caption=\"Antracite\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Antracite-b.jpg\"><img class=\"size-thumbnail wp-image-768\" title=\"Antracite\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Antracite-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_770\" align=\"alignleft\" width=\"116\" caption=\"Aosta\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Aosta-b.jpg\"><img class=\"size-thumbnail wp-image-770\" title=\"Aosta\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Aosta-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_772\" align=\"alignleft\" width=\"116\" caption=\"Apulia\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Apulia-b.jpg\"><img class=\"size-thumbnail wp-image-772\" title=\"Apulia\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Apulia-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_773\" align=\"alignleft\" width=\"116\" caption=\"Atena\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Atena-b.jpg\"><img class=\"size-thumbnail wp-image-773\" title=\"Atena\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Atena-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_775\" align=\"alignleft\" width=\"116\" caption=\"Auby\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Auby-b.jpg\"><img class=\"size-thumbnail wp-image-775\" title=\"Auby\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Auby-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_776\" align=\"alignleft\" width=\"116\" caption=\"Belvedere\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Belvedere-b.jpg\"><img class=\"size-thumbnail wp-image-776\" title=\"Belvedere-b\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Belvedere-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]", "Colores", "Amplia gama de colores y granulometrías.", "inherit", "open", "open", "", "379-revision-v1", "", "", "2012-05-28 12:38:10", "2012-05-28 16:38:10", "", "379", "http://santamargherita.s-m.cl/379-revision-14/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("796", "1", "2012-05-28 15:18:49", "2012-05-28 19:18:49", "", "Aplicaciones Baño", "", "inherit", "open", "open", "", "aplicaciones2", "", "", "2012-05-28 15:18:49", "2012-05-28 19:18:49", "", "386", "http://santamargherita.s-m.cl/wp-content/uploads/2012/03/aplicaciones2.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("781", "1", "2012-05-28 13:13:22", "2012-05-28 17:13:22", "<img class=\"alignnone size-full wp-image-779\" title=\"Ventajas\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/ventajas2.jpg\" alt=\"\" width=\"800\" height=\"328\" />\r\n\r\nSu composición de un 93% de piedras naturales y un 7% de resina poliéster otorgan al material diferentes características que lo llevan a posicionarse como un material muy superior a las piedras naturales con altas prestaciones técnicas, las más importantes son:\r\n<ul>\r\n	<li>Resistente al rayado.</li>\r\n	<li>Resistente al impacto</li>\r\n	<li>Resistente a los acidos</li>\r\n	<li>Resistente a las manchas</li>\r\n	<li>Resistente a la formación de bacterias</li>\r\n	<li>Resistente al calor.</li>\r\n</ul>", "Ventajas", "Su composición lo hace ser un material muy superior a las piedras naturales.", "inherit", "open", "open", "", "404-revision-5", "", "", "2012-05-28 13:13:22", "2012-05-28 17:13:22", "", "404", "http://santamargherita.s-m.cl/404-revision-5/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("914", "1", "2012-06-06 12:32:48", "2012-06-06 16:32:48", "", "Proyectos destacados", "", "inherit", "open", "open", "", "neroa", "", "", "2012-06-06 12:32:48", "2012-06-06 16:32:48", "", "404", "http://santamargherita.s-m.cl/wp-content/uploads/2012/03/neroa.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("782", "1", "2012-05-28 13:14:15", "2012-05-28 17:14:15", "<img class=\"alignnone size-full wp-image-779\" title=\"Ventajas\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/ventajas2.jpg\" alt=\"\" width=\"800\" height=\"328\" />\r\n\r\n<strong>VENTAJAS</strong>\r\n\r\n&nbsp;\r\n\r\nSu composición de un 93% de piedras naturales y un 7% de resina poliéster otorgan al material diferentes características que lo llevan a posicionarse como un material muy superior a las piedras naturales con altas prestaciones técnicas, las más importantes son:\r\n<ul>\r\n	<li>Resistente al rayado.</li>\r\n	<li>Resistente al impacto</li>\r\n	<li>Resistente a los acidos</li>\r\n	<li>Resistente a las manchas</li>\r\n	<li>Resistente a la formación de bacterias</li>\r\n	<li>Resistente al calor.</li>\r\n</ul>", "Ventajas", "Su composición lo hace ser un material muy superior a las piedras naturales.", "inherit", "open", "open", "", "404-revision-6", "", "", "2012-05-28 13:14:15", "2012-05-28 17:14:15", "", "404", "http://santamargherita.s-m.cl/404-revision-6/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("784", "1", "2012-05-28 13:23:44", "2012-05-28 17:23:44", "", "Ventajas", "", "inherit", "open", "open", "", "ventajas3", "", "", "2012-05-28 13:23:44", "2012-05-28 17:23:44", "", "404", "http://santamargherita.s-m.cl/wp-content/uploads/2012/03/ventajas3.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("783", "1", "2012-05-28 13:20:01", "2012-05-28 17:20:01", "<img class=\"alignnone size-full wp-image-779\" title=\"Ventajas\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/ventajas2.jpg\" alt=\"\" width=\"800\" height=\"328\" />\r\n<h2><strong>VENTAJAS</strong></h2>\r\n&nbsp;\r\n\r\nSu composición de un 93% de piedras naturales y un 7% de resina poliéster otorgan al material diferentes características que lo llevan a posicionarse como un material muy superior a las piedras naturales con altas prestaciones técnicas, las más importantes son:\r\n<ul>\r\n	<li>Resistente al rayado.</li>\r\n	<li>Resistente al impacto</li>\r\n	<li>Resistente a los acidos</li>\r\n	<li>Resistente a las manchas</li>\r\n	<li>Resistente a la formación de bacterias</li>\r\n	<li>Resistente al calor.</li>\r\n</ul>", "Ventajas", "Su composición lo hace ser un material muy superior a las piedras naturales.", "inherit", "open", "open", "", "404-revision-7", "", "", "2012-05-28 13:20:01", "2012-05-28 17:20:01", "", "404", "http://santamargherita.s-m.cl/404-revision-7/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("785", "1", "2012-05-28 13:22:29", "2012-05-28 17:22:29", "<img class=\"alignnone size-full wp-image-779\" title=\"Ventajas\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/ventajas2.jpg\" alt=\"\" width=\"800\" height=\"328\" />\r\n<h3><strong>VENTAJAS</strong></h3>\r\nSu composición de un 93% de piedras naturales y un 7% de resina poliéster otorgan al material diferentes características que lo llevan a posicionarse como un material muy superior a las piedras naturales con altas prestaciones técnicas, las más importantes son:\r\n<ul>\r\n	<li>Resistente al rayado.</li>\r\n	<li>Resistente al impacto</li>\r\n	<li>Resistente a los acidos</li>\r\n	<li>Resistente a las manchas</li>\r\n	<li>Resistente a la formación de bacterias</li>\r\n	<li>Resistente al calor.</li>\r\n</ul>", "Ventajas", "Su composición lo hace ser un material muy superior a las piedras naturales.", "inherit", "open", "open", "", "404-revision-8", "", "", "2012-05-28 13:22:29", "2012-05-28 17:22:29", "", "404", "http://santamargherita.s-m.cl/404-revision-8/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("791", "1", "2012-05-24 16:10:48", "2012-05-24 20:10:48", "<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/destacados.jpg\"><img class=\"alignnone size-full wp-image-746\" title=\"Proyectos Destacados\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/destacados.jpg\" alt=\"\" width=\"576\" height=\"200\" /></a>", "Proyectos destacados", "Proyectos destacados realizados por nuestra empresa.", "inherit", "open", "open", "", "398-revision-17", "", "", "2012-05-24 16:10:48", "2012-05-24 20:10:48", "", "398", "http://santamargherita.s-m.cl/398-revision-17/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("787", "1", "2012-05-24 16:23:50", "2012-05-24 20:23:50", "<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/novedades.jpg\"><img class=\"alignnone size-full wp-image-748\" title=\"Novedades\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/novedades.jpg\" alt=\"\" width=\"576\" height=\"200\" /></a>\r\n\r\nSANTAMARGHERITA además de los tradicionales efectos brillante, pulido, cepillado y envejecido, añade a sus colecciones de aglomerado de base de cuarzo, acabados nuevos y originales, que son fruto de una investigación a fondo y de un diseño sofisticado. La posibilidad de combinarlos y mezclarlos libremente permite obtener ambientes donde las superficies asumen la características de suavidad y movimiento.\r\n\r\nAdemás de la línea Trafficstone contamos con otras líneas de productos que se trabajan actualmente en Chile a pedido:\r\n\r\n&nbsp;\r\n\r\n<strong><em>Agglosimplex</em></strong>\r\n\r\nAglomerado a base de fragmentos de mármol seleccionados; una colección compuesta de baldosas con texturas de los mármoles más prestigiosos. La uniformidad de los colores, la estabilidad dimensional y la elevada resistencia a la abrasión, a los golpes y a las flexiones hacen que la colección AGGLOSIMPLEX sea la elección ideal tanto para uso doméstico como para la pavimentación de grandes obras.\r\n\r\n&nbsp;\r\n\r\n<strong><em>Marghestone</em></strong>\r\n\r\nMARGHESTONE, el aglomerado a base de granulados de mármol y de especiales resinas de poliéster, a pesar de su sencillez, valoriza el aspecto minimalista de los edificios de alto prestigio. La elección cromática de tonalidades neutras refinadas, desde el Bianco Ghiaccio hasta el Grigio Piave, o que se esfuman en las tonalidades de beige, desde el Toscana hasta el Golden Beige, enriquecidos por el Bianco Mandorla y el Crema, permite crear entornos elegantes y luminosos.", "Novedades", "Nuevos y originales acabados, fruto de una investigación a fondo y un diseño sofisticado.", "inherit", "open", "open", "", "401-revision-13", "", "", "2012-05-24 16:23:50", "2012-05-24 20:23:50", "", "401", "http://santamargherita.s-m.cl/401-revision-13/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("789", "1", "2012-05-28 15:05:41", "2012-05-28 19:05:41", "<img class=\"alignnone size-full wp-image-786\" title=\"Novedades\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/novedades2.jpg\" alt=\"\" width=\"810\" height=\"328\" />\r\n<h3>NOVEDADES</h3>\r\nSANTAMARGHERITA además de los tradicionales efectos brillante, pulido, cepillado y envejecido, añade a sus colecciones de aglomerado de base de cuarzo, acabados nuevos y originales, que son fruto de una investigación a fondo y de un diseño sofisticado. La posibilidad de combinarlos y mezclarlos libremente permite obtener ambientes donde las superficies asumen la características de suavidad y movimiento.\r\n\r\nAdemás de la línea Trafficstone contamos con otras líneas de productos que se trabajan actualmente en Chile a pedido:\r\n\r\n&nbsp;\r\n\r\n<strong><em>Agglosimplex</em></strong>\r\n\r\nAglomerado a base de fragmentos de mármol seleccionados; una colección compuesta de baldosas con texturas de los mármoles más prestigiosos. La uniformidad de los colores, la estabilidad dimensional y la elevada resistencia a la abrasión, a los golpes y a las flexiones hacen que la colección AGGLOSIMPLEX sea la elección ideal tanto para uso doméstico como para la pavimentación de grandes obras.\r\n\r\n&nbsp;\r\n\r\n<strong><em>Marghestone</em></strong>\r\n\r\nMARGHESTONE, el aglomerado a base de granulados de mármol y de especiales resinas de poliéster, a pesar de su sencillez, valoriza el aspecto minimalista de los edificios de alto prestigio. La elección cromática de tonalidades neutras refinadas, desde el Bianco Ghiaccio hasta el Grigio Piave, o que se esfuman en las tonalidades de beige, desde el Toscana hasta el Golden Beige, enriquecidos por el Bianco Mandorla y el Crema, permite crear entornos elegantes y luminosos.", "Novedades", "Nuevos y originales acabados, fruto de una investigación a fondo y un diseño sofisticado.", "inherit", "open", "open", "", "401-revision-14", "", "", "2012-05-28 15:05:41", "2012-05-28 19:05:41", "", "401", "http://santamargherita.s-m.cl/401-revision-14/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("793", "1", "2012-05-24 15:27:43", "2012-05-24 19:27:43", "<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/garantia.jpg\"><img class=\"alignnone size-full wp-image-732\" title=\"Garantía &amp; Calidad\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/garantia.jpg\" alt=\"\" width=\"576\" height=\"200\" /></a>\r\n\r\nSANTAMARGHERITA encierra sus valores en una única expresión\r\n“THE ORIGINAL ITALIAN SURFACE”.\r\n\r\nTHE ORIGINAL - La investigación constante, tanto tecnológica como estilística permite, desde hace más de cuarenta años, presentar al mercado un producto original en una gama de colores y acabados exclusivos.\r\n\r\nITALIAN – Garantía de calidad y fiabilidad, asistencia constante y competencia son sólo algunas de las características principales que hacen que los productos “Made in Italy” sean los primeros en el mundo por lo que respecta a diseño y arquitectura. SANTAMARGHERITA mantiene estos valores y los traduce en productos únicos e inimitables.\r\n\r\nSURFACE - Superﬁcies con base de mármol y de cuarzo, en esto se basa actualmente el know how de una empresa que no se detiene y mira hacia el futuro para desarrollarse cada vez más con la finalidad de brindar al cliente las más variadas posibilidades para revestir y decorar espacios habitacionales y grandes obras.", "Garantía &amp; calidad", "Santamargherita encierra sus valores en una única expresión “The original italian surface”.", "inherit", "open", "open", "", "372-revision-13", "", "", "2012-05-24 15:27:43", "2012-05-24 19:27:43", "", "372", "http://santamargherita.s-m.cl/372-revision-13/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("795", "1", "2012-05-28 12:43:42", "2012-05-28 16:43:42", "<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/colores.jpg\"><img class=\"alignnone size-full wp-image-734\" title=\"Colores\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/colores.jpg\" alt=\"\" width=\"576\" height=\"200\" /></a>\r\n\r\nEl aglomerado SANTAMARGHERITA , a base de arenas de cuarzo y resina, es un producto de elevadas características estéticas con una alta resistencia a la flexión, a la abrasión y a los ácidos. Innovador y con altas prestaciones técnicas es un material que se presenta de manera muy homogénea y uniforme, además de ser particularmente versátil en lo que se refiere a la coloración.<em></em>\r\n\r\nLa amplia gama de colores y granulometrías y una tecnología de vanguardia se presentan bajo forma de superficies con varias posibilidades de uso, los colores neutros y las tonalidades más fuertes permiten combinaciones personales e inéditas.\r\n\r\n<strong>Líneas:</strong>\r\n\r\nTrafficstone\r\n\r\n[caption id=\"attachment_767\" align=\"alignleft\" width=\"116\" caption=\"Amalfi\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Amalfi-b.jpg\"><img class=\"size-thumbnail wp-image-767 \" title=\"Amalfi\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Amalfi-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_768\" align=\"alignleft\" width=\"116\" caption=\"Antracite\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Antracite-b.jpg\"><img class=\"size-thumbnail wp-image-768\" title=\"Antracite\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Antracite-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_770\" align=\"alignleft\" width=\"116\" caption=\"Aosta\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Aosta-b.jpg\"><img class=\"size-thumbnail wp-image-770\" title=\"Aosta\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Aosta-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_772\" align=\"alignleft\" width=\"116\" caption=\"Apulia\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Apulia-b.jpg\"><img class=\"size-thumbnail wp-image-772\" title=\"Apulia\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Apulia-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_773\" align=\"alignleft\" width=\"116\" caption=\"Atena\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Atena-b.jpg\"><img class=\"size-thumbnail wp-image-773\" title=\"Atena\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Atena-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_775\" align=\"alignleft\" width=\"116\" caption=\"Auby\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Auby-b.jpg\"><img class=\"size-thumbnail wp-image-775\" title=\"Auby\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Auby-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_776\" align=\"alignleft\" width=\"116\" caption=\"Belvedere\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Belvedere-b.jpg\"><img class=\"size-thumbnail wp-image-776\" title=\"Belvedere-b\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Belvedere-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n", "Colores", "Amplia gama de colores y granulometrías.", "inherit", "open", "open", "", "379-revision-v1", "", "", "2012-05-28 12:43:42", "2012-05-28 16:43:42", "", "379", "http://santamargherita.s-m.cl/379-revision-15/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("797", "1", "2012-05-28 11:45:13", "2012-05-28 15:45:13", "<a name=\"bano\"></a><a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/aplicaciones.jpg\"><img class=\"alignnone size-full wp-image-738\" title=\"Aplicaciones\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/aplicaciones.jpg\" alt=\"\" width=\"576\" height=\"200\" /></a>\r\n\r\n<strong><em>Aglomerado de Cuarzo para encimeras de Cocina y Baño</em></strong>\r\n\r\nCada casa refleja la personalidad de quienes viven en ella. Caracteres, gustos y estilos que pueden llegar a ser infinitos, opuestos entre ellos; desde el neoclásico hasta el barroco, desde la ostentación hasta el minimalismo, con el uso de una paleta de colores desde las tonalidades más claras hasta las más fuertes.<strong><em></em></strong>\r\n\r\nSANTAMARGHERITA, a través de una investigación constante, crea superficies con altas prestaciones técnicas y que son estéticamente capaces de hacer que los ambientes domésticos sean únicos satisfaciendo perfectamente las diferentes exigencias.\r\n\r\nEl material ideal para pavimentos y revestimientos, cabinas de ducha y encimeras de cocina y baño se caracteriza, por un lado, por la alta resistencia a la flexión, abrasión y ácidos, y por el otro, por la variedad de colores y texturas más neutras o con mayor profundidad y efectos de movimiento.\r\n\r\nActualmente en el diseño de interiores está marcado el uso de tamaño cada vez más grandes y personalizados, por tanto las colecciones de aglomerado con base de cuarzo SANTAMARGHERITA se proponen en baldosas de dimensiones estándares o variables. Para cada proyecto, para cada exigencia, para cada gusto, SANTAMARGHERITA dispone de la superficie ideal.\r\n\r\n&nbsp;\r\n\r\n<a name=\"aeropuerto\"></a><a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/aeropuerto.jpg\"><img class=\"alignnone size-full wp-image-742\" title=\"Aeropuerto\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/aeropuerto.jpg\" alt=\"\" width=\"576\" height=\"200\" /></a>\r\n\r\n<strong><em>Aglomerado de Cuarzo para superficies de grandes obras</em></strong>\r\n\r\nAeropuertos, estaciones de trenes, centros comerciales, grandes superficies en todo el mundo ostentan actualmente pavimentos y revestimientos con la marca SANTAMARGHERITA. Las potencialidades del aglomerado de cuarzo permiten que SANTAMARGHERITA responda a las exigencias en lo que se refiere a complejidad y personalidad de cada proyecto, a partir del suministro de grandes volúmenes hasta un servicio de investigación y desarrollo de nuevos colores personalizados que dan originalidad y unicidad al producto.\r\n\r\n&nbsp;", "Aplicaciones", "Cada casa refleja la personalidad de quienes viven en ella.", "inherit", "open", "open", "", "386-revision-8", "", "", "2012-05-28 11:45:13", "2012-05-28 15:45:13", "", "386", "http://santamargherita.s-m.cl/386-revision-8/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("800", "1", "2012-05-24 16:30:15", "2012-05-24 20:30:15", "<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/mantenimiento.jpg\"><img class=\"alignnone size-full wp-image-754\" title=\"Mantenimiento\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/mantenimiento.jpg\" alt=\"\" width=\"576\" height=\"200\" /></a>\r\n\r\nLa composición especial, 93% de minerales naturales y 7% de resina de poliéster y pigmentos colorados, da al producto las variaciones de color, medida, forma o distribución de la gravilla de cuarzo y un color de fondo que hacen que sea exclusivo y único, manteniendo inalteradas las características técnicas. Las superficies no necesitan ser tratadas con ceras y, con la finalidad de mantener el estado de limpieza adecuado, se recomienda utilizar productos detergentes con base de alcohol y pH neutro, como por ejemplo productos para la limpieza de superficies de mármol (advertencia: no deben contener ceras).\r\n\r\nNo utilizar productos detergentes demasiado agresivos (pH muy alto o muy bajo). Se recomienda encarecidamente usar soportes para ollas o similares para evitar el contacto directo entre las superficies SANTAMARGHERITA y las fuentes de calor (ollas, paellas o platos quitandose del fuego). Para las encimeras con inserciones de nácar es necesario utilizar un producto detergente neutro de uso doméstico.\r\n\r\nSUSTANCIAS QUÍMICAS Y DISOLVENTES – Debe evitarse en lo posible el contacto entre las superficies y las sustancias químicas y disolventes, como por ejemplo amoniaco puro o productos detergentes a base de amoniaco, disolventes para uñas, blanqueantes, pinceles con tinta indeleble, jabones aceitosos, disolventes en general (especialmente los disolventes para las pinturas que contienen tricloroetileno y cloruro de metileno), etc.\r\n\r\nEn caso de contacto entre las sustancias antes indicadas y las superficies SANTAMARGHERITA aclarar abundantemente de inmediato.", "Mantenimiento", "Condiciones de mantenimiento.", "inherit", "open", "open", "", "407-revision-9", "", "", "2012-05-24 16:30:15", "2012-05-24 20:30:15", "", "407", "http://santamargherita.s-m.cl/407-revision-9/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("802", "1", "2012-05-28 11:51:38", "2012-05-28 15:51:38", "<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/certificaciones.jpg\"><img class=\"alignnone size-full wp-image-736\" title=\"Certificaciones\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/certificaciones.jpg\" alt=\"\" width=\"576\" height=\"200\" /></a>\r\n\r\nLos objetivos principales de SANTAMARGHERITA son la calidad y seguridad de sus productos. Nuestro laboratorio de Investigación y Desarrollo pone siempre toda su atención en la realización de aglomerados capaces de hacer frente, por un lado a los criterios establecidos en relación con las emisiones de materiales para la decoración de interiores, para grandes espacios y para la industria de la construcción, y por otro lado, a los relacionados con el proyecto y realización de edificios energéticamente eficientes y con bajo impacto ambiental.\r\nGracias a esta atención y a la colaboración con institutos prestigiosos a nivel internacional, los productos SANTAMARGHERITA han obtenido las importantes certiﬁcaciones NSF y GREENGUARD. Además, gracias a la cooperación con el Green Building Council Italia, del cual SANTAMARGHERITA es Miembro Ordinario, y con el Distretto Tecnologico Trentino, la empresa ha elaborado su propio “Protocolo LEED” según las normas del United States Green Building Council - USGBC (Consejo de la Construcción Ecológica de Estados Unidos).", "Certificaciones", "Los productos Santamargherita han obtenido importantes certiﬁcaciones, como NSF y GREENGUARD.", "inherit", "open", "open", "", "383-revision-7", "", "", "2012-05-28 11:51:38", "2012-05-28 15:51:38", "", "383", "http://santamargherita.s-m.cl/383-revision-7/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("806", "1", "2012-05-28 15:39:31", "2012-05-28 19:39:31", "", "Camargue", "Camargue", "inherit", "open", "open", "", "camargue-b", "", "", "2012-05-28 15:39:31", "2012-05-28 19:39:31", "", "379", "http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Camargue-b.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("807", "1", "2012-05-28 15:39:59", "2012-05-28 19:39:59", "", "Carnia", "Carnia", "inherit", "open", "open", "", "carnia-b", "", "", "2012-05-28 15:39:59", "2012-05-28 19:39:59", "", "379", "http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Carnia-b.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("808", "1", "2012-05-28 15:40:02", "2012-05-28 19:40:02", "", "Catalina", "Catalina", "inherit", "open", "open", "", "catalina-b", "", "", "2012-05-28 15:40:02", "2012-05-28 19:40:02", "", "379", "http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Catalina-b.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("809", "1", "2012-05-28 15:40:05", "2012-05-28 19:40:05", "", "Friuli", "Friuli", "inherit", "open", "open", "", "friuli-b", "", "", "2012-05-28 15:40:05", "2012-05-28 19:40:05", "", "379", "http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Friuli-b.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("810", "1", "2012-05-28 15:16:54", "2012-05-28 19:16:54", "<img class=\"alignnone size-full wp-image-794\" title=\"Colores\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/colores2.jpg\" alt=\"\" width=\"810\" height=\"328\" />\r\n<h3>COLORES</h3>\r\nEl aglomerado SANTAMARGHERITA , a base de arenas de cuarzo y resina, es un producto de elevadas características estéticas con una alta resistencia a la flexión, a la abrasión y a los ácidos. Innovador y con altas prestaciones técnicas es un material que se presenta de manera muy homogénea y uniforme, además de ser particularmente versátil en lo que se refiere a la coloración.<em></em>\r\n\r\nLa amplia gama de colores y granulometrías y una tecnología de vanguardia se presentan bajo forma de superficies con varias posibilidades de uso, los colores neutros y las tonalidades más fuertes permiten combinaciones personales e inéditas.\r\n\r\n<strong>Líneas:</strong>\r\n\r\nTrafficstone\r\n\r\n[caption id=\"attachment_767\" align=\"alignleft\" width=\"116\" caption=\"Amalfi\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Amalfi-b.jpg\"><img class=\"size-thumbnail wp-image-767 \" title=\"Amalfi\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Amalfi-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_768\" align=\"alignleft\" width=\"116\" caption=\"Antracite\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Antracite-b.jpg\"><img class=\"size-thumbnail wp-image-768\" title=\"Antracite\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Antracite-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_770\" align=\"alignleft\" width=\"116\" caption=\"Aosta\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Aosta-b.jpg\"><img class=\"size-thumbnail wp-image-770\" title=\"Aosta\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Aosta-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_772\" align=\"alignleft\" width=\"116\" caption=\"Apulia\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Apulia-b.jpg\"><img class=\"size-thumbnail wp-image-772\" title=\"Apulia\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Apulia-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_773\" align=\"alignleft\" width=\"116\" caption=\"Atena\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Atena-b.jpg\"><img class=\"size-thumbnail wp-image-773\" title=\"Atena\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Atena-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_775\" align=\"alignleft\" width=\"116\" caption=\"Auby\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Auby-b.jpg\"><img class=\"size-thumbnail wp-image-775\" title=\"Auby\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Auby-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_776\" align=\"alignleft\" width=\"116\" caption=\"Belvedere\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Belvedere-b.jpg\"><img class=\"size-thumbnail wp-image-776\" title=\"Belvedere-b\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Belvedere-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]", "Colores", "Amplia gama de colores y granulometrías.", "inherit", "open", "open", "", "379-revision-v1", "", "", "2012-05-28 15:16:54", "2012-05-28 19:16:54", "", "379", "http://santamargherita.s-m.cl/379-revision-16/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("811", "1", "2012-05-28 15:42:10", "2012-05-28 19:42:10", "<img class=\"alignnone size-full wp-image-794\" title=\"Colores\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/colores2.jpg\" alt=\"\" width=\"810\" height=\"328\" />\r\n<h3>COLORES</h3>\r\nEl aglomerado SANTAMARGHERITA , a base de arenas de cuarzo y resina, es un producto de elevadas características estéticas con una alta resistencia a la flexión, a la abrasión y a los ácidos. Innovador y con altas prestaciones técnicas es un material que se presenta de manera muy homogénea y uniforme, además de ser particularmente versátil en lo que se refiere a la coloración.<em></em>\r\n\r\nLa amplia gama de colores y granulometrías y una tecnología de vanguardia se presentan bajo forma de superficies con varias posibilidades de uso, los colores neutros y las tonalidades más fuertes permiten combinaciones personales e inéditas.\r\n\r\n<strong>Líneas:</strong>\r\n\r\nTrafficstone\r\n\r\n[caption id=\"attachment_767\" align=\"alignleft\" width=\"116\" caption=\"Amalfi\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Amalfi-b.jpg\"><img class=\"size-thumbnail wp-image-767 \" title=\"Amalfi\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Amalfi-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_768\" align=\"alignleft\" width=\"116\" caption=\"Antracite\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Antracite-b.jpg\"><img class=\"size-thumbnail wp-image-768\" title=\"Antracite\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Antracite-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_770\" align=\"alignleft\" width=\"116\" caption=\"Aosta\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Aosta-b.jpg\"><img class=\"size-thumbnail wp-image-770\" title=\"Aosta\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Aosta-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_772\" align=\"alignleft\" width=\"116\" caption=\"Apulia\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Apulia-b.jpg\"><img class=\"size-thumbnail wp-image-772\" title=\"Apulia\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Apulia-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_773\" align=\"alignleft\" width=\"116\" caption=\"Atena\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Atena-b.jpg\"><img class=\"size-thumbnail wp-image-773\" title=\"Atena\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Atena-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_775\" align=\"alignleft\" width=\"116\" caption=\"Auby\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Auby-b.jpg\"><img class=\"size-thumbnail wp-image-775\" title=\"Auby\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Auby-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_776\" align=\"alignleft\" width=\"116\" caption=\"Belvedere\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Belvedere-b.jpg\"><img class=\"size-thumbnail wp-image-776\" title=\"Belvedere-b\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Belvedere-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_804\" align=\"alignleft\" width=\"116\" caption=\"Breda\"]<img class=\"size-thumbnail wp-image-804\" title=\"Breda\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Breda-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" />[/caption]\r\n\r\n[caption id=\"attachment_805\" align=\"alignleft\" width=\"116\" caption=\"Caledonia\"]<img class=\"size-thumbnail wp-image-805\" title=\"Caledonia\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Caledonia-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" />[/caption]\r\n\r\n[caption id=\"attachment_806\" align=\"alignleft\" width=\"116\" caption=\"Camargue\"]<img class=\"size-thumbnail wp-image-806\" title=\"Camargue\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Camargue-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" />[/caption]\r\n\r\n[caption id=\"attachment_807\" align=\"alignleft\" width=\"116\" caption=\"Carnia\"]<img class=\"size-thumbnail wp-image-807\" title=\"Carnia\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Carnia-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" />[/caption]\r\n\r\n[caption id=\"attachment_808\" align=\"alignleft\" width=\"116\" caption=\"Catalina\"]<img class=\"size-thumbnail wp-image-808\" title=\"Catalina\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Catalina-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" />[/caption]\r\n\r\n[caption id=\"attachment_809\" align=\"alignleft\" width=\"116\" caption=\"Friuli\"]<img class=\"size-thumbnail wp-image-809\" title=\"Friuli\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Friuli-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" />[/caption]", "Colores", "Amplia gama de colores y granulometrías.", "inherit", "open", "open", "", "379-revision-v1", "", "", "2012-05-28 15:42:10", "2012-05-28 19:42:10", "", "379", "http://santamargherita.s-m.cl/379-revision-17/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("812", "1", "2012-05-28 15:48:12", "2012-05-28 19:48:12", "", "Hermitage", "Hermitage", "inherit", "open", "open", "", "hermitage-b", "", "", "2012-05-28 15:48:12", "2012-05-28 19:48:12", "", "379", "http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Hermitage-b.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("813", "1", "2012-05-28 15:48:14", "2012-05-28 19:48:14", "", "Istria", "Istria", "inherit", "open", "open", "", "istria-b", "", "", "2012-05-28 15:48:14", "2012-05-28 19:48:14", "", "379", "http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Istria-b.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("814", "1", "2012-05-28 15:48:17", "2012-05-28 19:48:17", "", "Itaca", "Itaca", "inherit", "open", "open", "", "itaca-b", "", "", "2012-05-28 15:48:17", "2012-05-28 19:48:17", "", "379", "http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Itaca-b.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("815", "1", "2012-05-28 15:48:18", "2012-05-28 19:48:18", "", "Miami", "Miami", "inherit", "open", "open", "", "miami-b", "", "", "2012-05-28 15:48:18", "2012-05-28 19:48:18", "", "379", "http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Miami-b.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("816", "1", "2012-05-28 15:48:20", "2012-05-28 19:48:20", "", "Miramare", "Miramare", "inherit", "open", "open", "", "miramare-b", "", "", "2012-05-28 15:48:20", "2012-05-28 19:48:20", "", "379", "http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Miramare-b.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("817", "1", "2012-05-28 15:48:22", "2012-05-28 19:48:22", "", "Modena", "Modena", "inherit", "open", "open", "", "modena-b", "", "", "2012-05-28 15:48:22", "2012-05-28 19:48:22", "", "379", "http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Modena-b.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("818", "1", "2012-05-28 15:48:24", "2012-05-28 19:48:24", "", "Naxos", "Naxos", "inherit", "open", "open", "", "naxos-b", "", "", "2012-05-28 15:48:24", "2012-05-28 19:48:24", "", "379", "http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Naxos-b.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("819", "1", "2012-05-28 15:48:26", "2012-05-28 19:48:26", "", "Nero", "Nero", "inherit", "open", "open", "", "nero-b", "", "", "2012-05-28 15:48:26", "2012-05-28 19:48:26", "", "379", "http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Nero-b.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("820", "1", "2012-05-28 15:48:28", "2012-05-28 19:48:28", "", "Otello", "Otello", "inherit", "open", "open", "", "otello-b", "", "", "2012-05-28 15:48:28", "2012-05-28 19:48:28", "", "379", "http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Otello-b.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("821", "1", "2012-05-28 15:48:30", "2012-05-28 19:48:30", "", "Pompei", "Pompei", "inherit", "open", "open", "", "pompei-b", "", "", "2012-05-28 15:48:30", "2012-05-28 19:48:30", "", "379", "http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Pompei-b.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("822", "1", "2012-05-28 15:48:31", "2012-05-28 19:48:31", "", "Prussia", "Prussia", "inherit", "open", "open", "", "prussia-b", "", "", "2012-05-28 15:48:31", "2012-05-28 19:48:31", "", "379", "http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Prussia-b.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("823", "1", "2012-05-28 15:49:16", "2012-05-28 19:49:16", "", "Rinmini", "Rinmini", "inherit", "open", "open", "", "rinmini-b", "", "", "2012-05-28 15:49:16", "2012-05-28 19:49:16", "", "379", "http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Rinmini-b.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("824", "1", "2012-05-28 15:43:41", "2012-05-28 19:43:41", "<img class=\"alignnone size-full wp-image-794\" title=\"Colores\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/colores2.jpg\" alt=\"\" width=\"810\" height=\"328\" />\r\n<h3>COLORES</h3>\r\nEl aglomerado SANTAMARGHERITA , a base de arenas de cuarzo y resina, es un producto de elevadas características estéticas con una alta resistencia a la flexión, a la abrasión y a los ácidos. Innovador y con altas prestaciones técnicas es un material que se presenta de manera muy homogénea y uniforme, además de ser particularmente versátil en lo que se refiere a la coloración.<em></em>\r\n\r\nLa amplia gama de colores y granulometrías y una tecnología de vanguardia se presentan bajo forma de superficies con varias posibilidades de uso, los colores neutros y las tonalidades más fuertes permiten combinaciones personales e inéditas.\r\n\r\n<strong>Líneas:</strong>\r\n\r\nTrafficstone\r\n\r\n[caption id=\"attachment_767\" align=\"alignleft\" width=\"116\" caption=\"Amalfi\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Amalfi-b.jpg\"><img class=\"size-thumbnail wp-image-767 \" title=\"Amalfi\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Amalfi-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_768\" align=\"alignleft\" width=\"116\" caption=\"Antracite\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Antracite-b.jpg\"><img class=\"size-thumbnail wp-image-768\" title=\"Antracite\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Antracite-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_770\" align=\"alignleft\" width=\"116\" caption=\"Aosta\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Aosta-b.jpg\"><img class=\"size-thumbnail wp-image-770\" title=\"Aosta\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Aosta-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_772\" align=\"alignleft\" width=\"116\" caption=\"Apulia\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Apulia-b.jpg\"><img class=\"size-thumbnail wp-image-772\" title=\"Apulia\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Apulia-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_773\" align=\"alignleft\" width=\"116\" caption=\"Atena\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Atena-b.jpg\"><img class=\"size-thumbnail wp-image-773\" title=\"Atena\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Atena-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_775\" align=\"alignleft\" width=\"116\" caption=\"Auby\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Auby-b.jpg\"><img class=\"size-thumbnail wp-image-775\" title=\"Auby\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Auby-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_776\" align=\"alignleft\" width=\"116\" caption=\"Belvedere\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Belvedere-b.jpg\"><img class=\"size-thumbnail wp-image-776\" title=\"Belvedere-b\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Belvedere-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_804\" align=\"alignleft\" width=\"116\" caption=\"Breda\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Breda-b.jpg\"><img class=\"size-thumbnail wp-image-804 \" title=\"Breda\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Breda-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_805\" align=\"alignleft\" width=\"116\" caption=\"Caledonia\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Caledonia-b.jpg\"><img class=\"size-thumbnail wp-image-805 \" title=\"Caledonia\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Caledonia-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_806\" align=\"alignleft\" width=\"116\" caption=\"Camargue\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Camargue-b.jpg\"><img class=\"size-thumbnail wp-image-806 \" title=\"Camargue\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Camargue-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_807\" align=\"alignleft\" width=\"116\" caption=\"Carnia\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Carnia-b.jpg\"><img class=\"size-thumbnail wp-image-807 \" title=\"Carnia\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Carnia-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_808\" align=\"alignleft\" width=\"116\" caption=\"Catalina\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Catalina-b.jpg\"><img class=\"size-thumbnail wp-image-808 \" title=\"Catalina\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Catalina-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_809\" align=\"alignleft\" width=\"116\" caption=\"Friuli\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Friuli-b.jpg\"><img class=\"size-thumbnail wp-image-809 \" title=\"Friuli\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Friuli-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]", "Colores", "Amplia gama de colores y granulometrías.", "inherit", "open", "open", "", "379-revision-v1", "", "", "2012-05-28 15:43:41", "2012-05-28 19:43:41", "", "379", "http://santamargherita.s-m.cl/379-revision-18/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("825", "1", "2012-05-28 15:52:24", "2012-05-28 19:52:24", "<img class=\"alignnone size-full wp-image-794\" title=\"Colores\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/colores2.jpg\" alt=\"\" width=\"810\" height=\"328\" />\r\n<h3>COLORES</h3>\r\nEl aglomerado SANTAMARGHERITA , a base de arenas de cuarzo y resina, es un producto de elevadas características estéticas con una alta resistencia a la flexión, a la abrasión y a los ácidos. Innovador y con altas prestaciones técnicas es un material que se presenta de manera muy homogénea y uniforme, además de ser particularmente versátil en lo que se refiere a la coloración.<em></em>\r\n\r\nLa amplia gama de colores y granulometrías y una tecnología de vanguardia se presentan bajo forma de superficies con varias posibilidades de uso, los colores neutros y las tonalidades más fuertes permiten combinaciones personales e inéditas.\r\n\r\n<strong>Líneas:</strong>\r\n\r\nTrafficstone\r\n\r\n[caption id=\"attachment_767\" align=\"alignleft\" width=\"116\" caption=\"Amalfi\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Amalfi-b.jpg\"><img class=\"size-thumbnail wp-image-767 \" title=\"Amalfi\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Amalfi-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_768\" align=\"alignleft\" width=\"116\" caption=\"Antracite\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Antracite-b.jpg\"><img class=\"size-thumbnail wp-image-768\" title=\"Antracite\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Antracite-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_770\" align=\"alignleft\" width=\"116\" caption=\"Aosta\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Aosta-b.jpg\"><img class=\"size-thumbnail wp-image-770\" title=\"Aosta\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Aosta-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_772\" align=\"alignleft\" width=\"116\" caption=\"Apulia\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Apulia-b.jpg\"><img class=\"size-thumbnail wp-image-772\" title=\"Apulia\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Apulia-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_773\" align=\"alignleft\" width=\"116\" caption=\"Atena\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Atena-b.jpg\"><img class=\"size-thumbnail wp-image-773\" title=\"Atena\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Atena-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_775\" align=\"alignleft\" width=\"116\" caption=\"Auby\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Auby-b.jpg\"><img class=\"size-thumbnail wp-image-775\" title=\"Auby\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Auby-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_776\" align=\"alignleft\" width=\"116\" caption=\"Belvedere\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Belvedere-b.jpg\"><img class=\"size-thumbnail wp-image-776\" title=\"Belvedere-b\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Belvedere-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_804\" align=\"alignleft\" width=\"116\" caption=\"Breda\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Breda-b.jpg\"><img class=\"size-thumbnail wp-image-804 \" title=\"Breda\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Breda-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_805\" align=\"alignleft\" width=\"116\" caption=\"Caledonia\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Caledonia-b.jpg\"><img class=\"size-thumbnail wp-image-805 \" title=\"Caledonia\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Caledonia-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_806\" align=\"alignleft\" width=\"116\" caption=\"Camargue\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Camargue-b.jpg\"><img class=\"size-thumbnail wp-image-806 \" title=\"Camargue\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Camargue-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_807\" align=\"alignleft\" width=\"116\" caption=\"Carnia\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Carnia-b.jpg\"><img class=\"size-thumbnail wp-image-807 \" title=\"Carnia\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Carnia-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_808\" align=\"alignleft\" width=\"116\" caption=\"Catalina\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Catalina-b.jpg\"><img class=\"size-thumbnail wp-image-808 \" title=\"Catalina\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Catalina-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_809\" align=\"alignleft\" width=\"116\" caption=\"Friuli\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Friuli-b.jpg\"><img class=\"size-thumbnail wp-image-809 \" title=\"Friuli\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Friuli-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption][caption id=\"attachment_812\" align=\"alignleft\" width=\"116\" caption=\"Hermitage\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Hermitage-b.jpg\"><img src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Hermitage-b-116x116.jpg\" alt=\"\" title=\"Hermitage\" width=\"116\" height=\"116\" class=\"size-thumbnail wp-image-812\" /></a>[/caption][caption id=\"attachment_813\" align=\"alignleft\" width=\"116\" caption=\"Istria\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Istria-b.jpg\"><img src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Istria-b-116x116.jpg\" alt=\"\" title=\"Istria\" width=\"116\" height=\"116\" class=\"size-thumbnail wp-image-813\" /></a>[/caption][caption id=\"attachment_814\" align=\"alignleft\" width=\"116\" caption=\"Itaca\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Itaca-b.jpg\"><img src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Itaca-b-116x116.jpg\" alt=\"\" title=\"Itaca\" width=\"116\" height=\"116\" class=\"size-thumbnail wp-image-814\" /></a>[/caption][caption id=\"attachment_815\" align=\"alignleft\" width=\"116\" caption=\"Miami\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Miami-b.jpg\"><img src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Miami-b-116x116.jpg\" alt=\"\" title=\"Miami\" width=\"116\" height=\"116\" class=\"size-thumbnail wp-image-815\" /></a>[/caption][caption id=\"attachment_816\" align=\"alignleft\" width=\"116\" caption=\"Miramare\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Miramare-b.jpg\"><img src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Miramare-b-116x116.jpg\" alt=\"\" title=\"Miramare\" width=\"116\" height=\"116\" class=\"size-thumbnail wp-image-816\" /></a>[/caption][caption id=\"attachment_817\" align=\"alignleft\" width=\"116\" caption=\"Modena\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Modena-b.jpg\"><img src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Modena-b-116x116.jpg\" alt=\"\" title=\"Modena\" width=\"116\" height=\"116\" class=\"size-thumbnail wp-image-817\" /></a>[/caption][caption id=\"attachment_818\" align=\"alignleft\" width=\"116\" caption=\"Naxos\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Naxos-b.jpg\"><img src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Naxos-b-116x116.jpg\" alt=\"\" title=\"Naxos\" width=\"116\" height=\"116\" class=\"size-thumbnail wp-image-818\" /></a>[/caption][caption id=\"attachment_819\" align=\"alignleft\" width=\"116\" caption=\"Nero\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Nero-b.jpg\"><img src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Nero-b-116x116.jpg\" alt=\"\" title=\"Nero\" width=\"116\" height=\"116\" class=\"size-thumbnail wp-image-819\" /></a>[/caption][caption id=\"attachment_820\" align=\"alignleft\" width=\"116\" caption=\"Otello\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Otello-b.jpg\"><img src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Otello-b-116x116.jpg\" alt=\"\" title=\"Otello\" width=\"116\" height=\"116\" class=\"size-thumbnail wp-image-820\" /></a>[/caption][caption id=\"attachment_821\" align=\"alignleft\" width=\"116\" caption=\"Pompei\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Pompei-b.jpg\"><img src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Pompei-b-116x116.jpg\" alt=\"\" title=\"Pompei\" width=\"116\" height=\"116\" class=\"size-thumbnail wp-image-821\" /></a>[/caption][caption id=\"attachment_822\" align=\"alignleft\" width=\"116\" caption=\"Prussia\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Prussia-b.jpg\"><img src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Prussia-b-116x116.jpg\" alt=\"\" title=\"Prussia\" width=\"116\" height=\"116\" class=\"size-thumbnail wp-image-822\" /></a>[/caption][caption id=\"attachment_823\" align=\"alignleft\" width=\"116\" caption=\"Rinmini\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Rinmini-b.jpg\"><img src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Rinmini-b-116x116.jpg\" alt=\"\" title=\"Rinmini\" width=\"116\" height=\"116\" class=\"size-thumbnail wp-image-823\" /></a>[/caption]", "Colores", "Amplia gama de colores y granulometrías.", "inherit", "open", "open", "", "379-revision-v1", "", "", "2012-05-28 15:52:24", "2012-05-28 19:52:24", "", "379", "http://santamargherita.s-m.cl/379-revision-19/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("826", "1", "2012-05-28 15:54:13", "2012-05-28 19:54:13", "<img class=\"alignnone size-full wp-image-794\" title=\"Colores\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/colores2.jpg\" alt=\"\" width=\"810\" height=\"328\" />\r\n<h3>COLORES</h3>\r\nEl aglomerado SANTAMARGHERITA , a base de arenas de cuarzo y resina, es un producto de elevadas características estéticas con una alta resistencia a la flexión, a la abrasión y a los ácidos. Innovador y con altas prestaciones técnicas es un material que se presenta de manera muy homogénea y uniforme, además de ser particularmente versátil en lo que se refiere a la coloración.<em></em>\r\n\r\nLa amplia gama de colores y granulometrías y una tecnología de vanguardia se presentan bajo forma de superficies con varias posibilidades de uso, los colores neutros y las tonalidades más fuertes permiten combinaciones personales e inéditas.\r\n\r\n<strong>Líneas:</strong>\r\n\r\nTrafficstone\r\n\r\n[caption id=\"attachment_767\" align=\"alignleft\" width=\"116\" caption=\"Amalfi\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Amalfi-b.jpg\"><img class=\"size-thumbnail wp-image-767 \" title=\"Amalfi\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Amalfi-b-116x116.jpg\" alt=\"\" width=\"90\" height=\"90\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_768\" align=\"alignleft\" width=\"116\" caption=\"Antracite\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Antracite-b.jpg\"><img class=\"size-thumbnail wp-image-768\" title=\"Antracite\" src=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Antracite-b-116x116.jpg\" alt=\"\" width=\"116\" height=\"116\" /></a>[/caption]\r\n\r\n[caption id=\"attachment_770\" align=\"alignleft\" width=\"116\" caption=\"Aosta\"]<a href=\"http://santamargherita.s-m.cl/wp-content/uploads/2012/03/Aosta-b.jpg\"><img class=\"size-thumbnail wp-image-770\" title=\"Aosta\" src=\"http://santamargherita.s-m.cl/w